<?php
$lang = isset($_SESSION['lang']) ? $_SESSION['lang'] : 'en'; // 'es' | 'en'

// widgets/buscador_colaborador.php
// Muestra un buscador simple por colaborador y redirige a colaborador_detalle.php

if (!isset($con)) {
  // fallback por si el header aún no incluyó la conexión
  include_once __DIR__ . '/../dbcon.php';
}
?>
<div class="row">
  <div class="col-md-12">
    <div class="box box-warning">
      <div class="box-header with-border">
        <h3 class="box-title" style="font-size:17px;"><?= T('finder.title') ?></h3>
        <div class="box-tools pull-right">
          <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
        </div>
      </div>
      <div class="box-body">
        <form class="form-inline" method="get" action="colaborador_detalle.php" id="frmBuscarColaborador" style="display:flex; gap:10px; align-items:center; flex-wrap:wrap;">
          <div class="form-group" style="min-width:280px; flex:1;">
            <label for="emp" class="sr-only"><?= T('finder.label') ?></label>
            <select id="emp" name="id" class="form-control" style="width:100%;" required>
              <option value=""><?= T('finder.selectPlaceholder') ?></option>
              <?php
              $rs = mysqli_query($con, "SELECT id, nombre_completo, cedula FROM empleados_planilla ORDER BY nombre_completo ASC");
              while($r = mysqli_fetch_assoc($rs)){
                $id = (int)$r['id'];
                $txt = htmlspecialchars($r['nombre_completo'] . ' - ' . $r['cedula']);
                echo "<option value=\"$id\">$txt</option>";
              }
              ?>
            </select>
          </div>

          <button type="submit" class="btn btn-primary">
            <i class="fa fa-search"></i> <?= T('finder.viewRecords') ?>
          </button>

          <!-- Botón igual que antes -->
          <button type="button" class="btn btn-default" id="btnImprimirDirecto" title="<?= T('finder.printTitle') ?>">
            <i class="fa fa-print"></i> <?= T('finder.generatePDF') ?>
          </button>
        </form>

        <small class="text-muted"><?= T('finder.help') ?></small>
      </div>
    </div>
  </div>
</div>

<script>
$(function(){
  // Textos desde PHP para usar en JS
  var i18n = {
    searchPh: <?= json_encode(T('finder.searchPlaceholder')) ?>,
    alertSel: <?= json_encode(T('finder.alertSelect')) ?>
  };

  if ($.fn.select2) {
    $('#emp').select2({ placeholder: i18n.searchPh, width:'100%' });
  }

  $('#btnImprimirDirecto').on('click', function(){
    var id = $('#emp').val();
    if(!id){
      alert(i18n.alertSel);
      return;
    }
    window.open('colaborador_detalle_pdf.php?id=' + encodeURIComponent(id), '_blank');
  });
});
</script>
