<?php
require_once __DIR__.'/../templates/header.php';
require_once __DIR__.'/../includes/sector_data.php';
require_once __DIR__.'/../includes/render_svg.php';
require_once __DIR__.'/../includes/db.php';
$sector_id = isset($_GET['sector_id']) ? (int)$_GET['sector_id'] : 0;
$type = $_GET['type'] ?? 'electrical';
$meta = sector_meta($con, $sector_id);
// carga plan publicado
$sql = "SELECT svg, version FROM sector_plan WHERE sector_id={$sector_id} AND type='".mysqli_real_escape_string($con,$type)."' AND status='published' ORDER BY version DESC LIMIT 1";
$rs = mysqli_query($con, $sql);
$svg = ''; $ver='-';
if ($rs && ($r=mysqli_fetch_assoc($rs))) { $svg = clean_svg_output($r['svg'] ?? ''); $ver = (string)$r['version']; }
$ac = (isset($meta['acometidas']) && count($meta['acometidas'])) ? implode(', ', $meta['acometidas']) : '(sin datos)';
?>
<div class="pl-card">
  <div class="pl-bar">
    <strong>Sector:</strong> <?php echo esc(($meta['codigo']??'').' '.($meta['nombre']??'')); ?> &nbsp;|&nbsp;
    <strong>Acometida(s):</strong> <?php echo esc($ac); ?> &nbsp;|&nbsp;
    <strong>Tipo:</strong> <?php echo esc($type); ?> &nbsp;|&nbsp;
    <strong>Versión:</strong> <?php echo esc($ver); ?>
  </div>
  <div id="pl-container" class="svg-view"><?php echo $svg ?: '<div class="note">No hay plano publicado.</div>'; ?></div>
  <div class="pl-bar"><a class="btn" href="/modulo_plano/viewer/plan_fullscreen.php?sector_id=<?php echo $sector_id; ?>&type=<?php echo esc($type); ?>">Ver grande</a></div>
</div>
<?php require_once __DIR__.'/../templates/footer.php'; ?>
