<?php
// ===== Arranque seguro =====
header('Content-Type: text/html; charset=UTF-8');
mb_internal_encoding('UTF-8');
if (session_status() !== PHP_SESSION_ACTIVE) session_start();

// ===== i18n (carga helpers, diccionarios, etc.) =====
require_once __DIR__ . '/../../includes/i18n.php';

// ===== DB =====
include('dbcon.php');

// ===== 1) Leer status actual (1=ES, 2=EN) =====
$rs  = mysqli_query($con, "SELECT status FROM header_admin WHERE id=1 LIMIT 1") or die(mysqli_error($con));
$row = mysqli_fetch_assoc($rs) ?: ['status' => 2];
$status = (int)$row['status'];

// ===== 2) Si llega ?lang=es|en, actualiza status y sincroniza =====
if (isset($_GET['lang'])) {
    $langParam = strtolower(trim($_GET['lang']));
    if ($langParam === 'es' || $langParam === 'en') {
        $newStatus = ($langParam === 'es') ? 1 : 2;
        if ($newStatus !== $status) {
            mysqli_query($con, "UPDATE header_admin SET status={$newStatus} WHERE id=1") or die(mysqli_error($con));
            $status = $newStatus; // usar el valor recin aplicado
        }
    }
}

// ===== 3) Definir columna por status =====
//   1 -> 'espain' (ES),  2 -> 'header' (EN)
$columna = ($status === 1) ? 'espain' : 'header';

// Mantener sesin coherente para otras vistas:
$_SESSION['lang'] = ($status === 1) ? 'es' : 'en';

// ===== 4) Cargar HTML del header con fallback segn idioma =====
$q = mysqli_query($con, "SELECT header, espain FROM header_admin WHERE id=1 LIMIT 1") or die(mysqli_error($con));
if ($r = mysqli_fetch_assoc($q)) {
    if ($status === 1) {
        // Espa09ol: intenta 'espain' y, si no existe/NULL, cae a 'espain' (o vaco)
        $header = $r[$columna] ?? ($r['espain'] ?? '');
    } else {
        // Ingls: intenta 'header' y, si no existe/NULL, cae a 'header' (o vaco)
        $header = $r[$columna] ?? ($r['header'] ?? '');
    }
} else {
    $header = '';
}

/* ---- Inicializacin segura de $dato y $totalstock ---- */
if (!isset($dato)) { $dato = null; }
if (is_array($dato)) { $dato = (object)$dato; }
if (!is_object($dato)) { $dato = new stdClass(); }
if (!property_exists($dato, 'totalstock') || $dato->totalstock === null) { $dato->totalstock = 0; }
$totalstock = (int)$dato->totalstock;

// (tu HTML sigue aqu) 
?>

<!DOCTYPE html>
<html>
  <head>
<title>Employee List</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo $_SESSION["sucursal"]?></title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.5 -->    
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="public/css/font-awesome.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="public/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
         folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="public/css/_all-skins.min.css">
    <link rel="stylesheet" type="text/css" href="public/css/bootstrap.min.css"/>
    <link rel="stylesheet" type="text/css" href="public/css/dataTables.bootstrap.min.css"/>
    <link rel="stylesheet" type="text/css" href="public/js/swat/sweet/lib/sweet-alert.css">
    <link rel="stylesheet" type="text/css" href="public/css/buttons.dataTables.min.css">

    <!-- jQuery 2.1.4 -->
<script>
  var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
  var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl)
  })
</script>
    <script type="text/javascript" src="public/js/jquery.min.js"></script>
    <script type="text/javascript" src="public/js/jquery.numeric.min.js"></script>
    <!-- Bootstrap 3.3.5 -->
    <script type="text/javascript" src="public/js/bootstrap.min.js"></script>
    <!-- AdminLTE App -->
    <script type="text/javascript" src="public/js/app.min.js"></script>
    <script type="text/javascript" src="public/js/bootbox.min.js"></script>
 
    <script type="text/javascript" src="public/js/dataTables.js"></script>

    <script type="text/javascript" src="public/js/swat/sweet/lib/sweet-alert.min.js"></script>


    <script type="text/javascript" src="public/js/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript" src="public/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="public/js/jszip.min.js"></script>
    <script type="text/javascript" src="public/js/pdfmake.min.js"></script>
    <script type="text/javascript" src="public/js/vfs_fonts.js"></script>
    <script type="text/javascript" src="public/js/buttons.html5.min.js"></script>
    <script type="text/javascript" src="public/js/Chart.js"></script>


    <script type="text/javascript" src="public/scripts/consulta_empleadosplanilla.js"></script>
    <script type="text/javascript" src="public/scripts/jquery.toaster.js"></script>

 <?php
// Personalizas variables ANTES de incluir
$page_title = 'Mi pgina 1';
$sidebar    = '<ul class="sidebar-menu"><li>Item 1</li></ul>';
$navbar     = '<nav class="navbar navbar-static-top">...</nav>';

// Incluyes el header comn
require_once __DIR__ . '/contenido_abajo_header/contenido_header2.php';
?>