<!-- view/Escritorio_RRHH.php -->
<?php
$lang = isset($_SESSION['lang']) ? $_SESSION['lang'] : 'en'; // 'es' | 'en'
?>

<section class="content-header">
  <h1>
    <?php echo T('Home'); ?>
    <small>HR</small>
  </h1>
  <script src="assets/ai_widget/ai_widget_data.js"></script>
</section>

<!-- FullCalendar CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.css">
<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">

<style>
  .calendar-toolbar{
    display:flex; gap:10px; align-items:center; justify-content:space-between; margin-bottom:10px; flex-wrap:wrap;
  }
  .select2-container--default .select2-selection--single{
    height:36px;border:1px solid #d2d6de;border-radius:3px; background:#fff;
    position:relative; padding-right:42px;
  }
  .select2-container--default .select2-selection--single .select2-selection__rendered{ line-height:34px;padding-left:10px; }
  .select2-container--default .select2-selection--single .select2-selection__arrow{ height:34px;right:8px; }
  .select2-container--default .select2-selection--single .select2-selection__clear{
    position:absolute; right:34px; top:50%; transform:translateY(-50%);
    width:22px;height:22px;line-height:20px;text-align:center;border-radius:50%;
    font-weight:700;font-size:14px;color:#fff !important;background:#d9534f;border:2px solid #fff;box-shadow:0 1px 3px rgba(0,0,0,.15);cursor:pointer;opacity:1;text-decoration:none !important;
  }
  .select2-container--default .select2-selection--single .select2-selection__clear:hover{ background:#c9302c; }
  .select2-container--default.select2-container--disabled .select2-selection__clear{ display:none !important; }

  /* Botones de modo */
  .mode-btns .btn{ min-width:140px; }
  .mode-btns .btn.active{ box-shadow: inset 0 2px 4px rgba(0,0,0,.15); }

  /* Borde izquierdo por categoría en los eventos */
  .fc-event.cat-border::before{
    content:'';
    position:absolute; left:0; top:0; height:100%; width:4px;
    border-top-left-radius:3px; border-bottom-left-radius:3px;
  }
</style>

<section class="content">

  <div class="row">
    <!-- Calendario -->
    <div class="col-md-8">
      <div class="box box-primary">
        <div class="box-header with-border">
          <h3 class="box-title" style="font-size:17px;"><?php echo T('Vacation calendar (current month)'); ?></h3>
          <div class="box-tools pull-right">
            <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
            <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">

          <!-- Barra: filtro por categoría + botones de modo -->
          <div class="calendar-toolbar">
            <div style="min-width:260px;flex:1;">
              <select id="categoryFilter" class="form-control" style="width:100%;">
                <option value="">Todos</option>
              </select>
            </div>

            <div class="mode-btns">
              <div class="btn-group" role="group" aria-label="Mode">
                <button id="btnModeVac" type="button" class="btn btn-primary active">
                  <i class="fa fa-sun-o"></i><?php echo T('Vacaciones'); ?>
                </button>
                <button id="btnModeInc" type="button" class="btn btn-warning">
                  <i class="fa fa-medkit"></i> <?php echo T('Incapacidades'); ?>
                </button>
              </div>
            </div>
          </div>

          <div id="calVacaciones"></div>
        </div>
      </div>
    </div>

    <!-- Próximos hitos (50 semanas) -->
    <div class="col-md-4">
      <div class="box box-info">
        <div class="box-header with-border">
          <h3 class="box-title" style="font-size:17px;"><?php echo T('Upcoming 50-week milestones'); ?></h3>
          <div class="box-tools pull-right">
            <span class="label label-primary" id="lblVentana"><?php echo T('Next 90 days'); ?></span>
          </div>
        </div>
        <div class="box-body">
          <ul id="lista50" class="list-group" style="max-height:505px; overflow:auto;"></ul>
        </div>
      </div>
    </div>
  </div>

  <!-- Buscador -->
  <div class="row">
    <div class="col-md-12">
      <?php include __DIR__ . '/../widgets/buscador_colaborador.php'; ?>
    </div>
  </div>

  <!-- Top saldos -->
  <div class="row">
    <div class="col-md-12">
      <div class="box box-success">
        <div class="box-header with-border">
          <h3 class="box-title" style="font-size:17px;"><?php echo T('Top vacation balances'); ?></h3>
          <div class="box-tools pull-right">
            <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
            <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
          <canvas id="chartTopSaldos" style="height:260px;"></canvas>
        </div>
      </div>
    </div>
  </div>

</section>

<!-- FullCalendar -->
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.js"></script>
<!-- FullCalendar locales (para que respete ES/EN automáticamente) -->
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/locales-all.min.js"></script>
<!-- Select2 -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.full.min.js"></script>

<!-- ====== Diccionario i18n liviano en JS (no rompe nada existente) ====== -->
<script>
(function(){
  window.APP_LANG = '<?php echo ($lang === "es" ? "es" : "en"); ?>';
  var ES = {
    'filter.all'            : 'Todos',
    'mode.vac'              : 'Vacaciones',
    'mode.inc'              : 'Incapacidades',
    'milestones.nextNDays'  : 'Próximos {n} días',
    'milestones.none'       : 'No hay hitos en este rango.',
    'milestones.label'      : 'Hito',
    'chart.vacBalance'      : 'Saldo de vacaciones',
    'event.from'            : 'Desde',
    'event.to'              : 'Hasta',
    'event.days'            : 'Días',
    'unit.days'             : 'días'
  };
  var EN = {
    'filter.all'            : 'All',
    'mode.vac'              : 'Vacations',
    'mode.inc'              : 'Sick leave',
    'milestones.nextNDays'  : 'Next {n} days',
    'milestones.none'       : 'No milestones within this range.',
    'milestones.label'      : 'Milestone',
    'chart.vacBalance'      : 'Vacation balance',
    'event.from'            : 'From',
    'event.to'              : 'To',
    'event.days'            : 'Days',
    'unit.days'             : 'days'
  };
  window.I18N = (window.APP_LANG === 'es') ? ES : EN;

  window.t = function(key, vars){
    var s = (I18N && I18N[key]) || key;
    if (vars){
      for (var k in vars){ s = s.replace(new RegExp('\\{'+k+'\\}','g'), vars[k]); }
    }
    return s;
  };
})();
</script>

<script>
(function(){
  /* ====== Estado ====== */
  var currentCategory = '';            // '' = Todos
  var currentMode     = 'vac';         // 'vac' | 'inc'
  var GLOBAL_CATS     = {};            // catálogo para el select

  /* ====== Helpers ====== */
  function getEventCategory(e){
    return (
      e.categoria_empleado || e.empleado_categoria || e.employee_category ||
      e.categoria || e.category || e.type || ''
    ).toString().trim();
  }

  function upsertCategoriesFrom(events){
    var added = false;
    (events||[]).forEach(function(ev){
      var c = getEventCategory(ev);
      if (c && !GLOBAL_CATS[c]) { GLOBAL_CATS[c] = true; added = true; }
    });
    if (!added) return;

    var $sel = $('#categoryFilter'); var prev = currentCategory;
    // i18n: primera opción
    $sel.empty().append('<option value="">' + t('filter.all') + '</option>');
    Object.keys(GLOBAL_CATS).sort(function(a,b){return a.localeCompare(b);})
      .forEach(function(c){ $sel.append($('<option>',{value:c,text:c})); });

    if (prev && GLOBAL_CATS[prev]) { $sel.val(prev); currentCategory = prev; }
    else { $sel.val(''); currentCategory = ''; }

    if ($sel.data('select2')) $sel.trigger('change.select2');
  }

  // Colores por categoría (borde)
  var CAT_COLORS = {
    'MANTENIMIENTO':  '#f39c12',
    'ADMINISTRACION': '#00a65a',
    'VACACIONES':     '#00a65a',
    'INCAPACIDAD':    '#dd4b39'
  };
  function colorForCategory(cat){
    var k = (cat||'').toString().trim().toUpperCase();
    return CAT_COLORS[k] || '#605ca8';
  }

  // Color por persona (fondo) – determinístico por id/nombre
  function djb2(str){
    var h = 5381, i = str.length;
    while(i){ h = (h * 33) ^ str.charCodeAt(--i); }
    return h >>> 0;
  }
  function hslToHex(h, s, l){
    h = h/360; s = s/100; l = l/100;
    var r, g, b;
    if (s === 0){ r=g=b=l; }
    else {
      var hue2rgb = function(p, q, t){
        if (t < 0) t += 1;
        if (t > 1) t -= 1;
        if (t < 1/6) return p + (q - p) * 6 * t;
        if (t < 1/2) return q;
        if (t < 2/3) return p + (q - p) * (2/3 - t) * 6;
        return p;
      };
      var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
      var p = 2 * l - q;
      r = hue2rgb(p, q, h + 1/3);
      g = hue2rgb(p, q, h);
      b = hue2rgb(p, q, h - 1/3);
    }
    var toHex = function(x){ var h = Math.round(x*255).toString(16); return h.length===1?'0'+h:h; };
    return '#' + toHex(r) + toHex(g) + toHex(b);
  }
  function personColor(seed){
    var base = String(seed || '');
    var hash = djb2(base);
    var hue = hash % 360;          // 0..359
    var sat = 55;                  // saturación fija
    var lig = 72;                  // luminosidad fija (pastel)
    return hslToHex(hue, sat, lig);
  }

  /* ====== UI ====== */
  $(function(){
    var $sel = $('#categoryFilter');
    if ($.fn.select2){
      $sel.select2({ placeholder: t('filter.all'), allowClear:true, width:'100%' });
    }
    $sel.on('change', function(){
      currentCategory = $(this).val() || '';
      if (window.__cal__) window.__cal__.refetchEvents();
    });

    // Etiquetas de botones (por si cambias de idioma en caliente)
    $('#btnModeVac').contents().filter(function(){ return this.nodeType===3; }).last().replaceWith(' ' + t('mode.vac'));
    $('#btnModeInc').contents().filter(function(){ return this.nodeType===3; }).last().replaceWith(' ' + t('mode.inc'));

    $('#btnModeVac').on('click', function(){
      if (currentMode==='vac') return;
      currentMode = 'vac';
      $('#btnModeVac').addClass('active btn-primary').removeClass('btn-default');
      $('#btnModeInc').removeClass('active btn-warning').addClass('btn-default');
      if (window.__cal__) window.__cal__.refetchEvents();
    });
    $('#btnModeInc').on('click', function(){
      if (currentMode==='inc') return;
      currentMode = 'inc';
      $('#btnModeInc').addClass('active btn-warning').removeClass('btn-default');
      $('#btnModeVac').removeClass('active btn-primary').addClass('btn-default');
      if (window.__cal__) window.__cal__.refetchEvents();
    });
  });

  /* ====== Calendario ====== */
  var calendarEl = document.getElementById('calVacaciones');
  if (calendarEl){
    var calendar = new FullCalendar.Calendar(calendarEl, {
      initialView: 'dayGridMonth',
      height: 520,
      locale: '<?php echo ($lang === "es" ? "es" : "en"); ?>', // i18n sin romper nada
      headerToolbar: { left:'prev,next today', center:'title', right:'dayGridMonth,timeGridWeek' },

      events: function(fetchInfo, success, failure){
        // Endpoint según modo
        var op = (currentMode === 'inc') ? 'incapacidades_mes_with_days' : 'vacaciones_mes_with_days';
        var url = 'ajax/HomeRRHHAjax.php?op='+op
          + '&start=' + encodeURIComponent(fetchInfo.startStr)
          + '&end='   + encodeURIComponent(fetchInfo.endStr)
          + (currentCategory ? ('&category='+encodeURIComponent(currentCategory)) : '');

        $.getJSON(url).done(function(rows){
          // Poblar catálogo de categorías para el <select>
          upsertCategoriesFrom(rows);

          var evs = (rows||[]).map(function(e){
            var cat = getEventCategory(e);
            var personSeed = e.idempleado || e.title || e.id;
            var bg = personColor(String(personSeed));
            var border = colorForCategory(cat);

            return {
              id: e.id,
              title: e.title,
              start: e.start,
              end:   e.end,
              backgroundColor: bg,
              borderColor: border,
              classNames: ['cat-border'],
              extendedProps: {
                categoria: cat,
                cantidad_dias: e.cantidad_dias,
                fecha_desde: e.fecha_desde,
                fecha_hasta: e.fecha_hasta
              }
            };
          });

          success(evs);
        }).fail(failure);
      },

      eventDidMount: function(info){
        // Borde izquierdo con color de categoría
        var cat = (info.event.extendedProps && info.event.extendedProps.categoria) || '';
        var border = colorForCategory(cat);
        info.el.classList.add('cat-border');
        info.el.style.position = 'relative';
        info.el.style.backgroundImage = 'linear-gradient(to right,'+border+' 0, '+border+' 4px, transparent 4px)';

        // tooltip nativo (i18n)
        var p = info.event.extendedProps || {};
        var text = t('event.from')+': '+(p.fecha_desde||'')
                 + '\n' + t('event.to') +': '+(p.fecha_hasta||'')
                 + '\n' + t('event.days')+': '+(p.cantidad_dias!=null?p.cantidad_dias:'');
        info.el.setAttribute('title', text);
      },

      eventClick: function(info){
        var p = info.event.extendedProps || {};
        var desde = p.fecha_desde || info.event.startStr || '';
        var hasta = p.fecha_hasta || (info.event.end ? FullCalendar.formatDate(info.event.end,{year:'numeric',month:'2-digit',day:'2-digit'}) : '') || '';
        var dias  = (p.cantidad_dias != null ? p.cantidad_dias : '');
        alert(info.event.title + "\n" + t('event.from') + ": " + desde + "\n" + t('event.to') + ": " + hasta + "\n" + t('event.days') + ": " + dias);
      }
    });

    window.__cal__ = calendar;
    calendar.render();
  }

  /* ====== Panel derecho y gráfica ====== */
  function renderProximos50(diasVentana){
    $('#lblVentana').text(t('milestones.nextNDays', {n: (diasVentana||350)}));
    $.getJSON('ajax/HomeRRHHAjax.php?op=proximas_50&dias=' + (diasVentana||350), function(items){
      var ul = $('#lista50'); ul.empty();
      if (!items || !items.length){
        ul.append('<li class="list-group-item">'+ t('milestones.none') +'</li>');
        return;
      }
      var unit = t('unit.days');
      items.forEach(function(it){
        var badge = (it.faltan_dias<=7)? 'label-danger' : (it.faltan_dias<=30? 'label-warning' : 'label-success');
        ul.append(
          '<li class="list-group-item">'+
            '<b>'+it.nombre+'</b> <small>('+(it.categoria||'')+')</small>'+
            '<span class="label '+badge+' pull-right">'+it.faltan_dias+' '+unit+'</span>'+
            '<br><small>'+ t('milestones.label') +': '+it.fecha_hito+'</small>'+
          '</li>'
        );
      });
    });
  }
  renderProximos50(350);

  function renderTopSaldos(n){
    $.getJSON('ajax/HomeRRHHAjax.php?op=top_saldos&n='+(n||10), function(rows){
      var ctx = document.getElementById('chartTopSaldos').getContext('2d');
      var labels = (rows||[]).map(function(r){ return r.nombre; });
      var data   = (rows||[]).map(function(r){ return r.saldo; });

      new Chart(ctx).Bar({
        labels: labels,
        datasets: [{
          label: t('chart.vacBalance'),
          fillColor: "rgba(0,166,90,0.5)",
          strokeColor: "rgba(0,166,90,1)",
          pointColor: "rgba(0,166,90,1)",
          data: data
        }]
      }, { responsive:true, maintainAspectRatio:false, scaleBeginAtZero:true });
    });
  }
  renderTopSaldos(10);

  $('#payroll_control').addClass("treeview active");
  $('#payroll_control_1').addClass("treeview active");
  $('#payroll_control_1_0').addClass("active");
})();
</script>

