<?php
session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) {
  header("Location:index.html");
  exit;
}

require_once "dbcon.php";

function back_to_edit(int $id, string $msg): void {
  $msg = urlencode($msg);
  header("Location: editar_empleado.php?id={$id}&msg={$msg}");
  exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header("Location: consulta_empleados.php");
  exit;
}

$idempleado = (int)($_POST['idempleado'] ?? 0);
if ($idempleado <= 0) {
  header("Location: consulta_empleados.php");
  exit;
}

/* =========================
   Leer y validar inputs
   ========================= */
$login = trim((string)($_POST['login'] ?? ''));
$clave = (string)($_POST['clave'] ?? '');

$nombre        = trim((string)($_POST['nombre'] ?? ''));
$apellidos     = trim((string)($_POST['apellidos'] ?? ''));
$tipo_doc      = trim((string)($_POST['tipo_documento'] ?? ''));
$num_doc       = trim((string)($_POST['num_documento'] ?? ''));
$email         = trim((string)($_POST['email'] ?? ''));
$telefono      = trim((string)($_POST['telefono'] ?? ''));
$foto_actual   = (string)($_POST['foto_actual'] ?? '');

if ($login === '' || $nombre === '' || $apellidos === '' || $tipo_doc === '' || $num_doc === '') {
  back_to_edit($idempleado, "Faltan datos obligatorios.");
}

/* =========================
   Verificar empleado existe
   ========================= */
$stmt = mysqli_prepare($con, "SELECT idempleado, foto FROM empleado WHERE idempleado=? LIMIT 1");
mysqli_stmt_bind_param($stmt, "i", $idempleado);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$emp = $res ? mysqli_fetch_assoc($res) : null;
mysqli_stmt_close($stmt);

if (!$emp) {
  header("Location: consulta_empleados.php");
  exit;
}

/* =========================
   Validar login nico
   ========================= */
$stmt = mysqli_prepare($con, "SELECT COUNT(*) c FROM empleado WHERE login=? AND idempleado<>?");
mysqli_stmt_bind_param($stmt, "si", $login, $idempleado);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$row = $res ? mysqli_fetch_assoc($res) : null;
mysqli_stmt_close($stmt);

if ($row && (int)$row['c'] > 0) {
  back_to_edit($idempleado, "Ese usuario ya existe. Usa otro.");
}

/* =========================
   Manejo de foto
   ========================= */
$foto_path = $foto_actual;
if (!empty($_FILES['foto']) && isset($_FILES['foto']['tmp_name']) && is_uploaded_file($_FILES['foto']['tmp_name'])) {
  $err = (int)($_FILES['foto']['error'] ?? 0);
  if ($err === 0) {
    $tmp  = $_FILES['foto']['tmp_name'];
    $name = (string)($_FILES['foto']['name'] ?? '');
    $ext  = strtolower(pathinfo($name, PATHINFO_EXTENSION));

    // Extensiones permitidas (ajusta si quieres)
    $allowed = ['jpg','jpeg','png','webp','gif'];
    if (!in_array($ext, $allowed, true)) {
      back_to_edit($idempleado, "Formato de foto no permitido (usa JPG/PNG/WebP).");
    }

    // Carpeta destino: intenta Files/Empleados, si no existe usa Files/
    $baseDir = __DIR__ . '/Files/Empleados';
    $baseRel = 'Files/Empleados';
    if (!is_dir($baseDir)) {
      @mkdir($baseDir, 0755, true);
    }
    if (!is_dir($baseDir)) {
      $baseDir = __DIR__ . '/Files';
      $baseRel = 'Files';
      if (!is_dir($baseDir)) {
        @mkdir($baseDir, 0755, true);
      }
    }

    $filename = 'emp_' . $idempleado . '_' . date('Ymd_His') . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
    $destAbs  = rtrim($baseDir, '/\\') . DIRECTORY_SEPARATOR . $filename;
    $destRel  = rtrim($baseRel, '/\\') . '/' . $filename;

    if (!move_uploaded_file($tmp, $destAbs)) {
      back_to_edit($idempleado, "No se pudo guardar la foto.");
    }

    $foto_path = $destRel;
  } else {
    back_to_edit($idempleado, "Error al subir la foto (cdigo {$err}).");
  }
}

/* =========================
   Actualizar empleado
   - login siempre
   - clave SOLO si viene escrita (md5)
   ========================= */
$setClave = (trim($clave) !== '');
if ($setClave) {
  // Mantener compatibilidad con el sistema legacy (clave varchar(32))
  $clave_md5 = md5($clave);

  $sql = "UPDATE empleado
          SET login=?, clave=?, nombre=?, apellidos=?, tipo_documento=?, num_documento=?, email=?, telefono=?, foto=?
          WHERE idempleado=? LIMIT 1";
  $stmt = mysqli_prepare($con, $sql);
  mysqli_stmt_bind_param(
    $stmt,
    "sssssssssi",
    $login,
    $clave_md5,
    $nombre,
    $apellidos,
    $tipo_doc,
    $num_doc,
    $email,
    $telefono,
    $foto_path,
    $idempleado
  );
} else {
  $sql = "UPDATE empleado
          SET login=?, nombre=?, apellidos=?, tipo_documento=?, num_documento=?, email=?, telefono=?, foto=?
          WHERE idempleado=? LIMIT 1";
  $stmt = mysqli_prepare($con, $sql);
  mysqli_stmt_bind_param(
    $stmt,
    "ssssssssi",
    $login,
    $nombre,
    $apellidos,
    $tipo_doc,
    $num_doc,
    $email,
    $telefono,
    $foto_path,
    $idempleado
  );
}

$ok = mysqli_stmt_execute($stmt);
$errMsg = mysqli_stmt_error($stmt);
mysqli_stmt_close($stmt);

if (!$ok) {
  back_to_edit($idempleado, "Error al actualizar: " . $errMsg);
}

header("Location: editar_empleado.php?id={$idempleado}&msg=" . urlencode("Actualizado correctamente."));
exit;
