<?php
session_start();
$idsucursal = 0;
date_default_timezone_set('America/Costa_Rica');
$fechaactual = date('Y-m-d');
$horaactual  = date('H:i');

if (isset($_SESSION["idusuario"])) {

  if ($_SESSION["superadmin"] != "S") {
    include "./view/header.php";

    $idusuario = $_SESSION["idusuario"];
    include('dbcon.php');

    // GLOBAL: tipo_moneda
    $tipo_moneda = '';
    $q = mysqli_query($con, "SELECT * FROM global") or die(mysqli_error($con));
    while ($row = mysqli_fetch_array($q)) {
      $tipo_moneda = $row['tipo_moneda'];
    }

    // Sucursal -> idsucursal
    $nombre_sucursal = isset($_SESSION["sucursal"]) ? $_SESSION["sucursal"] : '';
    $q = mysqli_query($con, "SELECT * FROM sucursal WHERE razon_social='$nombre_sucursal'") or die(mysqli_error($con));
    while ($row = mysqli_fetch_array($q)) {
      $idsucursal = $row['idsucursal'];
    }

    // Usuario -> idempleado
    $idempleado = 0;
    $q = mysqli_query($con, "SELECT * FROM usuario WHERE idusuario='$idusuario'") or die(mysqli_error($con));
    while ($row = mysqli_fetch_array($q)) {
      $idempleado = $row['idempleado'];
    }

    // Datos del empleado
    $nombre = '';
    $apellidos = '';
    $q = mysqli_query($con, "SELECT * FROM empleado WHERE idempleado='$idempleado'") or die(mysqli_error($con));
    while ($row = mysqli_fetch_array($q)) {
      $nombre    = $row['nombre'];
      $apellidos = $row['apellidos'];
    }
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>Email Request (Maintenance)</title>

<script type="text/javascript">
  // activar menú (si aplica en tu plantilla)
  document.addEventListener('DOMContentLoaded', function(){
    var er = document.getElementById('emailrequest');
    var er1 = document.getElementById('emailrequest1');
    if (er)  er.className = (er.className ? er.className + ' ' : '') + 'treeview active';
    if (er1) er1.className = (er1.className ? er1.className + ' ' : '') + 'active';
  });
</script>

<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

<style>
.enhanced-textarea {
  border: 1px solid #ccc;
  border-radius: 8px;
  padding: 10px 12px;
  font-size: 14px;
  width: 100%;
  box-shadow: inset 0 1px 3px rgba(0,0,0,0.1);
  resize: vertical;
  transition: border-color 0.3s, box-shadow 0.3s;
}
.enhanced-textarea:focus {
  border-color: #3c8dbc;
  box-shadow: 0 0 5px rgba(60, 141, 188, 0.5);
  outline: none;
}
</style>
</head>
<body>

<div class="box">
  <div class="box-header with-border">
    <h3 class="box-title">
      <i class="fa fa-lock"></i> Acceso restringido (Maintenance)
    </h3>

    <div class="box-tools pull-right">
      <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
      <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
    </div>
  </div>

  <div class="box-body">

    <style>
      .deny-wrap{
        min-height: 55vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 25px 10px;
      }
      .deny-card{
        width: 100%;
        max-width: 820px;
        border: 1px solid #d2d6de;
        border-radius: 10px;
        background: #fff;
        box-shadow: 0 2px 10px rgba(0,0,0,.08);
        padding: 30px 25px;
        text-align: center;
      }
      .deny-badge{
        display: inline-block;
        padding: 6px 12px;
        border-radius: 20px;
        background: #dd4b39; /* rojo AdminLTE */
        color: #fff;
        font-size: 13px;
        font-weight: 700;
        margin-bottom: 12px;
      }
      .deny-title{
        font-size: 22px;
        font-weight: 900;
        margin: 0 0 10px 0;
        color: #111;
      }
      .deny-text{
        font-size: 16px;
        color: #555;
        margin: 0 auto 18px auto;
        line-height: 1.6;
      }
      .deny-contact{
        font-size: 16px;
        color: #333;
        line-height: 1.7;
        margin-top: 10px;
      }
      .deny-contact a{
        font-weight: 800;
        text-decoration: none;
      }
      .deny-actions{
        margin-top: 22px;
      }
      .deny-actions .btn{
        margin: 4px;
      }
      .deny-mini{
        margin-top: 14px;
        font-size: 13px;
        color: #888;
      }
    </style>

    <div class="deny-wrap">
      <div class="deny-card">

        <div class="deny-badge">SIN ACCESO</div>

        <div class="deny-title">
          No tienes acceso a este sector por seguridad
        </div>

        <p class="deny-text">
          Este módulo está protegido. Si necesitas acceso, contacta al administrador del sistema.
        </p>

        <div class="deny-contact">
          <b>Administrador:</b> Julio Portales<br>
          📞 <b>Tlf:</b> <a href="tel:72030033">72030033</a><br>
          🌐 <b>Web:</b> <a href="https://jportales.com" target="_blank">Jportales.com</a>
        </div>

        <div class="deny-actions">
          <a href="javascript:history.back();" class="btn btn-default">
            <i class="fa fa-arrow-left"></i> Volver
          </a>

          <a href="https://mantenimiento.jportales.com" class="btn btn-primary">
            <i class="fa fa-home"></i> Ir a Mantenimiento
          </a>
        </div>

        <div class="deny-mini">
          Si crees que esto es un error, por favor solicita la activación de permisos.
        </div>

      </div>
    </div>

  </div>
</div>


      <!-- JS: preview de archivo -->
      <script type="text/javascript">
      document.getElementById('imagen1').addEventListener('change', function(event) {
        const file = event.target.files[0];
        const previewImg = document.getElementById('previewImagen1');
        const previewPdf = document.getElementById('previewPdf1');
        const container  = document.getElementById('previewContainer1');

        if (!file) {
          container.style.display = 'none';
          previewImg.style.display = 'none';
          previewPdf.style.display = 'none';
          previewImg.src = '';
          previewPdf.src = '';
          return;
        }

        container.style.display = 'block';
        const reader = new FileReader();

        if (file.type === "application/pdf") {
          previewImg.style.display = 'none';
          previewPdf.style.display = 'block';
          reader.onload = e => previewPdf.src = e.target.result;
        } else if (file.type.startsWith("image/")) {
          previewPdf.style.display = 'none';
          previewImg.style.display = 'block';
          reader.onload = e => previewImg.src = e.target.result;
        } else {
          alert("Only images or PDFs are allowed.");
          event.target.value = "";
          container.style.display = 'none';
          previewImg.style.display = 'none';
          previewPdf.style.display = 'none';
        }

        reader.readAsDataURL(file);
      });
      </script>

      <!-- Autogrow + contador de descripción -->
      <script>
      (function(){
        const descripcion = document.getElementById('descripcion');
        const charCount   = document.getElementById('charCount');
        const maxLength   = 500;
        if (!descripcion || !charCount) return;

        descripcion.addEventListener('input', function() {
          this.style.height = 'auto';
          this.style.height = this.scrollHeight + 'px';
          let len = this.value.length;
          charCount.textContent = len + '/' + maxLength;
        });
      })();
      </script>

      <!-- Inicialización Select2 -->
      <script>
      $(document).ready(function() {
        $('#area').select2({
          placeholder: "Search area...",
          allowClear: true,
          width: '100%'
        });
        $('#departamento').select2({
          placeholder: "Search department...",
          allowClear: true,
          width: '100%'
        });
        $('select[name="responsabilidad"]').select2({ width: '100%' });
        $('select[name="responsabilidad2"]').select2({ width: '100%', placeholder: ' ' });
        $('select[name="prioridad"]').select2({ width: '100%' });
        $('select[name="tipo_presupuesto"]').select2({ width: '100%' });
        // idempleado_view ya está disabled; no hace falta Select2, pero si lo deseas:
        $('#idempleado_view').select2({ width: '100%' });
      });
      </script>

      <!-- Recordar preferencias (localStorage) -->
      <script>
      (function(){
        const STORAGE_KEY = 'emailrequest_form_prefs_v1';
        const form = document.querySelector('form[action="add_emailrequest.php"]');
        if (!form) return;

        const fields = {
          fecha:            '#fecha',
          area:             '#area',
          responsabilidad:  'select[name="responsabilidad"]',
          responsabilidad2: 'select[name="responsabilidad2"]',
          // idempleado mostrado está disabled; el que enviamos es hidden. Si quieres recordar el valor, lo tomamos de ese hidden:
          idempleado:       'input[name="idempleado"]',
          prioridad:        'select[name="prioridad"]',
          final:            '#final',
          tipo_presupuesto: 'select[name="tipo_presupuesto"]',
          departamento:     '#departamento'
        };

        function readFormValues(){
          const data = { _savedAt: Date.now() };
          for (const k in fields) {
            const el = document.querySelector(fields[k]);
            if (!el) continue;
            data[k] = el.value || '';
          }
          return data;
        }

        function applyFormValues(data){
          for (const k in fields) {
            const el = document.querySelector(fields[k]);
            if (!el || data[k] == null) continue;
            el.value = data[k];
            if ($(el).data('select2')) {
              $(el).val(data[k]).trigger('change');
            }
          }
        }

        function loadPrefs(){
          try {
            const raw = localStorage.getItem(STORAGE_KEY);
            if (!raw) return;
            const data = JSON.parse(raw);
            const THIRTY_DAYS = 1000 * 60 * 60 * 24 * 30;
            if (data._savedAt && (Date.now() - data._savedAt) > THIRTY_DAYS) {
              localStorage.removeItem(STORAGE_KEY);
              return;
            }
            applyFormValues(data);
          } catch(e){}
        }

        function savePrefs(){
          try {
            const data = readFormValues();
            localStorage.setItem(STORAGE_KEY, JSON.stringify(data));
          } catch(e){}
        }

        function forgetPrefs(){
          localStorage.removeItem(STORAGE_KEY);
        }

        const rememberChk = document.getElementById('remember_prefs');
        const forgetBtn   = document.getElementById('forget_prefs');

        if (forgetBtn) {
          forgetBtn.addEventListener('click', function(){
            forgetPrefs();
            alert('Listo: se olvidaron las selecciones guardadas.');
          });
        }

        // Cargar después de Select2
        $(function(){ loadPrefs(); });

        // Guardar al enviar si el checkbox está marcado
        form.addEventListener('submit', function(){
          if (rememberChk && rememberChk.checked) {
            savePrefs();
          } else {
            forgetPrefs();
          }
        });
      })();
      </script>

    </div><!-- /.box-body -->
  </div><!-- /.box-body -->

  <div class="box-header"></div>
  <div class="box-body">
    <?php
    // Ejemplo de consulta existente (no se altera tu lógica)
    $query = mysqli_query(
      $con,
      "SELECT a.idarticulo, c.nombre AS categoria, a.nombre AS articulo, u.nombre AS unidad,
              a.descripcion, imagen, hora_inicio, hora_total, codigo2, costo, venta
       FROM unidad_medida AS u
       INNER JOIN articulo AS a ON a.idunidad_medida = u.idunidad_medida
       INNER JOIN categoria AS c ON a.idcategoria = c.idcategoria
       WHERE fecha='$fechaactual'"
    ) or die(mysqli_error($con));

    while ($row = mysqli_fetch_array($query)) {
      $idarticulo = $row['idarticulo'];
      $entrada    = $row['hora_inicio'];

      // Cálculo de horas
      $hora_inicio   = date('H', strtotime($entrada));
      $minuto_inicio = date('i', strtotime($entrada));
      $hora_proceso  = date('H');
      $minuto_proceso= date('i');

      $proceso1 = $hora_inicio * 60;
      $proceso2 = $hora_proceso * 60;
      $proceso3 = $minuto_inicio + $proceso1;
      $proceso4 = $minuto_proceso + $proceso2;

      $minutos1 = $proceso4 - $proceso3;
      $segundos = $minutos1 * 60;

      $horas   = floor($segundos / 3600);
      $minutos = floor(($segundos - ($horas * 3600)) / 60);
      $segundos= $segundos - ($horas * 3600) - ($minutos * 60);

      $hora_total1 = $horas . ':' . $minutos . ":" . $segundos;

      // Aquí podrías imprimir algo si quieres visualizar resultados...
      // echo "<pre>Artículo $idarticulo — Tiempo: $hora_total1</pre>";
    }
    ?>
  </div>

</div><!-- /.box -->

</body>
</html>
<?php
  } // fin if superadmin != S
} else {
  // Si no hay sesión, podrías redirigir:
  header('Location: index.php');
  exit;
}
?>
