<?php
// public_html/colegio/colegio10/rrhh_home/scaner_qr.php
// Escáner QR — librería local, auto-inicio si hay permiso, fallback a imagen

session_start();
date_default_timezone_set('America/Costa_Rica');

/* HTTPS (requerido para cámara) */
$isHttps = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] === '443');
$host    = $_SERVER['HTTP_HOST'] ?? '';
$uri     = $_SERVER['REQUEST_URI'] ?? '/scaner_qr.php';
if (!$isHttps && stripos($host, 'hr.jportales.com') !== false) {
  header('Location: https://' . $host . $uri, true, 301);
  exit;
}

if (isset($_SESSION["idusuario"])) {
  if ($_SESSION["superadmin"] != "S") {

    include "./view/header.php";
?>
<script type="text/javascript">
  $('#payroll_control').addClass("treeview active");
  $('#payroll_control_2').addClass("treeview active");
</script>

<style>
  .qr-wrap{
    max-width:960px; margin:18px auto; padding:16px;
    background:#fff; border:1px solid #e5e7eb; border-radius:12px;
    box-shadow:0 6px 18px rgba(0,0,0,.06);
  }
  .qr-title{ font-size:18px; font-weight:700; margin:0 0 8px; }
  .qr-sub  { color:#6b7280; margin-bottom:14px; }
  #qr-reader { width:100%; min-height:320px; }
  .qr-actions{ display:flex; gap:10px; margin-top:10px; flex-wrap:wrap; align-items:center; }
  .qr-btn{
    border:1px solid #d1d5db; background:#f9fafb; padding:10px 14px; border-radius:10px;
    cursor:pointer; display:inline-flex; align-items:center; gap:8px; font-weight:600;
  }
  .qr-btn.primary{ background:#111827; color:#fff; border-color:#111827; }
  .qr-select{ border:1px solid #d1d5db; padding:10px 12px; border-radius:10px; background:#fff; }
  .qr-status{ margin-top:10px; font-size:13px; color:#374151; }
  .qr-status .bad{ color:#b91c1c; }
  .qr-status .ok { color:#065f46; }
  .qr-link  { word-break: break-all; color:#0d6efd; }
  #qr-reader video{ width:100%!important; height:auto!important; object-fit:cover; }
</style>

<div class="box">
  <div class="box-header with-border">
    <h3><i class="fa fa-qrcode"></i> Escáner de código QR</h3>
    <div class="box-tools pull-right">
      <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
      <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
    </div>
  </div>

  <div class="box-body">
    <div class="qr-wrap">
      <p class="qr-title">Apunta la cámara al QR del formulario</p>
      <p class="qr-sub">En móvil, toca <strong>Activar cámara</strong> para conceder permisos. Al detectar un código, se abrirá el enlace.</p>

      <div class="qr-actions" style="margin-bottom:8px;">
        <button id="btn-activate" class="qr-btn primary"><i class="fa fa-play-circle"></i> Activar cámara (iniciar escaneo)</button>
        <button id="btn-permission" class="qr-btn"><i class="fa fa-unlock-alt"></i> Solicitar permiso de cámara</button>
      </div>

      <div id="qr-reader"></div>

      <div class="qr-actions">
        <select id="cam-select" class="qr-select" title="Seleccionar cámara" disabled></select>
        <button id="btn-switch"    class="qr-btn" disabled><i class="fa fa-camera"></i> Cambiar cámara</button>
        <button id="btn-torch"     class="qr-btn" disabled style="display:none;"><i class="fa fa-lightbulb-o"></i> Linterna</button>
        <button id="btn-stop"      class="qr-btn" disabled><i class="fa fa-stop"></i> Detener</button>
        <button id="btn-start"     class="qr-btn" disabled><i class="fa fa-play"></i> Iniciar</button>

        <label class="qr-btn" style="margin-left:auto;">
          <i class="fa fa-upload"></i> Leer desde imagen
          <!-- cámara o galería en móvil, selector en PC -->
          <input type="file" id="file-qr" accept="image/*" capture="environment" style="display:none">
        </label>
      </div>
      <div class="qr-status" id="qr-status">Cargando librería…</div>
      <?php if (!$isHttps): ?>
      <div class="qr-status bad" style="margin-top:6px;">⚠ Debes usar HTTPS para acceder a la cámara.</div>
      <?php endif; ?>
    </div>
  </div>
</div>

<script>
// Utilidades de UI
const elStatus = document.getElementById('qr-status');
function log(h){ elStatus.innerHTML = h || ''; }
function ok(m){ log('<span class="ok">'+m+'</span>'); }
function bad(m){ log('<span class="bad">'+m+'</span>'); }
function isUrl(s){ try{ new URL(s); return true; }catch(_){ return false; } }

// === Carga SOLO desde tu servidor (evitamos bloqueos por CDN/CSP) ===
const LIB_SOURCES = [
  '<?= htmlspecialchars("/js/html5-qrcode.min.js?v=".time(), ENT_QUOTES, "UTF-8"); ?>'
];

function loadScriptSeq(sources, idx=0){
  return new Promise((resolve, reject)=>{
    if (idx >= sources.length) return reject(new Error('No se pudo cargar html5-qrcode en local.'));
    const src = sources[idx];
    const s = document.createElement('script');
    s.src = src;
    s.async = true;
    s.onload = () => { ok('Librería cargada desde: <strong>'+src+'</strong>.'); resolve(true); };
    s.onerror = () => { bad('Fallo cargando: '+src); reject(new Error('Fallo cargando '+src)); };
    document.head.appendChild(s);
  });
}

let html5QrCode = null;
let camerasCache = [];
let currentCamId = null;
let torchOn = false;
let startedOnce = false;
let lastDecoded = '', lastTs = 0;

const selCam      = document.getElementById('cam-select');
const btnSwitch   = document.getElementById('btn-switch');
const btnTorch    = document.getElementById('btn-torch');
const btnStop     = document.getElementById('btn-stop');
const btnStart    = document.getElementById('btn-start');
const btnPerm     = document.getElementById('btn-permission');
const btnActivate = document.getElementById('btn-activate');

async function listCamerasAndFill(selectedId=null){
  try{
    camerasCache = await Html5Qrcode.getCameras();
    selCam.innerHTML = '';
    if (!camerasCache || camerasCache.length === 0){
      selCam.disabled = true; btnSwitch.disabled = true;
      bad('No se encontró cámara. Toca “Solicitar permiso de cámara” o sube una imagen del QR.');
      return;
    }
    selCam.disabled = false; btnSwitch.disabled = camerasCache.length < 2;

    const saved = localStorage.getItem('qr_cam_id');

    camerasCache.forEach((c, i)=>{
      const opt = document.createElement('option');
      opt.value = c.id;
      opt.textContent = c.label || ('Cámara ' + (i+1));
      selCam.appendChild(opt);
    });

    if (selectedId){ selCam.value = selectedId; }
    else if (saved && camerasCache.some(c=>c.id===saved)){ selCam.value = saved; }
    else {
      const back = camerasCache.find(c => /back|trás|rear|environment/i.test(c.label||''));
      selCam.value = (back ? back.id : camerasCache[0].id);
    }
  }catch(err){
    bad('No se pudo listar cámaras: ' + (err?.message || err));
  }
}

async function startScanner(cameraId=null){
  try{
    if (!window.Html5Qrcode) throw new Error('Librería no cargada.');
    if (!html5QrCode) html5QrCode = new Html5Qrcode("qr-reader", false);

    await listCamerasAndFill(cameraId);
    const camId = cameraId || selCam.value;
    currentCamId = camId;
    localStorage.setItem('qr_cam_id', camId);

    const config = {
      fps: 12,
      qrbox: { width: 320, height: 320 },
      aspectRatio: 1.777,
      experimentalFeatures: { useBarCodeDetectorIfSupported: true }
    };

    await html5QrCode.start(
      { deviceId: { exact: camId } },
      config,
      onScanSuccess,
      onScanFailure
    );
    startedOnce = true;
    btnStop.disabled = false; btnStart.disabled = true;

    // Mostrar linterna sólo si es soportada
    try {
      const video = document.querySelector('#qr-reader video');
      const track = video?.srcObject?.getVideoTracks?.()[0];
      const caps  = track?.getCapabilities?.();
      if (caps && 'torch' in caps) {
        btnTorch.style.display = 'inline-flex';
        btnTorch.disabled = false;
      } else {
        btnTorch.style.display = 'none';
        btnTorch.disabled = true;
      }
    } catch(_) {
      btnTorch.style.display = 'none';
      btnTorch.disabled = true;
    }

    ok('Escaneando…');
  }catch(err){
    handleStartError(err);
  }
}

function handleStartError(err){
  const msg = (err && err.message) ? err.message : String(err || '');
  if (/Html5Qrcode/i.test(msg)){ bad('Error iniciando la cámara: Html5Qrcode no está disponible.'); }
  else if (/NotAllowedError|Permission|denied/i.test(msg)){ bad('Permiso de cámara denegado. Toca “Solicitar permiso de cámara”.'); }
  else if (/NotFoundError|no.*device/i.test(msg)){ bad('No hay cámara disponible o accesible en el dispositivo.'); }
  else if (/secure context|https/i.test(msg)){ bad('Debes usar HTTPS para acceder a la cámara.'); }
  else { bad('Error iniciando la cámara: ' + msg); }
}

async function stopScanner(){
  try{
    if (html5QrCode && html5QrCode.isScanning){
      await html5QrCode.stop();
      btnStop.disabled = true; btnStart.disabled = false;
      ok('Escáner detenido.');
    }
  }catch(_){}
}

async function switchCamera(){
  try{
    if (!camerasCache || camerasCache.length < 2){ bad('No se pudo cambiar de cámara.'); return; }
    const idx = camerasCache.findIndex(c => c.id === currentCamId);
    const next = camerasCache[(idx+1) % camerasCache.length];
    await stopScanner();
    await startScanner(next.id);
    selCam.value = next.id;
  }catch(_){ bad('No se pudo cambiar de cámara.'); }
}

async function setSelectedCamera(){
  const id = selCam.value;
  if (!id) return;
  localStorage.setItem('qr_cam_id', id);
  await stopScanner();
  await startScanner(id);
}

async function toggleTorch(){
  try{
    if (!html5QrCode) return;
    torchOn = !torchOn;
    await html5QrCode.applyVideoConstraints({ advanced: [{ torch: torchOn }] });
    ok(torchOn ? 'Linterna encendida.' : 'Linterna apagada.');
  }catch(_){ bad('Tu dispositivo/navegador no soporta linterna.'); }
}

function onScanSuccess(decodedText, _decoded){
  const now = Date.now();
  if (decodedText === lastDecoded && (now - lastTs) < 3000) return; // evita lecturas duplicadas (3s)
  lastDecoded = decodedText; lastTs = now;

  stopScanner();
  if (isUrl(decodedText)){
    ok('Código detectado. Redirigiendo…<br><a class="qr-link" href="'+decodedText+'">'+decodedText+'</a>');
    setTimeout(()=>{ window.location.href = decodedText; }, 400);
  } else {
    ok('Código detectado: <strong>'+decodedText+'</strong>');
    if (confirm('El código no parece una URL. ¿Abrir igualmente?')) window.location.href = decodedText;
  }
}
function onScanFailure(_err){ /* lecturas fallidas normales: ignorar */ }

async function requestCameraPermission(){
  try{
    if (!navigator.mediaDevices?.getUserMedia){
      bad('Tu navegador no soporta getUserMedia.'); return;
    }
    const stream = await navigator.mediaDevices.getUserMedia({
      video: { facingMode: { ideal: "environment" } }, audio: false
    });
    stream.getTracks().forEach(t => t.stop());
    ok('Permiso concedido.');
    if (!startedOnce) { setTimeout(()=> startScanner(localStorage.getItem('qr_cam_id')||null), 150); }
  }catch(err){
    const msg = (err && err.message) ? err.message : String(err || '');
    if (/denied|NotAllowedError/i.test(msg)){
      bad('Permiso denegado. En el candado de la barra de direcciones → Cámara → Permitir.');
    } else {
      bad('No fue posible solicitar permiso: ' + msg);
    }
  }
}

// Fallback: leer QR desde imagen (permite cámara o galería en móvil)
document.getElementById('file-qr').addEventListener('change', async (e)=>{
  const file = e.target.files?.[0];
  if (!file) return;
  try{
    if (!window.Html5Qrcode) throw new Error('Librería no cargada.');
    if (!html5QrCode) html5QrCode = new Html5Qrcode("qr-reader");
    const result = await html5QrCode.scanFile(file, true);
    onScanSuccess(result);
  }catch(err){
    bad('No se pudo leer el QR de la imagen: ' + (err?.message || err));
  }finally{
    e.target.value = '';
  }
});

// Eventos UI
document.getElementById('btn-activate').addEventListener('click', async ()=>{
  await requestCameraPermission();   // gesto del usuario + permiso
  if (!startedOnce) setTimeout(()=> startScanner(localStorage.getItem('qr_cam_id')||null), 150);
});
document.getElementById('btn-permission').addEventListener('click', requestCameraPermission);
selCam  .addEventListener('change', setSelectedCamera);
btnSwitch.addEventListener('click', switchCamera);
btnTorch .addEventListener('click', toggleTorch);
btnStop  .addEventListener('click', stopScanner);
btnStart .addEventListener('click', ()=> startScanner(localStorage.getItem('qr_cam_id')||null));

// Cargar librería y AUTO-INICIAR si hay permiso
(async function init(){
  try{
    await loadScriptSeq(LIB_SOURCES);
  }catch(err){
    bad('No se pudo cargar la librería del escáner: ' + (err?.message || err));
    return;
  }

  // Si ya hay permiso concedido, arranca solo
  try{
    if (navigator.permissions && navigator.permissions.query){
      const st = await navigator.permissions.query({ name: 'camera' });
      st.onchange = async () => {
        if (st.state === 'granted' && !startedOnce) startScanner(localStorage.getItem('qr_cam_id')||null);
      };
      if (st.state === 'granted'){
        await startScanner(localStorage.getItem('qr_cam_id')||null);
        return;
      }
      if (st.state === 'prompt'){
        // algunos navegadores permiten mostrar el prompt al cargar
        try { await requestCameraPermission(); } catch(_){}
      }
    } else {
      // fallback: intentar solicitar permiso directamente
      try { await requestCameraPermission(); } catch(_){}
    }
  }catch(_){}

  // Si no se pudo iniciar aún, deja botones listos
  btnStart.disabled = false; btnStop.disabled = true; btnTorch.disabled = true;
})();
</script>

<?php
    include "view/footer.html";

  } else {
    include "view/headeradmin.html"; ?>
    <div class="box">
      <div class="box-header with-border"><h3>Escáner de QR</h3></div>
      <div class="box-body"><p>Inicia sesión como usuario normal para usar el escáner.</p></div>
    </div>
    <?php include "view/footer.html";
  }
} else {
  header("Location:index.html");
}
