<?php
// public_html/colegio/colegio10/rrhh_home/scan_vacacion_upload.php
// Mejora de "escaneo": nitidez + compresin, en COLOR, con recorte opcional

session_start();
include('dbcon.php');

if (!isset($_SESSION['idsucursal'])) { die('Sesin expirada.'); }

$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
if ($id<=0) { die('ID invlido'); }
if (empty($_FILES['archivo']['name'])) { die('Sin archivo'); }

@date_default_timezone_set('America/Costa_Rica');

$dir = "Files/Ingreso_vacaciones/";
if (!is_dir($dir)) { @mkdir($dir, 0775, true); }

// ==================== AJUSTES (puedes retocar aqu) ====================
$OUTPUT_DPI     = 200;      // DPI objetivo del PDF (equilibrio ntido/peso)
$JPEG_QUALITY   = 78;       // Calidad JPEG embebido (60-85 tpico). 78  buena
$SAT_BOOST      = 108;      // Saturacin (100=igual). Un toque de color
$BRIGHT_BOOST   = 104;      // Brillo (100=igual)
$CONTRAST_STEPS = 1;        // Pasos de contraste suaves (0-2)
$TRIM_FUZZ      = 8;        // Borde a recortar (Imagick trimImage fuzz)
$BORDER_PX      = 20;       // Margen blanco tras recorte
$SHARP_USM      = array(1.2, 0.6, 0.8, 0.03); // UnsharpMask: amount, radius, threshold
// ======================================================================

$origName = $_FILES['archivo']['name'];
$tmp      = $_FILES['archivo']['tmp_name'];
$size     = (int)$_FILES['archivo']['size'];
$ext      = strtolower(pathinfo($origName, PATHINFO_EXTENSION));

if ($size <= 0 || !is_uploaded_file($tmp)) { die('Carga invlida.'); }
if ($size > 25*1024*1024) { die('Archivo demasiado grande.'); }

// ----- Coordenadas de recorte (desde la UI con Cropper.js)
$crop_x = isset($_POST['crop_x']) ? (int)$_POST['crop_x'] : 0;
$crop_y = isset($_POST['crop_y']) ? (int)$_POST['crop_y'] : 0;
$crop_w = isset($_POST['crop_w']) ? (int)$_POST['crop_w'] : 0;
$crop_h = isset($_POST['crop_h']) ? (int)$_POST['crop_h'] : 0;
$crop_rotate = isset($_POST['crop_rotate']) ? (int)$_POST['crop_rotate'] : 0;

// Helper: finalizar
function approve_and_redirect($con, $id, $storedPath, $extra=''){
  // Cambia SOLO el status segn tipo_ausencia. No modifica cantidad_dias.
  $sql = "UPDATE ingreso_vacaciones
          SET imagen1 = ?,
              status = CASE
                  WHEN tipo_ausencia = 'Permiso pagado' THEN 3
                  WHEN tipo_ausencia = 'Permiso sin goce de salario' THEN 4
                  ELSE 1  -- Vacaciones u otros: flujo normal
              END
          WHERE id = ?";

  if ($stmt = mysqli_prepare($con, $sql)) {
    mysqli_stmt_bind_param($stmt, "si", $storedPath, $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
  }

  $dest = 'https://hr.jportales.com/consulta_vacaciones.php';
  $msg  = urlencode('Documento procesado a color (ntido y comprimido) y registro aprobado correctamente.'.$extra);
  echo "<script>
    alert('Documento procesado a color (ntido y comprimido) y registro aprobado correctamente.');
    window.location.href = '{$dest}?msg={$msg}';
  </script>";
  exit;
}



// PDF directo (no recortamos/alteramos PDFs)
if ($ext === 'pdf') {
  $safe = 'vac_'.$id.'_'.time().'.pdf';
  $target = $dir.$safe;
  if (!move_uploaded_file($tmp, $target)) { die('No se pudo guardar el PDF.'); }
  approve_and_redirect($con, $id, $target, '');
}

// =================== IMAGEN -> PDF A COLOR (recorte + nitidez + compresin) ===================
$safePdf   = 'vac_'.$id.'_'.time().'.pdf';
$targetPdf = $dir.$safePdf;

// Calcula A4 en pxeles al DPI objetivo
$a4w = (int)round(8.27 * $OUTPUT_DPI);
$a4h = (int)round(11.69 * $OUTPUT_DPI);

// ---------- Preferencia: IMAGICK (mejor calidad y control) ----------
if (class_exists('Imagick')) {
  $ok = false;
  try {
    $img = new Imagick();
    $img->readImage($tmp);

    // Normalizaciones bsicas
    if (method_exists($img,'stripImage'))  { $img->stripImage(); }
    if (method_exists($img,'autoOrient'))  { $img->autoOrient(); }

    // Rotacin por UI (si aplica)
    if ($crop_rotate != 0 && method_exists($img,'rotateImage')) {
      $img->rotateImage(new ImagickPixel('white'), $crop_rotate);
    }

    // Recorte del usuario (si vino)
    if ($crop_w > 0 && $crop_h > 0 && method_exists($img,'cropImage')) {
      $iw = $img->getImageWidth();
      $ih = $img->getImageHeight();
      $x  = max(0, min($crop_x, $iw-1));
      $y  = max(0, min($crop_y, $ih-1));
      $w  = max(1, min($crop_w, $iw - $x));
      $h  = max(1, min($crop_h, $ih - $y));
      $img->cropImage($w, $h, $x, $y);
      $img->setImagePage(0,0,0,0);
    }

    // Limpiezas suaves con COLOR (nada de B/N)
    if (method_exists($img,'enhanceImage'))  { $img->enhanceImage(); }
    if (method_exists($img,'reduceNoiseImage')) { $img->reduceNoiseImage(1); }
    for ($i=0; $i<$CONTRAST_STEPS; $i++) {
      if (method_exists($img,'contrastImage')) { $img->contrastImage(1); }
    }
    // Unsharp mask: amount, radius, threshold
    if (method_exists($img,'unsharpMaskImage')) {
      $img->unsharpMaskImage($SHARP_USM[0], $SHARP_USM[1], $SHARP_USM[2], $SHARP_USM[3]);
    } elseif (method_exists($img,'sharpenImage')) {
      $img->sharpenImage(0.5, 1.0);
    }
    // Brillo/Saturacin suave
    if (method_exists($img,'modulateImage')) { $img->modulateImage($BRIGHT_BOOST, $SAT_BOOST, 100); }

    // Trim de bordes + margen
    if (method_exists($img,'trimImage')) { $img->trimImage($TRIM_FUZZ); }
    if (method_exists($img,'borderImage')) { $img->borderImage('white', $BORDER_PX, $BORDER_PX); }

    // Sombra sutil (look escner)
    $shadow = new Imagick();
    $shadow->newImage($img->getImageWidth()+40, $img->getImageHeight()+40, new ImagickPixel('transparent'), 'png');
    $shadowLayer = new Imagick();
    $shadowLayer->newImage($img->getImageWidth(), $img->getImageHeight(), new ImagickPixel('black'), 'png');
    $shadowLayer->setImageAlphaChannel(Imagick::ALPHACHANNEL_SET);
    $shadowLayer->setImageBackgroundColor(new ImagickPixel('black'));
    if (method_exists($shadowLayer,'evaluateImage')) { $shadowLayer->evaluateImage(Imagick::EVALUATE_MULTIPLY, 0.22, Imagick::CHANNEL_ALPHA); }
    if (method_exists($shadowLayer,'blurImage'))      { $shadowLayer->blurImage(8,4); }
    $shadow->compositeImage($shadowLayer, Imagick::COMPOSITE_OVER, 20, 20);
    $shadow->compositeImage($img, Imagick::COMPOSITE_OVER, 0, 0);

    // **Redimensionar a A4 @ $OUTPUT_DPI**, manteniendo color
    $shadow->setImageUnits(Imagick::RESOLUTION_PIXELSPERINCH);
    $shadow->setImageResolution($OUTPUT_DPI, $OUTPUT_DPI);
    $shadow->mergeImageLayers(Imagick::LAYERMETHOD_FLATTEN);
    $shadow->setImageBackgroundColor('white');
    $shadow->resizeImage($a4w, $a4h, Imagick::FILTER_LANCZOS, 1, true);

    // Opciones para **comprimir** mejor el PDF (JPEG optimizado)
    $shadow->setImageFormat('pdf');
    $shadow->setImageCompression(Imagick::COMPRESSION_JPEG);
    $shadow->setImageCompressionQuality($JPEG_QUALITY);
    $shadow->setOption('jpeg:optimize-coding', 'true');
    $shadow->setOption('pdf:use-cropbox', 'true');
    $shadow->setInterlaceScheme(Imagick::INTERLACE_JPEG); // tama09o menor en algunos viewers

    $shadow->writeImage($targetPdf);
    $shadow->clear(); $shadow->destroy();
    $img->clear(); $img->destroy();

    $ok = file_exists($targetPdf);
  } catch (Exception $e) {
    $ok = false;
  }

  if ($ok) {
    approve_and_redirect($con, $id, $targetPdf, ' (recorte aplicado)');
  }
}

// ---------- Fallback: GD (ms simple, pero tambin ntido y comprimido) ----------

function load_image_any($tmp, $ext){
  switch($ext){
    case 'jpg': case 'jpeg': return @imagecreatefromjpeg($tmp);
    case 'png':              return @imagecreatefrompng($tmp);
    case 'gif':              return @imagecreatefromgif($tmp);
    case 'bmp':              return @imagecreatefrombmp($tmp);
    default: return false;
  }
}

function gd_sharpen_convolution(&$im){
  // Matriz de enfoque moderado
  $matrix = array(
    array( -1, -1, -1 ),
    array( -1,  16, -1 ),
    array( -1, -1, -1 )
  );
  $divisor = 8; $offset = 0;
  @imageconvolution($im, $matrix, $divisor, $offset);
}

function gd_image_to_pdf_a4_color($gd, $targetPdf, $a4w, $a4h, $jpegQuality){
  // Lienzo A4 color + sombra + margen
  $canvas = imagecreatetruecolor($a4w, $a4h);
  imagealphablending($canvas, true);
  imagesavealpha($canvas, false);
  $white  = imagecolorallocate($canvas, 255,255,255);
  imagefill($canvas, 0,0, $white);

  // Sombra suave
  $shadow = imagecolorallocatealpha($canvas, 0, 0, 0, 110);
  imagefilledrectangle($canvas, 80, 80, $a4w-60, $a4h-40, $shadow);

  // Escala a pgina con mrgenes
  $w = imagesx($gd); $h = imagesy($gd);
  $maxW = $a4w - 160; $maxH = $a4h - 160;
  $scale = min($maxW/$w, $maxH/$h);
  if ($scale > 1) $scale = 1;
  $dw = (int)($w*$scale); $dh = (int)($h*$scale);
  $dx = (int)(($a4w - $dw)/2) - 10;
  $dy = (int)(($a4h - $dh)/2) - 10;

  // Mejoras suaves manteniendo color
  if (function_exists('imagefilter')) {
    @imagefilter($gd, IMG_FILTER_SMOOTH, 2);
    @imagefilter($gd, IMG_FILTER_CONTRAST, -8);
    @imagefilter($gd, IMG_FILTER_BRIGHTNESS, 4);
  }
  gd_sharpen_convolution($gd); // nitidez

  // Pegar en lienzo
  imagecopyresampled($canvas, $gd, $dx, $dy, 0,0, $dw,$dh, $w,$h);

  // JPEG a memoria (comprimido)
  ob_start();
  imagejpeg($canvas, null, $jpegQuality);
  $imgData = ob_get_clean();
  imagedestroy($canvas);

  // PDF mnimo con JPEG incrustado
  $unit = 72; $a4wpt = 8.27*$unit; $a4hpt = 11.69*$unit;
  $ofs = array();
  $pdf = "%PDF-1.3\n";
  $ofs[] = strlen($pdf);
  $pdf .= "1 0 obj<< /Type /Catalog /Pages 2 0 R >>endobj\n";
  $ofs[] = strlen($pdf);
  $pdf .= "2 0 obj<< /Type /Pages /Count 1 /Kids [3 0 R] >>endobj\n";
  $ofs[] = strlen($pdf);
  $pdf .= "3 0 obj<< /Type /Page /Parent 2 0 R /MediaBox [0 0 ".sprintf('%.2f %.2f',$a4wpt,$a4hpt)."] /Resources << /XObject << /Im0 5 0 R >> /ProcSet [/PDF /ImageC] >> /Contents 4 0 R >>endobj\n";
  $stream = "q\n".sprintf('%.2f 0 0 %.2f 0 0 cm',$a4wpt,$a4hpt)."\n/Im0 Do\nQ\n";
  $ofs[] = strlen($pdf);
  $pdf .= "4 0 obj<< /Length ".strlen($stream)." >>stream\n".$stream."endstream\nendobj\n";
  $ofs[] = strlen($pdf);
  $pdf .= "5 0 obj<< /Type /XObject /Subtype /Image /Width ".$a4w." /Height ".$a4h." /ColorSpace /DeviceRGB /BitsPerComponent 8 /Filter /DCTDecode /Length ".strlen($imgData)." >>stream\n";
  $pdf .= $imgData."\nendstream\nendobj\n";
  $xrefPos = strlen($pdf);
  $pdf .= "xref\n0 6\n0000000000 65535 f \n";
  foreach ($ofs as $o){ $pdf .= sprintf("%010d 00000 n \n", $o); }
  $pdf .= "trailer<< /Size 6 /Root 1 0 R >>\nstartxref\n".$xrefPos."\n%%EOF";
  return (bool)file_put_contents($targetPdf, $pdf);
}

// Carga imagen original
$im = load_image_any($tmp, $ext);
if (!$im) { die('No se pudo leer la imagen.'); }

// Rotacin entera si vino un ngulo estndar
if (in_array($crop_rotate, array(-270,-180,-90,0,90,180,270))) {
  if ($crop_rotate != 0) {
    $bg = imagecolorallocate($im, 255,255,255);
    $rot = imagerotate($im, -$crop_rotate, $bg); // signo invertido para coincidir
    if ($rot) { imagedestroy($im); $im = $rot; }
  }
}

// Recorte si mandaron coords
$iw = imagesx($im); $ih = imagesy($im);
if ($crop_w > 0 && $crop_h > 0) {
  $x = max(0, min($crop_x, $iw-1));
  $y = max(0, min($crop_y, $ih-1));
  $w = max(1, min($crop_w, $iw - $x));
  $h = max(1, min($crop_h, $ih - $y));
  $crop = imagecreatetruecolor($w, $h);
  $white = imagecolorallocate($crop, 255,255,255);
  imagefill($crop, 0,0, $white);
  imagecopy($crop, $im, 0,0, $x,$y, $w,$h);
  imagedestroy($im);
  $im = $crop;
}

// Peque09o trim heurstico de blancos
function simple_trim_gd($img){
  $w = imagesx($img); $h = imagesy($img);
  $whiteThr = 245;
  $left=0;$right=$w-1;$top=0;$bottom=$h-1;
  for($x=0;$x<$w;$x++){
    $wh=0;
    for($y=0;$y<$h;$y+=max(1,(int)($h/100))){
      $rgb=imagecolorat($img,$x,$y); $r=$rgb>>16&0xFF; $g=$rgb>>8&0xFF; $b=$rgb&0xFF;
      if($r>$whiteThr&&$g>$whiteThr&&$b>$whiteThr){$wh++;}
    }
    if($wh<5){$left=$x;break;}
  }
  for($x=$w-1;$x>=0;$x--){
    $wh=0;
    for($y=0;$y<$h;$y+=max(1,(int)($h/100))){
      $rgb=imagecolorat($img,$x,$y); $r=$rgb>>16&0xFF; $g=$rgb>>8&0xFF; $b=$rgb&0xFF;
      if($r>$whiteThr&&$g>$whiteThr&&$b>$whiteThr){$wh++;}
    }
    if($wh<5){$right=$x;break;}
  }
  for($y=0;$y<$h;$y++){
    $wh=0;
    for($x=0;$x<$w;$x+=max(1,(int)($w/100))){
      $rgb=imagecolorat($img,$x,$y); $r=$rgb>>16&0xFF; $g=$rgb>>8&0xFF; $b=$rgb&0xFF;
      if($r>$whiteThr&&$g>$whiteThr&&$b>$whiteThr){$wh++;}
    }
    if($wh<5){$top=$y;break;}
  }
  for($y=$h-1;$y>=0;$y--){
    $wh=0;
    for($x=0;$x<$w;$x+=max(1,(int)($w/100))){
      $rgb=imagecolorat($img,$x,$y); $r=$rgb>>16&0xFF; $g=$rgb>>8&0xFF; $b=$rgb&0xFF;
      if($r>$whiteThr&&$g>$whiteThr&&$b>$whiteThr){$wh++;}
    }
    if($wh<5){$bottom=$y;break;}
  }
  $cw=max(20,$right-$left+1); $ch=max(20,$bottom-$top+1);
  $out=imagecreatetruecolor($cw,$ch);
  $white=imagecolorallocate($out,255,255,255);
  imagefill($out,0,0,$white);
  imagecopy($out,$img,0,0,$left,$top,$cw,$ch);
  imagedestroy($img);
  return $out;
}
$im = simple_trim_gd($im);

// Render a PDF (A4 @ DPI objetivo) con nitidez + compresin
$ok = gd_image_to_pdf_a4_color($im, $targetPdf, $a4w, $a4h, $JPEG_QUALITY);
imagedestroy($im);

if ($ok) {
  approve_and_redirect($con, $id, $targetPdf, ' (recorte aplicado)');
}

die('No fue posible convertir la imagen a PDF en el servidor.');
