<?php
// public_html/colegio/colegio10/rrhh_home/scan_vacacion.php
session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) {
  header("Location:index.html");
  exit;
}

include('dbcon.php');

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) { die('ID inválido'); }

/* ===== CARGA DEL REGISTRO ===== */
$sql = "SELECT a.*,
               c.nombre_completo AS empleado,
               a.idformulario    AS idformulario
        FROM ingreso_vacaciones a
        LEFT JOIN empleados_planilla c ON c.id=a.idempleado
        WHERE a.id=?";
if (!$stmt = mysqli_prepare($con,$sql)) { die(mysqli_error($con)); }
mysqli_stmt_bind_param($stmt,"i",$id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$row = mysqli_fetch_assoc($res);
mysqli_stmt_close($stmt);
if (!$row) { die('Registro no encontrado'); }

/* ===== Variables útiles ===== */
$empleado         = $row['empleado'];
$idrecibido         = $row['id'];
$fecha_desde     = $row['fecha_desde'];
$fecha_hasta      = $row['fecha_hasta'];
$comentario       = $row['comentarios'];
$cantidad_dias       = $row['cantidad_dias'];
$archivo          = $row['archivo'];
$idformulario     = (int)$row['idformulario'];
$estado_aprob     = $row['aprobado']; // S|N
$fecha_documento  = $row['fecha_documento'];
$motivo = $row['motivo'];

$sql = "SELECT a.*,
               c.nombre_completo AS empleado,
               a.idformulario    AS idformulario
        FROM ingreso_vacaciones a
        LEFT JOIN empleados_planilla c ON c.id=a.idempleado
        WHERE a.id=?";
if (!$stmt = mysqli_prepare($con,$sql)) { die(mysqli_error($con)); }
mysqli_stmt_bind_param($stmt,"i",$id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$row = mysqli_fetch_assoc($res);
mysqli_stmt_close($stmt);
if (!$row) { die('Registro no encontrado'); }

/* utilidades */
function esc($s){ return htmlspecialchars((string)$s,ENT_QUOTES,'UTF-8'); }

/* URLs auxiliares */
$fv_id      = isset($row['idformulario']) ? (int)$row['idformulario'] : 0;
$previewUrl = $fv_id ? "https://jportales.com/colegio/colegio10/rrhh_home/formulario_vacaciones_imprimir.php?id=".$fv_id : "";

/* archivo actual (si existe) */
$actual = '';
foreach (array('imagen1','imagen','archivo','doc') as $c) {
  if (isset($row[$c]) && trim($row[$c])!=='') { $actual = trim($row[$c]); break; }
}

/* mensaje opcional */
$msg = isset($_GET['msg']) ? $_GET['msg'] : '';

/* ===== VISTA CON HEADER DEL SISTEMA ===== */
if ($_SESSION["superadmin"] != "S") {
  include "./view/header.php";
  ?>
  <script type="text/javascript">
    $('#payroll_control').addClass("treeview active");
    $('#payroll_control_2').addClass("treeview active");
    $('#payroll_control_2_1').addClass("active");
  </script>

  <!-- Cropper.js (solo cuando recortas imágenes) -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>

  <style>
    .card{border:1px solid #e5e5e5;border-radius:8px;margin-bottom:16px;background:#fff;box-shadow:0 1px 2px rgba(0,0,0,.03)}
    .card-header{padding:10px 14px;border-bottom:1px solid #eee;font-weight:600;background:#f9fbfd}
    .card-body{padding:14px}
    .mini{font-size:12px;color:#777}
    .kv{margin-bottom:6px}
    .kv b{display:inline-block;min-width:180px}
    .preview-wrap{border:1px solid #e1e1e1;border-radius:6px;overflow:hidden;background:#fff}
    iframe.preview{width:100%;height:55vh;max-height:520px;border:0;display:block}
    .doc-nowrap{max-height:68vh;overflow:auto;border:1px dashed #ddd;border-radius:6px;padding:8px;background:#fff}
    .btn-row{display:flex;gap:8px;justify-content:flex-end;flex-wrap:wrap}
    .cropper-area{display:none;margin-top:10px}
    .cropper-container{max-width:100%}
    #cropperCanvasWrap{border:1px dashed #bbb;border-radius:6px;padding:6px;background:#fafafa}
    .hint{font-size:12px;color:#666}
  </style>

  <div class="box">
    <div class="box-header with-border">
      <h3 class="box-title">Vacation • Scan / Upload document &amp; approve</h3>
      <div class="box-tools pull-right">
        <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
        <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
      </div>
    </div>

    <div class="box-body">
      <?php if ($msg !== ''): ?>
        <div class="alert alert-success"><?php echo esc($msg); ?></div>
      <?php endif; ?>

      <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-header">Detalle del registro</div>
            <div class="card-body">
              <div class="kv"><b>ID registro:</b> #<?php echo $idrecibido; ?></div>
              <div class="kv"><b>Colaborador:</b> <?php echo $empleado; ?></div>
              <div class="kv"><b>Fecha documento:</b> <?php echo $fecha_documento; ?></div>
              <div class="kv"><b>Desde / Hasta:</b> <?php echo $fecha_desde; ?> → <?php echo $fecha_hasta; ?></div>
              <div class="kv"><b>Días solicitados:</b> <?php echo $cantidad_dias; ?></div>
              <div class="kv"><b>Motivo:</b> <?php echo $motivo; ?></div>
            </div>
          </div>

          <?php if ($previewUrl): ?>
          <div class="card">
            <div class="card-header">Preview del formulario (FV #<?php echo $fv_id; ?>)</div>
            <div class="card-body">
              <div class="preview-wrap">
                <iframe class="preview" src="<?php echo esc($previewUrl); ?>"
                        referrerpolicy="no-referrer"
                        sandbox="allow-same-origin allow-scripts allow-forms"></iframe>
              </div>
              <div class="mini" style="margin-top:6px">
                ¿No se carga? <a target="_blank" href="<?php echo esc($previewUrl); ?>">Abrir en nueva pestaña</a>.
              </div>
            </div>
          </div>
          <?php endif; ?>

          <div class="card">
            <div class="card-header">Documento actual</div>
            <div class="card-body">
              <div class="doc-nowrap">
                <?php if ($actual): ?>
                  <?php if (preg_match('~\.pdf$~i',$actual)): ?>
                    <embed src="<?php echo esc($actual); ?>" type="application/pdf" style="width:100%;height:60vh;">
                  <?php else: ?>
                    <img src="<?php echo esc($actual); ?>" class="img-responsive" style="max-width:100%;height:auto;border:1px solid #ddd;border-radius:6px">
                  <?php endif; ?>
                <?php else: ?>
                  <span class="text-muted">Sin archivo cargado.</span>
                <?php endif; ?>
              </div>
              <?php if ($actual): ?>
                <div class="mini" style="margin-top:6px">Archivo: <a target="_blank" href="<?php echo esc($actual); ?>"><?php echo esc($actual); ?></a></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="card">
            <div class="card-header">Subir / Tomar foto (con recorte opcional, se guardará como PDF a color y aprobará)</div>
            <div class="card-body">
              <form id="scanForm" method="post" action="scan_vacacion_upload.php?id=<?php echo $idrecibido; ?>" enctype="multipart/form-data" class="form">
                <input type="hidden" name="id" value="<?php echo $idrecibido; ?>">

                <!-- Coordenadas del recorte (las llena JS si hay imagen) -->
                <input type="hidden" name="crop_x" id="crop_x">
                <input type="hidden" name="crop_y" id="crop_y">
                <input type="hidden" name="crop_w" id="crop_w">
                <input type="hidden" name="crop_h" id="crop_h">
                <input type="hidden" name="crop_rotate" id="crop_rotate">
                <input type="hidden" name="crop_scaleX" id="crop_scaleX">
                <input type="hidden" name="crop_scaleY" id="crop_scaleY">
                <input type="hidden" name="orig_w" id="orig_w">
                <input type="hidden" name="orig_h" id="orig_h">

                <div class="form-group">
                  <label>Archivo</label>
                  <input type="file"
                         id="archivo"
                         name="archivo"
                         class="form-control"
                         accept="image/*,application/pdf"
                         capture="environment" required>
                  <p class="help-block mini">
                    • Sube una <b>imagen</b> (JPG/PNG) o <b>PDF</b>.<br>
                    • Si subes imagen, puedes <b>recortar</b> el área de la hoja antes de subir.<br>
                    • Tamaño máximo recomendado 25&nbsp;MB.
                  </p>
                  <div class="hint">Tip: coloca el documento sobre una mesa y encuádralo, luego recorta la hoja.</div>
                </div>

                <!-- Área de recorte (solo para imágenes) -->
                <div id="cropperArea" class="cropper-area">
                  <div id="cropperCanvasWrap">
                    <img id="cropperImg" src="" alt="preview" style="max-width:100%; display:block;">
                  </div>
                  <div class="mini" style="margin-top:6px">
                    Usa el mouse o los dedos para ajustar el recuadro. Botones:
                  </div>
                  <div class="btn-row" style="margin-top:6px">
                    <button type="button" id="btnRotateLeft"  class="btn btn-default"><i class="fa fa-rotate-left"></i> Rotar -90°</button>
                    <button type="button" id="btnRotateRight" class="btn btn-default"><i class="fa fa-rotate-right"></i> Rotar +90°</button>
                    <button type="button" id="btnReset"       class="btn btn-default"><i class="fa fa-refresh"></i> Reset</button>
                    <button type="button" id="btnFit"         class="btn btn-default"><i class="fa fa-arrows-alt"></i> Ajustar</button>
                  </div>
                </div>

                <hr>
                <div class="btn-row">
                  <a class="btn btn-default" href="bandeja_vacaciones.php">Cancelar</a>
                  <button id="btnSubmit" class="btn btn-success">
                    <span class="fa fa-cloud-upload"></span> Guardar PDF a color y Aprobar
                  </button>
                </div>
              </form>
            </div>
          </div>

        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.box-body -->
  </div><!-- /.box -->

  <script>
  (function(){
    var fileInput   = document.getElementById('archivo');
    var cropImg     = document.getElementById('cropperImg');
    var cropArea    = document.getElementById('cropperArea');
    var form        = document.getElementById('scanForm');
    var cropper     = null;

    function destroyCropper(){
      if (cropper){ cropper.destroy(); cropper=null; }
    }

    fileInput.addEventListener('change', function(e){
      destroyCropper();
      var f = this.files && this.files[0] ? this.files[0] : null;
      if (!f) { cropArea.style.display='none'; return; }
      var isPdf = /pdf$/i.test(f.type) || /\.pdf$/i.test(f.name);
      if (isPdf) {
        // Si es PDF, no hay recorte
        cropArea.style.display='none';
        return;
      }
      // Imagen: activamos cropper
      var reader = new FileReader();
      reader.onload = function(ev){
        cropImg.src = ev.target.result;
        cropImg.onload = function(){
          cropArea.style.display = 'block';
          cropper = new Cropper(cropImg, {
            viewMode: 1,
            autoCropArea: 0.95,
            dragMode: 'move',
            aspectRatio: NaN, // libre
            responsive: true,
            background: false
          });
        }
      };
      reader.readAsDataURL(f);
    });

    // Botones de control
    var $ = function(id){ return document.getElementById(id); };
    $('btnRotateLeft').addEventListener('click', function(){ if(cropper) cropper.rotate(-90); });
    $('btnRotateRight').addEventListener('click', function(){ if(cropper) cropper.rotate(90); });
    $('btnReset').addEventListener('click', function(){ if(cropper) cropper.reset(); });
    $('btnFit').addEventListener('click', function(){ if(cropper) cropper.zoomTo(0.95); });

    // Antes de enviar, guardamos coords del recorte
    form.addEventListener('submit', function(ev){
      var f = fileInput.files && fileInput.files[0] ? fileInput.files[0] : null;
      if (!f) return;
      var isPdf = /pdf$/i.test(f.type) || /\.pdf$/i.test(f.name);
      if (isPdf || !cropper) {
        // PDF o sin cropper: no mandamos coordenadas
        return;
      }
      var data = cropper.getData(true);     // x,y,width,height,rotate,scaleX,scaleY
      var imgData = cropper.getImageData(); // naturalWidth/Height

      // set hidden inputs
      $('crop_x').value = Math.max(0, Math.round(data.x));
      $('crop_y').value = Math.max(0, Math.round(data.y));
      $('crop_w').value = Math.max(1, Math.round(data.width));
      $('crop_h').value = Math.max(1, Math.round(data.height));
      $('crop_rotate').value = Math.round(data.rotate || 0);
      $('crop_scaleX').value = data.scaleX || 1;
      $('crop_scaleY').value = data.scaleY || 1;
      $('orig_w').value = Math.round(imgData.naturalWidth || 0);
      $('orig_h').value = Math.round(imgData.naturalHeight || 0);
    });
  })();
  </script>

  <?php
  include "view/footer.html";
} else {
  include "view/headeradmin.html"; ?>
  <div class="box">
    <div class="box-header with-border"><h3 class="box-title">Scan / Upload document &amp; approve</h3></div>
    <div class="box-body">
      <p>Esta pantalla no requiere privilegios especiales. Inicie sesión como usuario normal para ver la versión completa.</p>
    </div>
  </div>
  <?php include "view/footer.html";
}
