var tabla;

$(function () {

  tabla = $('#tblEmpleados').DataTable({
    "processing": true,
    "serverSide": false,
    "ajax": {
      url: './ajax/consulta_empleadosajax.php?op=listar',
      type: 'GET',
      dataType: 'json',
      error: function (e) {
        console.error(e.responseText);
      }
    },
    "language": {
      "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json"
    }
  });

});

function eliminarEmpleado(idempleado) {

  if (!confirm("Desea eliminar este empleado?")) return;

  $.post(
    "./ajax/consulta_empleadosajax.php?op=delete",
    { idempleado: idempleado },
    function (resp) {
      alert(resp.success || resp.error);
      tabla.ajax.reload(null, false);
    },
    "json"
  );
}
