<?php
// rrhh_home/planilla_home.php
// Home Planilla: Buscador Empleado + Mes/Rango → Polilla HTML, KPIs y gráficas
// PHP 8.1.33 - UTF-8

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) { header("Location:index.html"); exit; }
$ES_SUPER = isset($_SESSION["superadmin"]) && $_SESSION["superadmin"] === "S";

require_once __DIR__ . '/dbcon.php';
mysqli_set_charset($con, 'utf8mb4');

// Empleados para Select2
$empleados = [];
$q = "SELECT id, nombre_completo, cedula, categoria FROM empleados_planilla ORDER BY nombre_completo ASC";
if ($rs = mysqli_query($con, $q)) { while ($r = mysqli_fetch_assoc($rs)) $empleados[] = $r; mysqli_free_result($rs); }

$MES_DEF = date('Y-m');

// Header normal del sistema
if (!$ES_SUPER) include __DIR__ . '/view/header.php';
else            include __DIR__ . '/view/headeradmin.html';
?>
<script>
  $('#payroll_control').addClass("treeview active");
  $('#payroll_control_2').addClass("treeview active");
</script>

<!-- Select2 y Chart.js (CDN) -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet"/>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>

<style>
  .cal-head{display:grid;grid-template-columns:repeat(7,1fr);gap:6px;margin-bottom:6px}
  .cal-head .dhead{border:1px solid #e6e6e6;border-radius:8px;padding:8px;text-align:center;background:#f1f5f9;font-weight:600;color:#334155}

  .kpi {border:1px solid #eee; border-radius:10px; padding:12px; text-align:center; margin-bottom:10px; background:#fff}
  .kpi h3{margin:0; font-weight:700}
  .kpi small{color:#666}
  .polilla-card{border:1px solid #e6e6e6; border-radius:10px; padding:12px; background:#fff}
  .polilla-card h4{margin-top:0}
  .help {color:#777; font-size:12px}
  .scope-hint{margin:8px 0 4px; color:#475569; font-size:12px}
  .mode-pill{display:inline-block; margin-right:12px}
</style>

<div class="box">
  <div class="box-header with-border">
    <h3>Planilla – Home (Horas Extra &amp; Polilla)</h3>
    <div class="box-tools pull-right">
      <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
    </div>
  </div>

  <div class="box-body">
    <!-- Buscador -->
    <div class="row" style="margin-bottom:12px">
      <div class="col-md-4">
        <label>Empleado</label>
        <select id="empleado" class="form-control select2" style="width:100%">
          <option value="">-- Seleccione --</option>
          <?php foreach($empleados as $e): ?>
            <option value="<?= (int)$e['id'] ?>">
              <?= htmlspecialchars($e['nombre_completo']) ?> - <?= htmlspecialchars($e['cedula']) ?>
              (<?= htmlspecialchars($e['categoria']) ?>)
            </option>
          <?php endforeach; ?>
        </select>
        <div class="help">Busque por nombre o cédula</div>
      </div>

      <!-- Selector de modo: Mes o Rango -->
      <div class="col-md-5">
        <label>Período</label><br>
        <label class="mode-pill">
          <input type="radio" name="modo" value="month" checked> Mes
        </label>
        <label class="mode-pill">
          <input type="radio" name="modo" value="range"> Rango de fechas
        </label>

        <!-- Controles de MES -->
        <div id="boxMes" style="margin-top:6px;">
          <input type="month" id="mes" class="form-control" style="max-width:240px" value="<?= htmlspecialchars($MES_DEF) ?>">
        </div>

        <!-- Controles de RANGO -->
        <div id="boxRango" style="display:none; margin-top:6px;">
          <div class="form-inline">
            <input type="date" id="desde" class="form-control" style="width:160px">
            <span style="margin:0 6px">→</span>
            <input type="date" id="hasta" class="form-control" style="width:160px">
          </div>
          <div class="help">Seleccione Desde y Hasta (incluye ambos días)</div>
        </div>
      </div>

      <div class="col-md-3">
        <label>&nbsp;</label><br>
        <button id="btnPolilla" class="btn btn-primary">Ver polilla</button>
        <!-- Exportar Dashboard (se mantiene por MES) -->
        <button id="btnExpExcel" class="btn btn-success">Exportar Dashboard (Excel)</button>
        <button id="btnExpPDF" class="btn btn-danger">Exportar Dashboard (PDF)</button>
      </div>
    </div>

    <div class="scope-hint" id="scopeHint">Mostrando: <b>General del mes</b></div>

    <!-- KPIs HORAS -->
    <div class="row">
      <div class="col-sm-3"><div class="kpi"><small>Horas 1.5x</small><h3 id="kpi15">0.00</h3></div></div>
      <div class="col-sm-3"><div class="kpi"><small>Horas 2.0x</small><h3 id="kpi20">0.00</h3></div></div>
      <div class="col-sm-3"><div class="kpi"><small>Horas 3.0x</small><h3 id="kpi30">0.00</h3></div></div>
      <div class="col-sm-3"><div class="kpi"><small>Total del período</small><h3 id="kpiTot">0.00</h3></div></div>
    </div>

    <!-- KPIs MONTOS -->
    <div class="row" style="margin-top:8px">
      <div class="col-sm-3"><div class="kpi"><small>Monto 1.5x</small><h3 id="mk15">₡0.00</h3></div></div>
      <div class="col-sm-3"><div class="kpi"><small>Monto 2.0x</small><h3 id="mk20">₡0.00</h3></div></div>
      <div class="col-sm-3"><div class="kpi"><small>Monto 3.0x</small><h3 id="mk30">₡0.00</h3></div></div>
      <div class="col-sm-3"><div class="kpi"><small>Total a pagar</small><h3 id="mkT">₡0.00</h3></div></div>
    </div>

    <!-- Gráficas -->
    <div class="row">
      <div class="col-md-6">
        <div class="box">
          <div class="box-header with-border"><h3 class="box-title">Horas por factor (período)</h3></div>
          <div class="box-body"><canvas id="chartFactor" height="180"></canvas></div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="box">
          <div class="box-header with-border"><h3 class="box-title">Top 5 colaboradores por horas extra</h3></div>
          <div class="box-body"><canvas id="chartTop" height="180"></canvas></div>
        </div>
      </div>
    </div>

    <!-- Resultado polilla (no se usa aquí, pero lo dejamos) -->
    <div class="polilla-card" id="polillaCard" style="display:none">
      <h4>Polilla de pago</h4>
      <div id="polillaHtml"></div>
    </div>
  </div>
</div>

<script>
// Toggle Mes / Rango
$('input[name="modo"]').on('change', function(){
  const v = $('input[name="modo"]:checked').val();
  if(v==='range'){ $('#boxMes').hide(); $('#boxRango').show(); }
  else           { $('#boxRango').hide(); $('#boxMes').show(); }
  loadDashboard();
});

// Abrir polilla según el modo (mes o rango)
$('#btnPolilla').on('click', function(){
  const id   = $('#empleado').val();
  const modo = $('input[name="modo"]:checked').val();
  if(!id){ alert('Seleccione empleado.'); return; }

  if (modo === 'range') {
    const d = $('#desde').val(), h = $('#hasta').val();
    if(!d || !h || h < d){ alert('Rango inválido.'); return; }
    const url = 'polilla_html_range.php?idempleado='+encodeURIComponent(id)+
                '&desde='+encodeURIComponent(d)+'&hasta='+encodeURIComponent(h);
    window.open(url, '_blank');
  } else {
    const mes = $('#mes').val();
    if(!mes){ alert('Seleccione el mes.'); return; }
    const url = 'polilla_html.php?idempleado='+encodeURIComponent(id)+
                '&mes='+encodeURIComponent(mes);
    window.open(url, '_blank');
  }
});

// Exportar Dashboard (se mantiene por mes)
$('#btnExpExcel').on('click', function(){
  const mes = $('#mes').val();
  const id  = $('#empleado').val() || '';
  const url = 'export_dashboard_excel.php?mes='+encodeURIComponent(mes)+(id?('&idempleado='+encodeURIComponent(id)):'');
  window.open(url, '_blank');
});
$('#btnExpPDF').on('click', function(){
  const mes = $('#mes').val();
  const id  = $('#empleado').val() || '';
  const url = 'export_dashboard_pdf.php?mes='+encodeURIComponent(mes)+(id?('&idempleado='+encodeURIComponent(id)):'');
  window.open(url, '_blank');
});
</script>

<script>
$('.select2').select2({width:'100%', placeholder:'-- Seleccione --', allowClear:true});

let chartFactor=null, chartTop=null;

function loadDashboard(){
  const idemp = $('#empleado').val() || '';
  const modo  = $('input[name="modo"]:checked').val();
  let postData = {action:'stats_month', idempleado:idemp};

  if (modo==='range'){
    const d=$('#desde').val(), h=$('#hasta').val();
    if(d && h && h>=d){ postData.desde=d; postData.hasta=h; }
  } else {
    postData.mes = $('#mes').val();
  }

  $.post('extras_dashboard_api.php', postData, function(r){
    if(!r || !r.ok){ return; }

    // Scope hint
    if (r.scope === 'empleado' && r.empleado_nombre) {
      if (r.periodo === 'range' && r.desde && r.hasta) {
        $('#scopeHint').html('Mostrando: <b>' + r.empleado_nombre + '</b> · Rango: <b>' + r.desde + ' → ' + r.hasta + '</b>');
      } else {
        $('#scopeHint').html('Mostrando: <b>' + r.empleado_nombre + '</b> · Mes: <b>' + (r.mes||'') + '</b>');
      }
    } else {
      if (r.periodo === 'range' && r.desde && r.hasta) {
        $('#scopeHint').html('Mostrando: <b>General</b> · Rango: <b>' + r.desde + ' → ' + r.hasta + '</b>');
      } else {
        $('#scopeHint').html('Mostrando: <b>General del mes</b> · Mes: <b>' + (r.mes||'') + '</b>');
      }
    }

    // KPIs HORAS
    $('#kpi15').text(parseFloat(r.tot.h15||0).toFixed(2));
    $('#kpi20').text(parseFloat(r.tot.h20||0).toFixed(2));
    $('#kpi30').text(parseFloat(r.tot.h30||0).toFixed(2));
    $('#kpiTot').text(parseFloat(r.tot.hTot||0).toFixed(2));

    // KPIs MONTOS
    if (r.montos) {
      const f = n => Number(n||0).toLocaleString('en-US',{minimumFractionDigits:2, maximumFractionDigits:2});
      $('#mk15').text('₡' + f(r.montos.m15));
      $('#mk20').text('₡' + f(r.montos.m20));
      $('#mk30').text('₡' + f(r.montos.m30));
      $('#mkT').text('₡' + f(r.montos.mTot));
    } else {
      $('#mk15,#mk20,#mk30,#mkT').text('₡0.00');
    }

    // Gráfico de horas por factor
    const ctx1=document.getElementById('chartFactor');
    const data1=[r.tot.h15||0,r.tot.h20||0,r.tot.h30||0];
    if(chartFactor) chartFactor.destroy();
    chartFactor = new Chart(ctx1,{
      type:'bar',
      data:{labels:['1.5x','2.0x','3.0x'], datasets:[{label:'Horas', data:data1}]},
      options:{responsive:true, plugins:{legend:{display:false}}}
    });

    // Top 5 colaboradores
    const labels=(r.top||[]).map(x=>x.nombre);
    const data2=(r.top||[]).map(x=>x.horas);
    const ctx2=document.getElementById('chartTop');
    if(chartTop) chartTop.destroy();
    chartTop = new Chart(ctx2,{
      type:'bar',
      data:{labels:labels, datasets:[{label:'Horas', data:data2}]},
      options:{responsive:true, indexAxis:'y', plugins:{legend:{display:false}}}
    });
  }, 'json');
}

// Recargar dashboard cuando el usuario cambie empleado/periodo
$('#mes').on('change', loadDashboard);
$('#desde,#hasta').on('change', loadDashboard);
$('#empleado').on('change', loadDashboard);

$(document).ready(function(){ loadDashboard(); });
</script>

<?php include __DIR__ . '/view/footer.html';
