<?php
declare(strict_types=1);
session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) { header("Location:index.html"); exit; }
$ES_SUPER = isset($_SESSION["superadmin"]) && $_SESSION["superadmin"] === "S";

require_once __DIR__ . '/dbcon.php';
mysqli_set_charset($con,'utf8mb4');

if (!$ES_SUPER) { echo "Acceso restringido."; exit; }

/* Activar conjunto */
if (isset($_POST['activar_id'])) {
  $id = (int)$_POST['activar_id'];
  mysqli_query($con,"UPDATE payroll_legal_set SET activo=0");
  $st = mysqli_prepare($con,"UPDATE payroll_legal_set SET activo=1 WHERE id=?");
  mysqli_stmt_bind_param($st,'i',$id);
  mysqli_stmt_execute($st);
  mysqli_stmt_close($st);
}

/* Crear conjunto nuevo (clonar vacío) */
if (isset($_POST['nuevo_nombre']) && $_POST['nuevo_nombre']!=='') {
  $nom = trim($_POST['nuevo_nombre']);
  $st = mysqli_prepare($con,"INSERT INTO payroll_legal_set (nombre,activo) VALUES (?,0)");
  mysqli_stmt_bind_param($st,'s',$nom);
  mysqli_stmt_execute($st);
  mysqli_stmt_close($st);
}

/* Guardar edición de una tasa */
if (isset($_POST['save_rate'])) {
  $id = (int)$_POST['id'];
  $por = (float)$_POST['porcentaje'];
  $base = in_array($_POST['base'],['SALARIO','EXTRAS','AMBOS'],true) ? $_POST['base'] : 'AMBOS';
  $st = mysqli_prepare($con,"UPDATE payroll_legal_rate SET porcentaje=?, base=? WHERE id=?");
  mysqli_stmt_bind_param($st,'dsi',$por,$base,$id);
  mysqli_stmt_execute($st);
  mysqli_stmt_close($st);
}

$sets = [];
$rs = mysqli_query($con,"SELECT id,nombre,activo FROM payroll_legal_set ORDER BY activo DESC, id DESC");
while($r=mysqli_fetch_assoc($rs)) $sets[]=$r; mysqli_free_result($rs);

$active = null; foreach($sets as $s){ if($s['activo']){$active=$s;break;} }
$rates = ['EMPLOYEE'=>[], 'EMPLOYER'=>[]];
if ($active) {
  $st = mysqli_prepare($con,"SELECT * FROM payroll_legal_rate WHERE id_set=? ORDER BY side, id");
  mysqli_stmt_bind_param($st,'i',$active['id']);
  mysqli_stmt_execute($st);
  $r = mysqli_stmt_get_result($st);
  while($row=mysqli_fetch_assoc($r)) $rates[$row['side']][]=$row;
  mysqli_stmt_close($st);
}

if (!$ES_SUPER) include __DIR__.'/view/header.php'; else include __DIR__.'/view/headeradmin.html';
?>
<div class="box">
  <div class="box-header with-border">
    <h3>Configuración Legal (tasas y conjuntos)</h3>
  </div>
  <div class="box-body">
    <form method="post" class="form-inline" style="margin-bottom:12px">
      <label><b>Conjunto activo:</b></label>
      <select name="activar_id" class="form-control" onchange="this.form.submit()">
        <?php foreach($sets as $s): ?>
          <option value="<?= (int)$s['id'] ?>" <?= $s['activo']?'selected':'' ?>>
            <?= htmlspecialchars($s['nombre']) ?> <?= $s['activo']?'(activo)':'' ?>
          </option>
        <?php endforeach; ?>
      </select>
    </form>

    <form method="post" class="form-inline" style="margin-bottom:18px">
      <label>Nuevo conjunto:</label>
      <input type="text" name="nuevo_nombre" class="form-control" placeholder="Ej: Conjunto 2026">
      <button class="btn btn-default" type="submit">Crear</button>
    </form>

    <?php if($active): ?>
      <h4><?= htmlspecialchars($active['nombre']) ?></h4>

      <div class="row">
        <div class="col-md-6">
          <h5>Deducciones Trabajador</h5>
          <table class="table table-bordered table-condensed">
            <thead><tr><th>Nombre</th><th>%</th><th>Base</th><th>Guardar</th></tr></thead>
            <tbody>
              <?php foreach($rates['EMPLOYEE'] as $r): ?>
                <tr>
                  <form method="post">
                    <td><?= htmlspecialchars($r['nombre']) ?></td>
                    <td style="width:140px">
                      <input type="number" step="0.01" name="porcentaje" value="<?= htmlspecialchars($r['porcentaje']) ?>" class="form-control input-sm">
                    </td>
                    <td style="width:140px">
                      <select name="base" class="form-control input-sm">
                        <?php foreach(['SALARIO','EXTRAS','AMBOS'] as $b): ?>
                          <option value="<?= $b ?>" <?= $b===$r['base']?'selected':'' ?>><?= $b ?></option>
                        <?php endforeach; ?>
                      </select>
                    </td>
                    <td>
                      <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                      <button class="btn btn-primary btn-sm" name="save_rate" value="1">Guardar</button>
                    </td>
                  </form>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>

        <div class="col-md-6">
          <h5>Cargas Patronales</h5>
          <table class="table table-bordered table-condensed">
            <thead><tr><th>Nombre</th><th>%</th><th>Base</th><th>Guardar</th></tr></thead>
            <tbody>
              <?php foreach($rates['EMPLOYER'] as $r): ?>
                <tr>
                  <form method="post">
                    <td><?= htmlspecialchars($r['nombre']) ?></td>
                    <td style="width:140px">
                      <input type="number" step="0.01" name="porcentaje" value="<?= htmlspecialchars($r['porcentaje']) ?>" class="form-control input-sm">
                    </td>
                    <td style="width:140px">
                      <select name="base" class="form-control input-sm">
                        <?php foreach(['SALARIO','EXTRAS','AMBOS'] as $b): ?>
                          <option value="<?= $b ?>" <?= $b===$r['base']?'selected':'' ?>><?= $b ?></option>
                        <?php endforeach; ?>
                      </select>
                    </td>
                    <td>
                      <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                      <button class="btn btn-primary btn-sm" name="save_rate" value="1">Guardar</button>
                    </td>
                  </form>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>

      <p class="text-muted">* INS (Riesgos del Trabajo) varía según clase de riesgo; ajusta el porcentaje según tu póliza.</p>
    <?php else: ?>
      <div class="alert alert-warning">No hay conjunto activo.</div>
    <?php endif; ?>
  </div>
</div>
<?php include __DIR__.'/view/footer.html'; ?>
