<?php


require_once __DIR__ . '/../config/rrhh_docs_config.php';
require_once __DIR__ . '/../config/Conexion.php'; // Debe definir $conexion (mysqli)

class Documentos {

  private function esc($str){
    global $conexion;
    return "'" . $conexion->real_escape_string($str) . "'";
  }

  /** Crear: incluye categoria_id */
  public function insertar($fd, $desc, $categoria_id, $fi, $fv, $ruta, $dp){
    global $conexion;

    $cat_sql = is_null($categoria_id) ? "NULL" : intval($categoria_id);

    $sql = "INSERT INTO documentos_rrhh
            (fecha_documento, descripcion, categoria_id, fecha_inicio, fecha_vencimiento, imagen1, dias_programados)
            VALUES (".
              $this->esc($fd).",".
              $this->esc($desc).",".
              $cat_sql.",".
              $this->esc($fi).",".
              $this->esc($fv).",".
              $this->esc($ruta).",".
              intval($dp).
            ")";
    return $conexion->query($sql);
  }

  /** Editar: incluye categoria_id */
  public function actualizar($id, $fd, $desc, $categoria_id, $fi, $fv, $ruta, $dp){
    global $conexion;

    $cat_sql = is_null($categoria_id) ? "NULL" : intval($categoria_id);

    $sql = "UPDATE documentos_rrhh SET
              fecha_documento   = ".$this->esc($fd).",
              descripcion       = ".$this->esc($desc).",
              categoria_id      = ".$cat_sql.",
              fecha_inicio      = ".$this->esc($fi).",
              fecha_vencimiento = ".$this->esc($fv).",
              imagen1           = ".$this->esc($ruta).",
              dias_programados  = ".intval($dp)."
            WHERE id = ".intval($id);

    return $conexion->query($sql);
  }

  /** Eliminar */
  public function eliminar($id){
    global $conexion;
    return $conexion->query("DELETE FROM documentos_rrhh WHERE id = ".intval($id));
  }

  /** Obtener por ID: trae categoria_id y nombre de la categoría */
  public function obtenerPorId($id){
    global $conexion;
    $sql = "SELECT
              d.id,
              d.fecha_documento,
              d.descripcion,
              d.categoria_id,
              c.nombre AS categoria,
              d.fecha_inicio,
              d.fecha_vencimiento,
              d.imagen1,
              d.dias_programados
            FROM documentos_rrhh d
            LEFT JOIN categorias_rrhh c ON c.id = d.categoria_id
            WHERE d.id = ".intval($id)."
            LIMIT 1";
    $rs = $conexion->query($sql);
    if ($rs && $rs->num_rows > 0) return $rs->fetch_assoc();
    return null;
  }

  /** Listar todos: acepta filtro por categoría; devuelve estado y días restantes */
  public function listarTodos($categoria_id = 0){
    global $conexion;
    $where = "1=1";
    if ($categoria_id > 0){
      $where .= " AND d.categoria_id = ".intval($categoria_id);
    }

    $sql = "SELECT
              d.id,
              d.fecha_documento,
              d.descripcion,
              d.categoria_id,
              c.nombre AS categoria,
              d.fecha_inicio,
              d.fecha_vencimiento,
              d.imagen1,
              d.dias_programados,
              DATEDIFF(d.fecha_vencimiento, CURDATE()) AS dias_restantes,
              CASE
                WHEN d.fecha_vencimiento < CURDATE() THEN 'vencido'
                WHEN DATEDIFF(d.fecha_vencimiento, CURDATE()) <= d.dias_programados THEN 'por_vencer'
                ELSE 'vigente'
              END AS estado
            FROM documentos_rrhh d
            LEFT JOIN categorias_rrhh c ON c.id = d.categoria_id
            WHERE $where
            ORDER BY d.fecha_vencimiento ASC, d.id ASC";

    return $conexion->query($sql);
  }

  /** Listar por vencer: usa umbral global o dias_programados; acepta filtro por categoría */
  public function listarPorVencer($umbral = null, $categoria_id = 0){
    global $conexion;

    $where = array();
    $where[] = "d.fecha_vencimiento >= CURDATE()";
    if ($categoria_id > 0){
      $where[] = "d.categoria_id = ".intval($categoria_id);
    }
    if ($umbral !== null && is_numeric($umbral) && intval($umbral) > 0){
      $where[] = "DATEDIFF(d.fecha_vencimiento, CURDATE()) <= ".intval($umbral);
    } else {
      $where[] = "DATEDIFF(d.fecha_vencimiento, CURDATE()) <= d.dias_programados";
    }

    $sql = "SELECT
              d.id,
              d.fecha_documento,
              d.descripcion,
              d.categoria_id,
              c.nombre AS categoria,
              d.fecha_inicio,
              d.fecha_vencimiento,
              d.imagen1,
              d.dias_programados,
              DATEDIFF(d.fecha_vencimiento, CURDATE()) AS dias_restantes
            FROM documentos_rrhh d
            LEFT JOIN categorias_rrhh c ON c.id = d.categoria_id
            WHERE ".implode(" AND ", $where)."
            ORDER BY d.fecha_vencimiento ASC, d.id ASC";

    return $conexion->query($sql);
  }

  /** Rutas por IDs (para ZIP) */
  public function obtenerRutasPorIds($ids){
    global $conexion;
    if(!is_array($ids) || !count($ids)) return array();
    $clean = array();
    foreach($ids as $v){ $clean[] = intval($v); }

    $sql = "SELECT id, imagen1 FROM documentos_rrhh WHERE id IN (".implode(",", $clean).")";
    $rs = $conexion->query($sql);
    $out = array();
    if ($rs){
      while($r = $rs->fetch_assoc()){
        $out[intval($r['id'])] = $r['imagen1'];
      }
    }
    return $out;
  }
}
