<?php
// rrhh_home/legal_config_api.php
// API para legal_config.php (con auto-seed de valores CR si el set activo está vacío)
// PHP 8.1.33 – UTF-8

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Costa_Rica');
header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION["idusuario"])) { echo json_encode(['ok'=>false,'msg'=>'Sesión expirada']); exit; }
$ES_SUPER = isset($_SESSION["superadmin"]) && $_SESSION["superadmin"] === "A";
if (!$ES_SUPER) { echo json_encode(['ok'=>false,'msg'=>'Solo superadmin']); exit; }

require_once __DIR__ . '/dbcon.php';
if (!isset($con) || !($con instanceof mysqli)) { echo json_encode(['ok'=>false,'msg'=>'Sin BD']); exit; }
mysqli_set_charset($con,'utf8mb4');

$action = $_POST['action'] ?? $_GET['action'] ?? '';

function j($a){ echo json_encode($a, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

/* ============ Helpers ============ */
function ensure_active_set(mysqli $con): int {
  $active = null;
  if ($rs = mysqli_query($con,"SELECT id FROM payroll_legal_set WHERE activo=1 ORDER BY id DESC LIMIT 1")) {
    if ($r = mysqli_fetch_assoc($rs)) $active = (int)$r['id'];
    mysqli_free_result($rs);
  }
  if (!$active) {
    mysqli_query($con,"INSERT INTO payroll_legal_set (nombre, activo) VALUES ('CR-2025 DEMO', 1)");
    $active = (int)mysqli_insert_id($con);
  }
  return $active;
}
function count_rates(mysqli $con, int $set_id, string $side): int {
  $n=0;
  if($st=mysqli_prepare($con,"SELECT COUNT(*) FROM payroll_legal_rate WHERE set_id=? AND side=?")){
    mysqli_stmt_bind_param($st,'is',$set_id,$side); mysqli_stmt_execute($st);
    mysqli_stmt_bind_result($st,$n); mysqli_stmt_fetch($st); mysqli_stmt_close($st);
  }
  return (int)$n;
}
function count_isr(mysqli $con, int $set_id): int {
  $n=0;
  if($st=mysqli_prepare($con,"SELECT COUNT(*) FROM payroll_isr_tramo WHERE set_id=?")){
    mysqli_stmt_bind_param($st,'i',$set_id); mysqli_stmt_execute($st);
    mysqli_stmt_bind_result($st,$n); mysqli_stmt_fetch($st); mysqli_stmt_close($st);
  }
  return (int)$n;
}
/* Valores por defecto (referenciales CR) */
function seed_defaults_if_empty(mysqli $con, int $set_id): void {
  $needEmp = count_rates($con,$set_id,'EMPLOYEE')===0;
  $needPat = count_rates($con,$set_id,'EMPLOYER')===0;
  $needISR = count_isr($con,$set_id)===0;

  if(!$needEmp && !$needPat && !$needISR) return;

  mysqli_begin_transaction($con);

  if($needEmp){
    $sql="INSERT INTO payroll_legal_rate (set_id, side, code, nombre, pct) VALUES
      (?,?,?,?,?),(?,?,?,?,?),(?,?,?,?,?)";
    $st=mysqli_prepare($con,$sql);
    // EMPLOYEE: IVM 2.75%, EM 5.50%, Banco Popular 1.00%
    $a=['EMPLOYEE','CCSS_IVM','CCSS IVM (Empleado)',2.7500];
    $b=['EMPLOYEE','CCSS_EM','CCSS Enfermedad-Maternidad (Empleado)',5.5000];
    $c=['EMPLOYEE','BP','Banco Popular (Empleado)',1.0000];
    mysqli_stmt_bind_param(
      $st,'isssdisssdisssd',
      $set_id,$a[0],$a[1],$a[2],$a[3],
      $set_id,$b[0],$b[1],$b[2],$b[3],
      $set_id,$c[0],$c[1],$c[2],$c[3]
    );
    mysqli_stmt_execute($st); mysqli_stmt_close($st);
  }

  if($needPat){
    $sql="INSERT INTO payroll_legal_rate (set_id, side, code, nombre, pct) VALUES
      (?,?,?,?,?),(?,?,?,?,?),(?,?,?,?,?),(?,?,?,?,?),(?,?,?,?,?),(?,?,?,?,?)";
    $st=mysqli_prepare($con,$sql);
    // EMPLOYER: IVM 5.25, EM 9.25, INA 1.50, IMAS 0.50, BP 0.25, RIESGOS 1.00
    $r1=['EMPLOYER','CCSS_IVM','CCSS IVM (Patrono)',5.2500];
    $r2=['EMPLOYER','CCSS_EM','CCSS Enfermedad-Maternidad (Patrono)',9.2500];
    $r3=['EMPLOYER','INA','INA (Patrono)',1.5000];
    $r4=['EMPLOYER','IMAS','IMAS (Patrono)',0.5000];
    $r5=['EMPLOYER','BP','Banco Popular (Patrono)',0.2500];
    $r6=['EMPLOYER','RIESGOS','Riesgos del Trabajo (Patrono)',1.0000];
    mysqli_stmt_bind_param(
      $st,'isssdisssdisssdisssdisssdisssd',
      $set_id,$r1[0],$r1[1],$r1[2],$r1[3],
      $set_id,$r2[0],$r2[1],$r2[2],$r2[3],
      $set_id,$r3[0],$r3[1],$r3[2],$r3[3],
      $set_id,$r4[0],$r4[1],$r4[2],$r4[3],
      $set_id,$r5[0],$r5[1],$r5[2],$r5[3],
      $set_id,$r6[0],$r6[1],$r6[2],$r6[3]
    );
    mysqli_stmt_execute($st); mysqli_stmt_close($st);
  }

  if($needISR){
    // Tramos ISR (empleado) referenciales:
    // 0–929,000 => 0% | 929,000.01–1,362,000 => 10% | 1,362,000.01–2,223,000 => 15% | >2,223,000 => 20%
    // Último HASTA = NULL
    $q1="INSERT INTO payroll_isr_tramo (set_id, desde, hasta, pct) VALUES
         ($set_id, 0.00,      929000.00, 0.00),
         ($set_id, 929000.01, 1362000.00, 10.00),
         ($set_id, 1362000.01,2223000.00, 15.00)";
    mysqli_query($con,$q1);
    $st = mysqli_prepare($con,"INSERT INTO payroll_isr_tramo (set_id, desde, hasta, pct) VALUES ($set_id, ?, NULL, ?)");
    $desde = 2223000.01; $pct = 20.00;
    mysqli_stmt_bind_param($st,'dd',$desde,$pct);
    mysqli_stmt_execute($st); mysqli_stmt_close($st);
  }

  mysqli_commit($con);
}
/* ============ End helpers ============ */

switch($action){

  case 'get_init': {
    $active = ensure_active_set($con);

    // Auto-seed si vacío
    seed_defaults_if_empty($con,$active);

    // Devolver sets
    $sets=[]; $act=null;
    $rs=mysqli_query($con,"SELECT id, nombre, activo FROM payroll_legal_set ORDER BY id DESC");
    if($rs){ while($r=mysqli_fetch_assoc($rs)){ $sets[]=['id'=>(int)$r['id'],'nombre'=>$r['nombre'],'activo'=>$r['activo']]; if($r['activo']=='1') $act=(int)$r['id']; } mysqli_free_result($rs); }
    if(!$act) $act = $active;

    // Tasas empleado
    $emp=[]; 
    if($st=mysqli_prepare($con,"SELECT code,nombre,pct FROM payroll_legal_rate WHERE set_id=? AND side='EMPLOYEE' ORDER BY id ASC")){
      mysqli_stmt_bind_param($st,'i',$act); mysqli_stmt_execute($st); $rs=mysqli_stmt_get_result($st);
      while($r=mysqli_fetch_assoc($rs)) $emp[]=$r;
      mysqli_stmt_close($st);
    }
    // Tasas patrono
    $pat=[];
    if($st=mysqli_prepare($con,"SELECT code,nombre,pct FROM payroll_legal_rate WHERE set_id=? AND side='EMPLOYER' ORDER BY id ASC")){
      mysqli_stmt_bind_param($st,'i',$act); mysqli_stmt_execute($st); $rs=mysqli_stmt_get_result($st);
      while($r=mysqli_fetch_assoc($rs)) $pat[]=$r;
      mysqli_stmt_close($st);
    }
    // Tramos ISR
    $isr=[];
    if($st=mysqli_prepare($con,"SELECT desde,hasta,pct FROM payroll_isr_tramo WHERE set_id=? ORDER BY desde ASC")){
      mysqli_stmt_bind_param($st,'i',$act); mysqli_stmt_execute($st); $rs=mysqli_stmt_get_result($st);
      while($r=mysqli_fetch_assoc($rs)) $isr[]=['desde'=>(float)$r['desde'],'hasta'=>$r['hasta']===null?null:(float)$r['hasta'],'pct'=>(float)$r['pct']];
      mysqli_stmt_close($st);
    }

    j(['ok'=>true,'sets'=>$sets,'active_set_id'=>$act,'rates_employee'=>$emp,'rates_employer'=>$pat,'isr'=>$isr]);
  } break;

  case 'create_set': {
    $nombre = trim((string)($_POST['nombre'] ?? ''));
    if($nombre==='') j(['ok'=>false,'msg'=>'Nombre requerido']);
    if($st=mysqli_prepare($con,"INSERT INTO payroll_legal_set (nombre, activo) VALUES (?,0)")){
      mysqli_stmt_bind_param($st,'s',$nombre); mysqli_stmt_execute($st); mysqli_stmt_close($st);
      j(['ok'=>true]);
    }
    j(['ok'=>false,'msg'=>mysqli_error($con)]);
  } break;

  case 'activate_set': {
    $set_id = (int)($_POST['set_id'] ?? 0);
    if($set_id<=0) j(['ok'=>false,'msg'=>'Set inválido']);
    mysqli_begin_transaction($con);
    mysqli_query($con,"UPDATE payroll_legal_set SET activo=0");
    if($st=mysqli_prepare($con,"UPDATE payroll_legal_set SET activo=1 WHERE id=?")){
      mysqli_stmt_bind_param($st,'i',$set_id); mysqli_stmt_execute($st); mysqli_stmt_close($st);
      mysqli_commit($con); j(['ok'=>true]);
    } else { mysqli_rollback($con); j(['ok'=>false,'msg'=>mysqli_error($con)]); }
  } break;

  case 'save_rates': {
    $set_id = (int)($_POST['set_id'] ?? 0);
    $side   = ($_POST['side'] ?? 'EMPLOYEE') === 'EMPLOYER' ? 'EMPLOYER' : 'EMPLOYEE';
    $items  = json_decode($_POST['items'] ?? '[]', true);
    if($set_id<=0) j(['ok'=>false,'msg'=>'Set inválido']);

    mysqli_begin_transaction($con);
    if($st=mysqli_prepare($con,"DELETE FROM payroll_legal_rate WHERE set_id=? AND side=?")){
      mysqli_stmt_bind_param($st,'is',$set_id,$side); mysqli_stmt_execute($st); mysqli_stmt_close($st);
    } else { mysqli_rollback($con); j(['ok'=>false,'msg'=>mysqli_error($con)]); }

    $sql="INSERT INTO payroll_legal_rate (set_id, side, code, nombre, pct) VALUES (?,?,?,?,?)";
    if(!$st=mysqli_prepare($con,$sql)){ mysqli_rollback($con); j(['ok'=>false,'msg'=>mysqli_error($con)]); }
    foreach($items as $it){
      $code = substr((string)($it['code']??''),0,32);
      $nom  = substr((string)($it['nombre']??''),0,100);
      $pct  = (float)($it['pct']??0);
      mysqli_stmt_bind_param($st,'isssd',$set_id,$side,$code,$nom,$pct);
      mysqli_stmt_execute($st);
    }
    mysqli_stmt_close($st);
    mysqli_commit($con);
    j(['ok'=>true]);
  } break;

  case 'save_isr': {
    $set_id = (int)($_POST['set_id'] ?? 0);
    $items  = json_decode($_POST['items'] ?? '[]', true);
    if($set_id<=0) j(['ok'=>false,'msg'=>'Set inválido']);

    mysqli_begin_transaction($con);
    if($st=mysqli_prepare($con,"DELETE FROM payroll_isr_tramo WHERE set_id=?")){
      mysqli_stmt_bind_param($st,'i',$set_id); mysqli_stmt_execute($st); mysqli_stmt_close($st);
    } else { mysqli_rollback($con); j(['ok'=>false,'msg'=>mysqli_error($con)]); }

    $sql="INSERT INTO payroll_isr_tramo (set_id, desde, hasta, pct) VALUES (?,?,?,?)";
    if(!$st=mysqli_prepare($con,$sql)){ mysqli_rollback($con); j(['ok'=>false,'msg'=>mysqli_error($con)]); }
    foreach($items as $it){
      $desde=(float)($it['desde']??0);
      $hasta = array_key_exists('hasta',$it) && $it['hasta']!==null && $it['hasta']!=='' ? (float)$it['hasta'] : null;
      $pct=(float)($it['pct']??0);
      if($hasta===null){
        $sqlN="INSERT INTO payroll_isr_tramo (set_id, desde, hasta, pct) VALUES ($set_id, ?, NULL, ?)";
        $stN=mysqli_prepare($con,$sqlN);
        mysqli_stmt_bind_param($stN,'dd',$desde,$pct);
        mysqli_stmt_execute($stN);
        mysqli_stmt_close($stN);
      }else{
        mysqli_stmt_bind_param($st,'iddd',$set_id,$desde,$hasta,$pct);
        mysqli_stmt_execute($st);
      }
    }
    mysqli_stmt_close($st);
    mysqli_commit($con);
    j(['ok'=>true]);
  } break;

  default: j(['ok'=>false,'msg'=>'Acción no válida']);
}
