<?php
// rrhh_home/legal_config.php
// Configuración legal: conjuntos, tasas (empleado/patrono), tramos ISR y PROVISIONES
// PHP 8.1.33 – UTF-8

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) { header("Location:index.html"); exit; }
$ES_SUPER = isset($_SESSION["superadmin"]) && $_SESSION["superadmin"] === "A";

require_once __DIR__ . '/dbcon.php';
mysqli_set_charset($con, 'utf8mb4');

// Header normal del sistema
if (!$ES_SUPER) include __DIR__ . '/view/header.php';
else            include __DIR__ . '/view/header.php';
?>
<script>
  $('#payroll_control').addClass("treeview active");
  $('#payroll_control_2').addClass("treeview active");
</script>

<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet"/>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

<style>
  .help{color:#64748b;font-size:12px}
  .table td input{width:100%}
</style>

<div class="box">
  <div class="box-header with-border">
    <h3 class="box-title">Configuración legal: Sets, tasas y tramos ISR</h3>
  </div>
  <div class="box-body">
    <!-- Conjunto activo -->
    <div class="box">
      <div class="box-header with-border"><h3 class="box-title">Conjunto activo</h3></div>
      <div class="box-body">
        <div class="row">
          <div class="col-sm-6">
            <select id="setSelect" class="form-control"></select>
            <div class="help">Un set agrupa todos los porcentajes y tramos ISR. Solo uno está activo.</div>
          </div>
          <div class="col-sm-2">
            <button id="btnActivate" class="btn btn-primary">Activar</button>
          </div>
          <div class="col-sm-4 text-right">
            <div class="input-group">
              <input id="newSetName" type="text" class="form-control" placeholder="Nombre del nuevo set…">
              <span class="input-group-btn"><button id="btnNewSet" class="btn btn-default">Nuevo set…</button></span>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Tasas EMPLEADO -->
    <div class="row">
      <div class="col-md-6">
        <div class="box">
          <div class="box-header with-border"><h3 class="box-title">Tasas (empleado)</h3></div>
          <div class="box-body">
            <table id="tblEmp" class="table table-bordered table-condensed">
              <thead><tr><th style="width:120px">Código</th><th>Nombre</th><th style="width:120px">% (0–100)</th><th style="width:40px"></th></tr></thead>
              <tbody></tbody>
            </table>
            <button id="addEmp" class="btn btn-default">Agregar fila</button>
            <button id="saveEmp" class="btn btn-primary pull-right">Guardar</button>
          </div>
        </div>
      </div>

      <!-- Tasas PATRONO -->
      <div class="col-md-6">
        <div class="box">
          <div class="box-header with-border"><h3 class="box-title">Tasas (patrono)</h3></div>
          <div class="box-body">
            <table id="tblPat" class="table table-bordered table-condensed">
              <thead><tr><th style="width:120px">Código</th><th>Nombre</th><th style="width:120px">% (0–100)</th><th style="width:40px"></th></tr></thead>
              <tbody></tbody>
            </table>
            <button id="addPat" class="btn btn-default">Agregar fila</button>
            <button id="savePat" class="btn btn-primary pull-right">Guardar</button>
          </div>
        </div>
      </div>
    </div>

    <!-- Tramos ISR (Empleado) -->
    <div class="box">
      <div class="box-header with-border"><h3 class="box-title">Tramos ISR (Empleado)</h3></div>
      <div class="box-body">
        <table id="tblISR" class="table table-bordered table-condensed">
          <thead>
            <tr>
              <th style="width:180px">Desde</th>
              <th style="width:180px">Hasta (deje vacío = último)</th>
              <th style="width:120px">% (0–100)</th>
              <th style="width:40px"></th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
        <button id="addISR" class="btn btn-default">Agregar tramo</button>
        <button id="saveISR" class="btn btn-primary pull-right">Guardar</button>
        <div class="help" style="margin-top:6px">Los tramos se aplican por orden. El último tramo debe dejar “Hasta” vacío (NULL).</div>
      </div>
    </div>

    <!-- PROVISIONES -->
    <div class="box">
      <div class="box-header with-border"><h3 class="box-title">Provisiones (mensual)</h3></div>
      <div class="box-body">
        <div class="row">
          <div class="col-sm-3">
            <label>Aguinaldo %</label>
            <input id="prov_aguinaldo" type="number" class="form-control" step="0.0001" min="0" placeholder="8.3333">
          </div>
          <div class="col-sm-3">
            <label>Vacaciones %</label>
            <input id="prov_vacaciones" type="number" class="form-control" step="0.0001" min="0" placeholder="4.1667">
          </div>
          <div class="col-sm-3">
            <label>Cesantía %</label>
            <input id="prov_cesantia" type="number" class="form-control" step="0.0001" min="0" placeholder="5.3333">
          </div>
          <div class="col-sm-3">
            <label>Preaviso %</label>
            <input id="prov_preaviso" type="number" class="form-control" step="0.0001" min="0" placeholder="3.3333">
          </div>
        </div>
        <div class="text-right" style="margin-top:10px">
          <button id="btnSaveProv" class="btn btn-primary">Guardar provisiones</button>
        </div>
        <p class="help" style="margin-top:6px">
          Estos porcentajes son referenciales y editables. Se aplican sobre el salario bruto mensual para estimar reservas.
          Ajusta según tu política contable.
        </p>
      </div>
    </div>

  </div>
</div>

<script>
/* ===== Helpers UI ===== */
function rowRate(code='', name='', pct=''){
  return `<tr>
    <td><input class="code form-control" value="${code}"></td>
    <td><input class="name form-control" value="${name}"></td>
    <td><input class="pct form-control" type="number" step="0.0001" min="0" value="${pct}"></td>
    <td><button class="btn btn-xs btn-danger delRow"><i class="fa fa-trash"></i></button></td>
  </tr>`;
}
function rowISR(desde='', hasta='', pct=''){
  return `<tr>
    <td><input class="desde form-control" type="number" step="0.01" min="0" value="${desde}"></td>
    <td><input class="hasta form-control" type="number" step="0.01" min="0" value="${hasta}"></td>
    <td><input class="pct form-control" type="number" step="0.0001" min="0" value="${pct}"></td>
    <td><button class="btn btn-xs btn-danger delRow"><i class="fa fa-trash"></i></button></td>
  </tr>`;
}
function readTableRates(tbl){
  const out=[];
  $(tbl).find('tbody tr').each(function(){
    const code = $(this).find('.code').val().trim();
    const name = $(this).find('.name').val().trim();
    const pct  = parseFloat($(this).find('.pct').val()||'0');
    if(code && name){ out.push({code:code, nombre:name, pct:pct}); }
  });
  return out;
}
function readTableISR(){
  const out=[];
  $('#tblISR tbody tr').each(function(){
    const d = $(this).find('.desde').val().trim();
    const h = $(this).find('.hasta').val().trim();
    const p = parseFloat($(this).find('.pct').val()||'0');
    if(d!=='' || h!=='' || p>0){
      out.push({desde:(d===''?null:parseFloat(d)), hasta:(h===''?null:parseFloat(h)), pct:p});
    }
  });
  return out;
}

/* ===== Eventos de tabla ===== */
$(document).on('click','.delRow', function(){ $(this).closest('tr').remove(); });

$('#addEmp').on('click', ()=> $('#tblEmp tbody').append(rowRate()));
$('#addPat').on('click', ()=> $('#tblPat tbody').append(rowRate()));
$('#addISR').on('click', ()=> $('#tblISR tbody').append(rowISR()));

/* ===== Backend ===== */
function loadInit(){
  $.getJSON('legal_config_api.php', {action:'get_init'}, function(r){
    if(!r || !r.ok){ alert('No se pudo cargar.'); return; }

    // Sets
    const sel = $('#setSelect'); sel.empty();
    (r.sets||[]).forEach(s=>{
      sel.append(`<option value="${s.id}" ${s.id==r.active_set_id?'selected':''}>${s.nombre}${s.activo?' (activo)':''}</option>`);
    });

    // Tasas empleado
    const te = $('#tblEmp tbody'); te.empty();
    (r.rates_employee||[]).forEach(x=> te.append(rowRate(x.code, x.nombre, x.pct)));

    // Tasas patrono
    const tp = $('#tblPat tbody'); tp.empty();
    (r.rates_employer||[]).forEach(x=> tp.append(rowRate(x.code, x.nombre, x.pct)));

    // ISR
    const ti = $('#tblISR tbody'); ti.empty();
    (r.isr||[]).forEach(t=> ti.append(rowISR(t.desde, t.hasta??'', t.pct)));

    // Provisiones
    if (r.provisiones){
      $('#prov_aguinaldo').val(r.provisiones.aguinaldo);
      $('#prov_vacaciones').val(r.provisiones.vacaciones);
      $('#prov_cesantia').val(r.provisiones.cesantia);
      $('#prov_preaviso').val(r.provisiones.preaviso);
    }
  });
}
$('#btnActivate').on('click', function(){
  const id = $('#setSelect').val();
  $.post('legal_config_api.php',{action:'activate_set', id:id}, function(r){
    if(r && r.ok){ loadInit(); } else { alert(r?.msg||'No se pudo activar.'); }
  }, 'json');
});
$('#btnNewSet').on('click', function(){
  const name = $('#newSetName').val().trim();
  if(!name){ alert('Escribe un nombre.'); return; }
  $.post('legal_config_api.php',{action:'create_set', nombre:name}, function(r){
    if(r && r.ok){ $('#newSetName').val(''); loadInit(); } else { alert(r?.msg||'No se pudo crear.'); }
  }, 'json');
});
$('#saveEmp').on('click', function(){
  const id = $('#setSelect').val();
  const rows = readTableRates('#tblEmp');
  $.post('legal_config_api.php',{action:'save_rates', set_id:id, side:'EMPLOYEE', rows:JSON.stringify(rows)}, function(r){
    if(r && r.ok){ alert('Guardado.'); loadInit(); } else { alert(r?.msg||'Error guardando.'); }
  }, 'json');
});
$('#savePat').on('click', function(){
  const id = $('#setSelect').val();
  const rows = readTableRates('#tblPat');
  $.post('legal_config_api.php',{action:'save_rates', set_id:id, side:'EMPLOYER', rows:JSON.stringify(rows)}, function(r){
    if(r && r.ok){ alert('Guardado.'); loadInit(); } else { alert(r?.msg||'Error guardando.'); }
  }, 'json');
});
$('#saveISR').on('click', function(){
  const id = $('#setSelect').val();
  const rows = readTableISR();
  $.post('legal_config_api.php',{action:'save_isr', set_id:id, rows:JSON.stringify(rows)}, function(r){
    if(r && r.ok){ alert('Guardado.'); loadInit(); } else { alert(r?.msg||'Error guardando.'); }
  }, 'json');
});
$('#btnSaveProv').on('click', function(){
  const id = $('#setSelect').val();
  const data = {
    action:'save_provisiones',
    set_id:id,
    aguinaldo:  parseFloat($('#prov_aguinaldo').val()  || '0'),
    vacaciones: parseFloat($('#prov_vacaciones').val() || '0'),
    cesantia:   parseFloat($('#prov_cesantia').val()   || '0'),
    preaviso:   parseFloat($('#prov_preaviso').val()   || '0')
  };
  $.post('legal_config_api.php', data, function(r){
    if(r && r.ok){ alert('Provisiones guardadas'); }
    else{ alert(r?.msg || 'No se pudo guardar'); }
  }, 'json');
});

$(document).ready(loadInit);
</script>

<?php include __DIR__ . '/view/footer.html'; ?>
