<?php
session_start();
$idsucursal=0;
date_default_timezone_set('America/Costa_Rica');
$fechaactual = date('Y-m-d');
$horaactual  = date('H:i');

if(isset($_SESSION["idusuario"])){
  if ($_SESSION["superadmin"] != "S") {
    include "./view/header.php";

    $idusuario=$_SESSION["idusuario"];
    include('dbcon.php');

    // global
    $query=mysqli_query($con,"select * from global")or die(mysqli_error($con));
    while($row=mysqli_fetch_array($query)){ $tipo_moneda=$row['tipo_moneda']; }

    // sucursal
    $nombre_sucursal=$_SESSION["sucursal"];
    $query=mysqli_query($con,"select * from sucursal where razon_social='$nombre_sucursal'")or die(mysqli_error($con));
    while($row=mysqli_fetch_array($query)){ $idsucursal=$row['idsucursal']; }

    // usuario/empleado (del que inicia sesión)
    $query=mysqli_query($con,"select * from usuario where idusuario='$idusuario'")or die(mysqli_error($con));
    while($row=mysqli_fetch_array($query)){ $idempleado=$row['idempleado']; }
    $query=mysqli_query($con,"select * from empleado where idempleado='$idempleado'")or die(mysqli_error($con));
    while($row=mysqli_fetch_array($query)){ $nombre=$row['nombre']; $apellidos=$row['apellidos']; }
?>
<script type="text/javascript">
  $('#payroll_control').addClass("treeview active");
  $('#payroll_control_3').addClass("treeview active");
  $('#payroll_control_3_2').addClass("active"); // sección "Vacaciones Extra"
</script>

<!-- Select2 -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

<!-- Cropper para recorte -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css" rel="stylesheet"/>
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>

<!-- Sortable para reordenar -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.2/Sortable.min.js"></script>

<style>
  .file-card{border:2px dashed #3c8dbc;border-radius:10px;padding:10px;margin-bottom:10px;}
  .file-actions{margin-top:8px}
  .file-actions .btn{margin-right:6px}
  .thumb-img{max-width:100%;max-height:360px;border-radius:6px;display:block;margin:0 auto}
  .pdf-embed{width:100%;height:360px;border-radius:6px}
  .drag-handle{cursor:grab;color:#3c8dbc;margin-right:6px}

  /* === Overlay / Progreso de subida (igual patrón que ingreso_vacaciones) === */
  #uploadOverlay{
    position:fixed; left:0; top:0; right:0; bottom:0;
    background:rgba(0,0,0,.65); z-index:9999; display:none;
  }
  #uploadOverlay .inner{
    position:absolute; left:50%; top:50%; transform:translate(-50%,-50%);
    width:92%; max-width:520px; background:#fff; border-radius:12px;
    padding:18px 20px; box-shadow:0 10px 30px rgba(0,0,0,.25); text-align:center;
  }
  #uploadOverlay h4{ margin:0 0 6px 0; font-weight:600 }
  #uploadOverlay .sub{ color:#666; margin-bottom:12px }
  #uploadOverlay .progress{ height:10px; border-radius:6px; background:#e9ecef; overflow:hidden; margin-bottom:8px }
  #uploadOverlay .progress-bar{ width:0%; transition:width .3s ease }
  #uploadOverlay small{ display:block; color:#666 }
</style>

<div class="box">
  <div class="box-header with-border">
    <h3>Extra Vacation:------------------------------------------------> (Payroll Control) </h3>
    <div class="box-tools pull-right">
      <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
      <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
    </div>
  </div>

  <div class="box-body">
    <div class="box-body">
      <form method="post" action="add_ingreso_vacaciones_extra.php" enctype="multipart/form-data" class="form-horizontal" id="formVacExtra">

        <!-- Fecha documento -->
        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label>Document date:</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="date" class="form-control" id="fecha_documento" name="fecha_documento" disabled required>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <!-- Colaborador -->
        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label for="empleado">Select Collaborator:</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <select class="form-control select2" name="empleado" id="empleado" required>
                <option value="">-- Select Collaborator --</option>
                <?php
                $queryc = mysqli_query($con, "SELECT * FROM empleados_planilla ORDER BY nombre_completo ASC") or die(mysqli_error($con));
                while($rowc = mysqli_fetch_array($queryc)){
                  echo '<option value="'.$rowc['id'].'">'.htmlspecialchars($rowc['nombre_completo']).' - '.htmlspecialchars($rowc['cedula']).'</option>';
                }
                ?>
              </select>
            </div>

            <!-- Detalle empleado -->
            <div id="empleado-detalles" style="border:1px solid #ccc; padding:10px; margin-top:10px; display:none; clear:both;">
              <strong>Detalles del empleado:</strong>
              <div id="detalles-contenido"></div>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <!-- Cantidad de días -->
        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label for="cantidad_dias"><strong>Working days (Mon-Fri):</strong></label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="number" name="cantidad_dias" id="cantidad_dias" min="0" class="form-control">
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <!-- Motivo -->
        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label>Reason:</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group"><input class="form-control" id="motivo" name="motivo" placeholder="Reason" disabled></div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <h1><hr style="width:100%; border-color:black;"></h1>

        <!-- MULTI ARCHIVOS + RECORTE -->
        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label>Upload file(s):</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="file" class="form-control" id="imagen1" name="imagen1[]" accept="image/*,application/pdf" multiple disabled>
              <small class="text-muted">Puedes subir varios. Para imágenes, podrás recortar cada una. Se guardará como un solo PDF multipágina.</small>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <div id="filesContainer"></div>

        <input type="hidden" name="crop_json_list" id="crop_json_list" value="[]">
        <input type="hidden" name="file_order" id="file_order" value="[]">

        <h1><hr style="width:100%; border-color:black;"></h1>

        <button  type="submit" class="btn btn-primary">Continue</button>
      </form>
    </div>
  </div>
</div>

<!-- === Overlay de progreso (reutilizable) === -->
<div id="uploadOverlay">
  <div class="inner">
    <h4>Enviando registro de vacaciones extra…</h4>
    <div class="sub">Estamos subiendo y procesando tus archivos. No cierres esta ventana.</div>
    <div class="progress">
      <div id="upBar" class="progress-bar progress-bar-info" role="progressbar" style="width:0%"></div>
    </div>
    <div><strong id="upPercent">0%</strong></div>
    <div id="upList" style="text-align:left; margin-top:10px; max-height:150px; overflow:auto"></div>
    <small>Esto puede tardar unos segundos si tus archivos son pesados o tu conexión es lenta.</small>
  </div>
</div>

<script>
  // ===== Utilidades (si en el futuro agregas 'desde'/'hasta') =====
  function parseYMD(s){ if(!s) return null; const a=s.split('-'); return new Date(+a[0], +a[1]-1, +a[2]); }
  function getDatesInRange(d1, d2){ const out=[]; if(!d1||!d2) return out; let c=new Date(d1); while(c<=d2){ out.push(new Date(c)); c.setDate(c.getDate()+1); } return out; }
  function isWeekday(d){ const w=d.getDay(); return (w>=1 && w<=5); }

  function recomputeDias(){
    const d1El=document.getElementById('desde');
    const d2El=document.getElementById('hasta');
    if(!d1El || !d2El) return; // en este formulario no hay rango de fechas
    const d1=parseYMD(d1El.value);
    const d2=parseYMD(d2El.value);
    if(!d1 || !d2 || d2<d1){ document.getElementById('cantidad_dias').value=''; return; }
    const dias = getDatesInRange(d1,d2).filter(isWeekday).length;
    document.getElementById('cantidad_dias').value = dias;
  }
  // No agregamos listeners a 'desde'/'hasta' porque no existen en este form
</script>

<script>
  // ===== Habilitar/Deshabilitar por empleado =====
  function bloquear(){ $('#fecha_documento,#motivo,#imagen1').prop('disabled',true); }
  function desbloquear(){ $('#fecha_documento,#motivo,#imagen1').prop('disabled',false); }

  function limpiarUIArchivos(){
    filesState.splice(0, filesState.length);
    document.getElementById('filesContainer').innerHTML='';
    document.getElementById('file_order').value='[]';
    document.getElementById('crop_json_list').value='[]';
    const inp=document.getElementById('imagen1'); if (inp) inp.value='';
  }

  $(document).ready(function(){
    $('#empleado').select2({width:'100%'});
    bloquear();

    $('#empleado').on('change', function(){
      const idEmpleado=$(this).val();
      $('#fecha_documento,#motivo,#cantidad_dias').val('');
      limpiarUIArchivos();

      if(!idEmpleado){
        $('#empleado-detalles').hide(); $('#detalles-contenido').html(''); bloquear(); return;
      }
      desbloquear();
      $('#fecha_documento').val('<?php echo $fechaactual; ?>');

      $.ajax({
        url:'detalle_empleado.php',
        type:'POST',
        data:{id:idEmpleado},
        success:function(data){ $('#detalles-contenido').html(data); $('#empleado-detalles').show(); },
        error:function(xhr){ $('#detalles-contenido').html('<p style="color:red;">Error: '+xhr.responseText+'</p>'); $('#empleado-detalles').show(); }
      });
    });
  });
</script>

<script>
  // ===== Multiarchivos + Cropper + Sortable =====
  const filesState = []; // {id,file,type,cropper,el}
  let seq=0;
  const container = document.getElementById('filesContainer');
  const input = document.getElementById('imagen1');

  const sortable = new Sortable(container, { animation:150, handle:'.drag-handle', onSort:updateHiddenOrder });

  if (input){
    input.addEventListener('change', () => {
      const list = Array.from(input.files || []);
      list.forEach(f => addFileCard(f));
      input.value='';
    });
  }

  function addFileCard(file){
    const id='f_'+(seq++);
    const card=document.createElement('div'); card.className='file-card'; card.dataset.id=id;

    const header=document.createElement('div');
    header.innerHTML=`<span class="drag-handle"><i class="fa fa-bars"></i></span>
                      <strong>${escapeHtml(file.name)}</strong> <small>(${Math.round(file.size/1024)} KB)</small>`;

    const body=document.createElement('div');
    const actions=document.createElement('div'); actions.className='file-actions';

    const btnL=makeBtn('Rotate -90°','fa fa-undo');
    const btnR=makeBtn('Rotate +90°','fa fa-repeat');
    const btnC=makeBtn('Reset crop','fa fa-refresh');
    const btnD=makeBtn('Remove','fa fa-trash');

    btnL.addEventListener('click',()=>{ const c=getCropper(id); if(c) c.rotate(-90); });
    btnR.addEventListener('click',()=>{ const c=getCropper(id); if(c) c.rotate(90); });
    btnC.addEventListener('click',()=>{ const c=getCropper(id); if(c) c.reset(); });
    btnD.addEventListener('click',()=> removeCard(id));

    actions.appendChild(btnL);actions.appendChild(btnR);actions.appendChild(btnC);actions.appendChild(btnD);

    const media=document.createElement('div');
    const img=document.createElement('img'); img.className='thumb-img'; img.style.display='none';
    const emb=document.createElement('embed'); emb.className='pdf-embed'; emb.style.display='none'; emb.type='application/pdf';
    media.appendChild(img); media.appendChild(emb);

    body.appendChild(media); body.appendChild(actions);
    card.appendChild(header); card.appendChild(body);
    container.appendChild(card);

    const reader=new FileReader();
    reader.onload=e=>{
      if(file.type==='application/pdf'){
        emb.style.display='block'; emb.src=e.target.result;
        btnL.style.display='none'; btnR.style.display='none'; btnC.style.display='none';
        filesState.push({id,file,type:'pdf',cropper:null,el:card});
      }else if(file.type.startsWith('image/')){
        img.style.display='block'; img.src=e.target.result;
        const cropper=new Cropper(img,{
          viewMode:1, dragMode:'move', autoCropArea:1,
          movable:true, zoomable:true, rotatable:true,
          background:false, responsive:true
        });
        filesState.push({id,file,type:'image',cropper,el:card});
      }else{
        alert('Solo imágenes o PDF'); card.remove();
      }
      updateHiddenOrder();
    };
    reader.readAsDataURL(file);
  }

  function makeBtn(text,icon){ const b=document.createElement('button'); b.type='button'; b.className='btn btn-default btn-mini'; b.innerHTML=`<i class="${icon}"></i> ${text}`; return b; }
  function getCropper(id){ const it=filesState.find(x=>x.id===id); return it&&it.cropper?it.cropper:null; }
  function removeCard(id){
    const i=filesState.findIndex(x=>x.id===id);
    if(i>=0){ if(filesState[i].cropper) filesState[i].cropper.destroy(); filesState[i].el.remove(); filesState.splice(i,1); updateHiddenOrder(); }
  }
  function updateHiddenOrder(){
    const order=Array.from(container.children).map(ch=>ch.dataset.id);
    const idx=order.map(id=>filesState.findIndex(x=>x.id===id));
    document.getElementById('file_order').value=JSON.stringify(idx);
  }
  function escapeHtml(s){return (s||'').replace(/[&<>"']/g,m=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m]));}
</script>

<!-- ===== ÚNICO SUBMIT HANDLER: habilita → arma archivos/recortes → muestra overlay ===== -->
<script>

document.getElementById('formVacExtra').addEventListener('submit', function (e) {
  // 1) Habilitar campos para que entren al POST
  ['#fecha_documento','#motivo','#imagen1'].forEach(function(sel){
    var el = document.querySelector(sel);
    if (el) el.disabled = false;
  });

  // 2) Respetar el orden y recortes ANTES de enviar
  try {
    const orderIdx = JSON.parse(document.getElementById('file_order').value || '[]');
    const dt = new DataTransfer();
    const cropList = [];
    const items = (orderIdx.length>0 ? orderIdx.map(i=>filesState[i]) : filesState);

    for (const it of items){
      if (!it) continue;
      dt.items.add(it.file);
      if (it.type === 'image' && it.cropper){
        const d = it.cropper.getData(true);
        cropList.push({
          unit: 'px',
          x: Math.max(0, Math.round(d.x || 0)),
          y: Math.max(0, Math.round(d.y || 0)),
          width:  Math.max(1, Math.round(d.width  || 0)),
          height: Math.max(1, Math.round(d.height || 0)),
          rotate: Math.round(d.rotate || 0)
        });
      } else {
        cropList.push(null);
      }
    }
    const fileInput = document.getElementById('imagen1');
    if (fileInput) {
      fileInput.files = dt.files; // ahora ya no está disabled
    }
    document.getElementById('crop_json_list').value = JSON.stringify(cropList);

  } catch(_){ /* no bloqueamos el envío si algo falla aquí */ }

  // 3) Mostrar overlay elegante con lista de archivos
  try {
    const listEl = document.getElementById('upList');
    const f = document.getElementById('imagen1')?.files || [];
    if (f.length){
      let html = '';
      for (let i=0;i<f.length;i++){
        html += `<small>${i+1}. ${escapeHtml(f[i].name)} (${Math.round(f[i].size/1024)} KB)</small>`;
      }
      listEl.innerHTML = html;
    } else {
      listEl.innerHTML = '<small>Sin archivos adjuntos.</small>';
    }
    startFakeProgress();
    document.getElementById('uploadOverlay').style.display = 'block';
  } catch(_) {}

  // Dejamos que el form se envíe normal (sin preventDefault).
});

// Progreso semi-realista (feedback suficiente en móvil/conexiones lentas)
function startFakeProgress(){
  const bar = document.getElementById('upBar');
  const pct = document.getElementById('upPercent');
  let p = 0;
  const f = document.getElementById('imagen1')?.files || [];
  let total = 0; for (let i=0;i<f.length;i++) total += f[i].size;
  const totalMB = total/1024/1024;
  const est = Math.min(60, Math.max(8, Math.round(totalMB*1.2)+6)); // 8..60s aprox

  const iv = setInterval(()=>{
    if (p < 95){
      p += Math.max(1, Math.round(100/est/2));
      if (p>95) p = 95;
      bar.style.width = p + '%';
      pct.textContent = p + '%';
    } else {
      clearInterval(iv);
    }
  }, 250);
}
</script>
<script>
// === Refresco visual para Vacaciones Extra (usa el mismo valor del input) ===

// Lee un número base desde data-base o, si no existe, desde el texto del nodo
function leerBaseNumerica(el){
  if (!el) return 0;
  var v = parseFloat(el.dataset?.base);
  if (isFinite(v)) return v;
  var m = (el.textContent || '').match(/-?\d+(\.\d+)?/);
  return m ? parseFloat(m[0]) : 0;
}

// Pinta “x + y” en la línea de vacaciones extra y “base + y = total” en total disponible
function actualizarResumenExtraConInput(diasNuevos){
  diasNuevos = parseFloat(diasNuevos);
  if (!isFinite(diasNuevos)) diasNuevos = 0;

  // 1) "Días de vacaciones extra: 62.00 + 12.00"
  var elExtra = document.getElementById('diasExtra');
  if (elExtra){
    var laborablesBase = leerBaseNumerica(elExtra); // p.e. 62.00
    elExtra.innerHTML = laborablesBase.toFixed(2) +
      ' <span style="color:green; font-weight:bold;">+ ' + diasNuevos.toFixed(2) + '</span>';
  }

  // 2) "Total disponible: 51.85 + 12.00 = 63.85"
  var elTotal = document.getElementById('totalDias');
  if (elTotal){
    var base = leerBaseNumerica(elTotal);
    var total = base + diasNuevos;
    elTotal.innerHTML =
      base.toFixed(2) +
      ' <span style="color:green; font-weight:bold;">+ ' + diasNuevos.toFixed(2) + '</span>' +
      ' = <span style="font-weight:bold; color:black;">' + total.toFixed(2) + '</span>';
  }
}

$(document).ready(function(){
  // cuando teclea en “Working days (Mon-Fri)”
  $('#cantidad_dias').on('input change', function(){
    var v = parseFloat(this.value);
    actualizarResumenExtraConInput(isFinite(v) ? v : 0);
  });

  // tras cargar el detalle del empleado por AJAX, refrescamos con el valor ya escrito
  $(document).on('ajaxStop', function(){
    var v = parseFloat($('#cantidad_dias').val());
    actualizarResumenExtraConInput(isFinite(v) ? v : 0);
  });
});
</script>

<?php
    include "view/footer.html";
  } else {
    include "view/headeradmin.html"; ?>
    <div class="box">
      <div class="box-header with-border"><h3>Crear producto:------------------------------------------------> (Con Seriales)</h3></div>
      <div class="box-body"><p>Inicia sesión como usuario normal para ver esta sección.</p></div>
    </div>
    <?php include "view/footer.html"; }
} else {
  header("Location:index.html");
}
