<?php
session_start();
$idsucursal=0;
date_default_timezone_set('America/Costa_Rica');
$fechaactual = date('Y-m-d');
$horaactual  = date('H:i');

if(isset($_SESSION["idusuario"])){
  if ($_SESSION["superadmin"] != "S") {
    include "./view/header.php";

    $idusuario=$_SESSION["idusuario"];
    include('dbcon.php');

    // Global
    $query=mysqli_query($con,"select * from global")or die(mysqli_error($con));
    while($row=mysqli_fetch_array($query)){ $tipo_moneda=$row['tipo_moneda']; }

    // Sucursal
    $nombre_sucursal=$_SESSION["sucursal"];
    $query=mysqli_query($con,"select * from sucursal where razon_social='$nombre_sucursal' ")or die(mysqli_error($con));
    while($row=mysqli_fetch_array($query)){ $idsucursal=$row['idsucursal']; }

    // Usuario/empleado
    $query=mysqli_query($con,"select * from usuario where idusuario='$idusuario' ")or die(mysqli_error($con));
    while($row=mysqli_fetch_array($query)){ $idempleado=$row['idempleado']; }
    $query=mysqli_query($con,"select * from empleado where idempleado='$idempleado' ")or die(mysqli_error($con));
    while($row=mysqli_fetch_array($query)){ $nombre=$row['nombre']; $apellidos=$row['apellidos']; }
?>
<script type="text/javascript">
  $('#payroll_control').addClass("treeview active");
  $('#payroll_control_2').addClass("treeview active");
  $('#payroll_control_2_2').addClass("active");
</script>

<!-- Select2 -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

<!-- Cropper (recorte) -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css" rel="stylesheet"/>
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>

<!-- Sortable (drag & drop) -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.2/Sortable.min.js"></script>

<style>
  .preview-pane { border:2px dashed #3c8dbc; border-radius:10px; padding:10px; text-align:center; margin-top:10px; }
  .btn-mini { padding:6px 10px; }
  .file-card{border:2px dashed #3c8dbc;border-radius:10px;padding:10px;margin-bottom:10px;}
  .file-actions{margin-top:8px}
  .file-actions .btn{margin-right:6px}
  .thumb-img{max-width:100%;max-height:360px;border-radius:6px;display:block;margin:0 auto}
  .pdf-embed{width:100%;height:360px;border-radius:6px}
  .drag-handle{cursor:grab;color:#3c8dbc;margin-right:6px}

  /* ===== Overlay / Progreso de subida ===== */
  #uploadOverlay{
    position:fixed; left:0; top:0; right:0; bottom:0;
    background:rgba(0,0,0,.65); z-index:9999; display:none;
  }
  #uploadOverlay .inner{
    position:absolute; left:50%; top:50%; transform:translate(-50%,-50%);
    width:92%; max-width:520px; background:#fff; border-radius:12px;
    padding:18px 20px; box-shadow:0 10px 30px rgba(0,0,0,.25); text-align:center;
  }
  #uploadOverlay h4{ margin:0 0 6px 0; font-weight:600 }
  #uploadOverlay .sub{ color:#666; margin-bottom:12px }
  #uploadOverlay .progress{ height:10px; border-radius:6px; background:#e9ecef; overflow:hidden; margin-bottom:8px }
  #uploadOverlay .progress-bar{ width:0%; transition:width .3s ease }
  #uploadOverlay small{ display:block; color:#666 }
</style>

<div class="box">
  <div class="box-header with-border">
    <h3>Vacation:------------------------------------------------> (Payroll Control) </h3>
    <div class="box-tools pull-right">
      <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
      <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
    </div>
  </div>

  <div class="box-body">
    <div class="box-body">
      <form method="post" action="add_ingreso_vacaciones.php" enctype="multipart/form-data" class="form-horizontal" id="formVac">

        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label>Document date:</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="date" class="form-control" id="fecha_documento" disabled name="fecha_documento" required>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <div class="row">
          <div class="col-md-3 btn-print">
            <div class="form-group"><label for="empleado">Select Collaborator:</label></div>
          </div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <select class="form-control select2" name="empleado" id="empleado" required>
                <option value="">-- Select Collaborator --</option>
                <?php
                $queryc = mysqli_query($con, "SELECT * FROM empleados_planilla ORDER BY nombre_completo ASC") or die(mysqli_error($con));
                while($rowc = mysqli_fetch_array($queryc)){
                  echo '<option value="'.$rowc['id'].'">'.$rowc['nombre_completo'].' - '.$rowc['cedula'].'</option>';
                }
                ?>
              </select>
            </div>
            <div id="empleado-detalles" style="border:1px solid #ccc; padding:10px; margin-top:10px; display:none; clear:both;">
              <strong>Detalles del empleado:</strong>
              <div id="detalles-contenido"></div>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label>Date From:</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="date" class="form-control" id="desde" name="desde" disabled required>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label>Date until:</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="date" class="form-control" id="hasta" name="hasta" disabled required>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <!-- Resumen rango -->
        <div id="resumenRango" class="well well-sm" style="display:none; margin-top:10px;">
          <strong>Resumen del rango seleccionado:</strong>
          <div>
            Días totales: <span id="r_total">0</span> &nbsp;|
            Sábados: <span id="r_sab">0</span> &nbsp;|
            Domingos: <span id="r_dom">0</span> &nbsp;|
            Días hábiles (preliminar): <span id="r_habiles">0</span>
          </div>
        </div>

        <!-- Feriados -->
        <div style="margin:8px 0 14px;">
          <label style="margin-right:10px;">
            <input type="checkbox" id="chkFeriados"> Este rango incluye feriados (días no laborales)
          </label>
          <button type="button" class="btn btn-info btn-xs" id="btnMarcarFeriados" disabled>
            Marcar feriados…
          </button>
        </div>
        <input type="hidden" name="feriados_json" id="feriados_json" value="[]">

        <div class="modal fade" id="modalFeriados" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog modal-md">
            <div class="modal-content">
              <div class="modal-header" style="border-bottom:1px solid #eee;">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Selecciona feriados (solo días hábiles del rango)</h4>
              </div>
              <div class="modal-body">
                <div id="listaFeriados"></div>
                <small class="text-muted">Marca los días feriados (no laborables) dentro del rango elegido.</small>
              </div>
              <div class="modal-footer" style="border-top:1px solid #eee;">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="btnAplicarFeriados">Aplicar</button>
              </div>
            </div>
          </div>
        </div>

        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label>Reason:</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input class="form-control" id="motivo" name="motivo" placeholder="Reason" disabled>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label for="cantidad_dias">Number of days:</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="number" class="form-control" id="cantidad_dias" name="cantidad_dias" readonly placeholder="Number of days">
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <h1><hr style="width:100%; border-color:black;"></h1>

        <!-- MULTI ARCHIVOS + RECORTE -->
        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label>Upload file(s):</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="file" class="form-control" id="imagen1" name="imagen1[]" accept="image/*,application/pdf" multiple disabled>
              <div class="text-muted" style="margin-top:6px;">
                Puedes subir varios. Para imágenes, podrás recortar cada una. Se guardará como un solo PDF multipágina.
              </div>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <div id="filesContainer"></div>

        <!-- hidden -->
        <input type="hidden" name="crop_json_list" id="crop_json_list" value="[]">
        <input type="hidden" name="file_order" id="file_order" value="[]">

        <h1><hr style="width:100%; border-color:black;"></h1>

        <button  type="submit" class="btn btn-primary">Continue</button>
      </form>
    </div>

    <div class="box-header"></div>
    <div class="box-body">
      <?php
      // (Se deja tu bloque original de modales/listados si lo tienes…)
      ?>
    </div>
  </div>
</div>

<!-- ===== Overlay de progreso ===== -->
<div id="uploadOverlay">
  <div class="inner">
    <h4>Enviando solicitud de vacaciones…</h4>
    <div class="sub">Estamos subiendo y procesando tus archivos. No cierres esta ventana.</div>
    <div class="progress">
      <div id="upBar" class="progress-bar progress-bar-info" role="progressbar" style="width:0%"></div>
    </div>
    <div><strong id="upPercent">0%</strong></div>
    <div id="upList" style="text-align:left; margin-top:10px; max-height:150px; overflow:auto"></div>
    <small>Esto puede tardar unos segundos si tus archivos son pesados o tu conexión es lenta.</small>
  </div>
</div>

<script>
// ---------- Utilidades de fecha ----------
function parseYMD(s){ if(!s) return null; const a=s.split('-'); return new Date(+a[0], +a[1]-1, +a[2]); }
function ymd(d){ const z=n=> (n<10?'0':'')+n; return d.getFullYear()+'-'+z(d.getMonth()+1)+'-'+z(d.getDate()); }
function getDatesInRange(d1, d2){
  const out=[]; if(!d1 || !d2) return out;
  let c=new Date(d1.getFullYear(), d1.getMonth(), d1.getDate());
  const end=new Date(d2.getFullYear(), d2.getMonth(), d2.getDate());
  while(c<=end){ out.push(new Date(c)); c.setDate(c.getDate()+1); }
  return out;
}
function isWeekend(d){ const w=d.getDay(); return (w===0 || w===6); }
function isWeekday(d){ const w=d.getDay(); return (w>=1 && w<=5); }

// ---------- Estado feriados ----------
function getFeriadosSel(){
  const el = document.getElementById('feriados_json');
  if(!el) return [];
  try { return JSON.parse(el.value || '[]'); } catch(e){ return []; }
}
function setFeriadosSel(arr){
  document.getElementById('feriados_json').value = JSON.stringify(arr || []);
}

// ---------- Cálculo principal ----------
function recomputeDias(){
  var desdeVal = document.getElementById('desde').value;
  var hastaVal = document.getElementById('hasta').value;

  if(!desdeVal || !hastaVal){
    var cd = document.getElementById('cantidad_dias'); if(cd) cd.value = '';
    var rr = document.getElementById('resumenRango'); if(rr) rr.style.display='none';
    return;
  }

  var d1 = parseYMD(desdeVal);
  var d2 = parseYMD(hastaVal);
  if(d2 < d1){
    document.getElementById('cantidad_dias').value = '';
    document.getElementById('resumenRango').style.display='none';
    return;
  }

  var fechas = getDatesInRange(d1, d2);
  var total  = fechas.length;
  var sab    = fechas.filter(function(x){ return x.getDay()===6; }).length;
  var dom    = fechas.filter(function(x){ return x.getDay()===0; }).length;
  var hab    = fechas.filter(isWeekday).length;

  // Feriados (solo hábiles dentro del rango)
  var feriados = getFeriadosSel().filter(function(s){
    return s>=desdeVal && s<=hastaVal && isWeekday(parseYMD(s));
  });
  feriados = Array.from(new Set(feriados));

  var finalHabiles = Math.max(0, hab - feriados.length);

  document.getElementById('r_total').textContent   = total;
  document.getElementById('r_sab').textContent     = sab;
  document.getElementById('r_dom').textContent     = dom;
  document.getElementById('r_habiles').textContent = hab;
  document.getElementById('resumenRango').style.display='block';

  document.getElementById('cantidad_dias').value = finalHabiles;

  if (typeof actualizarDetalleEmpleado === 'function'){
    actualizarDetalleEmpleado(finalHabiles);
  }
}

// ---------- DOM Ready ----------
$(document).ready(function(){
  $('#empleado, #area').select2({ placeholder: "Search...", allowClear: true, width: '100%' });

  // Cambio de colaborador
  $('#empleado').on('change', function() {
    var idEmpleado = $(this).val();

    limpiarCamposFormulario();

    var campos = ['#fecha_documento','#desde','#hasta','#motivo','#cantidad_dias','#imagen1'];
    if (idEmpleado === "") {
      campos.forEach(function(s){ $(s).prop('disabled', true); });
      $('#empleado-detalles').hide(); $('#detalles-contenido').html('');
      return;
    } else {
      campos.forEach(function(s){ $(s).prop('disabled', false); });
      $('#fecha_documento').val('<?php echo $fechaactual; ?>');
    }

    $.ajax({
      url: 'detalle_empleado.php',
      type: 'POST',
      data: { id: idEmpleado },
      success: function(data) {
        $('#detalles-contenido').html(data);
        $('#empleado-detalles').show();
        recomputeDias();
      },
      error: function(xhr) {
        $('#detalles-contenido').html('<p style="color:red;">Error al cargar los datos: '+xhr.responseText+'</p>');
        $('#empleado-detalles').show();
      }
    });
  });

  // fechas
  $('#desde').on('change', function(){ setFeriadosSel([]); recomputeDias(); });
  $('#hasta').on('change', function(){ setFeriadosSel([]); recomputeDias(); });

  // Checkbox feriados
  $('#chkFeriados').on('change', function(){
    $('#btnMarcarFeriados').prop('disabled', !this.checked);
  });

  // Abrir modal feriados
  $('#btnMarcarFeriados').on('click', function(){
    var desdeVal = $('#desde').val();
    var hastaVal = $('#hasta').val();
    if(!desdeVal || !hastaVal) return;

    var d1 = parseYMD(desdeVal), d2 = parseYMD(hastaVal);
    var habiles = getDatesInRange(d1,d2).filter(isWeekday);

    var sel = new Set(getFeriadosSel());
    var html = '<div class="row" style="max-height:320px; overflow:auto;">';
    habiles.forEach(function(d){
      var s = ymd(d);
      var checked = sel.has(s) ? 'checked' : '';
      html += '<div class="col-xs-6"><label style="display:block; margin-bottom:6px;">'
           +  '<input type="checkbox" class="chk-feriado" value="'+s+'" '+checked+'> '+s
           +  '</label></div>';
    });
    html += '</div>';
    $('#listaFeriados').html(html);
    $('#modalFeriados').modal('show');
  });

  // Checkboxes dentro del modal
  $(document).on('change', '.chk-feriado', function(){
    var arr = $('.chk-feriado:checked').get().map(function(el){ return el.value; });
    setFeriadosSel(arr);
  });

  // Aplicar feriados
  $('#btnAplicarFeriados').on('click', function(){
    $('#modalFeriados').modal('hide');
    recomputeDias();
  });
});

// Limpieza general
function limpiarCamposFormulario() {
  $('#fecha_documento').val('');
  $('#desde').val(''); $('#hasta').val('');
  $('#motivo').val(''); $('#cantidad_dias').val('');

  // limpiar UI multi-archivos
  filesState.splice(0, filesState.length);
  document.getElementById('filesContainer').innerHTML='';
  document.getElementById('file_order').value='[]';
  document.getElementById('crop_json_list').value='[]';
  $('#imagen1').val('');

  setFeriadosSel([]);
  var rr = document.getElementById('resumenRango'); if(rr) rr.style.display='none';

  if(document.getElementById('diasSolicitados')) {
    document.getElementById('diasSolicitados').innerHTML = '0.00';
  }
  if(document.getElementById('totalDias')) {
    document.getElementById('totalDias').innerText = '0.00';
  }
}
</script>

<script>
// Actualizar panel derecho (si lo tienes)
function actualizarDetalleEmpleado(nuevosDias){
  nuevosDias = parseFloat(nuevosDias) || 0;
  const diasVac = parseFloat(document.getElementById('diasVacaciones')?.dataset.base) || 0;
  const diasExtra = parseFloat(document.getElementById('diasExtra')?.dataset.base) || 0;
  const diasIncap = parseFloat(document.getElementById('diasIncapacidad')?.dataset.base) || 0;
  const diasSolicBase = parseFloat(document.getElementById('diasSolicitados')?.dataset.base) || 0;

  if (document.getElementById('diasSolicitados')){
    document.getElementById('diasSolicitados').innerHTML =
      diasSolicBase.toFixed(2) + ' + ' +
      '<span style="color:green; font-weight:bold;">' + nuevosDias.toFixed(2) + '</span>';
  }

  const totalBase  = diasVac + diasExtra - diasIncap - diasSolicBase;
  const totalFinal = totalBase - nuevosDias;

  if (document.getElementById('totalDias')){
    document.getElementById('totalDias').innerHTML =
      totalBase.toFixed(2) +
      ' <span style="color:red; font-weight:bold;">- ' + nuevosDias.toFixed(2) + '</span>' +
      ' = <span style="font-weight:bold; color:black;">' + totalFinal.toFixed(2) + '</span>';
  }

  let alertaDiv = document.getElementById('alertaVacaciones');
  if (!alertaDiv && document.getElementById('totalDias')){
    alertaDiv = document.createElement('div');
    alertaDiv.id = 'alertaVacaciones';
    document.getElementById('totalDias').parentNode.appendChild(alertaDiv);
  }
  if (alertaDiv){
    alertaDiv.innerHTML = (totalFinal < 0)
      ? '<span style="color:red; font-weight:bold;">⚠ El monto de vacaciones que desea ingresar es mayor a la cantidad disponible que tiene la persona.</span>'
      : '';
  }
}
</script>

<!-- ===== Multi-archivos + Cropper + Sortable ===== -->
<script>
const filesState = []; // {id,file,type,cropper,el}
let seq=0;
const container = document.getElementById('filesContainer');
const input = document.getElementById('imagen1');

const sortable = new Sortable(container, { animation:150, handle:'.drag-handle', onSort:updateHiddenOrder });

input.addEventListener('change', () => {
  const list = Array.from(input.files || []);
  list.forEach(f => addFileCard(f));
  input.value='';
});

function addFileCard(file){
  const id='f_'+(seq++);
  const card=document.createElement('div'); card.className='file-card'; card.dataset.id=id;

  const header=document.createElement('div');
  header.innerHTML=`<span class="drag-handle"><i class="fa fa-bars"></i></span>
                    <strong>${escapeHtml(file.name)}</strong> <small>(${Math.round(file.size/1024)} KB)</small>`;

  const body=document.createElement('div');
  const actions=document.createElement('div'); actions.className='file-actions';

  const btnL=makeBtn('Rotate -90°','fa fa-undo');
  const btnR=makeBtn('Rotate +90°','fa fa-repeat');
  const btnC=makeBtn('Reset crop','fa fa-refresh');
  const btnD=makeBtn('Remove','fa fa-trash');

  btnL.addEventListener('click',()=>{ const c=getCropper(id); if(c) c.rotate(-90); });
  btnR.addEventListener('click',()=>{ const c=getCropper(id); if(c) c.rotate(90); });
  btnC.addEventListener('click',()=>{ const c=getCropper(id); if(c) c.reset(); });
  btnD.addEventListener('click',()=> removeCard(id));

  actions.appendChild(btnL);actions.appendChild(btnR);actions.appendChild(btnC);actions.appendChild(btnD);

  const media=document.createElement('div');
  const img=document.createElement('img'); img.className='thumb-img'; img.style.display='none';
  const emb=document.createElement('embed'); emb.className='pdf-embed'; emb.style.display='none'; emb.type='application/pdf';
  media.appendChild(img); media.appendChild(emb);

  body.appendChild(media); body.appendChild(actions);
  card.appendChild(header); card.appendChild(body);
  container.appendChild(card);

  const reader=new FileReader();
  reader.onload=e=>{
    if(file.type==='application/pdf'){
      emb.style.display='block'; emb.src=e.target.result;
      btnL.style.display='none'; btnR.style.display='none'; btnC.style.display='none';
      filesState.push({id,file,type:'pdf',cropper:null,el:card});
    }else if(file.type.startsWith('image/')){
      img.style.display='block'; img.src=e.target.result;
      const cropper=new Cropper(img,{
        viewMode:1, dragMode:'move', autoCropArea:1,
        movable:true, zoomable:true, rotatable:true,
        background:false, responsive:true
      });
      filesState.push({id,file,type:'image',cropper,el:card});
    }else{
      alert('Solo imágenes o PDF'); card.remove();
    }
    updateHiddenOrder();
  };
  reader.readAsDataURL(file);
}

function makeBtn(text,icon){ const b=document.createElement('button'); b.type='button'; b.className='btn btn-default btn-mini'; b.innerHTML=`<i class="${icon}"></i> ${text}`; return b; }
function getCropper(id){ const it=filesState.find(x=>x.id===id); return it&&it.cropper?it.cropper:null; }
function removeCard(id){
  const i=filesState.findIndex(x=>x.id===id);
  if(i>=0){ if(filesState[i].cropper) filesState[i].cropper.destroy(); filesState[i].el.remove(); filesState.splice(i,1); updateHiddenOrder(); }
}
function updateHiddenOrder(){
  const order=Array.from(container.children).map(ch=>ch.dataset.id);
  const idx=order.map(id=>filesState.findIndex(x=>x.id===id));
  document.getElementById('file_order').value=JSON.stringify(idx);
}
</script>

<!-- ===== ÚNICO SUBMIT HANDLER: habilita → arma archivos/recortes → muestra overlay ===== -->
<script>
document.getElementById('formVac').addEventListener('submit', function (e) {
  // 1) Habilitar campos para que entren al POST
  ['#fecha_documento','#desde','#hasta','#motivo','#imagen1'].forEach(function(sel){
    var el = document.querySelector(sel);
    if (el) el.disabled = false;
  });

  // 2) Respetar el orden y recortes ANTES de enviar
  try {
    const orderIdx = JSON.parse(document.getElementById('file_order').value || '[]');
    const dt = new DataTransfer();
    const cropList = [];
    const items = (orderIdx.length>0 ? orderIdx.map(i=>filesState[i]) : filesState);

    for (const it of items){
      if (!it) continue;
      dt.items.add(it.file);
      if (it.type === 'image' && it.cropper){
        const d = it.cropper.getData(true);
        cropList.push({
          unit: 'px',
          x: Math.max(0, Math.round(d.x || 0)),
          y: Math.max(0, Math.round(d.y || 0)),
          width:  Math.max(1, Math.round(d.width  || 0)),
          height: Math.max(1, Math.round(d.height || 0)),
          rotate: Math.round(d.rotate || 0)
        });
      } else {
        cropList.push(null);
      }
    }
    const fileInput = document.getElementById('imagen1');
    if (fileInput) {
      fileInput.files = dt.files; // ahora ya no está disabled
    }
    document.getElementById('crop_json_list').value = JSON.stringify(cropList);

  } catch(_){ /* si algo falla, no bloqueamos el envío */ }

  // 3) Mostrar overlay elegante
  try {
    const listEl = document.getElementById('upList');
    const f = document.getElementById('imagen1')?.files || [];
    if (f.length){
      let html = '';
      for (let i=0;i<f.length;i++){
        html += `<small>${i+1}. ${escapeHtml(f[i].name)} (${Math.round(f[i].size/1024)} KB)</small>`;
      }
      listEl.innerHTML = html;
    } else {
      listEl.innerHTML = '<small>Sin archivos adjuntos.</small>';
    }
    startFakeProgress();
    document.getElementById('uploadOverlay').style.display = 'block';
  } catch(_) {}

  // Dejamos que el form se envíe normal (sin preventDefault).
});

// Progreso semi-realista (suficiente feedback para móvil y conexiones lentas)
function startFakeProgress(){
  const bar = document.getElementById('upBar');
  const pct = document.getElementById('upPercent');
  let p = 0;
  const f = document.getElementById('imagen1')?.files || [];
  let total = 0; for (let i=0;i<f.length;i++) total += f[i].size;
  const totalMB = total/1024/1024;
  const est = Math.min(60, Math.max(8, Math.round(totalMB*1.2)+6)); // 8..60s aprox

  const iv = setInterval(()=>{
    if (p < 95){
      p += Math.max(1, Math.round(100/est/2));
      if (p>95) p = 95;
      bar.style.width = p + '%';
      pct.textContent = p + '%';
    } else {
      clearInterval(iv);
    }
  }, 250);
}
function escapeHtml(s){return (s||'').replace(/[&<>"']/g,m=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m]));}
</script>

<?php
    include "view/footer.html";
  } else {
    include "view/headeradmin.html"; ?>
    <div class="box">
      <div class="box-header with-border"><h3>Crear producto:------------------------------------------------> (Con Seriales)</h3></div>
      <div class="box-body"><p>Iniciar sesión como usuario normal para ver la versión completa.</p></div>
    </div>
    <?php include "view/footer.html"; }
} else {
  header("Location:index.html");
}
