<?php
session_start();
$idsucursal=0;
date_default_timezone_set('America/Costa_Rica');
$fechaactual = date('Y-m-d');
$horaactual  = date('H:i');

if(isset($_SESSION["idusuario"])){
  if ($_SESSION["superadmin"] != "S") {
    include "./view/header.php";

    $idusuario=$_SESSION["idusuario"];
    include('dbcon.php');

    // global
    $query=mysqli_query($con,"select * from global")or die(mysqli_error());
    while($row=mysqli_fetch_array($query)){ $tipo_moneda=$row['tipo_moneda']; }

    // sucursal
    $nombre_sucursal=$_SESSION["sucursal"];
    $query=mysqli_query($con,"select * from sucursal where razon_social='$nombre_sucursal'")or die(mysqli_error());
    while($row=mysqli_fetch_array($query)){ $idsucursal=$row['idsucursal']; }

    // usuario/empleado
    $query=mysqli_query($con,"select * from usuario where idusuario='$idusuario'")or die(mysqli_error());
    while($row=mysqli_fetch_array($query)){ $idempleado=$row['idempleado']; }
    $query=mysqli_query($con,"select * from empleado where idempleado='$idempleado'")or die(mysqli_error());
    while($row=mysqli_fetch_array($query)){ $nombre=$row['nombre']; $apellidos=$row['apellidos']; }
?>
<script type="text/javascript">
  $('#payroll_control').addClass("treeview active");
  $('#payroll_control_4').addClass("treeview active");
  $('#payroll_control_4_2').addClass("active");
</script>

<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

<!-- Cropper para recorte -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css" rel="stylesheet"/>
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>

<style>
  .file-card{border:2px dashed #3c8dbc;border-radius:10px;padding:10px;margin-bottom:10px;}
  .file-actions{margin-top:8px}
  .file-actions .btn{margin-right:6px}
  .thumb-img{max-width:100%;max-height:360px;border-radius:6px;display:block;margin:0 auto}
  .pdf-embed{width:100%;height:360px;border-radius:6px}
  .drag-handle{cursor:grab;color:#3c8dbc;margin-right:6px}

  /* === Overlay / Progreso de subida (igual patrón que vacaciones) === */
  #uploadOverlay{
    position:fixed; left:0; top:0; right:0; bottom:0;
    background:rgba(0,0,0,.65); z-index:9999; display:none;
  }
  #uploadOverlay .inner{
    position:absolute; left:50%; top:50%; transform:translate(-50%,-50%);
    width:92%; max-width:520px; background:#fff; border-radius:12px;
    padding:18px 20px; box-shadow:0 10px 30px rgba(0,0,0,.25); text-align:center;
  }
  #uploadOverlay h4{ margin:0 0 6px 0; font-weight:600 }
  #uploadOverlay .sub{ color:#666; margin-bottom:12px }
  #uploadOverlay .progress{ height:10px; border-radius:6px; background:#e9ecef; overflow:hidden; margin-bottom:8px }
  #uploadOverlay .progress-bar{ width:0%; transition:width .3s ease }
  #uploadOverlay small{ display:block; color:#666 }
</style>

<div class="box">
  <div class="box-header with-border">
    <h3>Work disability:------------------------------------------------> (Payroll Control) </h3>
    <div class="box-tools pull-right">
      <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
      <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
    </div>
  </div>

  <div class="box-body">
    <div class="box-body">
      <form method="post" action="add_ingreso_inscapacidad.php" enctype="multipart/form-data" class="form-horizontal" id="formIncapacidad">

        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label>Document date:</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="date" class="form-control" id="fecha_documento" name="fecha_documento" disabled required>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label for="empleado">Select Collaborator:</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <select class="form-control select2" name="empleado" id="empleado" required>
                <option value="">-- Select Collaborator --</option>
                <?php
                $queryc = mysqli_query($con, "SELECT * FROM empleados_planilla ORDER BY nombre_completo ASC") or die(mysqli_error($con));
                while($rowc = mysqli_fetch_array($queryc)){
                  echo '<option value="'.$rowc['id'].'">'.htmlspecialchars($rowc['nombre_completo']).' - '.htmlspecialchars($rowc['cedula']).'</option>';
                }
                ?>
              </select>
            </div>

            <!-- Panel de detalles -->
            <div id="empleado-detalles" style="border:1px solid #ccc; padding:10px; margin-top:10px; display:none; clear:both;">
              <strong>Detalles del empleado:</strong>
              <div id="detalles-contenido"></div>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label>Date From:</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="date" class="form-control" id="desde" name="desde" required>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label>Date until:</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="date" class="form-control" id="hasta" name="hasta" required>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label for="resultado_dias"><strong>Total días de incapacidad:</strong></label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="text" name="resultado_dias" id="resultado_dias" class="form-control" readonly style="text-align:left;">
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <div class="row">
          <div class="col-md-3 btn-print">
            <div class="form-group">
              <input type="hidden" id="calculo_anterior" value=" " class="form-control" readonly>
              <label for="resultado_div_35"><strong>Total dividido entre 35:</strong></label>
            </div>
          </div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="text" id="resultado_div_35" name="resultado_div_35" class="form-control" readonly style="text-align:left;">
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <script>
          function calcularDias() {
            const desde = document.getElementById("desde").value;
            const hasta = document.getElementById("hasta").value;
            if (desde && hasta) {
              const d1 = new Date(desde);
              const d2 = new Date(hasta);
              const diff = d2 - d1;
              if (diff >= 0) {
                const dias = Math.floor(diff / (1000*60*60*24)) + 1;
                const dividido = (dias / 35).toFixed(2);
                document.getElementById("resultado_dias").value = dias;
                document.getElementById("resultado_div_35").value = dividido;
                const inp = document.getElementById("cantidad_dias");
                if (inp) {
                  inp.value = parseFloat(dividido);
                  inp.dispatchEvent(new Event('input'));
                }
              } else {
                document.getElementById("resultado_dias").value = "0";
                document.getElementById("resultado_div_35").value = "0";
                const inp = document.getElementById("cantidad_dias");
                if (inp) {
                  inp.value = "0";
                  inp.dispatchEvent(new Event('input'));
                }
              }
            }
          }
          document.getElementById("desde").addEventListener("change", calcularDias);
          document.getElementById("hasta").addEventListener("change", calcularDias);
        </script>

        <script>
          $(document).ready(function(){
            $('#empleado').select2();
            // Bloqueo inicial
            bloquearCampos();

            $('#empleado').on('change', function() {
              var idEmpleado = $(this).val();
              resetCampos();
              if(idEmpleado == ""){
                $('#empleado-detalles').hide();
                $('#detalles-contenido').html('');
                bloquearCampos();
                return;
              } else {
                // habilitar
                desbloquearCampos();
                // set hoy
                $('#fecha_documento').val('<?php echo $fechaactual; ?>');
              }
              // Cargar detalle
              $.ajax({
                url:'detalle_empleado.php',
                type:'POST',
                data:{id:idEmpleado},
                success:function(data){
                  $('#detalles-contenido').html(data);
                  $('#empleado-detalles').show();
                  if (typeof _ajaxSuccessIncap === 'function') { _ajaxSuccessIncap(); }
                },
                error:function(xhr){
                  $('#detalles-contenido').html('<p style="color:red;">Error al cargar los datos: '+xhr.responseText+'</p>');
                  $('#empleado-detalles').show();
                }
              });
            });
          });

          function bloquearCampos(){ $('#motivo,#cantidad_dias,#fecha_documento,#imagen1').prop('disabled', true); $('#desde,#hasta').prop('disabled', true); }
          function desbloquearCampos(){ $('#motivo,#cantidad_dias,#fecha_documento,#imagen1').prop('disabled', false); $('#desde,#hasta').prop('disabled', false); }

          function resetCampos(){
            $('#fecha_documento,#desde,#hasta,#motivo,#cantidad_dias').val('');
            // limpiar multiarchivos UI
            filesState.splice(0, filesState.length);
            document.getElementById('filesContainer').innerHTML='';
            document.getElementById('file_order').value='[]';
            document.getElementById('crop_json_list').value='[]';
          }
        </script>

        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label>Reason:</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group"><input class="form-control" id="motivo" name="motivo" placeholder="motivo"></div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label for="cantidad_dias">Number of vacation days:</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="number" class="form-control" id="cantidad_dias" name="cantidad_dias" placeholder="Number of days" min="0" step="0.01" oninput="this.value=this.value.replace(/[^0-9.]/g,'');" readonly>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <h1><hr style="width:100%; border-color:black;"></h1>

        <!-- MULTI ARCHIVOS + RECORTE -->
        <div class="row">
          <div class="col-md-3 btn-print"><div class="form-group"><label>Upload file(s):</label></div></div>
          <div class="col-md-5 btn-print">
            <div class="form-group">
              <input type="file" class="form-control" id="imagen1" name="imagen1[]" accept="image/*,application/pdf" multiple>
              <small class="text-muted">Puedes subir varios. Para imágenes, podrás recortar cada una.</small>
            </div>
          </div>
          <div class="col-md-4 btn-print"></div>
        </div>

        <div id="filesContainer"></div>

        <input type="hidden" name="crop_json_list" id="crop_json_list" value="[]">
        <input type="hidden" name="file_order" id="file_order" value="[]">

        <h1><hr style="width:100%; border-color:black;"></h1>

        <button  type="submit" class="btn btn-primary">Continue</button>
      </form>
    </div>
  </div>
</div>

<!-- === Overlay de progreso (reutilizable) === -->
<div id="uploadOverlay">
  <div class="inner">
    <h4>Enviando registro de incapacidad…</h4>
    <div class="sub">Estamos subiendo y procesando tus archivos. No cierres esta ventana.</div>
    <div class="progress">
      <div id="upBar" class="progress-bar progress-bar-info" role="progressbar" style="width:0%"></div>
    </div>
    <div><strong id="upPercent">0%</strong></div>
    <div id="upList" style="text-align:left; margin-top:10px; max-height:150px; overflow:auto"></div>
    <small>Esto puede tardar unos segundos si tus archivos son pesados o tu conexión es lenta.</small>
  </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.2/Sortable.min.js"></script>
<script>
  // ------- Multiarchivos + Cropper + Orden -------
  const filesState = []; // {id, file, type, cropper?, el}
  let seq = 0;
  const container = document.getElementById('filesContainer');
  const input = document.getElementById('imagen1');

  const sortable = new Sortable(container, {
    animation:150, handle:'.drag-handle', onSort:updateHiddenOrder
  });

  $(function(){ $('#empleado').select2({width:'100%'}); });

  if (input){
    input.addEventListener('change', () => {
      const list = Array.from(input.files || []);
      list.forEach(f => addFileCard(f));
      input.value = ''; // limpiar input
    });
  }

  function addFileCard(file){
    const id = 'f_'+(seq++);
    const card = document.createElement('div');
    card.className='file-card'; card.dataset.id=id;

    const header=document.createElement('div');
    header.innerHTML = `<span class="drag-handle"><i class="fa fa-bars"></i></span>
                        <strong>${escapeHtml(file.name)}</strong> <small>(${Math.round(file.size/1024)} KB)</small>`;

    const body=document.createElement('div');
    const actions=document.createElement('div'); actions.className='file-actions';

    const btnRotateL = btn('Rotate -90°','fa fa-undo');
    const btnRotateR = btn('Rotate +90°','fa fa-repeat');
    const btnReset   = btn('Reset crop','fa fa-refresh');
    const btnRemove  = btn('Remove','fa fa-trash');

    btnRotateL.addEventListener('click', ()=>{ const c=getCropper(id); if(c) c.rotate(-90); });
    btnRotateR.addEventListener('click', ()=>{ const c=getCropper(id); if(c) c.rotate( 90); });
    btnReset.addEventListener  ('click', ()=>{ const c=getCropper(id); if(c) c.reset(); });
    btnRemove.addEventListener ('click', ()=> removeCard(id));

    actions.appendChild(btnRotateL);
    actions.appendChild(btnRotateR);
    actions.appendChild(btnReset);
    actions.appendChild(btnRemove);

    const media=document.createElement('div');
    const img=document.createElement('img'); img.className='thumb-img'; img.style.display='none';
    const emb=document.createElement('embed'); emb.className='pdf-embed'; emb.style.display='none'; emb.type='application/pdf';
    media.appendChild(img); media.appendChild(emb);

    body.appendChild(media); body.appendChild(actions);
    card.appendChild(header); card.appendChild(body);
    container.appendChild(card);

    const reader=new FileReader();
    reader.onload = e=>{
      if (file.type==='application/pdf'){
        emb.style.display='block'; emb.src=e.target.result;
        btnRotateL.style.display='none'; btnRotateR.style.display='none'; btnReset.style.display='none';
        filesState.push({id,file,type:'pdf',cropper:null,el:card});
      } else if (file.type.startsWith('image/')){
        img.style.display='block'; img.src=e.target.result;
        const cropper = new Cropper(img,{
          viewMode:1, dragMode:'move', autoCropArea:1,
          movable:true, zoomable:true, rotatable:true,
          background:false, responsive:true
        });
        filesState.push({id,file,type:'image',cropper,el:card});
      } else {
        alert('Solo imágenes o PDF.'); card.remove();
      }
      updateHiddenOrder();
    };
    reader.readAsDataURL(file);
  }

  function btn(text, icon){
    const b=document.createElement('button');
    b.type='button'; b.className='btn btn-default btn-mini';
    b.innerHTML = `<i class="${icon}"></i> ${text}`;
    return b;
  }
  function getCropper(id){ const it=filesState.find(x=>x.id===id); return it&&it.cropper?it.cropper:null; }
  function removeCard(id){
    const idx=filesState.findIndex(x=>x.id===id);
    if (idx>=0){
      if (filesState[idx].cropper){ filesState[idx].cropper.destroy(); }
      filesState[idx].el.remove(); filesState.splice(idx,1); updateHiddenOrder();
    }
  }
  function updateHiddenOrder(){
    const order = Array.from(container.children).map(ch=>ch.dataset.id);
    const indices = order.map(id=>filesState.findIndex(x=>x.id===id));
    document.getElementById('file_order').value = JSON.stringify(indices);
  }

  // === ÚNICO submit handler (respetamos tu lógica + mostramos overlay) ===
  document.getElementById('formIncapacidad').addEventListener('submit', function(){
    // 0) Habilitar campos deshabilitados para que viajen al POST
    var fd = document.getElementById('fecha_documento');
    var fi = document.getElementById('imagen1');
    if (fd) fd.disabled = false;
    if (fi) fi.disabled = false;

    // 1) Respetar orden y recortes ANTES de enviar (tu lógica)
    const orderIdx = JSON.parse(document.getElementById('file_order').value || '[]');
    const cropList=[]; const dt=new DataTransfer();
    const items = (orderIdx.length>0? orderIdx.map(i=>filesState[i]) : filesState);

    for(const item of items){
      if(!item) continue;
      dt.items.add(item.file);
      if(item.type==='image' && item.cropper){
        const d=item.cropper.getData(true);
        cropList.push({
          unit:'px',
          x:Math.max(0,Math.round(d.x||0)),
          y:Math.max(0,Math.round(d.y||0)),
          width: Math.max(1,Math.round(d.width||0)),
          height:Math.max(1,Math.round(d.height||0)),
          rotate: Math.round(d.rotate||0)
        });
      } else { cropList.push(null); }
    }
    if (fi) fi.files = dt.files;
    document.getElementById('crop_json_list').value = JSON.stringify(cropList);

    // 2) Mostrar overlay con barra y lista de archivos (sin cancelar)
    try{
      const listEl = document.getElementById('upList');
      const f = fi?.files || [];
      if (f.length){
        let html = '';
        for (let i=0;i<f.length;i++){
          html += `<small>${i+1}. ${escapeHtml(f[i].name)} (${Math.round(f[i].size/1024)} KB)</small>`;
        }
        listEl.innerHTML = html;
      } else {
        listEl.innerHTML = '<small>Sin archivos adjuntos.</small>';
      }
      startFakeProgress();
      document.getElementById('uploadOverlay').style.display = 'block';
    }catch(_){}
    // *** NO hacemos preventDefault: dejamos que se envíe normal. ***
  });

  function escapeHtml(s){return (s||'').replace(/[&<>"']/g,m=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m]));}

  // Progreso semi-realista (feedback suficiente en móvil/conexiones lentas)
  function startFakeProgress(){
    const bar = document.getElementById('upBar');
    const pct = document.getElementById('upPercent');
    let p = 0;
    const f = document.getElementById('imagen1')?.files || [];
    let total = 0; for (let i=0;i<f.length;i++) total += f[i].size;
    const totalMB = total/1024/1024;
    const est = Math.min(60, Math.max(8, Math.round(totalMB*1.2)+6)); // 8..60s aprox

    const iv = setInterval(()=>{
      if (p < 95){
        p += Math.max(1, Math.round(100/est/2));
        if (p>95) p = 95;
        bar.style.width = p + '%';
        pct.textContent = p + '%';
      } else {
        clearInterval(iv);
      }
    }, 250);
  }
</script>

<script>
// === Formateo helper ===
function fmt2(n){ n = Number(n); return (isFinite(n)? n.toFixed(2) : '0.00'); }

// === Refresca panel de incapacidad con el valor (dias/35) que ya calculas ===
function actualizarPanelIncapacidad(incapidadFrac){
  var add = Number(incapidadFrac) || 0;

  // Tomamos el <span id="diasIncapacidad"> que ya está dentro del <li>Días de incapacidades: ...</li>
  var elIncap = document.getElementById('diasIncapacidad');
  var elTotal = document.getElementById('totalDias');

  // Lee la base EXACTA (con todos los decimales) desde data-base (no redondeamos)
  var baseRaw = elIncap?.dataset.base;               // ej. "0.666667"
  var baseNum = parseFloat(baseRaw) || 0;

  // Otras bases para el total disponible
  var diasVac   = parseFloat(document.getElementById('diasVacaciones')?.dataset.base) || 0;
  var diasExtra = parseFloat(document.getElementById('diasExtra')?.dataset.base) || 0;
  var diasUsed  = parseFloat(document.getElementById('diasSolicitados')?.dataset.base) || 0;

  // 1) SOLO números dentro del span (el rótulo ya está fuera)
  if (elIncap){
    elIncap.innerHTML =
      (baseRaw ?? baseNum.toString()) +
      ' <span style="color:green;font-weight:600;">+ ' + (Number.isFinite(add) ? add.toFixed(2) : '0.00') + '</span>';
  }

  // 2) Total disponible = (vac + extra − incap_base − usados) − add
  var baseDisp  = diasVac + diasExtra - baseNum - diasUsed;
  var finalDisp = baseDisp - add;

  if (elTotal){
    elTotal.innerHTML =
      baseDisp.toFixed(2) +
      ' <span style="color:red;font-weight:600;">- ' + (Number.isFinite(add) ? add.toFixed(2) : '0.00') + '</span>' +
      ' = <span style="font-weight:700;color:#000;">' + finalDisp.toFixed(2) + '</span>';
  }
}

// Sincroniza el panel con tu cálculo existente (resultado_div_35 / cantidad_dias)
(function(){
  var elDesde = document.getElementById('desde');
  var elHasta = document.getElementById('hasta');
  var elFrac  = document.getElementById('resultado_div_35');
  var elCant  = document.getElementById('cantidad_dias');

  if (!elFrac || !elCant) return;

  function syncFromResultado(){
    var v = parseFloat(elFrac.value);
    if (!isFinite(v) || v < 0) v = 0;
    actualizarPanelIncapacidad(v);
  }

  elDesde?.addEventListener('change', syncFromResultado);
  elHasta?.addEventListener('change', syncFromResultado);

  elCant.addEventListener('input', function(){
    var v = parseFloat(this.value);
    if (!isFinite(v) || v < 0) v = 0;
    actualizarPanelIncapacidad(v);
  });

  document.addEventListener('DOMContentLoaded', function(){
    var v = parseFloat(elFrac.value);
    if (!isFinite(v) || v < 0) v = 0;
    actualizarPanelIncapacidad(v);
  });

  const _ajaxSuccess = function(){
    setTimeout(()=> {
      var v = parseFloat(elFrac.value);
      if (!isFinite(v) || v < 0) v = 0;
      actualizarPanelIncapacidad(v);
    }, 0);
  };
  window._ajaxSuccessIncap = _ajaxSuccess;
})();
</script>

<?php
    include "view/footer.html";

  } else {
    include "view/headeradmin.html"; ?>
    <div class="box">
      <div class="box-header with-border"><h3>Crear producto:------------------------------------------------> (Con Seriales)</h3></div>
      <div class="box-body"><p>Iniciar sesión como usuario normal para ver la versión completa.</p></div>
    </div>
    <?php include "view/footer.html"; }
} else {
  header("Location:index.html");
}
