<?php
require_once __DIR__.'/db.php';

function sector_meta($con, $sector_id){
  $out = [
    'sector_id'=>(int)$sector_id,
    'codigo'=>null, 'nombre'=>null, 'edificio'=>null, 'nivel'=>null,
    'ancho_m'=>null, 'largo_m'=>null, 'alto_m'=>null,
    'acometidas'=>[]
  ];
  // Intento genérico (ajusta nombres reales de columnas/tabla)
  $rs = @mysqli_query($con, "SELECT id, codigo, nombre, edificio, nivel, ancho_m, largo_m, alto_m FROM sector WHERE id=".(int)$sector_id." LIMIT 1");
  if ($rs && ($r=mysqli_fetch_assoc($rs))) {
    $out['codigo'] = $r['codigo'] ?? null;
    $out['nombre'] = $r['nombre'] ?? null;
    $out['edificio'] = $r['edificio'] ?? null;
    $out['nivel'] = $r['nivel'] ?? null;
    $out['ancho_m'] = $r['ancho_m'] ?? null;
    $out['largo_m'] = $r['largo_m'] ?? null;
    $out['alto_m'] = $r['alto_m'] ?? null;
  }
  // Acometidas del sector (ajusta a tu tabla real)
  $rs2 = @mysqli_query($con, "SELECT a.codigo AS acometida FROM sector_acometida sa JOIN acometida a ON a.id=sa.acometida_id WHERE sa.sector_id=".(int)$sector_id);
  if ($rs2) {
    while($x=mysqli_fetch_assoc($rs2)){
      $out['acometidas'][] = $x['acometida'];
    }
  }
  return $out;
}

function circuits_by_sector($con, $sector_id){
  $out = [];
  // Intento genérico (ajusta los nombres reales):
  $sql = "SELECT c.id, c.codigo AS circuito, t.id AS tablero_id, t.codigo AS tablero
          FROM sector_circuito sc
          JOIN circuito c ON c.id=sc.circuito_id
          JOIN tablero t ON t.id=c.tablero_id
          WHERE sc.sector_id=".(int)$sector_id."
          ORDER BY t.codigo, c.codigo";
  $rs = @mysqli_query($con, $sql);
  if ($rs) {
    while($r=mysqli_fetch_assoc($rs)){
      $out[] = [
        'id'=>(int)$r['id'],
        'circuito'=>$r['circuito'],
        'tablero_id'=>(int)$r['tablero_id'],
        'tablero'=>$r['tablero']
      ];
    }
  }
  return $out;
}
?>
