<?php
// /includes/i18n.php   Capa i18n simple (ES/EN) con sesin
// Requiere PHP 8.1+, UTF-8

if (session_status() !== PHP_SESSION_ACTIVE) {
  session_start();
}

const I18N_DEFAULT = 'es';
const I18N_SUPPORTED = ['es','en'];

// 1) Determina idioma: ?lang=xx  SESSION  por defecto
$reqLang = isset($_GET['lang']) ? strtolower(trim($_GET['lang'])) : '';
if ($reqLang !== '' && in_array($reqLang, I18N_SUPPORTED, true)) {
  $_SESSION['lang'] = $reqLang;
}
$lang = $_SESSION['lang'] ?? I18N_DEFAULT;
if (!in_array($lang, I18N_SUPPORTED, true)) {
  $lang = I18N_DEFAULT;
  $_SESSION['lang'] = $lang;
}

// 2) Carga diccionario
$__T = [];
$dictFile = __DIR__ . "/lang/{$lang}.php";
if (is_file($dictFile)) {
  /** @var array $__T */
  $__T = require $dictFile;
}
if (!is_array($__T)) { $__T = []; }

/**
 * T  Traduce una clave. Si no existe, devuelve la clave tal cual.
 * Soporta reemplazos estilo sprintf: T('Hello %s', $name)
 */
function T(string $key, mixed ...$args): string {
  global $__T;
  $msg = $__T[$key] ?? $key;
  if ($args) {
    // sprintf seguro: si falla, retorna el mensaje base
    try { $msg = vsprintf($msg, $args); } catch (Throwable) {}
  }
  return $msg;
}

/**
 * i18n_lang  idioma actual (es|en)
 */
function i18n_lang(): string {
  return $_SESSION['lang'] ?? I18N_DEFAULT;
}

/**
 * i18n_url  devuelve la URL actual con ?lang=xx (preservando otros parmetros)
 * Uso: <a href="<?= i18n_url('es') ?>">...</a>
 */
function i18n_url(string $toLang, ?string $url = null): string {
  if (!in_array($toLang, I18N_SUPPORTED, true)) $toLang = I18N_DEFAULT;

  // URL base: actual
  if ($url === null) {
    $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host   = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $path   = $_SERVER['REQUEST_URI'] ?? '/';
    $url    = $scheme . '://' . $host . $path;
  }

  // Partir en base + query
  $parts = parse_url($url);
  $base  = ($parts['scheme'] ?? '') . '://' . ($parts['host'] ?? '') . (($parts['port'] ?? '') ? ':' . $parts['port'] : '') . ($parts['path'] ?? '');
  $q     = [];
  if (!empty($parts['query'])) {
    parse_str($parts['query'], $q);
  }
  $q['lang'] = $toLang; // set/replace

  return $base . '?' . http_build_query($q);
}
