<?php
if (session_status() !== PHP_SESSION_ACTIVE) session_start();
if (isset($_GET['lang'])) {
  $lang = strtolower($_GET['lang']) === 'en' ? 'en' : 'es';
  $_SESSION['lang'] = $lang;
  setcookie('lang', $lang, time()+60*60*24*30, '/');
  $url = strtok($_SERVER['REQUEST_URI'], '?');
  header("Location: $url"); exit;
}
$lang = $_SESSION['lang'] ?? ($_COOKIE['lang'] ?? (substr($_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? 'es', 0, 2)));
$lang = ($lang === 'en') ? 'en' : 'es';
$_SESSION['lang'] = $lang;
$TR = [
  'es' => ['language'=>'Idioma','spanish'=>'Español','english'=>'Inglés'],
  'en' => ['language'=>'Language','spanish'=>'Spanish','english'=>'English'],
];
function __(string $key, array $replace = []) : string {
  $lang = $_SESSION['lang'] ?? 'es';
  global $TR;
  $txt = $TR[$lang][$key] ?? $key;
  foreach ($replace as $k=>$v) $txt = str_replace('{'.$k.'}', $v, $txt);
  return $txt;
}
