<?php
// rrhh_home/gestores_planilla.php
// CRUD simple: listar/activar/desactivar/eliminar gestores de planilla
// PHP 8.1.33 – UTF-8

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) { header("Location:index.html"); exit; }
$ES_SUPER = isset($_SESSION["superadmin"]) && $_SESSION["superadmin"] === "S";

require_once __DIR__ . '/dbcon.php';
mysqli_set_charset($con,'utf8mb4');

$uid = (int)($_SESSION['idusuario'] ?? 0);

// acciones rápidas
$act = $_GET['act'] ?? '';
$id  = (int)($_GET['id'] ?? 0);

if ($act && $id > 0) {
  if ($act === 'toggle') {
    $to = (int)($_GET['to'] ?? 0);
    if ($st = mysqli_prepare($con, "UPDATE planilla_gestores SET activo=?, actualizado_en=NOW() WHERE id=?")) {
      mysqli_stmt_bind_param($st,'ii',$to,$id);
      mysqli_stmt_execute($st);
      mysqli_stmt_close($st);
    }
    header('Location: gestores_planilla.php'); exit;
  }
  if ($act === 'delete') {
    if ($st = mysqli_prepare($con, "UPDATE planilla_gestores SET is_deleted=1, actualizado_en=NOW() WHERE id=?")) {
      mysqli_stmt_bind_param($st,'i',$id);
      mysqli_stmt_execute($st);
      mysqli_stmt_close($st);
    }
    header('Location: gestores_planilla.php'); exit;
  }
}

// listado
$rows = [];
$q = "SELECT g.id, g.nombre, g.username, g.activo, g.creado_en, e.nombre_completo, e.cedula, e.categoria
      FROM planilla_gestores g
      INNER JOIN empleados_planilla e ON e.id = g.idempleado
      WHERE g.is_deleted=0
      ORDER BY g.activo DESC, g.nombre ASC";
if ($rs = mysqli_query($con, $q)) {
  while ($r = mysqli_fetch_assoc($rs)) $rows[] = $r;
  mysqli_free_result($rs);
}

// Header
if(!$ES_SUPER) include __DIR__.'/view/header.php';
else           include __DIR__.'/view/headeradmin.html';
?>
<script>
  $('#payroll_control').addClass("treeview active");
</script>

<div class="box">
  <div class="box-header with-border">
    <h3>Gestores Planilla (Asistencia)</h3>
    <div class="box-tools pull-right">
      <a class="btn btn-success btn-sm" href="gestor_planilla_form.php"><i class="fa fa-plus"></i> Nuevo gestor</a>
    </div>
  </div>
  <div class="box-body">
    <p class="text-muted">Estos usuarios SOLO podrán entrar a <code>/asistencia/login.php</code> para escanear QR (no al panel admin).</p>

    <div class="table-responsive">
      <table class="table table-bordered table-hover">
        <thead>
          <tr>
            <th>#</th>
            <th>Gestor</th>
            <th>Usuario</th>
            <th>Empleado</th>
            <th>Cédula</th>
            <th>Categoría</th>
            <th>Estado</th>
            <th>Creado</th>
            <th style="width:220px">Acciones</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?= (int)$r['id'] ?></td>
            <td><?= htmlspecialchars($r['nombre']) ?></td>
            <td><code><?= htmlspecialchars($r['username']) ?></code></td>
            <td><?= htmlspecialchars($r['nombre_completo']) ?></td>
            <td><?= htmlspecialchars($r['cedula']) ?></td>
            <td><?= htmlspecialchars($r['categoria']) ?></td>
            <td>
              <?php if((int)$r['activo']===1): ?>
                <span class="label label-success">Activo</span>
              <?php else: ?>
                <span class="label label-default">Inactivo</span>
              <?php endif; ?>
            </td>
            <td><?= htmlspecialchars($r['creado_en']) ?></td>
            <td>
              <a class="btn btn-primary btn-xs" href="gestor_planilla_form.php?id=<?= (int)$r['id'] ?>"><i class="fa fa-pencil"></i> Editar</a>
              <?php if((int)$r['activo']===1): ?>
                <a class="btn btn-warning btn-xs" href="gestores_planilla.php?act=toggle&id=<?= (int)$r['id'] ?>&to=0"
                   onclick="return confirm('¿Desactivar este gestor?')">Desactivar</a>
              <?php else: ?>
                <a class="btn btn-success btn-xs" href="gestores_planilla.php?act=toggle&id=<?= (int)$r['id'] ?>&to=1"
                   onclick="return confirm('¿Activar este gestor?')">Activar</a>
              <?php endif; ?>
              <a class="btn btn-danger btn-xs" href="gestores_planilla.php?act=delete&id=<?= (int)$r['id'] ?>"
                 onclick="return confirm('¿Eliminar (soft delete) este gestor?')"><i class="fa fa-trash"></i></a>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$rows): ?>
          <tr><td colspan="9" class="text-muted">Sin gestores aún.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>

    <hr>
    <div class="text-muted">
      Accesos:
      <ul>
        <li>Pantalla pública QR: <code>/rrhh_home/asistencia/qr_public.php</code></li>
        <li>Gestor login: <code>/rrhh_home/asistencia/login.php</code></li>
        <li>Gestor scan: <code>/rrhh_home/asistencia/scan.php</code></li>
      </ul>
    </div>
  </div>
</div>

<?php include __DIR__.'/view/footer.html'; ?>
