<?php
// rrhh_home/gestor_planilla_form.php
// Form crear/editar gestores
// PHP 8.1.33 – UTF-8

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) { header("Location:index.html"); exit; }
$ES_SUPER = isset($_SESSION["superadmin"]) && $_SESSION["superadmin"] === "S";

require_once __DIR__ . '/dbcon.php';
mysqli_set_charset($con,'utf8mb4');

$id = (int)($_GET['id'] ?? 0);
$msg = '';
$err = '';

$empleados = [];
$q = "SELECT id, nombre_completo, cedula, categoria FROM empleados_planilla ORDER BY nombre_completo ASC";
if ($rs=mysqli_query($con,$q)) { while($r=mysqli_fetch_assoc($rs)) $empleados[]=$r; mysqli_free_result($rs); }

$row = [
  'idempleado' => 0,
  'nombre' => '',
  'username' => '',
  'activo' => 1
];

if ($id>0) {
  $q = "SELECT idempleado,nombre,username,activo FROM planilla_gestores WHERE id=? AND is_deleted=0 LIMIT 1";
  if ($st=mysqli_prepare($con,$q)) {
    mysqli_stmt_bind_param($st,'i',$id);
    mysqli_stmt_execute($st);
    $rs=mysqli_stmt_get_result($st);
    if ($rs && ($r=mysqli_fetch_assoc($rs))) $row = $r + $row;
    mysqli_stmt_close($st);
  }
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $idempleado = (int)($_POST['idempleado'] ?? 0);
  $nombre     = trim((string)($_POST['nombre'] ?? ''));
  $username   = trim((string)($_POST['username'] ?? ''));
  $activo     = (int)($_POST['activo'] ?? 1);
  $pass1      = (string)($_POST['pass1'] ?? '');
  $pass2      = (string)($_POST['pass2'] ?? '');

  if ($idempleado<=0) $err = 'Seleccione un empleado.';
  elseif ($nombre==='') $err = 'Nombre requerido.';
  elseif ($username==='') $err = 'Usuario requerido.';
  elseif ($id===0 && ($pass1==='' || $pass2==='')) $err = 'Clave requerida para crear.';
  elseif ($pass1!=='' && $pass1!==$pass2) $err = 'Las claves no coinciden.';

  if (!$err) {
    $pass_hash = null;
    if ($pass1!=='') $pass_hash = password_hash($pass1, PASSWORD_DEFAULT);

    if ($id>0) {
      if ($pass_hash) {
        $q = "UPDATE planilla_gestores SET idempleado=?, nombre=?, username=?, pass_hash=?, activo=?, actualizado_en=NOW() WHERE id=?";
        $st = mysqli_prepare($con,$q);
        mysqli_stmt_bind_param($st,'isssii', $idempleado,$nombre,$username,$pass_hash,$activo,$id);
      } else {
        $q = "UPDATE planilla_gestores SET idempleado=?, nombre=?, username=?, activo=?, actualizado_en=NOW() WHERE id=?";
        $st = mysqli_prepare($con,$q);
        mysqli_stmt_bind_param($st,'issii', $idempleado,$nombre,$username,$activo,$id);
      }
      if ($st) {
        if (!mysqli_stmt_execute($st)) $err = 'Error al guardar: '.mysqli_error($con);
        mysqli_stmt_close($st);
      } else {
        $err = 'Error prepare: '.mysqli_error($con);
      }
      if (!$err) { header('Location: gestores_planilla.php'); exit; }
    } else {
      $q = "INSERT INTO planilla_gestores (idempleado, username, pass_hash, nombre, activo, creado_por)
            VALUES (?,?,?,?,?,?)";
      if ($st = mysqli_prepare($con,$q)) {
        $uid = (int)($_SESSION['idusuario'] ?? 0);
        mysqli_stmt_bind_param($st,'isssii', $idempleado,$username,$pass_hash,$nombre,$activo,$uid);
        if (!mysqli_stmt_execute($st)) $err = 'Error al crear: '.mysqli_error($con);
        mysqli_stmt_close($st);
      } else {
        $err = 'Error prepare: '.mysqli_error($con);
      }
      if (!$err) { header('Location: gestores_planilla.php'); exit; }
    }
  }

  $row = ['idempleado'=>$idempleado,'nombre'=>$nombre,'username'=>$username,'activo'=>$activo];
}

// Header
if(!$ES_SUPER) include __DIR__.'/view/header.php';
else           include __DIR__.'/view/headeradmin.html';
?>
<script>
  $('#payroll_control').addClass("treeview active");
</script>

<div class="box">
  <div class="box-header with-border">
    <h3><?= $id>0 ? 'Editar gestor' : 'Nuevo gestor' ?></h3>
  </div>
  <div class="box-body">
    <?php if($err): ?><div class="alert alert-danger"><?= htmlspecialchars($err) ?></div><?php endif; ?>

    <form method="post">
      <div class="row">
        <div class="col-md-6">
          <div class="form-group">
            <label>Empleado</label>
            <select class="form-control" name="idempleado" required>
              <option value="">-- Seleccione --</option>
              <?php foreach($empleados as $e): ?>
                <option value="<?= (int)$e['id'] ?>" <?= ((int)$row['idempleado']===(int)$e['id'])?'selected':'' ?>>
                  <?= htmlspecialchars($e['nombre_completo']) ?> - <?= htmlspecialchars($e['cedula']) ?> (<?= htmlspecialchars($e['categoria']) ?>)
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="form-group">
            <label>Nombre (mostrar)</label>
            <input class="form-control" name="nombre" value="<?= htmlspecialchars((string)$row['nombre']) ?>" required>
          </div>

          <div class="form-group">
            <label>Usuario</label>
            <input class="form-control" name="username" value="<?= htmlspecialchars((string)$row['username']) ?>" required>
          </div>

          <div class="form-group">
            <label>Estado</label>
            <select class="form-control" name="activo">
              <option value="1" <?= ((int)$row['activo']===1)?'selected':'' ?>>Activo</option>
              <option value="0" <?= ((int)$row['activo']===0)?'selected':'' ?>>Inactivo</option>
            </select>
          </div>
        </div>

        <div class="col-md-6">
          <div class="alert alert-info">
            <b>Clave:</b> <?= $id>0 ? 'Solo llena si deseas cambiarla.' : 'Requerida para crear.' ?>
          </div>
          <div class="form-group">
            <label>Nueva clave</label>
            <input class="form-control" type="password" name="pass1" autocomplete="new-password">
          </div>
          <div class="form-group">
            <label>Confirmar clave</label>
            <input class="form-control" type="password" name="pass2" autocomplete="new-password">
          </div>

          <div class="alert alert-warning">
            Acceso del gestor: <code>/rrhh_home/asistencia/login.php</code>
          </div>
        </div>
      </div>

      <hr>
      <a class="btn btn-default" href="gestores_planilla.php">Volver</a>
      <button class="btn btn-primary"><?= $id>0?'Guardar cambios':'Crear gestor' ?></button>
    </form>
  </div>
</div>

<?php include __DIR__.'/view/footer.html'; ?>
