<?php
// public_html/colegio/colegio10/rrhh_home/formulario_vacaciones_pdf.php
// PHP 8.1+ – Dompdf con imágenes remotas, QR con phpqrcode (base64 embebido)

if (session_status() === PHP_SESSION_NONE) session_start();
date_default_timezone_set('America/Costa_Rica');

/* ===== DB ===== */
require_once __DIR__ . '/dbcon.php';
if (!isset($con) || !($con instanceof mysqli)) { http_response_code(500); exit('No hay conexión DB'); }
mysqli_set_charset($con, 'utf8mb4');

/* ===== QR library ===== */
require_once __DIR__ . '/phpqrcode/phpqrcode.php'; // ← tu ruta

/* ===== Debug opcional ===== */
$debug = isset($_GET['debug']) && $_GET['debug'] === '1';
ini_set('display_errors', $debug ? '1' : '0');
error_reporting($debug ? E_ALL : 0); // <-- corregido: E_ALL

/* ===== Entrada ===== */
$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) { http_response_code(400); exit('ID inválido.'); }

/* (Opcional) host canónico */
$canonical_host = 'jportales.com';
$current_host = $_SERVER['HTTP_HOST'] ?? '';
if (strcasecmp($current_host, $canonical_host) !== 0) {
  $qs = []; $qs[] = 'id='.$id;
  if (isset($_GET['download'])) $qs[] = 'download=1';
  if (isset($_GET['preview']))  $qs[] = 'preview=1';
  if ($debug)                   $qs[] = 'debug=1';
  header('Location: https://'.$canonical_host.'/colegio/colegio10/rrhh_home/formulario_vacaciones_pdf.php?'.implode('&',$qs), true, 301);
  exit;
}

/* ===== Dompdf ===== */
require_once __DIR__ . '/dompdf/autoload.inc.php';
use Dompdf\Dompdf;
use Dompdf\Options;

/* ===== Config logos (remotos) ===== */
$LOGO_BASE = 'https://hr.jportales.com/Files/';
$logo_izq_url = $LOGO_BASE . 'Logo.jpg';
$logo_der_url = $LOGO_BASE . 'Logo_internacional.png';

/* ===== Helpers ===== */
function safe($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

/* ===== Datos del formulario ===== */
$st = $con->prepare("SELECT id, fecha_documento, nombre_completo, categoria, fecha_desde, fecha_hasta, motivo,
                            cantidad_dias, tipo_ausencia, feriados_conteo, feriados_json
                     FROM formulario_vacaciones WHERE id=? LIMIT 1");
$st->bind_param('i', $id);
$st->execute();
$rs = $st->get_result();
if (!$rs || $rs->num_rows === 0) { http_response_code(404); exit('Registro no encontrado.'); }
$row = $rs->fetch_assoc();
$st->close();

/* nombre_completo = ID empleado */
$empleado_id = (int)($row['nombre_completo'] ?? 0);
$empleado_nombre = '';
$st2 = $con->prepare("SELECT nombre_completo FROM empleados_planilla WHERE id=? LIMIT 1");
if ($st2) {
  $st2->bind_param('i', $empleado_id);
  $st2->execute();
  $r2 = $st2->get_result();
  if ($r2 && $r2->num_rows > 0) { $emp = $r2->fetch_assoc(); $empleado_nombre = (string)($emp['nombre_completo'] ?? ''); }
  $st2->close();
}

/* ingreso_vacaciones relacionado (opcional) */
$ingreso_id = null;
$stIng = $con->prepare("SELECT id FROM ingreso_vacaciones
                        WHERE idempleado=? AND fecha_documento=? AND fecha_desde=? AND fecha_hasta=?
                        ORDER BY id DESC LIMIT 1");
if ($stIng) {
  $stIng->bind_param('isss', $empleado_id, $row['fecha_documento'], $row['fecha_desde'], $row['fecha_hasta']);
  $stIng->execute();
  $rIng = $stIng->get_result();
  if ($rIng && $rIng->num_rows > 0) { $ri = $rIng->fetch_assoc(); $ingreso_id = (int)$ri['id']; }
  $stIng->close();
}

/* feriados únicos (chips) */
$feriados_unicos = [];
$fer_json = (string)($row['feriados_json'] ?? '');
if ($fer_json !== '') {
  $tmp = json_decode($fer_json, true);
  if (is_array($tmp)) {
    foreach ($tmp as $f) { $f = trim((string)$f); if (preg_match('/^\d{4}-\d{2}-\d{2}$/', $f)) $feriados_unicos[$f] = true; }
  }
}
$feriados_cnt = count($feriados_unicos);

/* ===== QR (phpqrcode → PNG en memoria → base64) ===== */
$code_val   = $ingreso_id ?: (int)$row['id'];
$qr_payload = 'https://hr.jportales.com/scan_vacacion.php?id=' . $code_val;

ob_start();
QRcode::png($qr_payload, null, QR_ECLEVEL_L, 6, 2); // tamaño≈140px con margen
$qr_png = ob_get_clean();
$qr_base64 = 'data:image/png;base64,'.base64_encode($qr_png);

/* ===== HTML (replica del “Imprimir”) ===== */
ob_start(); ?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>Impresión - Solicitud de ausencia #<?php echo (int)$row['id']; ?></title>
<style>
  @page { size: A4; margin: 12mm 10mm; }
  *{ box-sizing:border-box; }
  body{ font-family: Arial, Helvetica, sans-serif; color:#111827; margin:0; background:#fff; font-size:12px; }
  .sheet{ width:100%; }
  .header{ display: table; width:100%; }
  .logo{ width:90px; height:auto; }
  .title{ text-align:center; display: table-cell; vertical-align:middle; }
  .title h1{ font-size:18px; margin:0 0 4px; }
  .sub{ color:#6b7280; font-size:12px; }
  .line{ height:1px; background:#d1d5db; margin:12px 0 16px; }

  .grid2{ width:100%; border-collapse:separate; border-spacing:10px 10px; }
  .cell{ width:50%; vertical-align:top; }
  .field{ border:1px solid #d1d5db; border-radius:8px; padding:10px; }
  .label{ font-size:12px; color:#374151; margin-bottom:4px; }
  .value{ font-size:14px; }

  .section-title{ font-weight:bold; margin:18px 0 8px; font-size:14px; }
  .chip{ display:inline-block; border:1px solid #d1d5db; border-radius:999px; padding:5px 10px; font-size:12px; background:#f8fafc; margin:0 6px 6px 0; }
  .muted{ color:#6b7280; font-size:12px; }
  .readonly{ width:100%; border:1px solid #d1d5db; border-radius:8px; padding:10px; font-size:13px; min-height:90px; background:#fbfbfb; }

  /* Firmas */
  .sign-wrap{ margin-top:20px; width:100%; border-collapse:separate; border-spacing:30px 0; }
  .sign-td{ width:50%; vertical-align:top; }
  .sig-label{ color:#6b7280; font-size:12px; text-align:left; margin-bottom:8px; }
  .sig-line{ border-top:1px solid #111; height:0; width:200px; margin:10px 0 5px; }
  .sig-date{ color:#6b7280; font-size:12px; }
  .date-blank{ display:inline-block; min-width:100px; height:14px; border-bottom:1px solid #111; }

  /* Footer con QR a la derecha como en imprimir */
  .footer-table{ width:100%; margin-top:22px; border-collapse:collapse; }
  .ft-left{ width:65%; font-size:11px; color:#374151; line-height:1.35; vertical-align:bottom; }
  .ft-right{ width:35%; text-align:right; vertical-align:bottom; }
  .qr-box{ display:inline-block; text-align:center; }
  .qr-img{ width:140px; height:140px; border:1px solid #e5e7eb; border-radius:6px; background:#fff; }
  .qr-caption{ font-size:11px; color:#374151; margin-top:6px; }
</style>
</head>
<body>
  <div class="sheet">
    <div class="header">
      <table style="width:100%; border-collapse:collapse;">
        <tr>
          <td style="width:100px;"><img class="logo" src="<?php echo safe($logo_izq_url); ?>" alt="Logo izquierda"></td>
          <td class="title">
            <h1>Time off request form · Formulario de solicitud de ausencia</h1>
            <div class="sub">Colegio Británico de Costa Rica · Recursos Humanos</div>
          </td>
          <td style="width:100px; text-align:right;"><img class="logo" src="<?php echo safe($logo_der_url); ?>" alt="Logo derecha"></td>
        </tr>
      </table>
    </div>

    <div class="line"></div>

    <table class="grid2">
      <tr>
        <td class="cell">
          <div class="field">
            <div class="label">Empleado / Employee</div>
            <div class="value"><?php echo safe($empleado_nombre); ?></div>
          </div>
        </td>
        <td class="cell">
          <div class="field">
            <div class="label">Position / Categoría</div>
            <div class="value"><?php echo safe((string)$row['categoria']); ?></div>
          </div>
        </td>
      </tr>
      <tr>
        <td class="cell">
          <div class="field">
            <div class="label">Fecha del documento</div>
            <div class="value"><?php echo safe((string)$row['fecha_documento']); ?></div>
          </div>
        </td>
        <td class="cell">
          <div class="field">
            <div class="label">¿Cómo desea esta ausencia?</div>
            <div class="value"><?php echo safe((string)$row['tipo_ausencia']); ?></div>
          </div>
        </td>
      </tr>
      <tr>
        <td class="cell">
          <div class="field">
            <div class="label">Desde</div>
            <div class="value"><?php echo safe((string)$row['fecha_desde']); ?></div>
          </div>
        </td>
        <td class="cell">
          <div class="field">
            <div class="label">Hasta (incluyendo)</div>
            <div class="value"><?php echo safe((string)$row['fecha_hasta']); ?></div>
          </div>
        </td>
      </tr>
    </table>

    <div class="section-title">Días feriados seleccionados</div>
    <?php if ($feriados_cnt > 0): ?>
      <?php foreach(array_keys($feriados_unicos) as $f): ?><span class="chip"><?php echo safe($f); ?></span><?php endforeach; ?>
    <?php else: ?>
      <div class="muted">No se seleccionaron feriados.</div>
    <?php endif; ?>

    <div class="section-title">Comentarios</div>
    <div class="readonly"><?php echo nl2br(safe((string)($row['motivo'] ?? ''))); ?></div>

    <!-- Firmas (igual a imprimir) -->
    <table class="sign-wrap">
      <tr>
        <td class="sign-td">
          <div class="sig-label">Firma del colaborador / Employee signature</div>
          <div class="sig-line"></div>
          <div class="sig-date">Fecha / Date: <span class="date-blank"></span></div>
        </td>
        <td class="sign-td">
          <div class="sig-label">Autorización Recursos Humanos / HR authorization</div>
          <div class="sig-line"></div>
          <div class="sig-date">Fecha / Date: <span class="date-blank"></span></div>
        </td>
      </tr>
    </table>

    <!-- Footer (izquierda texto, derecha QR) -->
    <table class="footer-table">
      <tr>
        <td class="ft-left">
          <strong>P.O. BOX 8184 – 1000 San José, Costa Rica</strong><br>
          Phone: 2220-0131 / 2220-0719 &nbsp;&nbsp; Fax: 2232-7833<br>
          E-mail: brit.sch.cr@gmail.com
        </td>
        <td class="ft-right">
          <div class="qr-box">
            <img class="qr-img" src="<?php echo $qr_base64; ?>" alt="QR Code">
            <div class="qr-caption">Leave Entry ID: <strong>#<?php echo (int)$code_val; ?></strong></div>
          </div>
        </td>
      </tr>
    </table>

  </div>
</body>
</html>
<?php
$html = ob_get_clean();

/* ===== Vista previa sin PDF ===== */
if (isset($_GET['preview']) && (int)$_GET['preview'] === 1) {
  header('Content-Type: text/html; charset=UTF-8');
  echo $html; exit;
}

/* ===== Render PDF ===== */
$options = new Options();
$options->set('isRemoteEnabled', true);
$options->set('isHtml5ParserEnabled', true);
$options->set('defaultFont', 'DejaVu Sans');

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html, 'UTF-8');
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

/* ===== Entrega ===== */
$filename = 'timeoff_request_'.((int)$row['id']).'.pdf';
$download = isset($_GET['download']) ? (int)$_GET['download'] : 0;
while (ob_get_level() > 0) { ob_end_clean(); }
$pdf_output = $dompdf->output();
header('Content-Type: application/pdf');
header('Content-Length: '.strlen($pdf_output));
header('Content-Disposition: ' . ($download ? 'attachment' : 'inline') . '; filename="'.$filename.'"');
echo $pdf_output;
exit;
