<?php
// public_html/colegio/colegio10/rrhh_home/formulario_vacaciones_imprimir.php
// PHP 8.1+ compatible

declare(strict_types=1);

if (session_status() === PHP_SESSION_NONE) session_start();

/* ===== Debug opcional (?debug=1) ===== */
$DEBUG = isset($_GET['debug']) && $_GET['debug'] === '1';
ini_set('display_errors', $DEBUG ? '1' : '0');
error_reporting($DEBUG ? E_ALL : 0);

/* ===== Zona horaria ===== */
date_default_timezone_set('America/Costa_Rica');

/* ===== Conexión ===== */
require_once __DIR__ . '/dbcon.php';
if (!isset($con) || !($con instanceof mysqli)) {
  http_response_code(500);
  exit('No hay conexión a la base de datos ($con)');
}
mysqli_set_charset($con, 'utf8mb4');

/* ===== Config: logos por URL ===== */
$LOGO_BASE = 'https://hr.jportales.com/Files/';
$logo_izq_url = $LOGO_BASE . 'Logo.jpg';
$logo_der_url = $LOGO_BASE . 'Logo_internacional.png';

/* ===== Librería PHP QR Code ===== */
require_once __DIR__ . '/phpqrcode/phpqrcode.php';

/* ===== Helpers ===== */
function safe(mixed $s): string { return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function getParam(string $name, mixed $default=null): mixed { return $_GET[$name] ?? $default; }
function parse_ymd(?string $s): ?DateTimeImmutable {
  if (!$s) return null;
  $dt = DateTimeImmutable::createFromFormat('Y-m-d', $s);
  return ($dt && $dt->format('Y-m-d') === $s) ? $dt : null;
}
function is_weekend_dt(DateTimeImmutable $dt): bool { $w = (int)$dt->format('w'); return ($w===0 || $w===6); }
function contar_rango(string $desde, string $hasta): array {
  $d1 = parse_ymd($desde); $d2 = parse_ymd($hasta);
  if (!$d1 || !$d2 || $d2 < $d1) return ['total'=>0,'weekends'=>0,'weekdays'=>0];
  $total=0; $weekends=0; $weekdays=0;
  for ($cur=$d1; $cur <= $d2; $cur=$cur->modify('+1 day')) {
    $total++; if (is_weekend_dt($cur)) $weekends++; else $weekdays++;
  }
  return ['total'=>$total,'weekends'=>$weekends,'weekdays'=>$weekdays];
}

/* ===== Navegación por defecto ===== */
$fallback_back_url = '/consulta_vacaciones.php';

/* ===== Entrada ===== */
$id = (int) getParam('id', 0);
if ($id <= 0) { http_response_code(400); exit('ID inválido.'); }

/* ===== Leer formulario ===== */
$sql = "SELECT id, fecha_documento, nombre_completo, categoria, fecha_desde, fecha_hasta, motivo,
               cantidad_dias, tipo_ausencia, feriados_conteo, feriados_json
        FROM formulario_vacaciones
        WHERE id = ? LIMIT 1";
$st = $con->prepare($sql);
if (!$st) { http_response_code(500); exit('Error preparando consulta.'); }
$st->bind_param('i', $id);
$st->execute();
$rs = $st->get_result();
if (!$rs || $rs->num_rows === 0) { http_response_code(404); exit('Registro no encontrado.'); }
$row = $rs->fetch_assoc();
$st->close();

/* nombre_completo = ID empleado */
$empleado_id = (int)($row['nombre_completo'] ?? 0);
$empleado_nombre = '';
$st2 = $con->prepare("SELECT nombre_completo FROM empleados_planilla WHERE id = ? LIMIT 1");
if ($st2) {
  $st2->bind_param('i', $empleado_id);
  $st2->execute();
  $r2 = $st2->get_result();
  if ($r2 && $r2->num_rows > 0) { $emp = $r2->fetch_assoc(); $empleado_nombre = (string)($emp['nombre_completo'] ?? ''); }
  $st2->close();
}

/* ingreso_vacaciones relacionado (opcional) */
$ingreso_id = null;
$sqlIng = "SELECT id FROM ingreso_vacaciones
           WHERE idempleado = ? AND fecha_documento = ? AND fecha_desde = ? AND fecha_hasta = ?
           ORDER BY id DESC LIMIT 1";
$stIng = $con->prepare($sqlIng);
if ($stIng) {
  $stIng->bind_param('isss', $empleado_id, $row['fecha_documento'], $row['fecha_desde'], $row['fecha_hasta']);
  $stIng->execute();
  $rIng = $stIng->get_result();
  if ($rIng && $rIng->num_rows > 0) { $ri = $rIng->fetch_assoc(); $ingreso_id = (int)$ri['id']; }
  $stIng->close();
}

/* Feriados únicos */
$feriados_unicos = [];
$feriados_json = (string)($row['feriados_json'] ?? '');
if ($feriados_json !== '') {
  $tmp = json_decode($feriados_json, true);
  if (is_array($tmp)) {
    foreach ($tmp as $f) { $f = trim((string)$f); if (preg_match('/^\d{4}-\d{2}-\d{2}$/', $f)) $feriados_unicos[$f] = true; }
  }
}
$feriados_cnt = count($feriados_unicos);

/* Cálculos */
$desde  = (string)$row['fecha_desde'];
$hasta  = (string)$row['fecha_hasta'];
$stats  = contar_rango($desde, $hasta);
$weekends = (int)$stats['weekends'];
$weekdays = (int)$stats['weekdays'];
$habiles_calculados = max(0, $weekdays - $feriados_cnt);
$habiles_guardados  = (int)($row['cantidad_dias'] ?? 0);

/* URLs absolutas para PDF (dominio fijo) */
$pdf_base = 'https://jportales.com/colegio/colegio10/rrhh_home/';
$pdf_url_view = $pdf_base.'formulario_vacaciones_pdf.php?id='.$id;
$pdf_url_dl   = $pdf_base.'formulario_vacaciones_pdf.php?id='.$id.'&download=1';

/* ====== QR code (Leave Entry ID o fallback al # de formulario) ====== */
$code_val   = $ingreso_id ?: (int)$row['id'];
$qr_payload = 'https://hr.jportales.com/scan_vacacion.php?id=' . $code_val; // URL con el ID

// 1) Intentar generar PNG con la librería PHP QR Code (servidor)
$qr_dir_abs  = __DIR__ . '/temp';
$qr_ok       = true;
if (!is_dir($qr_dir_abs)) {
  $qr_ok = @mkdir($qr_dir_abs, 0775, true);
}
$qr_file_abs = $qr_dir_abs . '/vacacion_' . $code_val . '.png';
$qr_file_url = 'temp/vacacion_' . $code_val . '.png';

if ($qr_ok) {
  // Nivel de corrección 'L', tamaño 4, margen 2
  // Guardamos a archivo para no enviar headers binarios
  @QRcode::png($qr_payload, $qr_file_abs, 'L', 4, 2);
  // Verificamos que realmente exista
  $qr_ok = is_file($qr_file_abs);
} else {
  $qr_ok = false;
}

// 2) Fallback extra (no se usa si $qr_ok): imagen de Google Charts por si acaso
$qr_url_google = 'https://chart.googleapis.com/chart?cht=qr&chs=140x140&chld=L|0&chl=' . rawurlencode($qr_payload);

/* Enlaces compartir */
$share_text = "Time off request #".$row['id'].
              " - Employee: ".$empleado_nombre."\n".
              "Dates: ".$row['fecha_desde']." to ".$row['fecha_hasta']."\n".
              "Type: ".$row['tipo_ausencia']."\n".
              "Workdays: ".$habiles_guardados."\n".
              "Leave Entry ID: ".($ingreso_id ? '#'.$ingreso_id : 'N/A')."\n".
              "PDF: ".$pdf_url_view;
$wa_link = 'https://wa.me/?text='.rawurlencode($share_text);

$email_subject = "Time off request form · Formulario de solicitud de ausencia — #".$row['id']." – ".$empleado_nombre;
$email_body    = "Hello,\n\nPlease review the following time off request (PDF link below):\n\n".
                 "• Request #: ".$row['id']."\n• Employee: ".$empleado_nombre."\n• Type: ".$row['tipo_ausencia'].
                 "\n• Dates: ".$row['fecha_desde']." to ".$row['fecha_hasta']."\n• Workdays: ".$habiles_guardados.
                 "\n• Leave Entry ID: ".($ingreso_id ? (string)$ingreso_id : 'N/A')."\n\nPDF:\n".$pdf_url_view."\n\nRegards.";
$mailto_link   = 'mailto:?subject='.rawurlencode($email_subject).'&body='.rawurlencode($email_body);

header('Content-Type: text/html; charset=UTF-8');
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>Impresión - Solicitud de ausencia #<?= (int)$row['id']; ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
  :root{ --bd:#d1d5db; --muted:#6b7280; --fg:#111827; --bd2:#d8dee4; }
  *{ box-sizing:border-box; }
  body{ font-family:Arial, Helvetica, sans-serif; color:var(--fg); margin:0; background:#fff; }

  /* ===== Topbar ===== */
  .topbar{
    position:sticky; top:0; z-index:10;
    background:#fff; border-bottom:1px solid var(--bd2);
    padding:10px 12px; display:flex; align-items:center; gap:10px; flex-wrap:wrap;
  }
  .btn{
    display:inline-flex; align-items:center; gap:8px;
    padding:10px 14px; border-radius:999px; cursor:pointer;
    font-weight:600; text-decoration:none; line-height:1;
    box-shadow:0 2px 6px rgba(0,0,0,.06);
    transition:transform .06s ease, box-shadow .2s ease, background .2s ease, color .2s ease, border-color .2s ease;
    border:1px solid #111;
  }
  .wa-btn{ background:#25D366; color:#fff; border-color:#1fb157; }
  .email-btn{ background:#0d6efd; color:#fff; border-color:#0b5ed7; }
  .pdf-btn{ background:#fff; color:#111; border-color:var(--bd2); }
  .print-btn{ background:#111; color:#fff; border-color:#111; }
  .btn:hover{ transform:translateY(-1px); box-shadow:0 6px 16px rgba(0,0,0,.12); }
  .btn:active{ transform:translateY(0); box-shadow:0 2px 6px rgba(0,0,0,.08); }
  .btn:focus{ outline:2px solid #0d6efd; outline-offset:2px; }
  .btn-label{ font-size:14px; letter-spacing:.2px; }

  /* ===== “Hoja” ===== */
  .sheet{ width:210mm; min-height:297mm; padding:18mm 16mm; margin:0 auto; display:flex; flex-direction:column; }
  .content{ flex:1; }

  .header{ display:flex; align-items:center; justify-content:space-between; }
  .logo{ width:90px; height:auto; object-fit:contain; }
  .title{ text-align:center; flex:1; }
  h1{ font-size:18px; margin:0 0 4px; }
  .sub{ color:#6b7280; font-size:12px; }

  .idbar{ display:flex; justify-content:flex-end; margin:8px 0 0; }
  .id-badge{ display:inline-flex; align-items:center; gap:6px; padding:6px 10px; border:1px solid var(--bd); border-radius:999px; background:#f8fafc; color:#111; font-size:12px; font-weight:600; }
  .id-badge .dot{ width:6px; height:6px; border-radius:50%; background:#0d6efd; display:inline-block; }

  .line{ height:1px; background:var(--bd); margin:12px 0 16px; }
  .grid2{ display:grid; grid-template-columns:1fr 1fr; grid-gap:10px 16px; }
  .field{ border:1px solid var(--bd); border-radius:8px; padding:10px; }
  .label{ font-size:12px; color:#374151; margin-bottom:4px; }
  .value{ font-size:14px; }

  .section-title{ font-weight:bold; margin:18px 0 8px; font-size:14px; }
  .chips{ display:flex; flex-wrap:wrap; gap:6px; margin-top:6px; }
  .chip{ border:1px solid var(--bd); border-radius:999px; padding:5px 10px; font-size:12px; background:#f8fafc; }

  .muted{ color:#6b7280; font-size:12px; }
  textarea.readonly{ width:100%; border:1px solid var(--bd); border-radius:8px; padding:10px; font-size:13px; resize:vertical; min-height:90px; background:#fbfbfb; }

  /* Footer QR */
  .footer{ display:flex;justify-content:space-between;align-items:flex-end;margin-top:18px; }
  .qr-box{ display:flex; flex-direction:column; align-items:center; gap:6px; }
  .qr-box img{ width:140px; height:140px; border:1px solid #e5e7eb; border-radius:6px; background:#fff; }
  .qr-caption{ font-size:11px; color:#374151; text-align:center; }

  /* ===== Print fixes ===== */
  @page { size: A4; margin: 12mm 10mm; }
  @media print{
    .topbar{ display:none !important; }
    .sheet{ width:auto !important; min-height:auto !important; padding:0 !important; margin:0 !important; }
  }
</style>
</head>
<body>

<!-- ===== Topbar (botones) ===== -->
<div class="topbar">
  <a href="<?= safe($wa_link); ?>" class="btn wa-btn" target="_blank" rel="noopener" title="Compartir PDF por WhatsApp">
    <span class="btn-label">WhatsApp</span>
  </a>

  <a href="<?= safe($mailto_link); ?>" class="btn email-btn" title="Compartir PDF por Email">
    <span class="btn-label">Email</span>
  </a>

  <a href="<?= safe($pdf_url_dl); ?>" class="btn pdf-btn" title="Descargar PDF">
    <span class="btn-label">Descargar PDF</span>
  </a>

  <button type="button" class="btn print-btn" onclick="window.print()" title="Imprimir esta página">
    <span class="btn-label">Imprimir</span>
  </button>
</div>

<div class="sheet">
  <div class="content">
    <div class="header">
      <img class="logo" src="<?= safe($logo_izq_url); ?>" alt="Logo izquierda">
      <div class="title">
        <h1>Time off request form · Formulario de solicitud de ausencia</h1>
        <div class="sub">Colegio Británico de Costa Rica · Recursos Humanos</div>
      </div>
      <img class="logo" src="<?= safe($logo_der_url); ?>" alt="Logo derecha">
    </div>

    <div class="idbar">
      <div class="id-badge" title="Leave Entry ID (ingreso_vacaciones)">
        <span class="dot" aria-hidden="true"></span>
        <span>Leave Entry ID:&nbsp;<strong><?= $ingreso_id ? '#'.$ingreso_id : '#'.$row['id']; ?></strong></span>
      </div>
    </div>

    <div class="line"></div>

    <div class="grid2">
      <div class="field"><div class="label">Empleado / Employee</div><div class="value"><?= safe($empleado_nombre); ?></div></div>
      <div class="field"><div class="label">Position / Categoría</div><div class="value"><?= safe((string)$row['categoria']); ?></div></div>
      <div class="field"><div class="label">Fecha del documento</div><div class="value"><?= safe((string)$row['fecha_documento']); ?></div></div>
      <div class="field"><div class="label">¿Cómo desea esta ausencia?</div><div class="value"><?= safe((string)$row['tipo_ausencia']); ?></div></div>
      <div class="field"><div class="label">Desde</div><div class="value"><?= safe((string)$row['fecha_desde']); ?></div></div>
      <div class="field"><div class="label">Hasta (incluyendo)</div><div class="value"><?= safe((string)$row['fecha_hasta']); ?></div></div>
    </div>

    <div class="section-title">Días feriados seleccionados</div>
    <?php if ($feriados_cnt > 0): ?>
      <div class="chips">
        <?php foreach(array_keys($feriados_unicos) as $f): ?><div class="chip"><?= safe($f); ?></div><?php endforeach; ?>
      </div>
    <?php else: ?><div class="muted">No se seleccionaron feriados.</div><?php endif; ?>

    <div class="section-title">Resumen de cálculo</div>
    <div class="chips">
      <div class="chip"><strong><?= $weekends; ?></strong>&nbsp;sábados + domingos <span class="muted">&nbsp;(no laborables)</span></div>
      <div class="chip"><strong><?= $feriados_cnt; ?></strong>&nbsp;feriados seleccionados</div>
      <div class="chip"><strong><?= $habiles_calculados; ?></strong>&nbsp;días laborables (recalculado)</div>
      <div class="chip"><strong><?= $habiles_guardados; ?></strong>&nbsp;días laborables (guardado)</div>
    </div>

    <div class="section-title">Comentarios</div>
    <textarea class="readonly" readonly><?= safe((string)($row['motivo'] ?? '')); ?></textarea>

    <!-- Sección de firma -->
    <div class="signature-section" style="margin-top: 30px;">
      <div class="field" style="width: 100%; display: flex; justify-content: space-between;">
        <div>
          <div class="label">Firma del colaborador / Employee signature</div>
          <br>
          <div style="border-bottom: 1px solid #000; width: 200px; margin-bottom: 5px;"></div>
          <div class="muted">Fecha / Date: <span style="border-bottom: 1px solid #000; width: 100px;"></span></div>
        </div>
        <div>
          <div class="label">Autorización Recursos Humanos / HR authorization</div>
          <br>
          <div style="border-bottom: 1px solid #000; width: 200px; margin-bottom: 5px;"></div>
          <div class="muted">Fecha / Date: <span style="border-bottom: 1px solid #000; width: 100px;"></span></div>
        </div>
      </div>
    </div>

  </div>

  <div class="footer">
    <div class="left" style="font-size:11px;color:#374151;line-height:1.35;max-width:65%;">
      <strong>P.O. BOX 8184 – 1000 San José, Costa Rica</strong><br>
      Phone: 2220-0131 / 2220-0719 &nbsp;&nbsp; Fax: 2232-7833<br>
      E-mail: brit.sch.cr@gmail.com
    </div>

    <!-- QR en el pie -->
    <div class="qr-box">
      <?php if ($qr_ok): ?>
        <!-- QR generado por la librería PHP (archivo local) -->
        <img src="<?= safe($qr_file_url); ?>" alt="QR Code">
      <?php else: ?>
        <!-- Fallback 1: Google Charts (si por permisos no se pudo escribir) -->
        <img src="<?= safe($qr_url_google); ?>" alt="QR Code">
        <!-- Fallback 2: tu canvas JS (solo si falla carga de imagen externa) -->
        <noscript>
          <div style="font-size:12px;color:#b91c1c">Activa JavaScript para ver el QR de respaldo.</div>
        </noscript>
        <canvas id="qr-canvas" style="width:140px; height:140px; background:#fff; border:1px solid #e5e7eb; border-radius:6px;"></canvas>
      <?php endif; ?>
      <div class="qr-caption">
        Leave Entry ID: <strong>#<?= (int)$code_val; ?></strong><br>

      </div>
    </div>
  </div>
</div>

<?php if (!$qr_ok): ?>
<!-- Solo cargamos la librería JS si se usa el canvas de respaldo -->
<script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.3/build/qrcode.min.js"></script>
<script>
  (function(){
    try{
      var el = document.getElementById('qr-canvas');
      if(!el) return;
      QRCode.toCanvas(el, <?= json_encode($qr_payload); ?>, { width: 140, margin: 1 }, function(err){
        if(err) console.error('Error al generar el QR (fallback JS):', err);
      });
    }catch(e){ console.error(e); }
  })();
</script>
<?php endif; ?>

<script>
function goBack(){
  try {
    var hasReferrer = document.referrer && document.referrer.indexOf(location.host) !== -1;
    if (hasReferrer && window.history.length > 1) { window.history.back(); return; }
  } catch(e){}
  window.location.href = <?= json_encode($fallback_back_url); ?>;
}
</script>
</body>
</html>
