<?php
// public_html/colegio/colegio10/rrhh_home/formulario_vacaciones.php
// PHP 5.6 compatible
error_reporting(E_ALL);
ini_set("display_errors", 1);
session_start();
date_default_timezone_set('America/Costa_Rica');
require_once __DIR__ . '/dbcon.php';

/* ===========================
   Configuración de logos
   =========================== */
$logo_izq = '/Files/Logo.jpg';
$logo_der = '/Files/Logo_internacional.png';

function url_exists_local($urlPath){
    $abs = rtrim($_SERVER['DOCUMENT_ROOT'], '/').$urlPath;
    return file_exists($abs);
}

/* ===========================
   URL de respaldo para "Go Back"
   =========================== */
$fallback_back_url = '/'; // <-- AJUSTA esta ruta si deseas otro destino por defecto

/* ===========================
   URL absoluta de esta página (para compartir)
   =========================== */
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host   = isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : $_SERVER['SERVER_NAME'];
$request_uri = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : $_SERVER['PHP_SELF'];
$current_absolute_url = $scheme.'://'.$host.$request_uri;

/* ===========================
   Utilidades (PHP 5.6)
   =========================== */
function limpiar($str) {
    $str = filter_var($str, FILTER_SANITIZE_STRING);
    return trim($str);
}

/** Cuenta días laborables (lun-vie) inclusivo, restando feriados dados ('Y-m-d') */
function contar_dias_laborables($desde_iso, $hasta_iso, $feriados_arr) {
    $d1 = DateTime::createFromFormat('Y-m-d', $desde_iso);
    $d2 = DateTime::createFromFormat('Y-m-d', $hasta_iso);
    if (!$d1 || !$d2 || $d2 < $d1) return 0;

    // normaliza set de feriados
    $feriados = array();
    if (is_array($feriados_arr)) {
        foreach ($feriados_arr as $f) {
            $f = trim($f);
            if ($f !== '') $feriados[$f] = true;
        }
    }

    $laborables = 0;
    $cursor = clone $d1;
    while ($cursor <= $d2) {
        $dow = (int)$cursor->format('w'); // 0=Dom, 6=Sáb
        if ($dow !== 0 && $dow !== 6) {
            $ymd = $cursor->format('Y-m-d');
            if (!isset($feriados[$ymd])) {
                $laborables++;
            }
        }
        $cursor->modify('+1 day');
    }
    return $laborables;
}

/** Guarda feriados como filas en vacaciones_feriados (estilo sistema vacaciones) */
function guardarFeriados($con, $idvacacion, $feriados_arr, $desde, $hasta){
    if (!is_array($feriados_arr)) return;
    foreach ($feriados_arr as $f){
        $f = trim($f);
        if ($f === '') continue;
        if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $f)) continue; // YYYY-MM-DD
        if ($f < $desde || $f > $hasta) continue;
        $w = (int)date('w', strtotime($f)); // 0 Dom, 6 Sáb
        if ($w === 0 || $w === 6) continue; // solo hábiles

        $f_sql = mysqli_real_escape_string($con, $f);
        mysqli_query(
            $con,
            "INSERT IGNORE INTO vacaciones_feriados (idvacacion, fecha) VALUES (".intval($idvacacion).", '$f_sql')"
        );
    }
}

/* ===========================
   Datos base para selects
   =========================== */
// Empleados (traemos también su categoria para autocompletar)
$empleados = array();        // [{id, nombre_completo, categoria}]
$empCatMap = array();        // id => categoria
$rsEmp = mysqli_query($con, "SELECT id, nombre_completo, categoria FROM empleados_planilla ORDER BY nombre_completo ASC");
if ($rsEmp) {
    while ($row = mysqli_fetch_assoc($rsEmp)) {
        $empleados[] = $row;
        $empCatMap[(int)$row['id']] = $row['categoria'];
    }
}

/* ===========================
   Mensajes
   =========================== */
$mensaje_ok = '';
$mensaje_error = '';

/* ===========================
   Token anti-doble envío (generar para GET)
   =========================== */
if (empty($_SESSION['vac_token'])) {
    if (function_exists('random_bytes')) {
        $_SESSION['vac_token'] = bin2hex(random_bytes(16));
    } else {
        $_SESSION['vac_token'] = bin2hex(openssl_random_pseudo_bytes(16));
    }
}
$vac_token = $_SESSION['vac_token'];

/* ===========================
   POST (guardar)
   =========================== */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Validación token
    $vac_token_post = isset($_POST['vac_token']) ? $_POST['vac_token'] : '';
    if (empty($_SESSION['vac_token']) || $vac_token_post !== $_SESSION['vac_token']) {
        $mensaje_error = 'Formulario ya fue enviado o token inválido. Actualice la página.';
    } else {
        // Consumimos token para evitar re-envío
        unset($_SESSION['vac_token']);

        // Campos principales
        $fecha_documento = isset($_POST['fecha_documento']) ? $_POST['fecha_documento'] : '';
        $id_empleado     = isset($_POST['nombre_completo']) ? (int)$_POST['nombre_completo'] : 0; // empleado_id
        $fecha_desde     = isset($_POST['fecha_desde']) ? $_POST['fecha_desde'] : '';
        $fecha_hasta     = isset($_POST['fecha_hasta']) ? $_POST['fecha_hasta'] : '';
        $motivo          = isset($_POST['motivo']) ? trim($_POST['motivo']) : '';
        $tipo_ausencia   = isset($_POST['tipo_ausencia']) ? $_POST['tipo_ausencia'] : 'Vacaciones';

        // Feriados (checklist) + respaldo JSON
        $feriados_sel = array();
        if (isset($_POST['feriados']) && is_array($_POST['feriados'])) {
            foreach ($_POST['feriados'] as $f) {
                $f = trim($f);
                if ($f !== '') $feriados_sel[] = $f;
            }
        }
        if (empty($feriados_sel) && isset($_POST['feriados_json'])) {
            $tmp = json_decode($_POST['feriados_json'], true);
            if (is_array($tmp)) $feriados_sel = $tmp;
        }

        // Obtener SIEMPRE la categoría desde empleados_planilla (server-side)
        $categoria = '';
        if ($id_empleado > 0) {
            $rs = mysqli_query($con, "SELECT categoria FROM empleados_planilla WHERE id = ".$id_empleado." LIMIT 1");
            if ($rs && mysqli_num_rows($rs) > 0) {
                $r = mysqli_fetch_assoc($rs);
                $categoria = $r['categoria'];
            }
        }

        // Validar obligatorios
        if ($fecha_documento === '' || $id_empleado <= 0 || $categoria === '' || $fecha_desde === '' || $fecha_hasta === '') {
            $mensaje_error = 'Por favor, complete los campos obligatorios.';
        } else {

            // Recalcular en servidor (laborables menos feriados)
            $cantidad_dias = contar_dias_laborables($fecha_desde, $fecha_hasta, $feriados_sel);
            if ($cantidad_dias < 0) $cantidad_dias = 0;

            // Estado pendiente
            $status = 2; // INT recomendado

            // ======== TRANSACCIÓN =========
            mysqli_autocommit($con, false);
            $ok1 = $ok2 = false;
            $id_form = 0;
            $idvacacion = 0;

            try {
                // 1) INSERT formulario_vacaciones
                $feriados_conteo = count($feriados_sel);
                $feriados_json   = json_encode(array_values($feriados_sel));

                $sql1 = "INSERT INTO formulario_vacaciones
                         (fecha_documento, nombre_completo, categoria, fecha_desde, fecha_hasta, motivo, cantidad_dias, tipo_ausencia, feriados_conteo, feriados_json)
                         VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                if (!$stmt1 = mysqli_prepare($con, $sql1)) {
                    throw new Exception('Error preparando stmt1: '.mysqli_error($con));
                }
                $empleado_guardar = (string)$id_empleado; // en tu esquema guardas el ID como texto
                mysqli_stmt_bind_param(
                    $stmt1,
                    'ssssssisis', // s s s s s s i s i s
                    $fecha_documento,
                    $empleado_guardar,
                    $categoria,
                    $fecha_desde,
                    $fecha_hasta,
                    $motivo,
                    $cantidad_dias,
                    $tipo_ausencia,
                    $feriados_conteo,
                    $feriados_json
                );
                $ok1 = mysqli_stmt_execute($stmt1);
                if (!$ok1) throw new Exception('Error ejecutando stmt1: '.mysqli_stmt_error($stmt1));
                $id_form = mysqli_insert_id($con);
                mysqli_stmt_close($stmt1);

// 2) INSERT ingreso_vacaciones referenciando el MISMO ID de formulario
$sql2 = "INSERT INTO ingreso_vacaciones
         (fecha_documento, fecha_desde, fecha_hasta, idempleado, motivo, cantidad_dias, status, idformulario, tipo_ausencia)
         VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
if (!$stmt2 = mysqli_prepare($con, $sql2)) {
    throw new Exception('Error preparando stmt2: '.mysqli_error($con));
}
// TIPOS CORRECTOS: s s s i s i i i s   => 'sssisiiis'
mysqli_stmt_bind_param(
    $stmt2,
    'sssisiiis',
    $fecha_documento, // s
    $fecha_desde,     // s
    $fecha_hasta,     // s
    $id_empleado,     // i
    $motivo,          // s
    $cantidad_dias,   // i
    $status,          // i
    $id_form,         // i
    $tipo_ausencia    // s
);
                $ok2 = mysqli_stmt_execute($stmt2);
                if (!$ok2) throw new Exception('Error ejecutando stmt2: '.mysqli_stmt_error($stmt2));
                $idvacacion = mysqli_insert_id($con);
                mysqli_stmt_close($stmt2);

                // 3) Guarda feriados desglosados (opcional)
                guardarFeriados($con, $idvacacion, $feriados_sel, $fecha_desde, $fecha_hasta);

                // Todo OK → COMMIT
                mysqli_commit($con);
                mysqli_autocommit($con, true);

                // Redirige a imprimir usando EL ID DEL FORMULARIO (mismo para ambos)
                header('Location: formulario_vacaciones_imprimir.php?id=' . $id_form);
                exit;

            } catch (Exception $e) {
                // Algo falló → ROLLBACK
                mysqli_rollback($con);
                mysqli_autocommit($con, true);
                $mensaje_error = 'Error al guardar el registro. '.$e->getMessage();
            }
        }
    }
}

/* Helper para selects */
function sel($a, $b){ return ($a == $b) ? ' selected' : ''; }
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>Formulario de solicitud de ausencia</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Select2 (CDN) -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<style>
  :root{ --bd:#d8dee4; --bg:#f6f8fa; --muted:#6b7280; }
  body{font-family:Arial, Helvetica, sans-serif; background:var(--bg); color:#111; margin:0; padding:28px;}
  .wrap{max-width:1024px; margin:0 auto; background:#fff; border:1px solid var(--bd); border-radius:16px; padding:28px;}

  .topbar{ display:flex; align-items:center; gap:8px; margin:-10px 0 12px; flex-wrap:wrap; }
  .btn{ display:inline-flex; align-items:center; gap:8px; padding:10px 14px; border-radius:999px; cursor:pointer; font-weight:600; text-decoration:none; line-height:1; box-shadow:0 2px 6px rgba(0,0,0,.08); transition:transform .06s, box-shadow .2s, background .2s, color .2s, border-color .2s; border:1px solid #111; background:#fff; color:#111; }
  .btn:hover{ transform:translateY(-1px); box-shadow:0 6px 16px rgba(0,0,0,.12); }
  .btn:active{ transform:translateY(0); box-shadow:0 2px 6px rgba(0,0,0,.08); }
  .btn:focus{ outline:2px solid #0d6efd; outline-offset:2px; }
  .back-btn{ background:#111; color:#fff; border-color:#111; }
  .wa-btn{ background:#25D366; color:#fff; border-color:#1fb157; }
  .email-btn{ background:#0d6efd; color:#fff; border-color:#0b5ed7; }
  .copy-btn{ background:#fff; color:#111; border-color:var(--bd); }

  .header{ display:flex; align-items:center; justify-content:space-between; gap:16px; margin-bottom:16px; }
  .title{ flex:1; text-align:center; }
  .logo{ width:96px; height:auto; object-fit:contain; }
  .logo.left{ margin-right:12px; }
  .logo.right{ margin-left:12px; }
  h1{font-size:22px; margin:0 0 6px; font-weight:700;}
  .sub{color:var(--muted); margin-bottom:18px; font-size:13px;}

  .card{border:1px solid var(--bd); border-radius:14px; padding:20px 18px 12px; margin-bottom:18px;}
  .grid{display:grid; grid-template-columns:1fr 1fr; grid-column-gap:18px; grid-row-gap:14px;}
  .row{display:flex; flex-direction:column; gap:8px;}
  label{font-weight:bold;}
  input[type="text"], input[type="date"], input[type="number"], textarea, select{
    width:100%; padding:12px 13px; border:1px solid var(--bd); border-radius:10px; font-size:14px; background:#fff;
  }
  input[readonly]{ background:#f9fafb; }
  textarea{min-height:110px; resize:vertical;}
  .muted{font-size:12px; color:#6b7280;}
  .actions{display:flex; gap:12px; margin-top:16px;}
  button{border:0; padding:11px 16px; border-radius:10px; cursor:pointer; font-weight:bold;}
  .primary{background:#0d6efd; color:#fff;}
  .ghost{background:#eef2f6;}
  .alert-ok{background:#e8f5e9; color:#1b5e20; border:1px solid #c8e6c9; padding:10px 12px; border-radius:8px; margin-bottom:12px;}
  .alert-err{background:#ffebee; color:#b71c1c; border:1px solid #ffcdd2; padding:10px 12px; border-radius:8px; margin-bottom:12px;}
  .help-msg{ font-size:12px; color:#0d6efd; display:none; }
  .inline-tip{ font-size:12px; color:#374151; }

  .feriados-grid{ display:grid; grid-template-columns: repeat(3, 1fr); grid-gap:10px; }
  .fer-item{ display:flex; align-items:center; gap:8px; padding:8px 10px; border:1px solid var(--bd); border-radius:8px; background:#fafafa; }
  .fer-item input{ transform: scale(1.15); }

  .select2-container{ width:100% !important; }

  .stats{ display:flex; flex-wrap:wrap; gap:8px; margin-top:10px; }
  .pill{ display:flex; align-items:center; gap:6px; border:1px solid --var(--bd); background:#f9fafb; border-radius:999px; padding:6px 10px; font-size:13px; }
  .pill strong{ font-size:13px; }

  @media (max-width: 900px){ .feriados-grid{ grid-template-columns: repeat(2, 1fr); } }
  @media (max-width: 620px){ .grid{ grid-template-columns:1fr; } .logo{ width:76px; } .feriados-grid{ grid-template-columns:1fr; } }
</style>
</head>
<body>
  <div class="wrap">

    <!-- Topbar con botones -->
    <div class="topbar">
      <!-- Go Back -->
      <button type="button" class="btn back-btn" onclick="goBack()" title="Go back to previous page">
        <span class="label">Go Back</span>
      </button>

      <!-- Share via WhatsApp -->
      <button type="button" class="btn wa-btn" onclick="shareWhatsApp()" title="Share link via WhatsApp">
        <span class="label">Share via WhatsApp</span>
      </button>

      <!-- Share via Email -->
      <button type="button" class="btn email-btn" onclick="shareEmail()" title="Share link via Email">
        <span class="label">Share via Email</span>
      </button>

      <!-- Copy link -->
      <button type="button" class="btn copy-btn" onclick="copyLink()" title="Copy page link">
        <span class="label">Copy link</span>
      </button>
    </div>

    <div class="header">
      <?php if (url_exists_local($logo_izq)): ?>
        <img class="logo left" src="<?php echo $logo_izq; ?>" alt="Logo izquierda">
      <?php endif; ?>

      <div class="title">
        <h1>Time off request form · Formulario de solicitud de ausencia</h1>
        <div class="sub">Colegio Británico de Costa Rica · Recursos Humanos</div>
      </div>

      <?php if (url_exists_local($logo_der)): ?>
        <img class="logo right" src="<?php echo $logo_der; ?>" alt="Logo derecha">
      <?php endif; ?>
    </div>

    <?php if($mensaje_ok !== ''): ?>
      <div class="alert-ok"><?php echo htmlspecialchars($mensaje_ok, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if($mensaje_error !== ''): ?>
      <div class="alert-err"><?php echo htmlspecialchars($mensaje_error, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>

    <form method="post" autocomplete="off" id="frmVac">
      <!-- Token anti-doble envío -->
      <input type="hidden" name="vac_token" value="<?php echo htmlspecialchars($vac_token, ENT_QUOTES, 'UTF-8'); ?>">

      <!-- Empleado / Categoría (categoría solo lectura) -->
      <div class="card">
        <div class="grid">
          <div class="row">
            <label for="empleado_id">Empleado / Employee *</label>
            <select id="empleado_id" name="nombre_completo" required>
              <option value="">-- Seleccione --</option>
              <?php
              $valPostEmp = isset($_POST['nombre_completo']) ? (int)$_POST['nombre_completo'] : 0;
              foreach($empleados as $e){
                  $val = (int)$e['id'];
                  $txt = $e['nombre_completo'];
                  $sel = ($valPostEmp === $val) ? ' selected' : '';
                  echo '<option value="'.$val.'"'.$sel.'>'.htmlspecialchars($txt, ENT_QUOTES, 'UTF-8').'</option>';
              }
              ?>
            </select>
            <div class="muted">Puede escribir para buscar. Se guardará el <strong>ID</strong> del empleado; en la impresión se mostrará el nombre.</div>
          </div>

          <div class="row">
            <label for="categoria_view">Position / Categoría (auto)</label>
            <input type="text" id="categoria_view" value="<?php
                if ($valPostEmp && isset($empCatMap[$valPostEmp])) {
                    echo htmlspecialchars($empCatMap[$valPostEmp], ENT_QUOTES, 'UTF-8');
                }
            ?>" readonly>
            <input type="hidden" id="categoria" name="categoria" value="<?php
                if ($valPostEmp && isset($empCatMap[$valPostEmp])) {
                    echo htmlspecialchars($empCatMap[$valPostEmp], ENT_QUOTES, 'UTF-8');
                }
            ?>">
            <div class="muted">Proviene de <em>empleados_planilla</em> y no se puede editar aquí.</div>
          </div>
        </div>
      </div>

      <!-- Documento / Tipo -->
      <div class="card">
        <div class="grid">
          <div class="row">
            <label for="fecha_documento">Fecha del documento *</label>
            <input type="date" id="fecha_documento" name="fecha_documento" required
                   value="<?php echo isset($_POST['fecha_documento']) ? htmlspecialchars($_POST['fecha_documento'], ENT_QUOTES, 'UTF-8') : date('Y-m-d'); ?>">
          </div>

          <div class="row">
            <label for="tipo_ausencia">¿Cómo desea esta ausencia? *</label>
            <select id="tipo_ausencia" name="tipo_ausencia" required>
              <?php
                $ta = isset($_POST['tipo_ausencia']) ? $_POST['tipo_ausencia'] : 'Vacaciones';
                $opts = array('Vacaciones', 'Permiso pagado', 'Permiso sin goce de salario');
                foreach ($opts as $op) {
                  echo '<option value="'.$op.'"'.sel($ta, $op).'>'.$op.'</option>';
                }
              ?>
            </select>
            <div id="tipo_msg" class="help-msg"></div>
          </div>
        </div>
      </div>

      <!-- Rango / Feriados (checklist) -->
      <div class="card">
        <div class="grid">
          <div class="row">
            <label for="fecha_desde">Desde *</label>
            <input type="date" id="fecha_desde" name="fecha_desde" required
                   value="<?php echo isset($_POST['fecha_desde']) ? htmlspecialchars($_POST['fecha_desde'], ENT_QUOTES, 'UTF-8') : ''; ?>">
          </div>
          <div class="row">
            <label for="fecha_hasta">Hasta (incluyendo) *</label>
            <input type="date" id="fecha_hasta" name="fecha_hasta" required
                   value="<?php echo isset($_POST['fecha_hasta']) ? htmlspecialchars($_POST['fecha_hasta'], ENT_QUOTES, 'UTF-8') : ''; ?>">
          </div>
        </div>

        <div class="row" style="margin-top:6px;">
          <label>Días feriados (marque si aplica)</label>
          <div id="feriadosGrid" class="feriados-grid"><!-- checkboxes dinámicos --></div>
          <div class="inline-tip">Cada día feriado marcado se restará del total de días laborables.</div>

          <!-- Resumen de cálculo -->
          <div class="stats">
            <div class="pill"><strong id="stat_sd">0</strong> sábados + domingos <span class="muted">(no laborables)</span></div>
            <div class="pill"><strong id="stat_fer">0</strong> feriados seleccionados</div>
            <div class="pill"><strong id="stat_hab">0</strong> días laborables</div>
          </div>
        </div>
      </div>

      <!-- Cantidad y comentarios -->
      <div class="card">
        <div class="grid">
          <div class="row">
            <label for="cantidad_dias">Cantidad de días laborables solicitados *</label>
            <input type="number" id="cantidad_dias" name="cantidad_dias" min="0" step="1" required readonly
                   value="<?php echo isset($_POST['cantidad_dias']) ? (int)$_POST['cantidad_dias'] : 0; ?>">
            <div class="muted">Se calcula con el rango (excluye sábados y domingos) y feriados marcados.</div>
          </div>
          <div class="row">
            <label for="motivo">Comentarios</label>
            <textarea id="motivo" name="motivo"><?php echo isset($_POST['motivo']) ? htmlspecialchars($_POST['motivo'], ENT_QUOTES, 'UTF-8') : ''; ?></textarea>
          </div>
        </div>
      </div>

      <!-- Hidden para enviar lista JSON de feriados (compatibilidad backend) -->
      <input type="hidden" id="feriados_json" name="feriados_json" value="[]">

      <div class="actions">
        <button type="submit" class="primary">Guardar</button>
        <button type="reset" class="ghost" id="btnReset">Limpiar</button>
      </div>
    </form>
  </div>

<script>
// ====== Config JS para compartir/copiar ======
var PAGE_URL = <?php echo json_encode($current_absolute_url); ?>;
var MAIL_SUBJECT = "Time off request form · Formulario de solicitud de ausencia";

function goBack(){
  try {
    var hasReferrer = document.referrer && document.referrer.indexOf(location.host) !== -1;
    if (hasReferrer && window.history.length > 1) { window.history.back(); return; }
  } catch(e){}
  window.location.href = <?php echo json_encode($fallback_back_url); ?>;
}

function shareWhatsApp(){
  var text = "Time off request form · Formulario de solicitud de ausencia%0A" + encodeURIComponent(PAGE_URL);
  var url = "https://wa.me/?text=" + text;
  window.open(url, '_blank');
}

function shareEmail(){
  var body = "Hello,%0D%0A%0D%0APlease fill/review the time off request form at:%0D%0A" + encodeURIComponent(PAGE_URL) + "%0D%0A%0D%0ARegards.";
  var mailto = "mailto:?subject=" + encodeURIComponent(MAIL_SUBJECT) + "&body=" + body;
  window.location.href = mailto;
}

function copyLink(){
  if (navigator.clipboard && navigator.clipboard.writeText) {
    navigator.clipboard.writeText(PAGE_URL).then(function(){
      alert('Link copied to clipboard.');
    }, function(){
      legacyCopy();
    });
  } else {
    legacyCopy();
  }
}
function legacyCopy(){
  var ta = document.createElement('textarea');
  ta.value = PAGE_URL;
  ta.setAttribute('readonly','');
  ta.style.position = 'absolute';
  ta.style.left = '-9999px';
  document.body.appendChild(ta);
  ta.select();
  try { document.execCommand('copy'); alert('Link copied to clipboard.'); }
  catch(e){ prompt('Copy this link:', PAGE_URL); }
  document.body.removeChild(ta);
}

// ====== Mapa categorias por empleado (id => categoria) ======
var empCatMap = <?php echo json_encode($empCatMap); ?>;

// ====== Utilidades fecha ======
function ymd(date){ var y=date.getFullYear(), m=date.getMonth()+1, d=date.getDate(); if(m<10)m='0'+m; if(d<10)d='0'+d; return y+'-'+m+'-'+d; }
function parseYmd(s){ var a=s.split('-'); if(a.length!==3)return null; var y=parseInt(a[0],10), m=parseInt(a[1],10)-1, d=parseInt(a[2],10); var dt=new Date(y,m,d); if(dt.getFullYear()!==y||dt.getMonth()!==m||dt.getDate()!==d)return null; return dt; }
function isWeekend(dt){ var w=dt.getDay(); return (w===0||w===6); } // 0 Dom, 6 Sáb

// ====== Elements ======
var empleado = document.getElementById('empleado_id');
var catView  = document.getElementById('categoria_view');
var catHidden= document.getElementById('categoria');

var desde = document.getElementById('fecha_desde');
var hasta = document.getElementById('fecha_hasta');
var ferGrid = document.getElementById('feriadosGrid');
var dias = document.getElementById('cantidad_dias');

var tipo = document.getElementById('tipo_ausencia');
var tipoMsg = document.getElementById('tipo_msg');
var btnReset = document.getElementById('btnReset');
var feriadosJsonField = document.getElementById('feriados_json');

var statSD  = document.getElementById('stat_sd');
var statFer = document.getElementById('stat_fer');
var statHab = document.getElementById('stat_hab');

// ====== Mensaje por tipo de ausencia ======
function actualizarMensajeTipo(){
  var v = tipo.value || '';
  var msg = '';
  if (v === 'Permiso pagado') {
    msg = 'Permiso pagado: la cantidad de días solicitados NO afectará las vacaciones disponibles.';
  } else if (v === 'Permiso sin goce de salario') {
    msg = 'Permiso sin goce de salario: la cantidad de días solicitados NO afectará las vacaciones disponibles, pero SÍ afectará el salario.';
  }
  tipoMsg.textContent = msg;
  tipoMsg.style.display = msg ? 'block' : 'none';
}

// ====== Autocompletar categoría por empleado (solo lectura) ======
function autocompletarCategoria(){
  var id = parseInt(empleado.value || '0', 10);
  var c = (id && empCatMap[id]) ? empCatMap[id] : '';
  catView.value = c || '';
  catHidden.value = c || '';
}

// ====== Construir checklist de feriados (días hábiles del rango) ======
function poblarFeriadosChecklist(){
  ferGrid.innerHTML = '';
  var ds = desde.value, hs = hasta.value;
  if(!ds || !hs) { actualizarStats(0,0,0); return; }

  var d1 = parseYmd(ds), d2 = parseYmd(hs);
  if(!d1 || !d2 || d2 < d1) { actualizarStats(0,0,0); return; }

  var cur = new Date(d1.getTime());
  while(cur <= d2){
    if (!isWeekend(cur)) {
      var val = ymd(cur);
      var wrap = document.createElement('label');
      wrap.className = 'fer-item';

      var cb = document.createElement('input');
      cb.type = 'checkbox';
      cb.name = 'feriados[]';
      cb.value = val;
      cb.addEventListener('change', recalcularDias);

      var sp = document.createElement('span');
      sp.textContent = val;

      wrap.appendChild(cb);
      wrap.appendChild(sp);
      ferGrid.appendChild(wrap);
    }
    cur.setDate(cur.getDate() + 1);
  }
  recalcularDias();
}

// ====== Recalcular y actualizar contadores ======
function recalcularDias(){
  var ds = desde.value, hs = hasta.value;
  if(!ds || !hs){ actualizarStats(0,0,0); dias.value = 0; return; }
  var d1 = parseYmd(ds), d2 = parseYmd(hs);
  if(!d1 || !d2 || d2 < d1){ actualizarStats(0,0,0); dias.value = 0; return; }

  var total = 0, weekends = 0, weekdays = 0;
  var cur = new Date(d1.getTime());
  while(cur <= d2){
    total++;
    if (isWeekend(cur)) weekends++; else weekdays++;
    cur.setDate(cur.getDate() + 1);
  }

  var checks = ferGrid.querySelectorAll('input[type="checkbox"]:checked');
  var ferSel = checks.length;

  var resultado = weekdays - ferSel;
  if (resultado < 0) resultado = 0;

  dias.value = resultado;
  actualizarStats(weekends, ferSel, resultado);
}

function actualizarStats(weekends, ferSel, habiles){
  statSD.textContent  = parseInt(weekends,10);
  statFer.textContent = parseInt(ferSel,10);
  statHab.textContent = parseInt(habiles,10);
}

// ====== Antes de enviar: empaquetar feriados a JSON (compatibilidad backend) ======
document.getElementById('frmVac').addEventListener('submit', function(){
  var btns = this.querySelectorAll('button[type="submit"]');
  for (var i=0;i<btns.length;i++){ btns[i].disabled = true; } // evita doble clic

  var checks = ferGrid.querySelectorAll('input[type="checkbox"]:checked');
  var arr = [];
  for (var i=0;i<checks.length;i++){ arr.push(checks[i].value); }
  feriadosJsonField.value = JSON.stringify(arr);
});

// ====== Inicialización ======
$(function(){
  $('#empleado_id').select2({
    placeholder: '-- Seleccione --',
    width: '100%',
    language: {
      noResults: function(){ return 'Sin resultados'; },
      searching: function(){ return 'Buscando…'; }
    }
  }).on('change', function(){
    autocompletarCategoria();
  });

  actualizarMensajeTipo();
  autocompletarCategoria();
  poblarFeriadosChecklist();

  $('#fecha_desde, #fecha_hasta').on('change', function(){
    poblarFeriadosChecklist();
  });

  $('#btnReset').on('click', function(){
    setTimeout(function(){
      $('#empleado_id').val('').trigger('change');
      $('#tipo_ausencia').val('Vacaciones').trigger('change');
      ferGrid.innerHTML = '';
      dias.value = 0;
      document.getElementById('stat_sd').textContent = '0';
      document.getElementById('stat_fer').textContent = '0';
      document.getElementById('stat_hab').textContent = '0';
      $('#categoria_view').val('');
      $('#categoria').val('');
      $('#feriados_json').val('[]');
    }, 0);
  });
});
</script>
</body>
</html>

