<?php
// rrhh_home/extras_editor.php
// Editor mensual/rango de horas extra + totales en vivo + eliminar día.
// + NUEVO: Panel QR por día (overtime_qr) dentro del modal con recalculo live.
// PHP 8.1.33 – UTF-8

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) { header("Location:index.html"); exit; }
$ES_SUPER = isset($_SESSION["superadmin"]) && $_SESSION["superadmin"] === "S";

require_once __DIR__ . '/dbcon.php';
mysqli_set_charset($con,'utf8mb4');

// Empleados para combo
$empleados = [];
$q = "SELECT id, nombre_completo, cedula, categoria FROM empleados_planilla ORDER BY nombre_completo ASC";
if ($rs = mysqli_query($con, $q)) {
  while ($r = mysqli_fetch_assoc($rs)) $empleados[] = $r;
  mysqli_free_result($rs);
}
$MES_DEF = date('Y-m');

// Header
if(!$ES_SUPER) include __DIR__.'/view/header.php';
else           include __DIR__.'/view/headeradmin.html';
?>
<script>
  $('#payroll_control').addClass("treeview active");
  $('#payroll_control_2').addClass("treeview active");
</script>

<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet"/>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

<style>
  .kpi {border:1px solid #e8e8e8; border-radius:12px; padding:14px; text-align:center; margin-bottom:12px; background:#fff}
  .kpi h3{margin:0; font-weight:800; letter-spacing:.3px}
  .kpi small{color:#6b7280}
  .legend{display:flex; gap:10px; align-items:center; flex-wrap:wrap; margin:8px 0 12px}
  .legend .tag{font-size:12px; padding:3px 8px; border-radius:20px; border:1px solid #e5e7eb; background:#f8fafc; color:#334155}
  .cal-wrap{border:1px solid #e6e6e6;border-radius:12px;padding:12px;background:#fff}
  .cal-head{display:grid;grid-template-columns:repeat(7,1fr);gap:6px;margin-bottom:6px}
  .cal-head .dhead{border:1px solid #e5e7eb;border-radius:10px;padding:10px;text-align:center;background:#f1f5f9;font-weight:700;color:#334155}
  .cal{display:grid;grid-template-columns:repeat(7,1fr);gap:6px}
  .cal .d{border:1px solid #eef0f2; border-radius:12px; min-height:110px; padding:10px 10px 8px 10px;background:#fafafa; cursor:pointer; position:relative; transition:box-shadow .18s ease, background .18s;}
  .cal .d:hover{ box-shadow:0 6px 18px rgba(0,0,0,.06); background:#fff; }
  .cal .d .num{position:absolute;top:8px;right:10px;color:#94a3b8;font-size:12px;font-weight:700}
  .cal .d .h{font-weight:800;font-size:20px;margin-top:18px; color:#0f172a}
  .cal .d .f{font-size:12px;color:#64748b; margin-top:2px}
  .cal .d .pill{position:absolute; left:10px; top:8px; font-size:11px; background:#e2e8f0; color:#334155; border-radius:12px; padding:2px 8px}
  .cal .d.we{background:#fff8f4}
  .cal .d.we .pill{background:#fde2cf}
  .cal .d.vac{outline:2px dashed #f59e0b}
  .cal .d.inc{outline:2px dashed #ef4444}
  .cal .d.hasdata{border-color:#dbeafe; background:#f8fbff}
  .cal .d.hasdata .h{color:#1d4ed8}
  .cal .d.hasdata .f{color:#2563eb}
  @media (max-width: 992px){ .cal .d{min-height:92px} }
  .mode-toggle{display:flex; gap:12px; align-items:center; margin-top:4px}
  .help-txt{margin-top:6px; color:#64748b}

  /* QR box (modal) */
  .qrbox{margin-top:12px; border:1px solid #e5e7eb; border-radius:14px; padding:12px; background:#f8fafc;}
  .qrbox h5{margin:0 0 10px 0; font-weight:900; display:flex; align-items:center; gap:10px;}
  .qrstate{display:inline-block; padding:4px 10px; border-radius:999px; font-weight:900; border:1px solid #e5e7eb; background:#fff;}
  .qrstate.closed{background:#dcfce7; border-color:#86efac;}
  .qrstate.planned{background:#fff7ed; border-color:#fdba74;}
  .qrstate.open{background:#fee2e2; border-color:#fca5a5;}
  .qrgrid{display:grid; grid-template-columns:repeat(3,1fr); gap:10px;}
  .qrgrid .form-group{margin-bottom:8px;}
  .qrminutes{grid-column:1/4;}
  .qr-alert{display:none; margin-top:8px; padding:8px 10px; border-radius:12px; background:#fff1f2; border:1px solid #fecdd3; color:#9f1239; font-weight:800;}
  .planned-red{border:2px solid #ef4444 !important; box-shadow:0 0 0 3px rgba(239,68,68,.12);}
  .qr-actions{display:flex; gap:10px; justify-content:flex-end; margin-top:10px;}
</style>

<div class="box">
  <div class="box-header with-border">
    <h3>Horas extra – Editor mensual</h3>
    <div class="box-tools pull-right">
      <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
    </div>
  </div>

  <div class="box-body">
    <div class="row" style="margin-bottom:12px">
      <div class="col-md-4">
        <label>Empleado</label>
        <select id="empleado" class="form-control select2" style="width:100%">
          <option value="">-- Seleccione --</option>
          <?php foreach($empleados as $e): ?>
            <option value="<?= (int)$e['id'] ?>">
              <?= htmlspecialchars($e['nombre_completo']) ?> - <?= htmlspecialchars($e['cedula']) ?>
              (<?= htmlspecialchars($e['categoria']) ?>)
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-8">
        <div class="mode-toggle">
          <label class="radio-inline"><input type="radio" name="modo" value="month" checked> Mes</label>
          <input type="month" id="mes" class="form-control" value="<?= htmlspecialchars($MES_DEF) ?>" style="max-width:180px">

          <label class="radio-inline" style="margin-left:18px"><input type="radio" name="modo" value="range"> Rango</label>
          <input type="date" id="desde" class="form-control" style="max-width:160px; display:none">
          <input type="date" id="hasta" class="form-control" style="max-width:160px; display:none">

          <button id="btnCargar" class="btn btn-primary">Cargar calendario</button>
          <a href="planilla_home.php" class="btn btn-default">Ir a Home/Polilla</a>
        </div>
        <div class="help-txt" id="selInfo"></div>
      </div>
    </div>

    <!-- KPIs -->
    <div class="row">
      <div class="col-sm-3"><div class="kpi"><small>Horas 1.5x</small><h3 id="k15">0.00</h3></div></div>
      <div class="col-sm-3"><div class="kpi"><small>Horas 2.0x</small><h3 id="k20">0.00</h3></div></div>
      <div class="col-sm-3"><div class="kpi"><small>Horas 3.0x</small><h3 id="k30">0.00</h3></div></div>
      <div class="col-sm-3"><div class="kpi"><small>Total</small><h3 id="kT">0.00</h3></div></div>
    </div>

    <div class="legend">
      <span class="tag">Fin de semana</span>
      <span class="tag">Vacaciones activas</span>
      <span class="tag">Incapacidad</span>
    </div>

    <div class="cal-wrap">
      <div id="calHead" class="cal-head"></div>
      <div id="cal" class="cal"></div>
    </div>
  </div>
</div>

<!-- Modal edición -->
<div class="modal fade" id="dlg" tabindex="-1" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Editar horas del <span id="dlgFecha"></span></h4></div>
      <div class="modal-body">
        <div class="form-group">
          <label>Horas</label>
          <input type="number" min="0" step="0.25" id="dlgHoras" class="form-control" placeholder="0.00" readonly>
        </div>
        <div class="form-group">
          <label>Factor</label>
          <select id="dlgFactor" class="form-control">
            <option value="1.5">1.5x (tiempo y medio)</option>
            <option value="2.0">2.0x (doble)</option>
            <option value="3.0">3.0x (triple)</option>
          </select>
        </div>
        <div class="form-group">
          <label>Descripción (opcional)</label>
          <input type="text" id="dlgDesc" maxlength="255" class="form-control" placeholder="Descripción corta…">
        </div>
        <div id="dlgWarn" class="text-danger" style="display:none"></div>

        <!-- ====== QR BOX (nuevo) ====== -->
        <div class="qrbox">
          <h5>
            Estado Horas Extra (QR)
            <span id="qrState" class="qrstate open">SIN</span>
            <button type="button" class="btn btn-default btn-xs" id="btnQrReload" style="margin-left:auto">
              <i class="fa fa-refresh"></i> Recargar
            </button>
          </h5>

          <div class="qrgrid">
            <div class="form-group">
              <label>Salida oficial</label>
              <input type="time" id="qrScheduleEnd" class="form-control" step="60">
            </div>
            <div class="form-group">
              <label>Programado</label>
              <input type="time" id="qrPlannedEnd" class="form-control" step="60">
            </div>
            <div class="form-group">
              <label>Cierre real</label>
              <input type="time" id="qrActualEnd" class="form-control" step="60">
            </div>

            <div class="form-group qrminutes">
              <label>Minutos</label>
              <input type="number" id="qrMinutes" class="form-control" min="0" step="1" placeholder="0" readonly>
              <div class="help-txt" style="margin-top:6px;">
                Tip: si editas <b>Cierre real</b> se recalcula <b>Minutos</b> y también <b>Horas</b> arriba (0.5 en 0.5).
              </div>
            </div>
          </div>

          <div id="qrAlert" class="qr-alert">
            ⚠ Este día quedó en <b>PROGRAMADO (PLANNED)</b> sin cierre real. Esto puede bloquear el QR al día siguiente.
          </div>

          <div class="qr-actions">
            <button type="button" class="btn btn-danger" id="btnQrDelete">
              <i class="fa fa-trash"></i> Eliminar QR de este día
            </button>
            <button type="button" class="btn btn-primary" id="btnQrSave">
              <i class="fa fa-save"></i> Guardar QR
            </button>
          </div>
        </div>
        <!-- ====== /QR BOX ====== -->

      </div>
      <div class="modal-footer">
        <button id="btnEliminar" class="btn btn-danger pull-left" style="display:none">
          <i class="fa fa-trash"></i> Eliminar
        </button>
        <button class="btn btn-default" data-dismiss="modal">Cancelar</button>
        <button id="btnGuardar" class="btn btn-primary">Guardar</button>
      </div>
    </div>
  </div>
</div>

<script>
/* ===== Select2 ===== */
$('.select2').select2({width:'100%', placeholder:'-- Seleccione --', allowClear:true});

/* ===== Estado ===== */
const cal      = document.getElementById('cal');
const calHead  = document.getElementById('calHead');
const selInfo  = document.getElementById('selInfo');
let curEmp = null, curMes = null, dataMes = {detalle:[], vacaciones:[], incapacidades:[]};
let dlgFecha=null, dlgTieneRegistro=false;
let modo='month', rango={desde:null,hasta:null};

const WEEKDAYS = ['Lunes','Martes','Miércoles','Jueves','Viernes','Sábado','Domingo'];

$('input[name="modo"]').on('change', function(){
  modo = this.value;
  if(modo==='month'){
    $('#mes').show();
    $('#desde,#hasta').hide().val('');
    selInfo.textContent = '';
  }else{
    $('#mes').hide();
    $('#desde,#hasta').show();
    const today = new Date();
    const y = today.getFullYear(), m = (today.getMonth()+1+'').padStart(2,'0');
    if(!$('#desde').val()) $('#desde').val(`${y}-${m}-01`);
    if(!$('#hasta').val()) $('#hasta').val(`${y}-${m}-${new Date(y, today.getMonth()+1, 0).getDate().toString().padStart(2,'0')}`);
  }
});

/* ===== Utilidades fecha ===== */
function ymd(d){ const z=n=> (n<10?'0':'')+n; return d.getFullYear()+'-'+z(d.getMonth()+1)+'-'+z(d.getDate()); }
function daysInMonth(year, month){ return new Date(year, month+1, 0).getDate(); }
function isWeekend(d){ const w=d.getDay(); return (w===0||w===6); } // DOM/SAB

function loadCalendar(){
  curEmp = $('#empleado').val();
  if(!curEmp){ alert('Seleccione empleado.'); return; }

  if(modo==='month'){
    curMes = $('#mes').val();
    if(!curMes){ alert('Seleccione mes.'); return; }
    $.post('extras_api.php',{action:'get_month', idempleado:curEmp, mes:curMes}, onLoaded, 'json');
  }else{
    const d = $('#desde').val(), h = $('#hasta').val();
    if(!d || !h || h<d){ alert('Seleccione un rango válido.'); return; }
    rango.desde = d; rango.hasta = h;
    $.post('extras_api.php',{action:'get_range', idempleado:curEmp, desde:d, hasta:h}, onLoaded, 'json');
  }
}

function onLoaded(r){
  if(!r || !r.ok){ alert(r?.msg || 'No se pudo cargar.'); return; }
  dataMes = r;
  renderCalendar(r);
  renderTotals(r.totales || {});
  if(r.modo==='range'){
    selInfo.textContent = `Viendo rango: ${r.desde} → ${r.hasta}`;
  }else{
    selInfo.textContent = `Viendo mes: ${$('#mes').val()}`;
  }
}

function renderTotals(t){
  $('#k15').text(parseFloat(t.h15||0).toFixed(2));
  $('#k20').text(parseFloat(t.h20||0).toFixed(2));
  $('#k30').text(parseFloat(t.h30||0).toFixed(2));
  $('#kT').text(parseFloat(t.hTot||0).toFixed(2));
}

function renderCalendarHeader(){
  calHead.innerHTML = '';
  WEEKDAYS.forEach(n=>{
    const el = document.createElement('div');
    el.className = 'dhead';
    el.textContent = n;
    calHead.appendChild(el);
  });
}

function renderCalendar(r){
  cal.innerHTML='';
  renderCalendarHeader();

  let start, end;
  if((r.modo||'month')==='range'){
    start = new Date(r.desde); end = new Date(r.hasta);
  }else{
    const parts = ($('#mes').val()||ymd(new Date()).slice(0,7)).split('-');
    start = new Date(+parts[0], (+parts[1])-1, 1);
    end   = new Date(+parts[0], (+parts[1])-1, daysInMonth(+parts[0], (+parts[1])-1));
  }

  const startDow = (start.getDay()+6)%7; // 0 = Lunes
  const gridStart = new Date(start); gridStart.setDate(start.getDate()-startDow);
  const endDow   = (end.getDay()+6)%7;
  const gridEnd  = new Date(end); gridEnd.setDate(end.getDate() + (6-endDow));

  const vac = new Set((r.vacaciones||[]).flatMap(v=>rangeDays(v.fecha_inicio, v.fecha_fin)));
  const inc = new Set((r.incapacidades||[]).flatMap(i=>rangeDays(i.fecha_inicio, i.fecha_fin)));

  const map = new Map();
  (r.detalle||[]).forEach(d=> map.set(d.fecha, d));

  for(let d=new Date(gridStart); d<=gridEnd; d.setDate(d.getDate()+1)){
    const s = ymd(d);
    const box = document.createElement('div'); box.className='d';
    if(isWeekend(d)) box.classList.add('we');
    if(vac.has(s)) box.classList.add('vac');
    if(inc.has(s)) box.classList.add('inc');

    const det = map.get(s);
    const horas = det ? parseFloat(det.horas||0) : 0;
    const factor= det ? det.factor : '';
    const desc  = det && det.descripcion ? det.descripcion : '';

    if (horas>0 || factor) box.classList.add('hasdata');

    box.innerHTML = `<div class="num">${d.getDate()}</div>
                     ${ (isWeekend(d)) ? '<span class="pill">WE</span>' : '' }
                     <div class="h">${horas>0?horas.toFixed(2):'—'}</div>
                     <div class="f">${factor?factor+'x':''}</div>`;

    const tips = [];
    tips.push(`Fecha: ${s}`);
    if(horas>0) tips.push(`Horas: ${horas.toFixed(2)}`);
    if(factor)  tips.push(`Factor: ${factor}x`);
    if(desc)    tips.push(`Desc: ${desc}`);
    if(vac.has(s)) tips.push('Vacaciones activas');
    if(inc.has(s)) tips.push('Incapacidad');
    if(isWeekend(d)) tips.push('Fin de semana');
    tips.push('• Click para editar (0 = eliminar)');
    box.title = tips.join(' • ');

    box.dataset.fecha = s;
    box.onclick = ()=>openDlg(s, det||null, (r.modo||'month'));
    cal.appendChild(box);
  }
}

function rangeDays(a,b){
  const out=[]; const d1=new Date(a), d2=new Date(b);
  for(let d=new Date(d1.getFullYear(),d1.getMonth(),d1.getDate()); d<=d2; d.setDate(d.getDate()+1)){
    out.push(ymd(d));
  }
  return out;
}

/* =========================
   QR helpers (live calc)
   ========================= */
function hhmmToMin(h){
  if(!h) return null;
  const p = h.split(':'); if(p.length<2) return null;
  const hh = parseInt(p[0],10), mm=parseInt(p[1],10);
  if(isNaN(hh)||isNaN(mm)) return null;
  return hh*60+mm;
}
function minDiff(scheduleHHMM, actualHHMM){
  const a = hhmmToMin(scheduleHHMM);
  const b = hhmmToMin(actualHHMM);
  if(a===null || b===null) return 0;
  let d = b-a;
  if(d<0) d=0;
  return d;
}
function roundHalfHoursFromMinutes(mins){
  mins = parseInt(mins||0,10);
  if(isNaN(mins)||mins<=0) return 0;
  return Math.ceil(mins/30)*0.5;
}
function setQrState(state){
  const el = document.getElementById('qrState');
  el.classList.remove('closed','planned','open');
  if(state==='CLOSED'){ el.textContent='CLOSED'; el.classList.add('closed'); }
  else if(state==='PLANNED'){ el.textContent='PLANNED'; el.classList.add('planned'); }
  else if(state==='OPEN'){ el.textContent='OPEN'; el.classList.add('open'); }
  else { el.textContent='SIN'; el.classList.add('open'); }
}

/* ===== Modal ===== */
function openDlg(fecha, det, modoActual){
  dlgFecha = fecha;
  $('#dlgFecha').text(fecha);
  $('#dlgHoras').val(det?det.horas:'');
  $('#dlgFactor').val(det?det.factor:'1.5');
  $('#dlgDesc').val(det?det.descripcion:'');

  dlgTieneRegistro = !!det;
  $('#btnEliminar').toggle(dlgTieneRegistro);

  $('#dlgWarn').hide().text('');

  const r=dataMes;
  const isVac = (r.vacaciones||[]).some(v=> fecha>=v.fecha_inicio && fecha<=v.fecha_fin );
  const isInc = (r.incapacidades||[]).some(i=> fecha>=i.fecha_inicio && fecha<=i.fecha_fin );
  const d=new Date(fecha); const w=isWeekend(d);
  let warn=[]; if(w) warn.push('Es fin de semana.'); if(isVac) warn.push('Dentro de vacaciones.'); if(isInc) warn.push('Dentro de incapacidad.');
  if(warn.length){ $('#dlgWarn').show().text('⚠ '+warn.join(' ')); }

  // ===== cargar QR del día =====
  loadQr(fecha);

  // Guardar (manual)
  $('#btnGuardar').off('click').on('click', function(){
    const horas = parseFloat($('#dlgHoras').val()||'0');
    const factor = $('#dlgFactor').val();
    const desc = $('#dlgDesc').val()||'';
    if(isNaN(horas) || horas<0){ alert('Horas inválidas.'); return; }
    const mes = fecha.slice(0,7);
    $.post('extras_api.php',{action:'upsert_day', idempleado: $('#empleado').val(), mes, fecha, horas, factor, descripcion: desc}, function(r){
      if(!r || !r.ok){ alert(r?.msg || 'No se pudo guardar.'); return; }
      $('#dlg').modal('hide');
      loadCalendar();
    }, 'json');
  });

  // Eliminar (manual)
  $('#btnEliminar').off('click').on('click', function(){
    if(!dlgTieneRegistro) return;
    if(!confirm('¿Eliminar el registro de este día?')) return;
    const mes = fecha.slice(0,7);
    $.post('extras_api.php',{action:'delete_day', idempleado: $('#empleado').val(), mes, fecha}, function(r){
      if(!r || !r.ok){ alert(r?.msg || 'No se pudo eliminar.'); return; }
      $('#dlg').modal('hide');
      loadCalendar();
    }, 'json');
  });

  // Botones QR
  $('#btnQrReload').off('click').on('click', ()=> loadQr(fecha));

  $('#btnQrSave').off('click').on('click', function(){
    const idemp = $('#empleado').val();
    if(!idemp){ alert('Seleccione empleado.'); return; }

    const payload = {
      action:'qr_save',
      idempleado:idemp,
      fecha:fecha,
      schedule_end: $('#qrScheduleEnd').val() || '',
      planned_end:  $('#qrPlannedEnd').val() || '',
      actual_end:   $('#qrActualEnd').val() || ''
    };

    $.post('extras_api.php', payload, function(r){
      if(!r || !r.ok){ alert(r?.msg || 'No se pudo guardar QR'); return; }
      // refrescar estado
      loadQr(fecha);
      // refrescar calendario para ver horas actualizadas
      loadCalendar();
    }, 'json');
  });

  $('#btnQrDelete').off('click').on('click', function(){
    const idemp = $('#empleado').val();
    if(!idemp){ alert('Seleccione empleado.'); return; }
    if(!confirm('¿Eliminar el QR de este día? (y si la extra fue inyectada por QR, también se elimina)')) return;

    $.post('extras_api.php', {action:'qr_delete', idempleado:idemp, fecha:fecha}, function(r){
      if(!r || !r.ok){ alert(r?.msg || 'No se pudo eliminar'); return; }
      loadQr(fecha);
      loadCalendar();
    }, 'json');
  });

  // Live recalculo
  hookQrLive();

  $('#dlg').modal('show');
}

function loadQr(fecha){
  const idemp = $('#empleado').val();
  setQrState('OPEN');
  $('#qrAlert').hide();
  $('#qrPlannedEnd').removeClass('planned-red');

  // limpiar si no hay
  if(!idemp){
    $('#qrScheduleEnd').val('');
    $('#qrPlannedEnd').val('');
    $('#qrActualEnd').val('');
    $('#qrMinutes').val('');
    return;
  }

  $.post('extras_api.php', {action:'qr_get', idempleado:idemp, fecha:fecha}, function(r){
    if(!r || !r.ok){ return; }

    if(!r.has){
      setQrState('OPEN');
      // schedule_end dejamos vacío (lo puede setear manual)
      $('#qrPlannedEnd').val('');
      $('#qrActualEnd').val('');
      $('#qrMinutes').val('0');
      $('#qrAlert').hide();
      $('#qrPlannedEnd').removeClass('planned-red');
      return;
    }

    setQrState(r.state || 'OPEN');
    $('#qrScheduleEnd').val(r.schedule_end || '');
    $('#qrPlannedEnd').val(r.planned_end || '');
    $('#qrActualEnd').val(r.actual_end || '');
    $('#qrMinutes').val(parseInt(r.minutes||0,10));

    if((r.state||'')==='PLANNED'){
      $('#qrAlert').show();
      $('#qrPlannedEnd').addClass('planned-red');
    }else{
      $('#qrAlert').hide();
      $('#qrPlannedEnd').removeClass('planned-red');
    }

    // si hay actual_end, alinear horas arriba en vivo
    if(r.actual_end && r.schedule_end){
      const mins = minDiff(r.schedule_end, r.actual_end);
      const hours = roundHalfHoursFromMinutes(mins);
      $('#qrMinutes').val(mins);
      $('#dlgHoras').val(hours.toFixed(2));
      $('#dlgFactor').val('1.5');
    }
  }, 'json');
}

let qrLiveHooked = false;
function hookQrLive(){
  if(qrLiveHooked) return;
  qrLiveHooked = true;

  function recalcFromTimes(){
    const sched = ($('#qrScheduleEnd').val()||'').trim();
    const act   = ($('#qrActualEnd').val()||'').trim();

    // si no hay cierre real, no tocar horas arriba
    if(!sched || !act){
      // si queda planned y sin actual, alert + rojo
      const planned = ($('#qrPlannedEnd').val()||'').trim();
      if(planned && !act){
        setQrState('PLANNED');
        $('#qrAlert').show();
        $('#qrPlannedEnd').addClass('planned-red');
      }
      return;
    }

    const mins = minDiff(sched, act);
    $('#qrMinutes').val(mins);

    const hours = roundHalfHoursFromMinutes(mins);
    // reflejar en el modal (arriba)
    $('#dlgHoras').val(hours.toFixed(2));
    $('#dlgFactor').val('1.5');

    // estado CLOSED
    setQrState('CLOSED');
    $('#qrAlert').hide();
    $('#qrPlannedEnd').removeClass('planned-red');
  }

  function recalcFromMinutes(){
    const mins = parseInt($('#qrMinutes').val()||'0',10);
    const hours = roundHalfHoursFromMinutes(mins);
    $('#dlgHoras').val(hours.toFixed(2));
    $('#dlgFactor').val('1.5');
  }

  // cuando cambie el reloj del cierre real, recalcular TODO
  $('#qrActualEnd').on('input change', recalcFromTimes);
  $('#qrScheduleEnd').on('input change', recalcFromTimes);

  // si cambian minutos manualmente, recalcular horas arriba
  $('#qrMinutes').on('input change', recalcFromMinutes);

  // si ponen planned y no actual -> rojo + alerta
  $('#qrPlannedEnd').on('input change', function(){
    const planned = ($('#qrPlannedEnd').val()||'').trim();
    const act = ($('#qrActualEnd').val()||'').trim();
    if(planned && !act){
      setQrState('PLANNED');
      $('#qrAlert').show();
      $('#qrPlannedEnd').addClass('planned-red');
    }else{
      $('#qrAlert').hide();
      $('#qrPlannedEnd').removeClass('planned-red');
    }
  });
}

/* ===== Go ===== */
$('#btnCargar').on('click', loadCalendar);
</script>

<?php include __DIR__.'/view/footer.html'; ?>
