<?php
// rrhh_home/empleado_panel.php
// Panel del Empleado: resumen mensual (salario, extras, deducciones, cargas, PROVISIONES)
// PHP 8.1.33 – UTF-8

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) { header("Location:index.html"); exit; }
$ES_SUPER = isset($_SESSION["superadmin"]) && $_SESSION["superadmin"] === "S";

require_once __DIR__ . '/dbcon.php';
mysqli_set_charset($con,'utf8mb4');

/* ===== Empleados para selector ===== */
$empleados=[];
$rs = mysqli_query($con,"SELECT id, nombre_completo, cedula, categoria, COALESCE(salario_bruto,0) salario_bruto
                         FROM empleados_planilla ORDER BY nombre_completo ASC");
if($rs){ while($r=mysqli_fetch_assoc($rs)) $empleados[]=$r; mysqli_free_result($rs); }

/* ===== Parámetros entrada ===== */
$idempleado = isset($_GET['idempleado']) ? (int)$_GET['idempleado'] : (count($empleados)? (int)$empleados[0]['id'] : 0);
$MES_DEF = date('Y-m');
$mes = isset($_GET['mes']) && preg_match('/^\d{4}\-\d{2}$/', $_GET['mes']) ? $_GET['mes'] : $MES_DEF;

/* ===== Datos empleado seleccionado ===== */
$emp = ['id'=>0,'nombre'=>'','cedula'=>'','categoria'=>'','salario_bruto'=>0.0];
if($idempleado>0){
  if($st=mysqli_prepare($con,"SELECT id, nombre_completo, cedula, categoria, COALESCE(salario_bruto,0)
                              FROM empleados_planilla WHERE id=?")){
    mysqli_stmt_bind_param($st,'i',$idempleado);
    mysqli_stmt_execute($st);
    mysqli_stmt_bind_result($st,$i,$n,$c,$cat,$sb);
    if(mysqli_stmt_fetch($st)){
      $emp=['id'=>$i,'nombre'=>$n,'cedula'=>$c,'categoria'=>$cat,'salario_bruto'=>(float)$sb];
    }
    mysqli_stmt_close($st);
  }
}

/* ===== Cálculo horas extra del mes ===== */
$totHoras = ['h15'=>0.0,'h20'=>0.0,'h30'=>0.0,'hTot'=>0.0];
if($idempleado>0){
  $q="SELECT
         COALESCE(SUM(CASE WHEN d.factor=1.5 THEN d.horas ELSE 0 END),0) h15,
         COALESCE(SUM(CASE WHEN d.factor=2.0 THEN d.horas ELSE 0 END),0) h20,
         COALESCE(SUM(CASE WHEN d.factor=3.0 THEN d.horas ELSE 0 END),0) h30,
         COALESCE(SUM(d.horas),0) hTot
      FROM extras_detalle d
      INNER JOIN extras_mes m ON m.id=d.id_extras_mes
      WHERE m.idempleado=? AND m.mes=?";
  if($st=mysqli_prepare($con,$q)){
    mysqli_stmt_bind_param($st,'is',$idempleado,$mes);
    mysqli_stmt_execute($st);
    mysqli_stmt_bind_result($st,$a,$b,$c,$t);
    if(mysqli_stmt_fetch($st)) $totHoras=['h15'=>(float)$a,'h20'=>(float)$b,'h30'=>(float)$c,'hTot'=>(float)$t];
    mysqli_stmt_close($st);
  }
}

/* ===== Regla de factores (por si los cambiaste en payroll_legal_rules) ===== */
$rules = ['factor_overtime'=>1.5,'factor_holiday'=>2.0,'factor_custom'=>3.0];
$rs = mysqli_query($con,"SELECT factor_overtime,factor_holiday,factor_custom FROM payroll_legal_rules WHERE activo=1 ORDER BY id DESC LIMIT 1");
if($rs && ($r=mysqli_fetch_assoc($rs))){
  $rules['factor_overtime'] = (float)$r['factor_overtime'];
  $rules['factor_holiday']  = (float)$r['factor_holiday'];
  $rules['factor_custom']   = (float)$r['factor_custom'];
  mysqli_free_result($rs);
}

/* ===== Pref para salario-hora ===== */
$pref=['horas_dia'=>8.0,'dias_mes'=>30.0];
$rs = mysqli_query($con,"SELECT horas_dia, dias_mes FROM payroll_pref WHERE activo=1 ORDER BY id DESC LIMIT 1");
if($rs && ($r=mysqli_fetch_assoc($rs))){ $pref=['horas_dia'=>(float)$r['horas_dia'],'dias_mes'=>(float)$r['dias_mes']]; mysqli_free_result($rs); }
$salario_hora = ($pref['horas_dia']>0 && $pref['dias_mes']>0) ? ($emp['salario_bruto']/($pref['horas_dia']*$pref['dias_mes'])) : 0.0;

/* ===== Montos de horas extra ===== */
$m15 = $totHoras['h15']*$salario_hora*$rules['factor_overtime'];
$m20 = $totHoras['h20']*$salario_hora*$rules['factor_holiday'];
$m30 = $totHoras['h30']*$salario_hora*$rules['factor_custom'];
$mTot= $m15+$m20+$m30;

/* ===== Tasas (empleado/patrono) del set activo ===== */
$set_id=0;
$rs = mysqli_query($con,"SELECT id FROM payroll_legal_set WHERE activo=1 ORDER BY id DESC LIMIT 1");
if($rs && ($r=mysqli_fetch_assoc($rs))){ $set_id=(int)$r['id']; mysqli_free_result($rs); }

$tasasEmp=[]; $tasasPat=[];
if($set_id>0){
  $rs = mysqli_query($con,"SELECT side, code, nombre, pct FROM payroll_legal_rate WHERE set_id={$set_id} ORDER BY id ASC");
  if($rs){
    while($r=mysqli_fetch_assoc($rs)){
      $row=['code'=>$r['code'],'nombre'=>$r['nombre'],'pct'=>(float)$r['pct']];
      if($r['side']==='EMPLOYEE') $tasasEmp[]=$row; else if($r['side']==='EMPLOYER') $tasasPat[]=$row;
    }
    mysqli_free_result($rs);
  }
}

/* ===== Provisiones del set activo ===== */
$prov = ['aguinaldo'=>8.3333,'vacaciones'=>4.1667,'cesantia'=>5.3333,'preaviso'=>3.3333];
if($set_id>0){
  $rs = mysqli_query($con,"SELECT prov_aguinaldo_pct,prov_vacaciones_pct,prov_cesantia_pct,prov_preaviso_pct
                           FROM payroll_legal_set WHERE id={$set_id}");
  if($rs && ($r=mysqli_fetch_assoc($rs))){
    $prov = [
      'aguinaldo'=>(float)$r['prov_aguinaldo_pct'],
      'vacaciones'=>(float)$r['prov_vacaciones_pct'],
      'cesantia'=>(float)$r['prov_cesantia_pct'],
      'preaviso'=>(float)$r['prov_preaviso_pct']
    ];
    mysqli_free_result($rs);
  }
}

/* ===== Cálculos base: salario bruto del mes ===== */
$salario_bruto = (float)$emp['salario_bruto'];
$baseEmpleado   = $salario_bruto; // base para deducciones empleado (simple)
$basePatrono    = $salario_bruto; // base cargas patrono (simple)

/* ===== Deducciones empleado ===== */
$dedRows=[]; $dedTotal=0.0;
foreach($tasasEmp as $t){
  $m = $baseEmpleado * ($t['pct']/100.0);
  $dedRows[]=['nombre'=>$t['nombre'],'pct'=>$t['pct'],'monto'=>$m];
  $dedTotal += $m;
}

/* ===== Cargas patronales ===== */
$carRows=[]; $carTotal=0.0;
foreach($tasasPat as $t){
  $m = $basePatrono * ($t['pct']/100.0);
  $carRows[]=['nombre'=>$t['nombre'],'pct'=>$t['pct'],'monto'=>$m];
  $carTotal += $m;
}

/* ===== Provisiones (sobre salario bruto) ===== */
$prAgu = $salario_bruto*($prov['aguinaldo']/100.0);
$prVac = $salario_bruto*($prov['vacaciones']/100.0);
$prCes = $salario_bruto*($prov['cesantia']/100.0);
$prPre = $salario_bruto*($prov['preaviso']/100.0);
$prTot = $prAgu+$prVac+$prCes+$prPre;

/* ===== Neto estimado (simplificado): bruto - deducciones + extras ===== */
$netoEstimado = $salario_bruto - $dedTotal + $mTot;

/* ===== Costo patrono (simplificado): bruto + cargas patronales + provisiones + extras ===== */
$costoPatrono = $salario_bruto + $carTotal + $prTot + $mTot;

/* ===== Header ===== */
if (!$ES_SUPER) include __DIR__ . '/view/header.php';
else            include __DIR__ . '/view/headeradmin.html';
?>
<script>
  $('#payroll_control').addClass("treeview active");
  $('#payroll_control_2').addClass("treeview active");
</script>

<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet"/>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

<div class="box">
  <div class="box-header with-border">
    <h3 class="box-title">Panel del Empleado (Resumen Mensual)</h3>
  </div>
  <div class="box-body">

    <form class="row" method="get" action="empleado_panel.php" style="margin-bottom:12px">
      <div class="col-md-6">
        <label>Empleado</label>
        <select name="idempleado" id="empleado" class="form-control select2" style="width:100%">
          <?php foreach($empleados as $e): ?>
            <option value="<?= (int)$e['id'] ?>" <?= ((int)$e['id']===$idempleado?'selected':'') ?>>
              <?= htmlspecialchars($e['nombre_completo']) ?> - <?= htmlspecialchars($e['cedula']) ?> (<?= htmlspecialchars($e['categoria']) ?>)
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <label>Mes</label>
        <div class="input-group">
          <input type="month" name="mes" class="form-control" value="<?= htmlspecialchars($mes) ?>">
          <span class="input-group-btn"><button class="btn btn-primary" style="min-width:140px">Cargar resumen</button></span>
        </div>
      </div>
      <div class="col-md-3">
        <label>&nbsp;</label><br>
        <a href="planilla_home.php" class="btn btn-default">Ir a Home/Polilla</a>
        <a href="legal_config.php" class="btn btn-warning">Editar reglas y porcentajes</a>
      </div>
    </form>

    <!-- KPIs -->
    <div class="row">
      <div class="col-md-4">
        <div class="small-box bg-aqua">
          <div class="inner"><h3>₡<?= number_format($salario_bruto,2) ?></h3><p>Salario bruto</p></div>
          <div class="icon"><i class="fa fa-money"></i></div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="small-box bg-green">
          <div class="inner"><h3>₡<?= number_format($netoEstimado,2) ?></h3><p>Neto estimado</p></div>
          <div class="icon"><i class="fa fa-calculator"></i></div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="small-box bg-yellow">
          <div class="inner"><h3>₡<?= number_format($costoPatrono,2) ?></h3><p>Costo patrono</p></div>
          <div class="icon"><i class="fa fa-briefcase"></i></div>
        </div>
      </div>
    </div>

    <!-- Detalle empleado -->
    <div class="box">
      <div class="box-header with-border"><h3 class="box-title">Detalle del empleado</h3></div>
      <div class="box-body">
        <p style="margin:0"><b><?= htmlspecialchars($emp['nombre']) ?></b> — <?= htmlspecialchars($emp['categoria']) ?></p>
        <p style="margin:0">Cédula: <?= htmlspecialchars($emp['cedula']) ?></p>
        <p style="margin:0">Salario bruto: <b>₡<?= number_format($salario_bruto,2) ?></b></p>
        <p style="margin:0">Salario hora (pref): <b>₡<?= number_format($salario_hora,2) ?></b></p>
      </div>
    </div>

    <div class="row">
      <!-- Deducciones empleado -->
      <div class="col-md-6">
        <div class="box">
          <div class="box-header with-border"><h3 class="box-title">Cargas sociales y deducciones (Empleado)</h3></div>
          <div class="box-body">
            <table class="table table-bordered table-condensed">
              <thead><tr><th>Concepto</th><th class="text-right">% </th><th class="text-right">Monto</th></tr></thead>
              <tbody>
                <?php foreach($dedRows as $r): ?>
                  <tr><td><?= htmlspecialchars($r['nombre']) ?></td><td class="text-right"><?= number_format($r['pct'],2) ?>%</td><td class="text-right">₡<?= number_format($r['monto'],2) ?></td></tr>
                <?php endforeach; ?>
              </tbody>
              <tfoot>
                <tr class="info"><th>Total</th><th></th><th class="text-right">₡<?= number_format($dedTotal,2) ?></th></tr>
              </tfoot>
            </table>
            <div class="help">Base deducible considerada: salario bruto mensual.</div>
          </div>
        </div>
      </div>

      <!-- Cargas patronales -->
      <div class="col-md-6">
        <div class="box">
          <div class="box-header with-border"><h3 class="box-title">Cargas patronales</h3></div>
          <div class="box-body">
            <table class="table table-bordered table-condensed">
              <thead><tr><th>Concepto</th><th class="text-right">% </th><th class="text-right">Monto</th></tr></thead>
              <tbody>
                <?php foreach($carRows as $r): ?>
                  <tr><td><?= htmlspecialchars($r['nombre']) ?></td><td class="text-right"><?= number_format($r['pct'],2) ?>%</td><td class="text-right">₡<?= number_format($r['monto'],2) ?></td></tr>
                <?php endforeach; ?>
              </tbody>
              <tfoot>
                <tr class="info"><th>Total</th><th></th><th class="text-right">₡<?= number_format($carTotal,2) ?></th></tr>
              </tfoot>
            </table>
            <div class="help">Base considerada: salario bruto mensual.</div>
          </div>
        </div>
      </div>
    </div>

    <!-- Horas extra del mes -->
    <div class="box">
      <div class="box-header with-border"><h3 class="box-title">Horas extra del mes</h3></div>
      <div class="box-body">
        <table class="table table-bordered table-condensed">
          <thead><tr><th>Factor</th><th>Horas</th><th class="text-right">Monto</th></tr></thead>
          <tbody>
            <tr><td>1.5x</td><td><?= number_format($totHoras['h15'],2) ?></td><td class="text-right">₡<?= number_format($m15,2) ?></td></tr>
            <tr><td>2.0x</td><td><?= number_format($totHoras['h20'],2) ?></td><td class="text-right">₡<?= number_format($m20,2) ?></td></tr>
            <tr><td>3.0x</td><td><?= number_format($totHoras['h30'],2) ?></td><td class="text-right">₡<?= number_format($m30,2) ?></td></tr>
          </tbody>
          <tfoot>
            <tr class="info"><th>Total</th><th><?= number_format($totHoras['hTot'],2) ?></th><th class="text-right">₡<?= number_format($mTot,2) ?></th></tr>
          </tfoot>
        </table>
        <div class="help">Reglas: OT=<?= number_format($rules['factor_overtime'],2) ?>· Feriado=<?= number_format($rules['factor_holiday'],2) ?>· Custom=<?= number_format($rules['factor_custom'],2) ?></div>
      </div>
    </div>

    <!-- PROVISIONES -->
    <div class="box">
      <div class="box-header with-border"><h3 class="box-title">Reservas / Provisiones (mensual)</h3></div>
      <div class="box-body">
        <table class="table table-bordered table-condensed">
          <thead><tr><th>Concepto</th><th class="text-right">% (set activo)</th><th class="text-right">Monto</th></tr></thead>
          <tbody>
            <tr><td>Aguinaldo</td><td class="text-right"><?= number_format($prov['aguinaldo'],4) ?>%</td><td class="text-right">₡<?= number_format($prAgu,2) ?></td></tr>
            <tr><td>Vacaciones</td><td class="text-right"><?= number_format($prov['vacaciones'],4) ?>%</td><td class="text-right">₡<?= number_format($prVac,2) ?></td></tr>
            <tr><td>Cesantía (provisión)</td><td class="text-right"><?= number_format($prov['cesantia'],4) ?>%</td><td class="text-right">₡<?= number_format($prCes,2) ?></td></tr>
            <tr><td>Preaviso (provisión)</td><td class="text-right"><?= number_format($prov['preaviso'],4) ?>%</td><td class="text-right">₡<?= number_format($prPre,2) ?></td></tr>
          </tbody>
          <tfoot>
            <tr class="info"><th>Total provisiones</th><th></th><th class="text-right">₡<?= number_format($prTot,2) ?></th></tr>
          </tfoot>
        </table>
        <p class="help">Base: salario bruto mensual. Ajusta porcentajes en <a href="legal_config.php">Configuración legal</a>.</p>
      </div>
    </div>

  </div>
</div>

<script>
$('.select2').select2({width:'100%'});
</script>

<?php include __DIR__ . '/view/footer.html'; ?>
