<?php
require_once __DIR__.'/../templates/header.php';
require_once __DIR__.'/../includes/auth.php';
require_login_plano();
$sector_id = isset($_GET['sector_id']) ? (int)$_GET['sector_id'] : 0;
$type = 'electrical';
?>
<div class="pl-card">
  <h2>Editor Eléctrico</h2>
  <p class="note">MVP: administra metadatos del sector (acometida) y permite pegar SVG/JSON para guardar/versión. Próximas iteraciones: editor visual con símbolos/cableado.</p>
  <div class="pl-row">
    <div class="pl-col">
      <h3>Metadatos (solo lectura)</h3>
      <div id="meta" class="note">Cargando metadatos del sector…</div>
      <h3 style="margin-top:14px;">Circuitos del sector</h3>
      <div id="circuits" class="note">Cargando circuitos…</div>
    </div>
    <div class="pl-col">
      <h3>SVG actual (publicado)</h3>
      <div id="svg-view" class="svg-view">Cargando plano…</div>
      <div class="pl-bar">
        <button class="btn" onclick="reloadPlan()">Recargar</button>
      </div>
    </div>
  </div>
</div>

<div class="pl-card">
  <h3>Nueva versión</h3>
  <form id="form-elec" class="pl-row" onsubmit="return false;">
    <input type="hidden" name="type" value="electrical">
    <div class="pl-col">
      <label>Sector ID</label>
      <input type="number" name="sector_id" value="<?php echo $sector_id; ?>" required>
      <label>Notas</label>
      <input type="text" name="notes" placeholder="Notas del cambio (opcional)">
      <label>JSON (escena)</label>
      <textarea name="json" rows="10" placeholder='{"objects": []}'></textarea>
      <label>SVG</label>
      <textarea name="svg" rows="10" placeholder="<svg>...</svg>"></textarea>
      <div class="pl-bar">
        <button class="btn primary" onclick="doSave()">Guardar nueva versión</button>
      </div>
      <div id="save-resp" class="note"></div>
    </div>
  </form>
</div>

<script src="/modulo_plano/assets/js/embeddable_viewer.js"></script>
<script src="/modulo_plano/assets/js/versioning.js"></script>
<script>
const sectorId = <?php echo (int)$sector_id; ?>;
async function loadMeta(){
  const r = await fetch('/modulo_plano/ajax/sector_meta.php?sector_id='+sectorId);
  const data = await r.json();
  const acom = (data.meta && data.meta.acometidas && data.meta.acometidas.length) ? data.meta.acometidas.join(', ') : '(sin datos)';
  document.getElementById('meta').innerHTML =
    `<div><strong>Sector:</strong> ${data.meta.codigo||''} ${data.meta.nombre||''}</div>
     <div><strong>Acometida(s):</strong> ${acom}</div>
     <div><strong>Ancho x Largo x Alto:</strong> ${data.meta.ancho_m||'?'} m × ${data.meta.largo_m||'?'} m × ${data.meta.alto_m||'?'} m</div>`;
}
async function loadCircuits(){
  const r = await fetch('/modulo_plano/ajax/elec_circuits_by_sector.php?sector_id='+sectorId);
  const data = await r.json();
  if (data.ok && data.items && data.items.length){
    document.getElementById('circuits').innerHTML =
      '<ul>'+data.items.map(i=>`<li>Tablero ${i.tablero}: Circuito ${i.circuito}</li>`).join('')+'</ul>';
  } else {
    document.getElementById('circuits').innerHTML = '<span class="err">No se encontraron circuitos asociados a este sector.</span>';
  }
}
async function reloadPlan(){
  await loadPlanInto('svg-view', sectorId, 'electrical');
}
async function doSave(){
  const f = document.getElementById('form-elec');
  const fd = new FormData(f);
  const r = await savePlan(fd);
  document.getElementById('save-resp').innerText = r.ok ? 'Guardado OK (v'+r.version+')' : ('Error: '+(r.err||'desconocido'));
  if (r.ok) reloadPlan();
}
loadMeta(); loadCircuits(); reloadPlan();
</script>
<?php require_once __DIR__.'/../templates/footer.php'; ?>
