<?php
require_once __DIR__.'/../templates/header.php';
require_once __DIR__.'/../includes/auth.php';
require_login_plano();
$sector_id = isset($_GET['sector_id']) ? (int)$_GET['sector_id'] : 0;
?>
<div class="pl-card">
  <h2>Editor Arquitectónico</h2>
  <p class="note">MVP: pega SVG/JSON manualmente para pruebas. Próximas iteraciones añaden herramientas de muros/cotas.</p>
  <form id="form-arch" class="pl-row" onsubmit="return false;">
    <input type="hidden" name="type" value="architectural">
    <div class="pl-col">
      <label>Sector ID</label>
      <input type="number" name="sector_id" value="<?php echo $sector_id; ?>" required>
      <label>Notas</label>
      <input type="text" name="notes" placeholder="Notas del cambio (opcional)">
      <label>JSON (escena)</label>
      <textarea name="json" rows="12" placeholder='{{}}'></textarea>
      <label>SVG</label>
      <textarea name="svg" rows="12" placeholder="<svg>...</svg>"></textarea>
      <div class="pl-bar">
        <button class="btn primary" onclick="doSave('architectural')">Guardar nueva versión</button>
      </div>
      <div id="save-resp" class="note"></div>
    </div>
  </form>
</div>
<script src="/modulo_plano/assets/js/versioning.js"></script>
<script>
async function doSave(type){
  const f = document.getElementById('form-arch');
  const fd = new FormData(f);
  fd.set('type', type);
  const r = await savePlan(fd);
  document.getElementById('save-resp').innerText = r.ok ? 'Guardado OK (v'+r.version+')' : ('Error: '+(r.err||'desconocido'));
}
</script>
<?php require_once __DIR__.'/../templates/footer.php'; ?>
