<?php
require_once __DIR__.'/../templates/header.php';
require_once __DIR__.'/../includes/auth.php';
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/helpers.php';
require_login_plano();
$sector_id = isset($_GET['sector_id']) ? (int)$_GET['sector_id'] : 0;
$type = $_GET['type'] ?? 'electrical';
$rs = mysqli_query($con, "SELECT id,version,status,updated_by,updated_at,notes FROM sector_plan WHERE sector_id={$sector_id} AND type='".mysqli_real_escape_string($con,$type)."' ORDER BY version DESC");
?>
<div class="pl-card">
  <h2>Versiones del plano (sector <?php echo (int)$sector_id; ?>, tipo <?php echo esc($type); ?>)</h2>
  <table border="1" cellpadding="6" cellspacing="0">
    <tr><th>Versión</th><th>Status</th><th>Usuario</th><th>Fecha</th><th>Notas</th><th>Acciones</th></tr>
    <?php if($rs && mysqli_num_rows($rs)): while($r=mysqli_fetch_assoc($rs)): ?>
      <tr>
        <td><?php echo (int)$r['version']; ?></td>
        <td><?php echo esc($r['status']); ?></td>
        <td><?php echo esc($r['updated_by']); ?></td>
        <td><?php echo esc($r['updated_at']); ?></td>
        <td><?php echo esc($r['notes']); ?></td>
        <td>
          <form method="post" action="/modulo_plano/ajax/plan_publish.php" style="display:inline;">
            <input type="hidden" name="sector_id" value="<?php echo $sector_id; ?>">
            <input type="hidden" name="type" value="<?php echo esc($type); ?>">
            <input type="hidden" name="version" value="<?php echo (int)$r['version']; ?>">
            <button class="btn">Publicar</button>
          </form>
          <form method="post" action="/modulo_plano/ajax/plan_revert.php" style="display:inline;">
            <input type="hidden" name="sector_id" value="<?php echo $sector_id; ?>">
            <input type="hidden" name="type" value="<?php echo esc($type); ?>">
            <input type="hidden" name="version" value="<?php echo (int)$r['version']; ?>">
            <button class="btn">Revertir</button>
          </form>
        </td>
      </tr>
    <?php endwhile; else: ?>
      <tr><td colspan="6">Sin versiones aún.</td></tr>
    <?php endif; ?>
  </table>
</div>
<?php require_once __DIR__.'/../templates/footer.php'; ?>
