<?php
session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) {
    header("Location:index.html");
    exit;
}

include "view/header.php";
include "dbcon.php";

$id = intval($_GET['id']);

// EMPLEADO
$qEmp = mysqli_query($con, "SELECT * FROM empleado WHERE idempleado='$id' LIMIT 1");
$emp = mysqli_fetch_assoc($qEmp);

// USUARIO ASOCIADO
$qUser = mysqli_query($con, "SELECT * FROM usuario WHERE idempleado='$id' LIMIT 1");
$user = mysqli_fetch_assoc($qUser);
?>

<script>
  $('#payroll_control').addClass("treeview active");
  $('#payroll_control_2').addClass("treeview active");
  $('#payroll_control_2_2').addClass("active");
</script>

<div class="box">
  <div class="box-header with-border">
    <h3 class="box-title">Editar empleado</h3>
  </div>

  <div class="box-body">
    <form method="POST" action="update_empleado.php" enctype="multipart/form-data" class="form-horizontal">

      <input type="hidden" name="idempleado" value="<?= $emp['idempleado'] ?>">
      <input type="hidden" name="idusuario" value="<?= $user['idusuario'] ?>">

      <!-- USUARIO -->
      <div class="row">
        <div class="col-md-3"><label>Usuario</label></div>
        <div class="col-md-5">
          <input type="text" name="login" class="form-control" value="<?= $user['usuario'] ?>" required>
        </div>
      </div><br>

      <div class="row">
        <div class="col-md-3"><label>Nueva clave</label></div>
        <div class="col-md-5">
          <input type="password" name="clave" class="form-control">
          <small class="text-muted">Dejar en blanco para no cambiar</small>
        </div>
      </div><br>

      <!-- DATOS PERSONALES -->
      <div class="row">
        <div class="col-md-3"><label>Nombre</label></div>
        <div class="col-md-5">
          <input type="text" name="nombre" class="form-control" value="<?= $emp['nombre'] ?>" required>
        </div>
      </div><br>

      <div class="row">
        <div class="col-md-3"><label>Apellidos</label></div>
        <div class="col-md-5">
          <input type="text" name="apellidos" class="form-control" value="<?= $emp['apellidos'] ?>" required>
        </div>
      </div><br>

      <div class="row">
        <div class="col-md-3"><label>Tipo documento</label></div>
        <div class="col-md-5">
          <select name="tipo_documento" class="form-control" required>
            <option value="Cedula" <?= $emp['tipo_documento']=='Cedula'?'selected':'' ?>>Cédula</option>
            <option value="Dni" <?= $emp['tipo_documento']=='Dni'?'selected':'' ?>>DNI</option>
            <option value="Pasaporte" <?= $emp['tipo_documento']=='Pasaporte'?'selected':'' ?>>Pasaporte</option>
            <option value="Residencia" <?= $emp['tipo_documento']=='Residencia'?'selected':'' ?>>Residencia</option>
          </select>
        </div>
      </div><br>

      <div class="row">
        <div class="col-md-3"><label>Número documento</label></div>
        <div class="col-md-5">
          <input type="text" name="num_documento" class="form-control" value="<?= $emp['num_documento'] ?>" required>
        </div>
      </div><br>

      <div class="row">
        <div class="col-md-3"><label>Email</label></div>
        <div class="col-md-5">
          <input type="email" name="email" class="form-control" value="<?= $emp['email'] ?>">
        </div>
      </div><br>

      <div class="row">
        <div class="col-md-3"><label>Teléfono</label></div>
        <div class="col-md-5">
          <input type="text" name="telefono" class="form-control" value="<?= $emp['telefono'] ?>">
        </div>
      </div><br>

      <!-- FOTO -->
      <div class="row">
        <div class="col-md-3"><label>Foto</label></div>
        <div class="col-md-5">
          <input type="file" name="foto" class="form-control" onchange="previewImg(this)">
          <br>
          <img id="preview" src="<?= $emp['foto'] ?: 'Files/sin_imagen.png' ?>" style="width:120px;border-radius:50%;">
          <input type="hidden" name="foto_actual" value="<?= $emp['foto'] ?>">
        </div>
      </div><br>

      <hr>

      <div class="row">
        <div class="col-md-3"></div>
        <div class="col-md-5">
          <button type="submit" class="btn btn-primary">Actualizar</button>
          <a href="consulta_empleados.php" class="btn btn-default">Cancelar</a>
        </div>
      </div>

    </form>
  </div>
</div>

<script>
function previewImg(input){
  if(input.files && input.files[0]){
    let reader = new FileReader();
    reader.onload = e => document.getElementById('preview').src = e.target.result;
    reader.readAsDataURL(input.files[0]);
  }
}
</script>

<?php include "view/footer.html"; ?>
