<?php

session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) { header("Location: index.html"); exit; }

require_once __DIR__ . '/model/Documentos.php';
require_once __DIR__ . '/config/rrhh_docs_config.php';

$doc = new Documentos();

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$registro = null;
if ($id>0){
  $registro = $doc->obtenerPorId($id);
  if(!$registro) die("Registro no encontrado.");
}

include "view/header.php";
?>
<script type="text/javascript">
    
    $('#vencimiento').addClass("treeview active");

    
        $('#vencimiento2').addClass("treeview active");


</script>
<section class="content-header">
  <h1><?php echo $id>0?"Editar":"Nuevo"; ?> Documento RRHH <small>Archivo o Link</small></h1>
</section>

<section class="content">
  <div class="box box-primary">
    <div class="box-header with-border"><h3 class="box-title"><?php echo $id>0?"Editar #".$id:"Ingreso"; ?></h3></div>

    <form class="form-horizontal" method="post" action="ajax/documentos_guardar.php" enctype="multipart/form-data" id="frmDocs">
      <input type="hidden" name="id" value="<?php echo $id;?>">

      <!-- ocultos para multi-archivos -->
      <input type="hidden" name="crop_json_list" id="crop_json_list" value="[]">
      <input type="hidden" name="file_order" id="file_order" value="[]">

      <div class="box-body">
        <div class="form-group">
          <label class="col-sm-2 control-label">Fecha documento</label>
          <div class="col-sm-4">
            <input type="date" name="fecha_documento" class="form-control" required
                   value="<?php echo isset($registro['fecha_documento']) ? $registro['fecha_documento'] : ''; ?>">
          </div>
          <label class="col-sm-2 control-label">Días programados</label>
          <div class="col-sm-4">
            <input type="number" name="dias_programados" class="form-control" min="1" required
                   value="<?php echo isset($registro['dias_programados']) ? intval($registro['dias_programados']) : 30; ?>">
          </div>
        </div>

        <div class="form-group">
          <label class="col-sm-2 control-label">Descripción</label>
          <div class="col-sm-10">
            <input type="text" name="descripcion" class="form-control" maxlength="255" required
                   value="<?php echo isset($registro['descripcion']) ? htmlspecialchars($registro['descripcion'],ENT_QUOTES,'UTF-8') : ''; ?>">
          </div>
        </div>

        <!-- Categoría -->
        <div class="form-group">
          <label class="col-sm-2 control-label">Categoría</label>
          <div class="col-sm-8">
            <select name="categoria_id" id="categoria_id" class="form-control">
              <option value="">— Ninguna —</option>
              <!-- Se llena por JS -->
            </select>
          </div>
          <div class="col-sm-2">
            <a href="categorias.php" target="_blank" class="btn btn-info btn-block"><i class="fa fa-tags"></i></a>
          </div>
        </div>

        <div class="form-group">
          <label class="col-sm-2 control-label">Fecha inicio</label>
          <div class="col-sm-4">
            <input type="date" name="fecha_inicio" class="form-control" required
                   value="<?php echo isset($registro['fecha_inicio']) ? $registro['fecha_inicio'] : ''; ?>">
          </div>
          <label class="col-sm-2 control-label">Fecha vencimiento</label>
          <div class="col-sm-4">
            <input type="date" name="fecha_vencimiento" class="form-control" required
                   value="<?php echo isset($registro['fecha_vencimiento']) ? $registro['fecha_vencimiento'] : ''; ?>">
          </div>
        </div>

        <div class="alert alert-info" style="margin:10px 15px;">
          Sube <b>archivos</b> o indica <b>un link</b>. Carpeta: <code><?php echo RRHH_DOCS_DIR; ?></code><br>
          <?php if($id>0 && isset($registro['imagen1']) && $registro['imagen1']!=''): ?>
            Actual: <a href="<?php echo htmlspecialchars($registro['imagen1'],ENT_QUOTES,'UTF-8'); ?>" target="_blank">
              <?php echo htmlspecialchars($registro['imagen1'],ENT_QUOTES,'UTF-8'); ?>
            </a>
          <?php endif; ?>
        </div>

        <div class="form-group">
          <label class="col-sm-2 control-label">Archivo(s)</label>
          <div class="col-sm-10">
            <input
              type="file"
              name="archivo[]"
              id="archivo"
              class="form-control"
              accept="<?php echo '.' . str_replace(',', ',.', strtolower(RRHH_ALLOWED_EXT)); ?>"
              multiple>

            <p class="help-block">
              Permitidos: <?php echo htmlspecialchars(RRHH_ALLOWED_EXT,ENT_QUOTES,'UTF-8'); ?>.
              Máx <?php echo (int)(RRHH_MAX_SIZE/1024/1024); ?>MB por archivo.
            </p>

            <div id="filesContainer" style="margin-top:10px;"></div>
            <small class="text-muted">
              Arrastra para reordenar. Las imágenes se pueden recortar individualmente.
              Se generará un único PDF multipágina (también fusiona PDFs si subes varios).
            </small>
          </div>
        </div>

        <div class="form-group">
          <label class="col-sm-2 control-label">Link</label>
          <div class="col-sm-10"><input type="url" name="link" class="form-control" placeholder="https://..."></div>
        </div>
      </div>

      <div class="box-footer">
        <a href="documentos.php" class="btn btn-default">Cancelar</a>
        <button type="submit" class="btn btn-primary pull-right"><i class="fa fa-save"></i> Guardar</button>
      </div>
    </form>
  </div>
</section>

<?php include "view/footer.html"; ?>

<!-- CropperJS + Sortable -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css"/>
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.2/Sortable.min.js"></script>

<style>
.file-card{border:2px dashed #3c8dbc;border-radius:10px;padding:10px;margin-bottom:10px;}
.file-actions .btn{margin-right:6px}
.thumb-img{max-width:100%;max-height:360px;border-radius:6px;display:block;margin:0 auto}
.pdf-frame{width:100%;height:420px;border:0;border-radius:6px;display:none}
.drag-handle{cursor:grab;color:#3c8dbc;margin-right:6px}
.btn-mini{padding:6px 10px;}
</style>

<script>
// ====== Cargar categorías por AJAX y marcar la actual ======
$(function(){
  var sel = $('#categoria_id');
  var current = <?php echo (isset($registro['categoria_id']) && $registro['categoria_id']!=='') ? (int)$registro['categoria_id'] : 0; ?>;

  $.getJSON('ajax/categorias.php?op=select')
    .done(function(items){
      // Se espera un arreglo de objetos {id, text}
      sel.find('option:not(:first)').remove();
      if (Array.isArray(items) && items.length){
        items.forEach(function(it){
          var o = $('<option>').val(it.id).text(it.text);
          if (current && Number(current) === Number(it.id)) o.prop('selected', true);
          sel.append(o);
        });
      } else {
        sel.append($('<option>').val('').text('(sin categorías)'));
      }
    })
    .fail(function(xhr){
      console.error('No se pudieron cargar categorías:', xhr.status, xhr.responseText);
      // Fallback visual para no dejar el select vacío
      if (sel.find('option').length<=1){
        sel.append($('<option>').val('').text('(error cargando categorías)'));
      }
    });
});
</script>

<script>
(function(){
  const filesState=[]; let seq=0;
  const container=document.getElementById('filesContainer');
  const input=document.getElementById('archivo');
  const sortable=new Sortable(container,{animation:150, handle:'.drag-handle', onSort:updateHiddenOrder});

  input.addEventListener('change',()=>{
    const list=Array.from(input.files||[]);
    list.forEach(f=>addFileCard(f));
    input.value='';
  });

  function addFileCard(file){
    const id='f_'+(seq++);
    const card=document.createElement('div'); card.className='file-card'; card.dataset.id=id;

    const header=document.createElement('div');
    header.innerHTML=`<span class="drag-handle"><i class="fa fa-bars"></i></span>
                      <strong>${escapeHtml(file.name)}</strong> <small>(${Math.round(file.size/1024)} KB)</small>`;

    const body=document.createElement('div');
    const actions=document.createElement('div'); actions.className='file-actions';

    const btnL=makeBtn('Rotar -90°','fa fa-undo');
    const btnR=makeBtn('Rotar +90°','fa fa-repeat');
    const btnC=makeBtn('Reset crop','fa fa-refresh');
    const btnD=makeBtn('Quitar','fa fa-trash');

    actions.appendChild(btnL);actions.appendChild(btnR);actions.appendChild(btnC);actions.appendChild(btnD);

    const media=document.createElement('div');
    const img=document.createElement('img'); img.className='thumb-img'; img.style.display='none';
    const frame=document.createElement('iframe'); frame.className='pdf-frame';

    media.appendChild(img); media.appendChild(frame);
    body.appendChild(media); body.appendChild(actions);
    card.appendChild(header); card.appendChild(body);
    container.appendChild(card);

    const item={ id, file, type:'other', cropper:null, el:card, blobUrl:null };

    const blobUrl = URL.createObjectURL(file);
    item.blobUrl = blobUrl;

    if (file.type === 'application/pdf' || /\.pdf$/i.test(file.name)){
      frame.style.display='block';
      frame.src = blobUrl;
      btnL.style.display='none'; btnR.style.display='none'; btnC.style.display='none';
      item.type='pdf';

    } else if (file.type.startsWith('image/')){
      img.style.display='block';
      img.src = blobUrl;
      const cropper=new Cropper(img,{
        viewMode:1, dragMode:'move', autoCropArea:1, movable:true,
        zoomable:true, rotatable:true, background:false, responsive:true
      });
      btnL.addEventListener('click',()=>{ cropper.rotate(-90); });
      btnR.addEventListener('click',()=>{ cropper.rotate(90); });
      btnC.addEventListener('click',()=>{ cropper.reset(); });
      item.type='image';
      item.cropper=cropper;

    } else {
      frame.style.display='none'; img.style.display='none';
      btnL.style.display='none'; btnR.style.display='none'; btnC.style.display='none';
      item.type='file';
    }

    btnD.addEventListener('click',()=> removeCard(id));
    filesState.push(item);
    updateHiddenOrder();
  }

  function makeBtn(text,icon){
    const b=document.createElement('button'); b.type='button';
    b.className='btn btn-default btn-mini'; b.innerHTML=`<i class="${icon}"></i> ${text}`;
    return b;
  }

  function removeCard(id){
    const i=filesState.findIndex(x=>x.id===id);
    if(i>=0){
      const it=filesState[i];
      if(it.cropper) it.cropper.destroy();
      if(it.blobUrl){ try{ URL.revokeObjectURL(it.blobUrl); }catch(e){} }
      it.el.remove();
      filesState.splice(i,1);
      updateHiddenOrder();
    }
  }

  function updateHiddenOrder(){
    const order=Array.from(container.children).map(ch=>ch.dataset.id);
    const idx=order.map(id=>filesState.findIndex(x=>x.id===id));
    document.getElementById('file_order').value=JSON.stringify(idx);
  }

  document.getElementById('frmDocs').addEventListener('submit', function(){
    const orderIdx=JSON.parse(document.getElementById('file_order').value||'[]');
    const dt=new DataTransfer(); const cropList=[];
    const items=(orderIdx.length>0? orderIdx.map(i=>filesState[i]) : filesState);

    for(const it of items){
      if(!it) continue;
      dt.items.add(it.file);
      if(it.type==='image' && it.cropper){
        const d=it.cropper.getData(true);
        cropList.push({
          unit:'px',
          x:Math.max(0,Math.round(d.x||0)),
          y:Math.max(0,Math.round(d.y||0)),
          width: Math.max(1,Math.round(d.width||0)),
          height:Math.max(1,Math.round(d.height||0)),
          rotate: Math.round(d.rotate||0)
        });
      }else{
        cropList.push(null);
      }
    }
    document.getElementById('archivo').files=dt.files;
    document.getElementById('crop_json_list').value=JSON.stringify(cropList);
  });

  function escapeHtml(s){return (s||'').replace(/[&<>"']/g,m=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m]));}
})();
</script>
