<?php

session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) { header("Location: index.html"); exit; }

include "view/header.php";

$esSuper = (isset($_SESSION["superadmin"]) && $_SESSION["superadmin"] === "S");
$tieneRRHH = (isset($_SESSION["permisos"]) && is_array($_SESSION["permisos"]) && in_array("RRHH", $_SESSION["permisos"]));
$puedeDescargar = ($esSuper || $tieneRRHH);
?>
<section class="content-header">
  <h1>Documentos RRHH <small>Consulta y alertas</small></h1>
</section>
<script type="text/javascript">
    
    $('#vencimiento').addClass("treeview active");

    
        $('#vencimiento1').addClass("treeview active");


</script>
<section class="content">

<!-- Filtro de categoría (Select2 con búsqueda) -->
<div class="box">
  <div class="box-body">
    <div class="form-inline" style="margin:8px 0 12px;">
      <label for="filtroCategoria" style="margin-right:8px;">Category:</label>

      <select id="filtroCategoria" class="form-control input-sm" style="min-width:280px;">
        <option value="">All</option>
      </select>

      <button id="btnCatClear" class="btn btn-default btn-sm" style="margin-left:6px;">
        Clear
      </button>

      <a href="categorias.php" class="btn btn-info btn-sm" style="margin-left:6px;">
        <i class="fa fa-tags"></i> Manage
      </a>

      <a href="documentos_form.php" class="btn btn-primary btn-sm" style="margin-left:6px;">
        <i class="fa fa-plus"></i> Nuevo
      </a>
    </div>
  </div>
</div>

<div class="box">
  <div class="box-body">
    <div class="nav-tabs-custom">
      <ul class="nav nav-tabs">
        <li class="active"><a href="#tab_all" data-toggle="tab">Todos</a></li>
        <li><a href="#tab_warn" data-toggle="tab">Por vencer</a></li>
        <?php if ($puedeDescargar): ?>
          <li><a href="#tab_dl" data-toggle="tab"><i class="fa fa-download"></i> Descargas</a></li>
        <?php endif; ?>
      </ul>

      <div class="tab-content">

        <!-- TAB: Todos -->
        <div class="tab-pane active" id="tab_all">
          <div class="table-responsive">
            <table id="tablaTodos" class="table table-striped table-hover table-condensed">
              <thead>
                <tr>
                  <th>#</th>
                  <th>Fecha doc.</th>
                  <th>Descripción</th>
                  <th>Category</th>
                  <th>Inicio</th>
                  <th>Vencimiento</th>
                  <th>Archivo</th>
                  <th>Plan (días)</th>
                  <th>Restan</th>
                  <th>Estado</th>
                  <th>Acciones</th>
                </tr>
              </thead>
              <tbody></tbody>
            </table>
          </div>
        </div>

        <!-- TAB: Por vencer -->
        <div class="tab-pane" id="tab_warn">
          <form class="form-inline" onsubmit="return false;" style="margin:10px 0 15px;">
            <div class="form-group">
              <label for="umbralGlobal">Umbral global (días):</label>
              <input type="number" id="umbralGlobal" class="form-control input-sm" placeholder="Ej. 90" min="1" style="margin-left:8px;">
            </div>
            <button id="btnAplicar" class="btn btn-primary btn-sm" style="margin-left:8px;">
              <i class="fa fa-filter"></i> Aplicar
            </button>
            <button id="btnLimpiar" class="btn btn-default btn-sm" style="margin-left:4px;">
              Limpiar
            </button>
          </form>

          <div class="table-responsive">
            <table id="tablaWarn" class="table table-striped table-hover table-condensed">
              <thead>
                <tr>
                  <th>#</th>
                  <th>Fecha doc.</th>
                  <th>Descripción</th>
                  <th>Category</th>
                  <th>Inicio</th>
                  <th>Vencimiento</th>
                  <th>Archivo</th>
                  <th>Plan (días)</th>
                  <th>Restan</th>
                  <th>Acciones</th>
                </tr>
              </thead>
              <tbody></tbody>
            </table>
          </div>
        </div>

        <!-- TAB: Descargas -->
        <?php if ($puedeDescargar): ?>
        <div class="tab-pane" id="tab_dl">
          <form id="formZip" method="post" action="ajax/documentos_zip.php" target="_blank">
            <div class="alert alert-info">
              El ZIP solo incluye archivos locales de <code>Files/documentos_rrhh/</code>.
            </div>
            <div class="table-responsive">
              <table id="tablaDL" class="table table-bordered table-condensed">
                <thead>
                  <tr>
                    <th style="width:32px;"><input type="checkbox" id="chk_all"></th>
                    <th>#</th>
                    <th>Descripción</th>
                    <th>Category</th>
                    <th>Vencimiento</th>
                    <th>Ruta/URL</th>
                  </tr>
                </thead>
                <tbody></tbody>
              </table>
            </div>
            <button id="btnZip" class="btn btn-success">
              <i class="fa fa-file-archive-o"></i> Descargar seleccionados (ZIP)
            </button>
          </form>
        </div>
        <?php endif; ?>

      </div>
    </div>
  </div>
</div>

</section>

<?php include "view/footer.html"; ?>

<script>
// ---------- CARGA DINÁMICA DE SELECT2 (por si no está en el header) ----------
(function(){
  function loadCSS(href){ var l=document.createElement('link'); l.rel='stylesheet'; l.href=href; document.head.appendChild(l); }
  function loadJS(src, cb){ var s=document.createElement('script'); s.src=src; s.onload=cb||function(){}; document.body.appendChild(s); }
  // Si no existe $.fn.select2, lo cargamos desde CDN
  var needSelect2 = !(window.jQuery && jQuery.fn && jQuery.fn.select2);
  if (needSelect2){
    loadCSS('https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css');
    loadJS('https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.full.min.js', function(){
      // listo para usar
      initPage();
    });
  } else {
    initPage();
  }

  function initPage(){

    // ---------- Helpers UI ----------
    function esURL(v){ return /^https?:\/\//i.test(v||''); }
    function renderArchivo(path){
      if(!path) return '';
      var ext = (path.split('.').pop()||'').toLowerCase();
      if(['jpg','jpeg','png','gif','webp','bmp'].indexOf(ext)>=0 && !esURL(path)){
        return '<a href="'+path+'" target="_blank"><img src="'+path+'" style="max-height:36px;border-radius:4px"></a>';
      }
      if(ext==='pdf'){
        return '<a href="'+path+'" target="_blank" class="btn btn-xs btn-default"><i class="fa fa-file-pdf-o"></i> PDF</a>';
      }
      return '<a href="'+path+'" target="_blank" class="btn btn-xs btn-default"><i class="fa fa-external-link"></i> Abrir</a>';
    }
    function acciones(row){
      var path = row.imagen1 || '';
      var ver = path ? '<a href="'+path+'" target="_blank" class="btn btn-xs btn-primary"><i class="fa fa-eye"></i> Ver</a>' : '';
      var descargar = path ? '<a href="'+path+'" download class="btn btn-xs btn-success" style="margin-left:4px;"><i class="fa fa-download"></i> Descargar</a>' : '';
      var editar = '<a href="documentos_form.php?id='+row.id+'" class="btn btn-xs btn-warning" style="margin-left:4px;"><i class="fa fa-edit"></i> Editar</a>';
      var eliminar = '<button class="btn btn-xs btn-danger btn-del" data-id="'+row.id+'" style="margin-left:4px;"><i class="fa fa-trash"></i> Eliminar</button>';
      return ver + ' ' + descargar + ' ' + editar + ' ' + eliminar;
    }
    function bindDeleteButtons(table){
      $(table.table().body()).on('click', '.btn-del', function(){
        var id = $(this).data('id');
        if(!confirm('¿Seguro que deseas eliminar el registro #'+id+'?')) return;
        $.post('ajax/documentos_eliminar.php', {id:id})
          .done(function(){
            table.ajax.reload(null,false);
            if(window.dtWarn) dtWarn.ajax.reload(null,false);
            if(window.dtDL) dtDL.ajax.reload(null,false);
          })
          .fail(function(xhr){
            alert('Error al eliminar: ' + (xhr.responseText || xhr.status));
          });
      });
    }
    function urlList(base){
      var cat = $('#filtroCategoria').val();
      return base + (cat ? ('&categoria_id=' + encodeURIComponent(cat)) : '');
    }

    // ---------- Cargar categorías y Select2 ----------
    function cargarCategorias(callback){
      $.getJSON('ajax/categorias.php?op=select', function(items){
        var $sel = $('#filtroCategoria');
        $sel.find('option:not(:first)').remove();
        $.each(items, function(i,it){
          $sel.append($('<option>').val(it.id).text(it.text));
        });

        if ($.fn.select2) {
          // Reinicializar si ya estaba
          if ($sel.hasClass('select2-hidden-accessible')) { $sel.select2('destroy'); }
          $sel.select2({
            placeholder: 'Todas las categorías',
            allowClear: true,
            width: '280px',
            language: {
              noResults: function(){ return 'Sin resultados'; },
              searching: function(){ return 'Buscando…'; }
            }
          });
        }

        if (typeof callback === 'function') callback();
      }).fail(function(){
        console.warn('No se pudieron cargar las categorías (select).');
        if (typeof callback === 'function') callback();
      });
    }

    // ---------- Inicio ----------
    $(function(){

      cargarCategorias(function(){

        // DataTable: Todos
        window.dtAll = $('#tablaTodos').DataTable({
          ajax: { url: urlList('ajax/documentos.php?op=listar'), dataSrc: 'data' },
          order: [[5,'asc']],
          columns: [
            {data:'id'},
            {data:'fecha_documento'},
            {data:'descripcion'},
            {data:'categoria', defaultContent:'', render:function(d){ return d||'<span class="text-muted">—</span>'; }},
            {data:'fecha_inicio'},
            {data:'fecha_vencimiento'},
            {data:'imagen1', render:function(d){ return renderArchivo(d);} },
            {data:'dias_programados'},
            {data:'dias_restantes'},
            {data:null, render:function(row){
              if (row.estado==='vencido') return '<span class="label label-danger">Vencido</span>';
              if (row.estado==='por_vencer') return '<span class="label label-warning">Por vencer ('+row.dias_restantes+' d)</span>';
              return '<span class="label label-success">Vigente ('+row.dias_restantes+' d)</span>';
            }},
            {data:null, orderable:false, render:function(row){ return acciones(row);} }
          ]
        });
        bindDeleteButtons(window.dtAll);

        // DataTable: Por vencer
        window.dtWarn = $('#tablaWarn').DataTable({
          ajax: { url: urlList('ajax/documentos.php?op=por_vencer'), dataSrc: 'data' },
          order:[[5,'asc']],
          columns:[
            {data:'id'},
            {data:'fecha_documento'},
            {data:'descripcion'},
            {data:'categoria', defaultContent:'', render:function(d){ return d||'<span class="text-muted">—</span>'; }},
            {data:'fecha_inicio'},
            {data:'fecha_vencimiento'},
            {data:'imagen1', render:function(d){ return renderArchivo(d);} },
            {data:'dias_programados'},
            {data:'dias_restantes'},
            {data:null, orderable:false, render:function(row){ return acciones(row);} }
          ]
        });

        // DataTable: Descargas
        window.dtDL = $('#tablaDL').DataTable({
          ajax:{ url: urlList('ajax/documentos.php?op=listar'), dataSrc:'data' },
          order:[[4,'asc']],
          columns:[
            {data:null, orderable:false, render:function(row){ return '<input type="checkbox" class="chk_doc" name="ids[]" value="'+row.id+'">'; }},
            {data:'id'},
            {data:'descripcion'},
            {data:'categoria', defaultContent:'', render:function(d){ return d||'<span class="text-muted">—</span>'; }},
            {data:'fecha_vencimiento'},
            {data:'imagen1', render:function(d){ return d?d:'<span class="text-muted">—</span>'; }}
          ]
        });

        // Eventos del filtro
        $('#filtroCategoria').on('change', function(){
          dtAll.ajax.url(urlList('ajax/documentos.php?op=listar')).load();
          dtWarn.ajax.url(urlList('ajax/documentos.php?op=por_vencer')).load();
          dtDL.ajax.url(urlList('ajax/documentos.php?op=listar')).load();
        });

        $('#btnCatClear').on('click', function(){
          if ($.fn.select2 && $('#filtroCategoria').hasClass('select2-hidden-accessible')) {
            $('#filtroCategoria').val('').trigger('change.select2');
          } else {
            $('#filtroCategoria').val('').trigger('change');
          }
        });

        // Umbral por vencer
        $('#btnAplicar').on('click', function(){
          var um = $('#umbralGlobal').val();
          var base = 'ajax/documentos.php?op=por_vencer' + (um ? ('&umbral='+encodeURIComponent(um)) : '');
          dtWarn.ajax.url(urlList(base)).load();
        });
        $('#btnLimpiar').on('click', function(){
          $('#umbralGlobal').val('');
          var base = 'ajax/documentos.php?op=por_vencer';
          dtWarn.ajax.url(urlList(base)).load();
        });

        // ZIP
        $('#chk_all').on('change', function(){ var on=$(this).is(':checked'); $('.chk_doc').prop('checked', on); });
        $('#btnZip').on('click', function(){ document.getElementById('formZip').submit(); });
      });

    }); // ready
  } // initPage
})();
</script>
