<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include('dbcon.php'); // tu conexión, define $con

$id = isset($_POST['id']) ? intval($_POST['id']) : 0;
if($id <= 0){
    echo "<p style='color:red;'>ID de empleado no válido.</p>";
    exit;
}

// Obtener datos del empleado
$sql = "SELECT * FROM empleados_planilla WHERE id = $id";
$result = mysqli_query($con, $sql);

if(!$result || mysqli_num_rows($result) == 0){
    echo "<p style='color:red;'>Empleado no encontrado.</p>";
    exit;
}

$row = mysqli_fetch_assoc($result);

// Datos básicos
$nombre = $row['nombre_completo'];
$cedula = $row['cedula'];
$categoria = $row['categoria'];



// Calcular días por tiempo trabajado
$fecha_ingreso = $row['year_ingreso'].'-'.$row['mes_ingreso'].'-'.$row['dia_ingreso'];
$fecha_actual = date('Y-m-d');

$datetime1 = new DateTime($fecha_ingreso);
$datetime2 = new DateTime($fecha_actual);
$diferencia = $datetime1->diff($datetime2);
$dias_trabajados = $diferencia->days;

// 1 día de vacaciones cada 35 días trabajados
$dias_vacaciones_base = floor($dias_trabajados / 35);

// Ajustes de sumar/restar
$dias_vacaciones_ajustado = $dias_vacaciones_base + intval($row['sumar']) - intval($row['restar']);

// Días de incapacidades
$sql_incap = "SELECT IFNULL(SUM(cantidad_dias),0) AS total FROM ingreso_inscapacidad WHERE idempleado=$id";
$res_incap = mysqli_query($con, $sql_incap);
$row_incap = mysqli_fetch_assoc($res_incap);
$dias_ins = floor($row_incap['total'] / 35);
$dias_incapacidad = intval($dias_ins);

// Días de vacaciones extra
$sql_extra = "SELECT IFNULL(SUM(cantidad_dias),0) AS total FROM ingreso_vacaciones_extra WHERE idempleado=$id";
$res_extra = mysqli_query($con, $sql_extra);
$row_extra = mysqli_fetch_assoc($res_extra);
$dias_extra = intval($row_extra['total']);

// Días de vacaciones solicitados
$sql_solicitados = "SELECT IFNULL(SUM(cantidad_dias),0) AS total FROM ingreso_vacaciones WHERE idempleado=$id";
$res_solicitados = mysqli_query($con, $sql_solicitados);
$row_solicitados = mysqli_fetch_assoc($res_solicitados);
$dias_solicitados = intval($row_solicitados['total']);

// Días disponibles finales
$dias_disponibles = max(0, $dias_vacaciones_ajustado + $dias_extra - $dias_incapacidad - $dias_solicitados);

// Cantidad de expedientes por empleados
$sql_doc = "SELECT 
    COUNT(*) AS cantidad_expedientes FROM ingreso_documentos_empleadosplanilla WHERE idempleado =$id;";
$res_doc = mysqli_query($con, $sql_doc);
$row_doc = mysqli_fetch_assoc($res_doc);
$cantidad_expedientes = intval($row_doc['cantidad_expedientes']);

// Cantidad de expedientes por empleados
$sql_doc1 = "SELECT 
    COUNT(*) AS cantidad_expedientes_g FROM ingreso_documentosgenerales_empleadosplanilla WHERE categoria='$categoria';";
$res_doc1 = mysqli_query($con, $sql_doc1);
$row_doc1 = mysqli_fetch_assoc($res_doc1);
$cantidad_expedientes_generales = intval($row_doc1['cantidad_expedientes_g']);

// Mostrar resultados con IDs para recalculo dinámico

echo "<p><b>Categoria:</b> $categoria</p>";

echo "<hr>";
echo "<p><b>Detalle histórico:</b></p>";
echo "<ul>";
echo "<li>Total de expedientes por categoria: <span id='CantidadExpedientesGenerales'>$cantidad_expedientes_generales</span></li>";
echo "</ul>";

?>
