<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include('dbcon.php'); // tu conexión, define $con

$id = isset($_POST['id']) ? intval($_POST['id']) : 0;
if($id <= 0){
    echo "<p style='color:red;'>ID de empleado no válido.</p>";
    exit;
}

// Obtener datos del empleado
$sql = "SELECT * FROM empleados_planilla WHERE id = $id";
$result = mysqli_query($con, $sql);

if(!$result || mysqli_num_rows($result) == 0){
    echo "<p style='color:red;'>Empleado no encontrado.</p>";
    exit;
}

$row = mysqli_fetch_assoc($result);

// Datos básicos
$nombre = $row['nombre_completo'];
$cedula = $row['cedula'];
$categoria = $row['categoria'];


// Calcular días por tiempo trabajado
$fecha_ingreso = $row['year_ingreso'].'-'.$row['mes_ingreso'].'-'.$row['dia_ingreso'];
$fecha_actual = date('Y-m-d');

$datetime1 = new DateTime($fecha_ingreso);
$datetime2 = new DateTime($fecha_actual);
$diferencia = $datetime1->diff($datetime2);
$dias_trabajados = $diferencia->days;

// Obtener días de incapacidad reales
$sql_incap = "SELECT IFNULL(SUM(dias_calculo),0) AS total FROM ingreso_inscapacidad WHERE idempleado=$id";
$res_incap = mysqli_query($con, $sql_incap);
$row_incap = mysqli_fetch_assoc($res_incap);
$dias_incapacidad = floatval($row_incap['total']);  // ✅ SIN dividir por 35

// Calcular base de vacaciones
$dias_vacaciones_base = round($dias_trabajados / 35.0, 6);  // ✅ Igual que en "list"
$dias_ins = round($dias_incapacidad / 30.0, 6);             // ✅ Igual que en "list"

// Ajustes sumar/restar
$dias_vacaciones_ajustado = $dias_vacaciones_base + intval($row['sumar']) - intval($row['restar']);


// Días de vacaciones extra
$sql_extra = "SELECT IFNULL(SUM(cantidad_dias),0) AS total FROM ingreso_vacaciones_extra WHERE idempleado=$id";
$res_extra = mysqli_query($con, $sql_extra);
$row_extra = mysqli_fetch_assoc($res_extra);
$dias_extra = intval($row_extra['total']);

// Días de vacaciones solicitados
$sql_solicitados = "SELECT IFNULL(SUM(cantidad_dias),0) AS total FROM ingreso_vacaciones WHERE idempleado=$id AND status='1'" ;
$res_solicitados = mysqli_query($con, $sql_solicitados);
$row_solicitados = mysqli_fetch_assoc($res_solicitados);
$dias_solicitados = intval($row_solicitados['total']);

// Días disponibles finales
$dias_disponibles = max(2, $dias_vacaciones_ajustado + $dias_extra - $dias_ins - $dias_solicitados);

// Cantidad de expedientes por empleados
$sql_doc = "SELECT 
    COUNT(*) AS cantidad_expedientes FROM ingreso_documentos_empleadosplanilla WHERE idempleado =$id;";
$res_doc = mysqli_query($con, $sql_doc);
$row_doc = mysqli_fetch_assoc($res_doc);
$cantidad_expedientes = intval($row_doc['cantidad_expedientes']);

// Cantidad de expedientes por empleados
$sql_doc1 = "SELECT 
    COUNT(*) AS cantidad_expedientes_g FROM ingreso_documentosgenerales_empleadosplanilla WHERE categoria='$categoria';";
$res_doc1 = mysqli_query($con, $sql_doc1);
$row_doc1 = mysqli_fetch_assoc($res_doc1);
$cantidad_expedientes_generales = intval($row_doc1['cantidad_expedientes_g']);

// Mostrar resultados con IDs para recalculo dinámico
echo "<p><b>Nombre:</b> $nombre</p>";
echo "<p><b>Cédula:</b> $cedula</p>";
echo "<p><b>Categoria:</b> $categoria</p>";
echo "<input type='hidden' id='categoria_empleado_oculta' value='" . htmlspecialchars($categoria, ENT_QUOTES) . "'>";


$diasVacaciones= floor ($dias_vacaciones_ajustado);
$diasIncapacidad= floor ($dias_ins);
$totalDias= floor ($dias_disponibles);



echo "<hr>";
echo "<p><b>Detalle histórico:</b></p>";
echo "<ul>";
echo "<li>Días por tiempo trabajado (ajustado): <span id='diasVacaciones' data-base='$dias_vacaciones_ajustado'>$dias_vacaciones_ajustado</span></li>";
echo "<li>Días de incapacidades: <span id='diasIncapacidad' data-base='$dias_ins'>$dias_ins</span></li>";
echo "<li>Días de vacaciones extra: <span id='diasExtra' data-base='$dias_extra'>$dias_extra</span></li>";
echo "<li>Días de vacaciones usados: <span id='diasSolicitados' data-base='$dias_solicitados'>$dias_solicitados</span></li>";
echo "<li>Total disponible: <span id='totalDias'>$dias_disponibles</span></li>";
echo "<hr>";
echo "<p><b>Detalle de expedientes:</b></p>";
echo "<li>Total de expedientes: <span id='CantidadExpedientes'>$cantidad_expedientes</span></li>";
echo "<li>Total de expedientes por categoria: <span id='CantidadExpedientesGenerales'>$cantidad_expedientes_generales</span></li>";
echo "</ul>";

?>
