<?php
// consulta_login_evidencias.php
// Evidencias de Login (GPS + Foto)
// PHP 8.1.33

session_start();
require_once __DIR__ . '/dbcon.php';

$lang = $_SESSION['lang'] ?? 'en';
header('Content-Type: text/html; charset=UTF-8');

if (!function_exists('esc')) {
  function esc($v){
    $s = (string)$v;
    if (!mb_detect_encoding($s, 'UTF-8', true)) {
      $s = @mb_convert_encoding($s, 'UTF-8', 'Windows-1252,ISO-8859-1,UTF-8') ?: $s;
    }
    return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
  }
}

date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) {
  header("Location:index.php");
  exit;
}

/**
 * ✅ IMPORTANTE:
 * Aquí NO incluimos "consulta_empleadosplanilla.php" porque eso es una pantalla completa.
 * Debemos incluir SOLO el header real del sistema (el que pinta AdminLTE + menú).
 */
if (isset($_SESSION["superadmin"]) && $_SESSION["superadmin"] === "S") {
  include "view/headeradmin.html";
} else {
  // Ajusta esto si tu header normal tiene otro nombre
  // (en muchos proyectos es view/header.html)
  include "view/header.php";
}

// charset DB
if (isset($con) && $con instanceof mysqli) {
  mysqli_set_charset($con, 'utf8mb4');
}

$sql = "
  SELECT
    le.id,
    le.idusuario,
    le.lat,
    le.lng,
    le.accuracy_m,
    le.ip,
    le.user_agent,
    le.photo_path,
    le.created_at,
    u.idempleado,
    e.nombre,
    e.apellidos
  FROM login_evidencias le
  LEFT JOIN usuario u  ON u.idusuario = le.idusuario
  LEFT JOIN empleado e ON e.idempleado = u.idempleado
  ORDER BY le.id DESC
  LIMIT 500
";

$res = mysqli_query($con, $sql);
if (!$res) {
  echo '<div class="alert alert-danger"><b>Error SQL:</b> '.esc(mysqli_error($con)).'</div>';
  echo '<pre style="white-space:pre-wrap;">'.esc($sql).'</pre>';
  include "view/footer.html";
  exit;
}
?>

<script type="text/javascript">
  // Marca el menú activo (si luego creas el botón)
  // $('#seguridad').addClass("treeview active");
  // $('#seguridad_login_evidencias').addClass("active");
</script>

<style>
  .evid-thumb{
    width:42px; height:42px; border-radius:50%;
    object-fit:cover; cursor:pointer; border:1px solid #ddd;
  }
  .evid-gps{
    display:inline-block; padding:2px 10px; border-radius:999px;
    background:#f4f4f4; border:1px solid #e0e0e0; font-size:12px;
  }
  .ua-mini{
    display:block; max-width:520px; white-space:nowrap; overflow:hidden; text-overflow:ellipsis;
    font-size:12px; color:#666;
  }
</style>

<!-- ✅ Aquí seguimos tu estructura típica -->
<div class="box-body">
  <div class="panel panel-default">
    <div class="panel-heading">
      <div class="box-header with-border">
        <h3 class="box-title">Evidencias de Login (GPS + Foto)</h3>
        <div class="box-tools pull-right">
          <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
          <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
        </div>
      </div>
    </div>

    <div class="box-body">
      <div class="table-responsive">
        <table id="tblLoginEvid" class="table table-striped table-bordered table-condensed table-hover" cellspacing="0" width="100%">
          <thead>
            <tr>
              <th width="50">#</th>
              <th width="60">ID</th>
              <th width="170">Fecha</th>
              <th width="80">IdUsuario</th>
              <th width="220">Empleado</th>
              <th width="250">GPS</th>
              <th width="130">IP</th>
              <th width="90">Foto</th>
              <th width="100">Opciones</th>
            </tr>
          </thead>
          <tbody>
          <?php
            $i = 1;
            while ($row = mysqli_fetch_assoc($res)):
              $id = (int)$row['id'];
              $idusuario = (int)$row['idusuario'];
              $created = (string)($row['created_at'] ?? '');

              $nombre = trim((string)($row['nombre'] ?? '') . ' ' . (string)($row['apellidos'] ?? ''));
              if ($nombre === '') $nombre = '-';

              $lat = $row['lat']; $lng = $row['lng']; $acc = $row['accuracy_m'];
              $gpsTxt = 'N/A'; $mapUrl = '';
              if ($lat !== null && $lng !== null && $lat !== '' && $lng !== '') {
                $gpsTxt = esc($lat).', '.esc($lng);
                if ($acc !== null && $acc !== '') $gpsTxt .= ' (±'.esc($acc).'m)';
                $mapUrl = 'https://www.google.com/maps?q=' . rawurlencode((string)$lat.','.(string)$lng);
              }

              $ip = (string)($row['ip'] ?? '');
              $ua = (string)($row['user_agent'] ?? '');
              $foto = (string)($row['photo_path'] ?? '');
          ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= $id ?></td>
              <td>
                <?= esc($created) ?>
                <?php if ($ua): ?><span class="ua-mini"><?= esc($ua) ?></span><?php endif; ?>
              </td>
              <td><?= $idusuario ?></td>
              <td><?= esc($nombre) ?></td>
              <td><span class="evid-gps"><?= $gpsTxt ?></span></td>
              <td><?= esc($ip) ?></td>
              <td class="text-center">
                <?php if ($foto): ?>
                  <img
                    src="<?= esc($foto) ?>"
                    class="evid-thumb img-evid"
                    data-imagen="<?= esc($foto) ?>"
                    onerror="this.src='Files/sin_imagen.png';"
                    alt="foto">
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
              <td class="text-center">
                <?php if ($mapUrl): ?>
                  <a class="btn btn-xs btn-info" target="_blank" href="<?= esc($mapUrl) ?>">
                    <i class="fa fa-map-marker"></i> Mapa
                  </a>
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
            </tr>
          <?php endwhile; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <!-- Modal Imagen (igual a tu estilo) -->
  <div class="modal fade" id="modalImagenGlobal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Foto evidencia</h4>
        </div>
        <div class="modal-body text-center">
          <img id="imagenModalImg" src="" style="width:100%; height:auto;" onerror="this.src='Files/sin_imagen.png'">
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
jQuery(function($){
  $(document).on('click', '.img-evid', function(){
    var src = $(this).data('imagen') || $(this).attr('src');
    $('#imagenModalImg').attr('src', src);
    $('#modalImagenGlobal').modal('show');
  });

  if ($.fn.DataTable) {
    $('#tblLoginEvid').DataTable({
      order: [[1, 'desc']],
      pageLength: 25
    });
  }
});
</script>

<?php include "view/footer.html"; ?>
