<?php
session_start();
require_once __DIR__.'/dbcon.php';

$lang = isset($_SESSION['lang']) ? $_SESSION['lang'] : 'en'; // 'es' | 'en'

// Cabecera HTTP y fallback del default_charset
header('Content-Type: text/html; charset=UTF-8');

// Helper seguro para imprimir texto (convierte a UTF-8 si hace falta)
if (!function_exists('esc')) {
  function esc($v){
    $s = (string)$v;

    // Si NO es UTF-8 válido, intenta convertir desde latin1/Win1252 a UTF-8
    if (!mb_detect_encoding($s, 'UTF-8', true)) {
      // intenta desde 1252 o ISO-8859-1; deja UTF-8 si ya lo es
      $s = @mb_convert_encoding($s, 'UTF-8', 'Windows-1252,ISO-8859-1,UTF-8') ?: $s;
    }

    // ENT_SUBSTITUTE = reemplaza cualquier secuencia inválida en vez de vaciar
    return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
  }
}
$idsucursal=0;
date_default_timezone_set('America/Costa_Rica');
$fechaactual = date('Y-m-d');
$horaactual  = date('H:i');

if(isset($_SESSION["idusuario"])){
  if ($_SESSION["superadmin"] != "S") {
    include "view/consulta/consulta_empleadosplanilla.php";

    $idusuario=$_SESSION["idusuario"];
    include('dbcon.php');

    // $branch=$_SESSION['branch'];
    $query=mysqli_query($con,"select * from global  ")or die(mysqli_error());
    $i=1;
    while($row=mysqli_fetch_array($query)){
      $tipo_moneda=$row['tipo_moneda'];
    }
    $nombre_sucursal=$_SESSION["sucursal"];
    $query=mysqli_query($con,"select * from sucursal where razon_social='$nombre_sucursal' ")or die(mysqli_error());
    $i=1;
    while($row=mysqli_fetch_array($query)){
      $idsucursal=$row['idsucursal'];
    }

    $query=mysqli_query($con,"select * from usuario where idusuario='$idusuario' ")or die(mysqli_error());
    $i=1;
    while($row=mysqli_fetch_array($query)){
      $idempleado=$row['idempleado'];
    }
    $query=mysqli_query($con,"select * from empleado where idempleado='$idempleado' ")or die(mysqli_error());
    $i=1;
    while($row=mysqli_fetch_array($query)){
      $nombre=$row['nombre'];
      $apellidos=$row['apellidos'];
    }
    $query=mysqli_query($con, "SELECT COUNT(*) total FROM articulo where fecha='$fechaactual' and estatus='abierto' ")or die(mysqli_error());
    $i=1;
    while($row=mysqli_fetch_array($query)){
      $cantidadfila=$row['total'];
    }
    $query=mysqli_query($con, "SELECT COUNT(*) total FROM articulo where fecha='$fechaactual' and estatus='suspendido' ")or die(mysqli_error());
    $i=1;
    while($row2=mysqli_fetch_array($query)){
      $cantidadfila2=$row2['total'];
    }
    $query=mysqli_query($con, "SELECT COUNT(*) total FROM articulo where fecha='$fechaactual' ")or die(mysqli_error());
    $i=1;
    while($row3=mysqli_fetch_array($query)){
      $cantidadfila3=$row3['total'];
    }
?>
<script type="text/javascript">
  $('#payroll_control').addClass("treeview active");
  $('#payroll_control_1').addClass("treeview active");
  $('#payroll_control_1_1').addClass("active");
</script>
<style>
  /* Oculta Copy, CSV y PDF; deja Excel visible */
  .dt-buttons .buttons-copy,
  .dt-buttons .buttons-csv,
  .dt-buttons .buttons-pdf { display: none !important; }
</style>
<meta charset="UTF-8">
<title><?= T('Employee List ') ?></title>
<div class="box-body">
  <!-- Date range -->
  <form method="post" action="articulos_add2.php" enctype="multipart/form-data" class="form-horizontal">

    <!-- /.input group -->

    <div class="panel panel-default">
      <div class="panel-heading">
        <div class="box-header with-border">
          <h3 class="box-title"><?= T('Collaborators ') ?></h3> <?= T('Assistant: ') ?><a style="color: red"><?= T('Off: ') ?></a>
          <div class="box-tools pull-right">
            <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
            <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
          </div>
        </div>
      </div>
      <!-- /.box-header -->
      <div class="box-body">
        <div class="row">
          <div class="col-md-12">
            <!--Contenido-->
            <a href="ingreso_empleadosplanilla.php" onclick="$(this).button('loading').siblings().prop('disabled', false);" type="submit" class="btn btn-primary"><?= T('Create New Employed') ?></a>
            <a href="preguntas_frecuentes_english.php" onclick="$(this).button('loading').siblings().prop('disabled', false);" type="submit" class="btn btn-success"><?= T('Frequently asked questions:?') ?></a>

            <div class="col-sm-14" id="VerForm">

              <form role="form" name="frmArticulos" id="frmArticulos" enctype="multipart/form-data">
                <div class="row">
                  <div class="col-lg-4 left">
                    <label for="inputMarca"><?= T('Categor铆a:') ?></label>
                    <div class="form-group has-success">
                      <input id="txtIdArticulo" type="hidden" maxlength="50" class="form-control" name="txtIdArticulo" required="" placeholder="" autofocus="" />
                      <select id="cboCategoria" name="cboCategoria" class="form-control"></select>
                    </div>
                  </div>
                  <div class="col-lg-4 left">
                    <label for="inputMarca"><?= T('U. Medida:') ?></label>
                    <div class="form-group has-success">
                      <select id="cboUnidadMedida" name="cboUnidadMedida" class="form-control"></select>
                    </div>
                  </div>
                  <div class="col-lg-6 left">
                    <label for="inputMarca"><?= T('Nombre:') ?></label>
                    <div class="form-group has-success">
                      <input id="txtNombre" type="text" maxlength="50" class="form-control" name="txtNombre" required="" placeholder="<?= T('Ingrese el nombre del Articulo') ?>" autofocus="" />
                    </div>
                  </div>
                  <div class="col-lg-6 left">
                    <label for="inputMarca"><?= T('Precio:') ?></label>
                    <div class="form-group has-success">
                      <input id="venta" type="text" maxlength="50" class="form-control" name="venta" required="" placeholder="<?= T('Ingrese el precio del Articulo') ?>" autofocus="" />
                    </div>
                  </div>
                  <div class="col-lg-12 left">
                    <label for="inputMarca"><?= T('Costo:') ?></label>
                    <div class="form-group has-success">
                      <input id="costo" type="text" maxlength="50" class="form-control" name="costo" required="" placeholder="<?= T('Ingrese el costo del Articulo') ?>" autofocus="" />
                    </div>
                  </div>
                  <div class="col-lg-12 left">
                    <label for="inputInscripcion"><?= T('Descripci贸n:') ?></label>
                    <div class="form-group has-success">
                      <textarea id="txtDescripcion" class="form-control" name="txtDescripcion" placeholder=""></textarea>
                    </div>
                  </div>
                  <div class="col-lg-6 left">
                    <label for="inputInscripcion"><?= T('Imagen:') ?></label>
                    <div class="form-group has-success">
                      <input id="imagenArt" type="file" class="form-control" name="imagenArt" autofocus="" />
                      <input id="txtRutaImgArt" type="text" class="form-control" name="txtRutaImgArt" autofocus="" />
                    </div>
                  </div>
                  <div class="col-lg-12 left">
                    <h5></h5>
                    <button class="btn btn-success" type="submit"><i class="fa fa-floppy-o"></i> <?= T('Registrar') ?></button>
                    <a href="Articulo.php" class="btn btn-primary"><i class="fa fa-remove"></i> <?= T('Cancelar') ?></a>
                    <hr>
                    <span class="lead text-primary"></span>
                  </div>
                </div>
              </form>
            </div>

            <br><br>
            <div id="VerListado" class="table-responsive">

              <table id="tblArticulos" class="table table-striped table-bordered table-condensed table-hover" cellspacing="0" cellpadding="0" width="100%">
                <thead>
                  <tr>
                    <th width="5px"><?= T('#') ?></th>
                    <th width="5px"><?= T('Id') ?></th>
                    <th width="200px"><?= T('Full Name') ?></th>
                    <th width="60px"><?= T('Category') ?></th>
                    <th width="15px"><?= T('Nationality') ?></th>
                    <th width="60px"><?= T('Date of birth') ?></th>
                    <th width="15px"><?= T('Emergency number:') ?></th>
                    <th width="15px"><?= T('Marital status:') ?></th>
                    <th width="15px"><?= T('ID card') ?></th>
                    <th width="60px"><?= T('Date of entry') ?></th>
                    <th width="60px"><?= T('Holidays') ?></th>
                    <th width="60px"><?= T('Additional Holidays') ?></th>
                    <th width="60px"><?= T('Work disability') ?></th>
                    <th width="60px"><?= T('Remaining vacation days used') ?></th>
                    <th width="60px"><?= T('Available vacation balance') ?></th>
                    <th width="60px"><?= T('photo of the document') ?></th>
                    <th width="60px"><?= T('Options') ?></th>
                  </tr>
                </thead>

                <tfoot>
                  <tr>
                    <th width="5px"><?= T('#') ?></th>
                    <th width="5px"><?= T('Id') ?></th>
                    <th width="200px"><?= T('Full Name') ?></th>
                    <th width="60px"><?= T('Category') ?></th>
                    <th width="15px"><?= T('Nationality') ?></th>
                    <th width="60px"><?= T('Date of birth') ?></th>
                    <th width="15px"><?= T('Emergency number:') ?></th>
                    <th width="15px"><?= T('Marital status:') ?></th>
                    <th width="15px"><?= T('ID card') ?></th>
                    <th width="60px"><?= T('Date of entry') ?></th>
                    <th width="60px"><?= T('Holidays') ?></th>
                    <th width="60px"><?= T('Additional Holidays') ?></th>
                    <th width="60px"><?= T('Work disability') ?></th>
                    <th width="60px"><?= T('Remaining vacation days used') ?></th>
                    <th width="60px"><?= T('Available vacation balance') ?></th>
                    <th width="60px"><?= T('photo of the document') ?></th>
                    <th width="20px"><?= T('Options') ?></th>
                  </tr>
                </tfoot>

                <tbody id="articulo"></tbody>
              </table>

              <div class="modal fade" id="modalImagenGlobal" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                  <div class="modal-content">
                    <div class="modal-header">
                      <button type="button" class="close" data-dismiss="modal">&times;</button>
                      <h4 class="modal-title"><?= T('Imagen del empleado') ?></h4>
                    </div>
                    <div class="modal-body text-center">
                      <!-- Imagen -->
                      <img id="imagenModalImg" src="" style="width:100%; height:auto; display:none;" onerror="this.src='Files/sin_imagen.png'">
                      <!-- PDF -->
                      <embed id="imagenModalPdf" src="" type="application/pdf" style="width:100%; height:500px; display:none;" />
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= T('Cerrar') ?></button>
                    </div>
                  </div>
                </div>
              </div>

            </div>
            <!--Fin-Contenido-->
          </div>
        </div><!-- /.row -->
      </div><!-- /.box-body -->
    </div><!-- /.box -->

  </form>

  <script type="text/javascript">
    function manejarImagenes(clase, editarUrl) {
      $(document).on('click', clase, function() {
        var src = $(this).data('imagen');  // URL de la imagen
        var id = $(this).data('id');       // ID del registro
        $('#btnEditarImagen').attr('href', editarUrl + '?id=' + id);

        if(src.match(/\.pdf$/i)) {
          $('#imagenModalImg').hide();
          $('#imagenModalPdf').show().attr('src', src);
        } else {
          $('#imagenModalPdf').hide();
          $('#imagenModalImg').show().attr('src', src);
        }

        $('#modalImagenGlobal').modal('show');
      });

      // Abrir automáticamente la primera imagen de ese grupo
      var primeraMostrada = false;
      function abrirPrimera() {
        if (primeraMostrada) return;
        var primeraImg = $(clase).first();
        if (primeraImg.length > 0) {
          var src = primeraImg.data('imagen');
          var id = primeraImg.data('id');
          $('#btnEditarImagen').attr('href', editarUrl + '?id=' + id);

          if(src.match(/\.pdf$/i)) {
            $('#imagenModalImg').hide();
            $('#imagenModalPdf').show().attr('src', src);
          } else {
            $('#imagenModalPdf').hide();
            $('#imagenModalImg').show().attr('src', src);
          }

          $('#modalImagenGlobal').modal('show');
          primeraMostrada = true;

          setTimeout(function() {
            $('#modalImagenGlobal').modal('hide');
          }, 10);
        }
      }

      abrirPrimera();
    }

    // Inicializamos ambos tipos de imágenes
    manejarImagenes('.img-clickable1', 'modificar_imagen1.php');
    manejarImagenes('.img-clickable2', 'modificar_imagen2.php'); // puedes usar otro archivo si es distinto
  </script>

  <!-- Aquí cargaremos el contenido del PHP con AJAX -->
</div>
</div>
</div>
</div>
</div>

<script>
  function confirm_delete(message) {
    return confirm(message); // Devuelve true si OK, false si Cancel
  }
</script>

<div class="box-header"></div><!-- /.box-header -->
<div class="box-body">
<?php
  // $branch=$_SESSION['branch'];
  $query=mysqli_query($con,"select a.idarticulo,c.nombre AS categoria,a.nombre AS articulo,u.nombre AS unidad,a.descripcion,imagen,imagen2,hora_inicio,hora_final,hora_total,codigo2,costo,venta from unidad_medida AS u
  INNER JOIN articulo AS a
      ON a.idunidad_medida = u.idunidad_medida INNER JOIN categoria AS c
      ON a.idcategoria = c.idcategoria where fecha='$fechaactual' limit 20")or die(mysqli_error());
  $i=1;
  while($row=mysqli_fetch_array($query)){
    $idarticulo=$row['idarticulo'];
    $entrada=$row['hora_inicio'];

    date_default_timezone_set('America/Costa_Rica');

    //aqui comienza calculo de hora
    $hora_inicio=date('H', strtotime($entrada));
    $minuto_inicio=date('i', strtotime($entrada));

    $hora_procceso=date('H');
    $minuto_procceso= date('i');

    $h1=$hora_inicio;
    $h2=$hora_procceso;

    $m1=$minuto_inicio;
    $m2=$minuto_procceso;

    $proceso1=$h1*60;
    $proceso2=$h2*60;
    $proceso3=$m1+$proceso1;
    $proceso4=$m2+$proceso2;

    $minutos1=$proceso4-$proceso3;
    $segundos=$minutos1*60;

    $horas   = floor($segundos/ 3600);
    $minutos = floor(($segundos - ($horas * 3600)) / 60);
    $segundos = $segundos - ($horas * 3600) - ($minutos * 60);

    $hora_total1=$horas . ':' . $minutos . ":" . $segundos;
    //aqui termina calculo de hora
?>
  <div id="updateordinance<?php echo $row['id_gastos'];?>" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog" style="width: 900px; height: 900px;">
      <div class="modal-content" style="height:auto">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">×</span></button>
          <h4 class="modal-title"><?= T('Actualizar gastos') ?></h4>
        </div>
        <div class="modal-body" style="width: 100%; height: 100%;">
          <form class="form-horizontal" method="post" action="gastos_actualizar.php" enctype='multipart/form-data'>
            <input type="hidden" class="form-control" id="id_gastos" name="id_gastos" value="<?php echo $row['id_gastos'];?>" required>

            <div class="col-md-12 btn-print">
              <div class="form-group">
                <label class="control-label col-lg-3" for="price"><?= T('descripcion') ?></label><br>
                <div class="input-group col-md-8">
                  <input type="text" class="form-control" id="descripcion" name="descripcion" value="<?php echo $row['descripcion'];?>" >
                </div>
              </div>
            </div>

            <div class="col-md-12 btn-print">
              <div class="form-group">
                <label class="control-label col-lg-3" for="file"><?= T('cantidad') ?></label>
                <div class="input-group col-md-8">
                  <input type="text" class="form-control" id="cantidad" name="cantidad" value="<?php echo $row['cantidad'];?>" >
                </div>
              </div>
            </div>

        </div><br><br><br><hr>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary"><?= T('Guardar cambios') ?></button>
          <button type="button" class="btn btn-default" data-dismiss="modal"><?= T('Cerrar') ?></button>
        </div>
          </form>
      </div>
    </div><!--end of modal-dialog-->
  </div>
  <!--end of modal-->
<?php 
  } // while
?>
</div><!-- /.box-body -->

<?php
  } else {
    include "view/headeradmin.html";
?>

<?php
  include('dbcon.php');

  // $branch=$_SESSION['branch'];
  $query=mysqli_query($con,"select * from global  ")or die(mysqli_error());
  $i=1;
  while($row=mysqli_fetch_array($query)){
    $tipo_moneda=$row['tipo_moneda'];
  }
  $nombre_sucursal=$_SESSION["sucursal"];
  $query=mysqli_query($con,"select * from sucursal where razon_social='$nombre_sucursal' ")or die(mysqli_error());
  $i=1;
  while($row=mysqli_fetch_array($query)){
    $idsucursal=$row['idsucursal'];
  }
?>
<script type="text/javascript">
  $('#liAlmacen').addClass("treeview active");
  $('#liArticulos1').addClass("active");
</script>
<h2><?= T('Crear producto:------------------------------------------------> (Con Seriales)') ?></h2>
<h1><hr style="width:100%; border-color:black; "></h1>
<div class="box-body">
  <!-- Date range -->
  <form method="post" action="ot_add_no.php" enctype="multipart/form-data" class="form-horizontal">

    <div class="row">
      <div class="col-md-3 btn-print">
        <div class="form-group">
          <label for="date"><?= T('Categoria') ?></label>
        </div>
      </div>
      <div class="col-md-4 btn-print">
        <div class="form-group">
          <select class="form-control select2" name="idcategoria" required>
            <?php
              $queryc=mysqli_query($con,"select * from categoria where cod=1 ")or die(mysqli_error());
              while($rowc=mysqli_fetch_array($queryc)){
            ?>
              <option value="<?php echo $rowc['idcategoria'];?>"><?php echo $rowc['nombre'];?></option>
            <?php } ?>
          </select>
        </div>
      </div>
      <div class="col-md-4 btn-print"></div>
    </div>

    <div class="row">
      <div class="col-md-3 btn-print">
        <div class="form-group">
          <label for="date"><?= T('Unidad de medida') ?></label>
        </div>
      </div>
      <div class="col-md-4 btn-print">
        <div class="form-group">
          <select class="form-control select2" name="idunidad_medida" required>
            <?php
              $queryc=mysqli_query($con,"select * from unidad_medida  ")or die(mysqli_error());
              while($rowc=mysqli_fetch_array($queryc)){
            ?>
              <option value="<?php echo $rowc['idunidad_medida'];?>"><?php echo $rowc['nombre'];?></option>
            <?php } ?>
          </select>
        </div>
      </div>
      <div class="col-md-4 btn-print"></div>
    </div>

    <div class="row">
      <div class="col-md-3 btn-print">
        <div class="form-group">
          <label for="date"><?= T('Proveedores') ?></label>
        </div>
      </div>
      <div class="col-md-4 btn-print">
        <div class="form-group">
          <select class="form-control select2" name="idproveedor" required>
            <?php
              $queryc=mysqli_query($con,"select * from persona   where tipo_persona='Proveedor' ")or die(mysqli_error());
              while($rowc=mysqli_fetch_array($queryc)){
            ?>
              <option value="<?php echo $rowc['idpersona'];?>"><?php echo $rowc['nombre'];?></option>
            <?php } ?>
          </select>
        </div>
      </div>
      <div class="col-md-4 btn-print"></div>
    </div>

    <div class="row">
      <div class="col-md-3 btn-print">
        <div class="form-group">
          <label for="date"><?= T('Nombre') ?></label>
        </div>
      </div>
      <div class="col-md-4 btn-print">
        <div class="form-group">
          <input class="form-control pull-right" id="descripcion" name="nombre" placeholder="<?= T('Nombre del Producto') ?>" required>
        </div>
      </div>
      <div class="col-md-4 btn-print"></div>
    </div>

    <div class="row">
      <div class="col-md-3 btn-print">
        <div class="form-group">
          <label for="date"><?= T('Descripcion Producto') ?></label>
        </div>
      </div>
      <div class="col-md-4 btn-print">
        <div class="form-group">
          <textarea class="form-control pull-right" id="descripcion_producto" name="descripcion_producto" placeholder="<?= T('Descripcion del Producto') ?>" required></textarea>
        </div>
      </div>
      <div class="col-md-4 btn-print"></div>
    </div>

    <div class="row">
      <div class="col-md-3 btn-print">
        <div class="form-group">
          <label for="date"><?= T('Imagen') ?></label>
        </div>
      </div>
      <div class="col-md-4 btn-print">
        <div class="form-group">
          <input type="file" class="form-control" id="imagen" name="imagen">
        </div>
      </div>
      <div class="col-md-4 btn-print"></div>
    </div>

    <div class="row">
      <div class="col-md-3 btn-print">
        <div class="form-group">
          <label><?= T('FECHA') ?></label>
        </div>
      </div>
      <div class="col-md-4 btn-print">
        <div class="form-group">
          <input type="date" class="form-control" id="fecha" name="fecha" value="<?php echo $fechaactual;?>" readonly="readonly">
        </div>
      </div>
      <div class="col-md-4 btn-print"></div>
    </div>

    <div class="row">
      <div class="col-md-3 btn-print">
        <div class="form-group">
          <label for="date"><?= T('Precio compra') ?></label>
        </div>
      </div>
      <div class="col-md-4 btn-print">
        <div class="form-group">
          <input type="text" class="form-control pull-right" id="costo" name="costo" value"0" placeholder="<?= T('precio de compra') ?>" required>
        </div>
      </div>
      <div class="col-md-4 btn-print"></div>
    </div>

    <div class="row">
      <div class="col-md-3 btn-print">
        <div class="form-group">
          <label for="date"><?= T('Precio venta') ?></label>
        </div>
      </div>
      <div class="col-md-4 btn-print">
        <div class="form-group">
          <input type="text" class="form-control pull-right" id="venta" name="venta" placeholder="<?= T('precio ventapublico') ?>" required>
        </div>
      </div>
      <div class="col-md-4 btn-print"></div>
    </div>

    <button type="submit" class="btn btn-primary"><?= T('Guardar cambios') ?></button>

  </form>
</div>

<?php
  }

  include "view/footer.html";
} else {
  header("Location:index.html");
}


