<?php
// =========================
// FICHA PDF  COLABORADOR
// =========================

ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/dbcon.php';

// ------- ID -------
$id = null;
if (isset($_GET['id']) && ctype_digit($_GET['id'])) {
  $id = (int)$_GET['id'];
}
if (!$id) { die('Falta ID'); }

// ------- Utils -------
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function fmt($f){
  if(!$f || $f==='0000-00-00') return '';
  $ts = strtotime($f);
  return $ts ? date('d/m/Y',$ts) : h($f);
}

// ------- Empleado -------
$sqlEmp = "SELECT id, categoria, nombre_completo, tipo_documento, cedula, nacionalidad,
                  fecha_nacimiento, numero_emergencia, estado_civil,
                  year_ingreso, mes_ingreso, dia_ingreso, imagen1
           FROM empleados_planilla
           WHERE id = $id LIMIT 1";
$empRes = mysqli_query($con, $sqlEmp) or die(mysqli_error($con));
$emp = mysqli_fetch_assoc($empRes);
if(!$emp){ die('Empleado no encontrado'); }

$fecha_ingreso = '';
if ($emp['year_ingreso'] && $emp['mes_ingreso'] && $emp['dia_ingreso']) {
  $y = (int)$emp['year_ingreso'];
  $m = str_pad((int)$emp['mes_ingreso'], 2, '0', STR_PAD_LEFT);
  $d = str_pad((int)$emp['dia_ingreso'], 2, '0', STR_PAD_LEFT);
  $fecha_ingreso = "$y-$m-$d";
}

// ------- Vacaciones -------
$vac = [];
$q = "SELECT id, fecha_documento, fecha_desde, fecha_hasta, cantidad_dias, motivo
      FROM ingreso_vacaciones
      WHERE idempleado=$id AND status='1' ORDER BY fecha_desde DESC";
$r = mysqli_query($con,$q);
while($row = mysqli_fetch_assoc($r)) $vac[] = $row;

// ------- Vacaciones Extra -------
$vacx = [];
$q = "SELECT id, fecha_documento, cantidad_dias, motivo
      FROM ingreso_vacaciones_extra
      WHERE idempleado=$id ORDER BY fecha_desde DESC";
$r = mysqli_query($con,$q);
while($row = mysqli_fetch_assoc($r)) $vacx[] = $row;

// ------- Incapacidades -------
$inc = [];
$q = "SELECT fecha_documento, fecha_desde, fecha_hasta, cantidad_dias, dividido_35, dias_calculo, motivo
      FROM ingreso_inscapacidad
      WHERE idempleado=$id ORDER BY fecha_desde DESC";
$r = mysqli_query($con,$q);
while($row = mysqli_fetch_assoc($r)) $inc[] = $row;

// ------- Documentos -------
$docG = []; $docE = [];
$q = "SELECT fecha_documento, categoria, descripcion, comentario
      FROM ingreso_documentosgenerales_empleadosplanilla
      WHERE (idempleado=$id OR idempleado IS NULL OR idempleado=0)
      ORDER BY fecha_documento DESC,id DESC";
$r = mysqli_query($con,$q);
while($row = mysqli_fetch_assoc($r)) $docG[] = $row;

$q = "SELECT fecha_documento, categoria, descripcion, comentario
      FROM ingreso_documentos_empleadosplanilla
      WHERE idempleado=$id
      ORDER BY fecha_documento DESC,id DESC";
$r = mysqli_query($con,$q);
while($row = mysqli_fetch_assoc($r)) $docE[] = $row;


// ====================
// Dompdf (0.8.3)
// ====================
$dompdfPath = __DIR__ . '/dompdf/autoload.inc.php';
if (!file_exists($dompdfPath)) {
  die('No se encontr Dompdf (autoload.inc.php).');
}
require_once $dompdfPath;

use Dompdf\Dompdf;
use Dompdf\Options;


// ------- Imagen -> data URI respetando EXIF -------
function image_datauri_with_exif($url){
  if(!$url) return '';

  $ctx = stream_context_create([
    'http' => ['timeout' => 4, 'follow_location' => 1],
    'ssl'  => ['verify_peer'=>false, 'verify_peer_name'=>false]
  ]);
  $raw = @file_get_contents($url, false, $ctx);
  if($raw === false) return '';

  $tmp = tempnam(sys_get_temp_dir(), 'img');
  if(!$tmp) return '';
  file_put_contents($tmp, $raw);

  $mime = function_exists('mime_content_type') ? @mime_content_type($tmp) : 'image/jpeg';

  $needsRotation = false;
  $orientation = 0;

  if (function_exists('exif_read_data') && stripos((string)$mime, 'jpeg') !== false) {
    $ex = @exif_read_data($tmp);
    if(!empty($ex['Orientation'])){
      $orientation = (int)$ex['Orientation'];
      if (in_array($orientation, [3,6,8], true)) $needsRotation = true;
    }
  }

  if(!$needsRotation){
    $b64 = base64_encode($raw);
    @unlink($tmp);
    return "data:".($mime?:'image/jpeg').";base64,$b64";
  }

  if(!function_exists('imagecreatefromjpeg') || !function_exists('imagerotate')){
    $b64 = base64_encode($raw);
    @unlink($tmp);
    return "data:".($mime?:'image/jpeg').";base64,$b64";
  }

  $im = @imagecreatefromjpeg($tmp);
  if(!$im){
    $b64 = base64_encode($raw);
    @unlink($tmp);
    return "data:".($mime?:'image/jpeg').";base64,$b64";
  }

  switch($orientation){
    case 6: $deg = -90; break;
    case 8: $deg = 90;  break;
    case 3: $deg = 180; break;
    default:$deg = 0;   break;
  }

  if($deg !== 0){
    $rot = @imagerotate($im, $deg, 0);
    if($rot){ imagedestroy($im); $im = $rot; }
  }

  ob_start();
  imagejpeg($im, null, 85);
  $jpeg = ob_get_clean();
  imagedestroy($im);
  @unlink($tmp);

  $b64 = base64_encode($jpeg);
  return "data:image/jpeg;base64,$b64";
}

$imgDataUri = $emp['imagen1'] ? image_datauri_with_exif($emp['imagen1']) : '';

// >>> NUEVO: cargar logo local como data URI (sin cambiar estilos existentes)
function file_to_data_uri($path){
  if (!is_file($path)) return '';
  $raw = @file_get_contents($path);
  if ($raw === false) return '';
  $mime = function_exists('mime_content_type') ? @mime_content_type($path) : 'image/jpeg';
  return 'data:'.($mime ?: 'image/jpeg').';base64,'.base64_encode($raw);
}
$logoDataUri = file_to_data_uri('/home/jportales/public_html/colegio/colegio10/home/Files/Logo.jpg'); // ruta que indicaste
// Segundo logo (lado derecho)
$logoIntlDataUri = file_to_data_uri('/home/jportales/public_html/colegio/colegio10/home/Files/Logo_internacional.png');

// <<< NUEVO


// ------- HTML -------
$now = date('d/m/Y H:i');
$cVac  = count($vac);
$cVacX = count($vacx);
$cInc  = count($inc);
$cG    = count($docG);
$cE    = count($docE);

/* ===============================
   CSS original
   =============================== */
$css = <<<CSS
@page { margin: 26px 28px; }
* { font-family: DejaVu Sans, Arial, Helvetica, sans-serif; }
body { color:#222; font-size: 9px; }
.header { margin-bottom: 14px; }
.title   { font-size:20px; font-weight:700; text-align:center; margin: 8px 0 4px; }
.subtle  { text-align:center; font-size:11px; color:#666; }
.meta    { font-size:11px; text-align:center; color:#666; margin-top:4px; }

.card {
  border:1px solid #d9dfe7;
  border-radius:6px;
  margin: 10px 0 14px;
  overflow: hidden;
}
.card-hd {
  background:#f7f9fc;
  border-bottom:1px solid #d9dfe7;
  padding:8px 10px;
  font-weight:700;
}
.card-bd { padding:10px; }

table.tbl { width:100%; border-collapse:collapse; }
.tbl th,.tbl td { border:1px solid #dfe4ea; padding:6px 8px; vertical-align:top; }
.tbl th { background:#f9fbfe; font-weight:700; }
.badge { display:inline-block; font-size:10px; color:#555; background:#eef2f7; border:1px solid #d9dfe7; border-radius:10px; padding:1px 7px; }

.grid { display: table; width:100%; table-layout: fixed; }
.colL, .colR { display: table-cell; vertical-align:top; }
.colL { width: 62%; padding-right:10px; }
.colR { width: 38%; padding-left:10px; }

.photoBox {
  border:1px solid #dfe4ea; border-radius:6px; padding:8px;
  min-height: 260px;
}
.photoBox img { display:block; width:100%; height:auto; }

.note { font-size:10px; color:#777; margin-top:6px; }

/* (mantengo tu wrap) */
.wrap { width: 100%; }

/* >>> NUEVO: solo clase del logo (no afecta estilos existentes) */
.logo-fixed {
  position: absolute;   /* antes: fixed */
  top: 18px;
  left: 28px;           /* antes: right */
  width: 140px;
  height: auto;
}
/* Logo derecho (solo en la primera pgina) */
.logo-fixed-right {
  position: absolute;   /* absolute => solo 1ra pgina */
  top: 18px;
  right: 28px;
  width: 60px;
  height: auto;
}

/* <<< NUEVO */
CSS;

$tablaDatos = '
<tr><th style="width:28%">Nombre</th><td>'.h($emp['nombre_completo']).'</td></tr>
<tr><th>Categora</th><td>'.h($emp['categoria']).'</td></tr>
<tr><th>Documento</th><td>'.h($emp['tipo_documento']).'  '.h($emp['cedula']).'</td></tr>
<tr><th>Nacionalidad</th><td>'.h($emp['nacionalidad']).'</td></tr>
<tr><th>Fecha nacimiento</th><td>'.fmt($emp['fecha_nacimiento']).'</td></tr>
<tr><th>Fecha ingreso</th><td>'.fmt($fecha_ingreso).'</td></tr>
<tr><th>Estado civil</th><td>'.h($emp['estado_civil']).'</td></tr>
<tr><th>Emergencia</th><td>'.h($emp['numero_emergencia']).'</td></tr>';


// Vacaciones
$rows1=''; $i=1;
foreach($vac as $v){
  $rows1 .= '<tr>'.
    '<td style="width:1px">'.$i++.'</td>'.
    '<td style="width:20px">'.fmt($v['fecha_documento']).'</td>'.
    '<td style="width:20px">'.fmt($v['fecha_desde']).'</td>'.
    '<td style="width:20px">'.fmt($v['fecha_hasta']).'</td>'.
    '<td style="width:5px">'.h($v['cantidad_dias']).'</td>'.
    '<td style="width:250px" >'.h($v['motivo']).'</td>'.
    '<td></td>'.
  '</tr>';
}
if(!$rows1) $rows1 = '<tr><td colspan="7" style="text-align:center;color:#777">No hay registros.</td></tr>';

// Vacaciones adicionales
$rows2=''; $i=1;
foreach($vacx as $v){
  $rows2 .= '<tr>'.
    '<td>'.$i++.'</td>'.
    '<td style="width:20px">'.fmt($v['fecha_documento']).'</td>'.
    '<td>'.h($v['cantidad_dias']).'</td>'.
    '<td>'.h($v['motivo']).'</td>'.
  '</tr>';
}
if(!$rows2) $rows2 = '<tr><td colspan="4" style="text-align:center;color:#777">No hay registros.</td></tr>';

// Incapacidades
$rows3=''; $i=1;
foreach($inc as $v){
  $rows3 .= '<tr>'.
    '<td>'.$i++.'</td>'.
    '<td style="width:20px">'.fmt($v['fecha_documento']).'</td>'.
    '<td style="width:20px">'.fmt($v['fecha_desde']).'</td>'.
    '<td style="width:20px">'.fmt($v['fecha_hasta']).'</td>'.
    '<td>'.h($v['cantidad_dias']).'</td>'.
    '<td>'.h($v['dividido_35']).'</td>'.
    '<td>'.h($v['dias_calculo']).'</td>'.
    '<td style="width:250px" >'.h($v['motivo']).'</td>'.
  '</tr>';
}
if(!$rows3) $rows3 = '<tr><td colspan="8" style="text-align:center;color:#777">No hay registros.</td></tr>';

// Documentos
$rowsG=''; $i=1;
foreach($docG as $d){
  $rowsG .= '<tr>'.
    '<td>'.$i++.'</td>'.
    '<td style="width:20px">'.fmt($d['fecha_documento']).'</td>'.
    '<td style="width:40px">'.h($d['categoria']).'</td>'.
    '<td>'.nl2br(h($d['descripcion'])).'</td>'.
    '<td>'.nl2br(h($d['comentario'])).'</td>'.
  '</tr>';
}
if(!$rowsG) $rowsG = '<tr><td colspan="5" style="text-align:center;color:#777">Sin documentos.</td></tr>';

$rowsE=''; $i=1;
foreach($docE as $d){
  $rowsE .= '<tr>'.
    '<td>'.$i++.'</td>'.
    '<td style="width:20px">'.fmt($d['fecha_documento']).'</td>'.
    '<td style="width:40px">'.h($d['categoria']).'</td>'.
    '<td>'.nl2br(h($d['descripcion'])).'</td>'.
    '<td>'.nl2br(h($d['comentario'])).'</td>'.
  '</tr>';
}
if(!$rowsE) $rowsE = '<tr><td colspan="5" style="text-align:center;color:#777">Sin documentos.</td></tr>';

$fotoHtml = $imgDataUri
  ? '<img src="'.$imgDataUri.'" alt="Foto del colaborador">'
  : '<div style="width:100%;height:260px;background:#fafafa;border:1px dashed #ccc;border-radius:4px;text-align:center;line-height:260px;color:#999;">Sin imagen</div>';

// HTML
$html = <<<HTML
<!DOCTYPE html>
<html>
<head><meta charset="utf-8"><style>$css</style></head>
<body>

  <!-- >>> NUEVO: logo en esquina superior derecha (todas las pginas) -->
  <?php if (!empty($logoDataUri)): ?>
    <img src="$logoDataUri" class="logo-fixed" alt="Logo">
  <?php endif; ?>
  
  <!-- >>> NUEVO: logo en esquina superior derecha (todas las pginas) -->
  <?php if (!empty($logoIntlDataUri)): ?>
    <img src="$logoIntlDataUri" class="logo-fixed-right alt="Logo">
  <?php endif; ?>

  <div class="header">
    <div class="title">Ficha de colaborador</div>
    <div class="meta">Generado: $now &nbsp;&nbsp; ID colaborador: $id</div>
  </div>

  <div class="wrap-scale">
    <div class="card">
      <div class="card-hd">Datos del colaborador</div>
      <div class="card-bd">
        <div class="grid">
          <div class="colL">
            <table class="tbl">
              $tablaDatos
            </table>
          </div>
          <div class="colR">
            <div class="photoBox">
              $fotoHtml
              <div class="note">* Los datos mostrados corresponden a la ltima actualizacin registrada.</div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="card">
      <div class="card-hd">Vacaciones <span class="badge">$cVac reg.</span></div>
      <div class="card-bd">
        <table class="tbl">
          <thead>
            <tr>
              <th style="width:35px;">#</th><th>Documento</th><th>Desde</th><th>Hasta</th>
              <th>Das</th><th>Motivo</th><th>Feriados</th>
            </tr>
          </thead>
          <tbody>$rows1</tbody>
        </table>
      </div>
    </div>

    <div class="card">
      <div class="card-hd">Vacaciones adicionales <span class="badge">$cVacX reg.</span></div>
      <div class="card-bd">
        <table class="tbl">
          <thead>
            <tr><th style="width:35px;">#</th><th>Documento</th><th>Das</th><th>Motivo</th></tr>
          </thead>
          <tbody>$rows2</tbody>
        </table>
      </div>
    </div>

    <div class="card">
      <div class="card-hd">Incapacidades <span class="badge">$cInc reg.</span></div>
      <div class="card-bd">
        <table class="tbl">
          <thead>
            <tr>
              <th style="width:35px;">#</th><th>Documento</th><th>Desde</th><th>Hasta</th>
              <th>Das</th><th>Div. 35</th><th>Das clc.</th><th>Motivo</th>
            </tr>
          </thead>
          <tbody>$rows3</tbody>
        </table>
      </div>
    </div>

<div class="card">
  <div class="card-hd">Documentos  Generales <span class="badge">$cG reg.</span></div>
  <div class="card-bd">
    <table class="tbl">
      <thead>
        <tr>
          <th style="width:35px;">#</th>
          <th>Fecha</th>
          <th>Categora</th>
          <th>Descripcin</th>
          <th>Comentario</th>
        </tr>
      </thead>
      <tbody><?= $rowsG ?></tbody>
    </table>
  </div>
</div>

<!-- Card: Documentos  Por empleado/categora -->
<div class="card doc-especificos">
  <div class="card-hd">Documentos  Por empleado/categora <span class="badge">$cE reg.</span></div>
  <div class="card-bd">
    <table class="tbl">
      <thead>
        <tr>
          <th style="width:35px;">#</th>
          <th>Fecha</th>
          <th>Categora</th>
          <th>Descripcin</th>
          <th>Comentario</th>
        </tr>
      </thead>
      <tbody><?= $rowsE ?></tbody>
    </table>
  </div>
</div>
</body>
</html>
HTML;

// ------- Dompdf opciones -------
$options = new Options();
$options->set('isRemoteEnabled', true);
$options->set('isPhpEnabled', false);
$options->set('defaultFont', 'DejaVu Sans');
$options->set('dpi', 96);

$dompdf = new Dompdf($options);
$dompdf->setPaper('A4','portrait');
$dompdf->loadHtml($html, 'UTF-8');
$dompdf->render();
$dompdf->stream('Ficha de colaborador', ['Attachment'=>false]);
exit;
