<?php
// ====== Diagnóstico básico ======


session_start();

// ====== Conexión ======
require_once __DIR__ . '/dbcon.php';

// ====== Sanitizar y validar parámetro ======
$id = null;
if (isset($_GET['id']) && ctype_digit($_GET['id'])) {
  $id = (int)$_GET['id'];
} elseif (isset($_POST['id']) && ctype_digit($_POST['id'])) {
  $id = (int)$_POST['id'];
}
if (!$id) {
  http_response_code(400);
  echo "<h3>Missing collaborator <code>id</code> parameter.</h3>";
  exit;
}

// ====== Utilidades ======
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function fmtFecha($f){
  if(!$f || $f==='0000-00-00') return '';
  $ts = strtotime($f);
  if(!$ts) return h($f);
  return date('d/m/Y', $ts);
}

// ====== 1) Empleado ======
$sqlEmp = "SELECT id, categoria, nombre_completo, tipo_documento, cedula, nacionalidad,
                  fecha_nacimiento, numero_emergencia, estado_civil,
                  year_ingreso, mes_ingreso, dia_ingreso, imagen1, sumar, restar
           FROM empleados_planilla
           WHERE id = $id
           LIMIT 1";
$empRes = mysqli_query($con, $sqlEmp) or die("Error empleado: ".mysqli_error($con));
$emp = mysqli_fetch_assoc($empRes);
if(!$emp){
  echo "<h3>Collaborator with id ".h($id)." was not found.</h3>";
  exit;
}

// Fecha de ingreso armada
$fecha_ingreso = '';
if(!empty($emp['year_ingreso']) && !empty($emp['mes_ingreso']) && !empty($emp['dia_ingreso'])){
  $y = (int)$emp['year_ingreso'];
  $m = str_pad((int)$emp['mes_ingreso'], 2, '0', STR_PAD_LEFT);
  $d = str_pad((int)$emp['dia_ingreso'], 2, '0', STR_PAD_LEFT);
  $fecha_ingreso = "$y-$m-$d";
}

// ====== 2) Vacaciones ======
$vac = [];
$qVac = "SELECT id, fecha_desde, fecha_hasta, idempleado, motivo, cantidad_dias, imagen1, fecha_documento
         FROM ingreso_vacaciones
         WHERE idempleado = $id AND status='1'
         ORDER BY fecha_desde DESC";
$rVac = mysqli_query($con, $qVac);
if($rVac){ while($row = mysqli_fetch_assoc($rVac)){ $vac[] = $row; } }

// ====== 3) Vacaciones Extra (sin desde/hasta en la UI) ======
$vacx = [];
$qVacX = "SELECT id, fecha_desde, fecha_hasta, idempleado, motivo, cantidad_dias, imagen1, fecha_documento
          FROM ingreso_vacaciones_extra
          WHERE idempleado = $id
          ORDER BY fecha_desde DESC";
$rVacX = mysqli_query($con, $qVacX);
if($rVacX){ while($row = mysqli_fetch_assoc($rVacX)){ $vacx[] = $row; } }

// ====== 4) Incapacidades ======
$inc = [];
$qInc = "SELECT id, fecha_desde, fecha_hasta, dividido_35, dias_calculo, idempleado, motivo, cantidad_dias, imagen1, fecha_documento
         FROM ingreso_inscapacidad
         WHERE idempleado = $id
         ORDER BY fecha_desde DESC";
$rInc = mysqli_query($con, $qInc);
if($rInc){ while($row = mysqli_fetch_assoc($rInc)){ $inc[] = $row; } }

// ====== 5) Documentos ======
// >>> FILTRO “GENERAL” POR CATEGORÍA DEL EMPLEADO <<<
// Muestra:
//   - Documentos generales asignados a este empleado (idempleado = $id)  —independiente de categoría.
//   - Documentos "generales" (idempleado NULL/0) cuya categoria = categoria del empleado.
$docGenerales = [];
$empCat = mysqli_real_escape_string($con, (string)$emp['categoria']);
$qG = "
  SELECT id, idempleado, categoria, descripcion, comentario, imagen1, fecha_documento
  FROM ingreso_documentosgenerales_empleadosplanilla
  WHERE
    (idempleado = $id)
    OR
    ((idempleado IS NULL OR idempleado = 0) AND categoria = '$empCat')
  ORDER BY fecha_documento DESC, id DESC
";
$rG = mysqli_query($con, $qG);
if($rG){ while($row = mysqli_fetch_assoc($rG)){ $docGenerales[] = $row; } }

// b) ESPECÍFICOS por empleado/categoría (sin cambios)
$docEspecificos = [];
$qE = "SELECT id, idempleado, categoria, descripcion, comentario, imagen1, fecha_documento
       FROM ingreso_documentos_empleadosplanilla
       WHERE idempleado = $id
       ORDER BY fecha_documento DESC, id DESC";
$rE = mysqli_query($con, $qE);
if($rE){ while($row = mysqli_fetch_assoc($rE)){ $docEspecificos[] = $row; } }

// ====== Feriados ligados a vacaciones (si existe tabla) ======
$feriadosPorVac = []; // idvacacion => array(fecha,...)
$tblCheck = mysqli_query($con, "SHOW TABLES LIKE 'vacaciones_feriados'");
if ($tblCheck && mysqli_num_rows($tblCheck) > 0) {
  foreach($vac as $v){
    $idv = (int)$v['id'];
    $feriadosPorVac[$idv] = [];
    $qr = mysqli_query($con, "SELECT fecha FROM vacaciones_feriados WHERE idvacacion = $idv ORDER BY fecha");
    if($qr){ while($fr = mysqli_fetch_assoc($qr)){ $feriadosPorVac[$idv][] = $fr['fecha']; } }
  }
}

// ====== UI ======
include __DIR__ . '/view/header.php';
?>

<style>
/* ---------- MODAL VIEWER ---------- */
.viewer-overlay{
  position: fixed; inset:0; background: rgba(0,0,0,.7);
  display:none; z-index: 9999; overflow:auto; padding: 40px 20px;
}
.viewer-box{
  background:#fff; margin:auto; max-width: 1100px; border-radius:10px;
  box-shadow:0 10px 30px rgba(0,0,0,.4); position:relative;
}
.viewer-header{
  padding:12px 16px; border-bottom:1px solid #eee; font-weight:600; background:#f7f7f7;
}
.viewer-close{
  position:absolute; right:12px; top:8px; font-size:20px; line-height:20px;
  width:36px; height:36px; text-align:center; border-radius:50%;
  cursor:pointer; color:#fff; background:#d9534f; border:2px solid #fff;
  display:flex; align-items:center; justify-content:center;
  transition: transform .05s ease-in;
}
.viewer-close:hover{ transform: scale(1.07); }
.viewer-content{ padding:12px; }
.viewer-img-wrap{ text-align:center; overflow:hidden; }
.viewer-img{
  max-width:100%; transform-origin:center center;
  transition: transform .08s ease-out; cursor: grab;
}
.viewer-instructions{
  padding:6px 12px 14px; font-size:12px; color:#666;
}

/* ---------- PRINT ---------- */
@media print{
  .no-print, .viewer-overlay{ display:none !important; }
}
</style>

<section class="content-header">
  <h1>Collaborator file <small>Details</small></h1>
</section>

<!-- Printable area (everything inside) -->
<div id="printArea">
<section class="content">

  <!-- Collaborator data -->
  <div class="box box-primary">
    <div class="box-header with-border">
      <h3 class="box-title" style="font-size:17px;">Collaborator data</h3>
      <div class="box-tools pull-right no-print">
        <a class="btn btn-default btn-sm"
           href="colaborador_detalle_pdf.php?id=<?= (int)$id ?>"
           target="_blank" rel="noopener">
          <i class="fa fa-file-pdf-o"></i> Generate PDF
        </a>
      </div>
    </div>
    <div class="box-body">
      <div class="row">
        <div class="col-sm-9">
          <table class="table table-condensed">
            <tr><th style="width:180px">Full name</th><td><?= h($emp['nombre_completo']) ?></td></tr>
            <tr><th>Category</th><td><?= h($emp['categoria']) ?></td></tr>
            <tr><th>Document</th><td><?= h($emp['tipo_documento']).' — '.h($emp['cedula']) ?></td></tr>
            <tr><th>Nationality</th><td><?= h($emp['nacionalidad']) ?></td></tr>
            <tr><th>Birth date</th><td><?= fmtFecha($emp['fecha_nacimiento']) ?></td></tr>
            <tr><th>Join date</th><td><?= fmtFecha($fecha_ingreso) ?></td></tr>
            <tr><th>Marital status</th><td><?= h($emp['estado_civil']) ?></td></tr>
            <tr><th>Emergency phone</th><td><?= h($emp['numero_emergencia']) ?></td></tr>
          </table>
        </div>
        <div class="col-sm-3 text-center">
          <?php if(!empty($emp['imagen1'])): ?>
            <img
              src="<?= h($emp['imagen1']) ?>"
              alt="Document / photo"
              style="max-width:100%;max-height:220px;border-radius:6px;border:1px solid #ddd;cursor:zoom-in;"
              onclick="openImageViewer('<?= h($emp['imagen1']) ?>','Document / collaborator photo')"
            >
          <?php else: ?>
            <div style="width:100%;height:220px;border:1px dashed #ccc;display:flex;align-items:center;justify-content:center;border-radius:6px;">
              <span class="text-muted">No image</span>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>

  <!-- Vacations -->
  <div class="box box-success">
    <div class="box-header with-border">
      <h3 class="box-title" style="font-size:17px;">Vacations</h3>
    </div>
    <div class="box-body">
      <?php if(!$vac): ?>
        <p class="text-muted">No vacation records.</p>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table table-striped table-bordered">
            <thead>
              <tr>
                <th>#</th>
                <th>Document date</th>
                <th>From</th>
                <th>To</th>
                <th>Days</th>
                <th>Reason</th>
                <th class="no-print">Attachment</th>
                <th>Holidays (if any)</th>
              </tr>
            </thead>
            <tbody>
            <?php foreach($vac as $i=>$v): ?>
              <tr>
                <td><?= $i+1 ?></td>
                <td><?= fmtFecha($v['fecha_documento']) ?></td>
                <td><?= fmtFecha($v['fecha_desde']) ?></td>
                <td><?= fmtFecha($v['fecha_hasta']) ?></td>
                <td><?= h($v['cantidad_dias']) ?></td>
                <td><?= h($v['motivo']) ?></td>
                <td class="no-print">
                  <?php if(!empty($v['imagen1'])): ?>
                    <?php $url = h($v['imagen1']); $isPdf = stripos($url,'.pdf')!==false; ?>
                    <button class="btn btn-xs btn-info"
                      onclick="<?= $isPdf ? "openPdfViewer('{$url}','Vacation attachment')" : "openImageViewer('{$url}','Vacation attachment')" ?>">
                      <i class="fa fa-file"></i> View
                    </button>
                  <?php endif; ?>
                </td>
                <td>
                  <?php
                  $idv = (int)$v['id'];
                  if(!empty($feriadosPorVac[$idv])){
                    echo implode(', ', array_map('h', $feriadosPorVac[$idv]));
                  } else {
                    echo '<span class="text-muted">—</span>';
                  }
                  ?>
                </td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <!-- Extra vacations (NO from/to columns) -->
  <div class="box box-info">
    <div class="box-header with-border">
      <h3 class="box-title" style="font-size:17px;">Additional vacations</h3>
    </div>
    <div class="box-body">
      <?php if(!$vacx): ?>
        <p class="text-muted">No additional vacation records.</p>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table table-striped table-bordered">
            <thead>
              <tr>
                <th>#</th>
                <th>Document date</th>
                <th>Days</th>
                <th>Reason</th>
                <th class="no-print">Attachment</th>
              </tr>
            </thead>
            <tbody>
            <?php foreach($vacx as $i=>$v): ?>
              <tr>
                <td><?= $i+1 ?></td>
                <td><?= fmtFecha($v['fecha_documento']) ?></td>
                <td><?= h($v['cantidad_dias']) ?></td>
                <td><?= h($v['motivo']) ?></td>
                <td class="no-print">
                  <?php if(!empty($v['imagen1'])): ?>
                    <?php $url = h($v['imagen1']); $isPdf = stripos($url,'.pdf')!==false; ?>
                    <button class="btn btn-xs btn-info"
                      onclick="<?= $isPdf ? "openPdfViewer('{$url}','Additional vacation attachment')" : "openImageViewer('{$url}','Additional vacation attachment')" ?>">
                      <i class="fa fa-file"></i> View
                    </button>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <!-- Sick leaves / disabilities -->
  <div class="box box-warning">
    <div class="box-header with-border">
      <h3 class="box-title" style="font-size:17px;">Sick leave</h3>
    </div>
    <div class="box-body">
      <?php if(!$inc): ?>
        <p class="text-muted">No sick leave records.</p>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table table-striped table-bordered">
            <thead>
              <tr>
                <th>#</th>
                <th>Document date</th>
                <th>From</th>
                <th>To</th>
                <th>Days</th>
                <th>Divided by 35</th>
                <th>Calculated days</th>
                <th>Reason</th>
                <th class="no-print">Attachment</th>
              </tr>
            </thead>
            <tbody>
            <?php foreach($inc as $i=>$v): ?>
              <tr>
                <td><?= $i+1 ?></td>
                <td><?= fmtFecha($v['fecha_documento']) ?></td>
                <td><?= fmtFecha($v['fecha_desde']) ?></td>
                <td><?= fmtFecha($v['fecha_hasta']) ?></td>
                <td><?= h($v['cantidad_dias']) ?></td>
                <td><?= h($v['dividido_35']) ?></td>
                <td><?= h($v['dias_calculo']) ?></td>
                <td><?= h($v['motivo']) ?></td>
                <td class="no-print">
                  <?php if(!empty($v['imagen1'])): ?>
                    <?php $url = h($v['imagen1']); $isPdf = stripos($url,'.pdf')!==false; ?>
                    <button class="btn btn-xs btn-info"
                      onclick="<?= $isPdf ? "openPdfViewer('{$url}','Sick leave attachment')" : "openImageViewer('{$url}','Sick leave attachment')" ?>">
                      <i class="fa fa-file"></i> View
                    </button>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <!-- Documents -->
  <div class="box box-default">
    <div class="box-header with-border">
      <h3 class="box-title" style="font-size:17px;">Documents (General & Specific)</h3>
    </div>
    <div class="box-body">
      <?php if(!$docGenerales && !$docEspecificos): ?>
        <p class="text-muted">No documents.</p>
      <?php else: ?>
        <div class="row">
          <div class="col-sm-6">
            <h4>General <small class="text-muted">(filtered by employee category)</small></h4>
            <div class="table-responsive">
              <table class="table table-striped table-bordered">
                <thead>
                  <tr>
                    <th>#</th><th>Date</th><th>Category</th><th>Description</th><th>Comment</th><th class="no-print">Attachment</th>
                  </tr>
                </thead>
                <tbody>
                <?php foreach($docGenerales as $i=>$d): ?>
                  <tr>
                    <td><?= $i+1 ?></td>
                    <td><?= fmtFecha($d['fecha_documento']) ?></td>
                    <td><?= h($d['categoria']) ?></td>
                    <td><?= h($d['descripcion']) ?></td>
                    <td><?= h($d['comentario']) ?></td>
                    <td class="no-print">
                      <?php if(!empty($d['imagen1'])): ?>
                        <?php $url = h($d['imagen1']); $isPdf = stripos($url,'.pdf')!==false; ?>
                        <button class="btn btn-xs btn-info"
                          onclick="<?= $isPdf ? 'openPdfViewer(\''.$url.'\',\'General document\')' : 'openImageViewer(\''.$url.'\',\'General document\')' ?>">
                          <i class="fa fa-file"></i> View
                        </button>
                      <?php endif; ?>
                    </td>
                  </tr>
                <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>

          <div class="col-sm-6">
            <h4>By employee/category</h4>
            <div class="table-responsive">
              <table class="table table-striped table-bordered">
                <thead>
                  <tr>
                    <th>#</th><th>Date</th><th>Category</th><th>Description</th><th>Comment</th><th class="no-print">Attachment</th>
                  </tr>
                </thead>
                <tbody>
                <?php foreach($docEspecificos as $i=>$d): ?>
                  <tr>
                    <td><?= $i+1 ?></td>
                    <td><?= fmtFecha($d['fecha_documento']) ?></td>
                    <td><?= h($d['categoria']) ?></td>
                    <td><?= h($d['descripcion']) ?></td>
                    <td><?= h($d['comentario']) ?></td>
                    <td class="no-print">
                      <?php if(!empty($d['imagen1'])): ?>
                        <?php $url = h($d['imagen1']); $isPdf = stripos($url,'.pdf')!==false; ?>
                        <button class="btn btn-xs btn-info"
                          onclick="<?= $isPdf ? 'openPdfViewer(\''.$url.'\',\'Employee/category document\')' : 'openImageViewer(\''.$url.'\',\'Employee/category document\')' ?>">
                          <i class="fa fa-file"></i> View
                        </button>
                      <?php endif; ?>
                    </td>
                  </tr>
                <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      <?php endif; ?>
    </div>
  </div>

</section>
</div><!-- /printArea -->

<!-- MODAL VIEWER -->
<div id="viewer" class="viewer-overlay" onclick="closeViewer()">
  <div class="viewer-box" onclick="event.stopPropagation()">
    <div class="viewer-header">
      <span id="viewerTitle">Document</span>
      <span class="viewer-close" onclick="closeViewer()" title="Close">×</span>
    </div>
    <div class="viewer-content">
      <div id="viewerImgWrap" class="viewer-img-wrap" style="display:none;">
        <img id="viewerImg" class="viewer-img" src="" alt="Image">
      </div>
      <embed id="viewerPdf" type="application/pdf" style="width:100%; height:80vh; border:0; display:none;" />
    </div>
    <div class="viewer-instructions">
      <b>Image:</b> wheel/pinch to zoom, drag to move. &nbsp;
      <b>PDF:</b> use the viewer’s controls to zoom.
    </div>
  </div>
</div>

<script>
// ====== PRINT (same as Ctrl+P) ======
function triggerPrint(){
  var overlay = document.getElementById('viewer');
  if (overlay && overlay.style.display === 'block') {
    closeViewer();
  }
  setTimeout(function(){
    try{ window.focus(); }catch(e){}
    window.print();
  }, 60);
}

document.addEventListener('DOMContentLoaded', function(){
  var btn = document.getElementById('btnPrintFicha'); // (por si lo vuelves a agregar)
  if (btn){
    btn.addEventListener('click', function(ev){
      ev.preventDefault(); ev.stopPropagation();
      triggerPrint();
    }, true);
  }
});

// ====== SINGLE VIEWER (image/PDF) ======
var vOverlay = document.getElementById('viewer');
var vTitle   = document.getElementById('viewerTitle');
var vImgWrap = document.getElementById('viewerImgWrap');
var vImg     = document.getElementById('viewerImg');
var vPdf     = document.getElementById('viewerPdf');

function closeViewer(){
  vOverlay.style.display = 'none';
  if (vImg) { vImg.src = ''; vImg.style.transform = 'translate(0,0) scale(1)'; }
  if (vPdf) { vPdf.src = ''; }
  document.onmousemove = null;
  document.onmouseup = null;
}

function openPdfViewer(url, title){
  vTitle.textContent = title || 'PDF document';
  vImgWrap.style.display = 'none';
  vPdf.style.display = 'block';
  vPdf.src = url;
  vOverlay.style.display = 'block';
}

function openImageViewer(url, title){
  vTitle.textContent = title || 'Image';
  vPdf.style.display = 'none';
  vImgWrap.style.display = 'block';
  vImg.src = url;
  vOverlay.style.display = 'block';
  setupZoomAndDrag();
}

document.addEventListener('keydown', function(e){
  if (e.key === 'Escape') closeViewer();
});

// Zoom + drag
function setupZoomAndDrag(){
  var img = vImg;
  if(!img) return;

  var scale = 1;
  var pos = { x: 0, y: 0 };
  var isDown = false;
  var start = { x: 0, y: 0 };

  function apply(){
    img.style.transform = 'translate('+pos.x+'px,'+pos.y+'px) scale('+scale+')';
  }

  img.onwheel = function(e){
    e.preventDefault();
    var delta = e.deltaY < 0 ? 0.12 : -0.12;
    scale = Math.min(5, Math.max(0.3, scale + delta));
    apply();
  };

  img.onmousedown = function(e){
    isDown = true;
    img.style.cursor = 'grabbing';
    start.x = e.clientX - pos.x;
    start.y = e.clientY - pos.y;
  };
  document.onmousemove = function(e){
    if(!isDown) return;
    pos.x = e.clientX - start.x;
    pos.y = e.clientY - start.y;
    apply();
  };
  document.onmouseup = function(){
    isDown = false;
    img.style.cursor = 'grab';
  };
}
</script>

<?php include __DIR__ . '/view/footer.html'; ?>

