<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
if (!isset($_SESSION["idusuario"])) { header("Location: login.html"); exit; }
include "view/header.php";
?>
<section class="content-header">
  <h1>Document Categories <small>Create, edit and delete</small></h1>
</section>

<section class="content">
  <div class="box">
    <div class="box-header with-border">
      <div class="btn-group">
        <a href="documentos.php" class="btn btn-default">
          <i class="fa fa-arrow-left"></i> Regresar
        </a>
        <button class="btn btn-primary" id="btnNew">
          <i class="fa fa-plus"></i> New Category
        </button>
      </div>
    </div>

    <div class="box-body">
      <div class="table-responsive">
        <table id="tablaCats" class="table table-striped table-hover table-condensed">
          <thead>
            <tr>
              <th>#</th>
              <th>Name</th>
              <th>Description</th>
              <th style="width:140px;">Actions</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
      <p class="text-muted" style="margin-top:10px;">
        Tip: Asigna categorías en <a href="documentos_form.php">Nuevo/Editar documento</a> y filtra por categoría en <a href="documentos.php">Consultas</a>.
      </p>
    </div>
  </div>
</section>

<!-- Modal -->
<div class="modal fade" id="catModal">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="catForm" autocomplete="off">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title" id="catTitle">New Category</h4>
        </div>
        <div class="modal-body">
          <input type="hidden" name="id" id="cat_id" value="0">
          <div class="form-group">
            <label>Name</label>
            <input type="text" class="form-control" name="nombre" id="cat_nombre" maxlength="80" required>
          </div>
          <div class="form-group">
            <label>Description</label>
            <input type="text" class="form-control" name="descripcion" id="cat_descripcion" maxlength="255">
          </div>
          <div class="alert" id="catMsg" style="display:none;"></div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Save</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php include "view/footer.html"; ?>

<script>
$(function(){
  var table = $('#tablaCats').DataTable({
    ajax: { url: 'ajax/categorias.php?op=listar', dataSrc: 'data' },
    order: [[1,'asc']],
    columns: [
      {data:'id'},
      {data:'nombre'},
      {data:'descripcion', defaultContent:'', render:function(d){ return d || '<span class="text-muted">—</span>'; }},
      {data:null, orderable:false, render:function(r){
        return ''+
          '<button class="btn btn-xs btn-warning btn-edit"><i class="fa fa-edit"></i> Edit</button> '+
          '<button class="btn btn-xs btn-danger btn-del"><i class="fa fa-trash"></i> Delete</button>';
      }}
    ]
  });

  function showMsg(type, text){
    var $m = $('#catMsg');
    $m.removeClass('alert-success alert-danger alert-info').addClass('alert-'+type).text(text).show();
  }

  $('#btnNew').on('click', function(){
    $('#cat_id').val('0');
    $('#cat_nombre').val('');
    $('#cat_descripcion').val('');
    $('#catTitle').text('New Category');
    $('#catMsg').hide();
    $('#catModal').modal('show');
  });

  $('#tablaCats').on('click', '.btn-edit', function(){
    var d = table.row($(this).closest('tr')).data();
    $('#cat_id').val(d.id);
    $('#cat_nombre').val(d.nombre);
    $('#cat_descripcion').val(d.descripcion || '');
    $('#catTitle').text('Edit Category');
    $('#catMsg').hide();
    $('#catModal').modal('show');
  });

  $('#tablaCats').on('click', '.btn-del', function(){
    var d = table.row($(this).closest('tr')).data();
    if(!confirm('Delete category "'+d.nombre+'"?')) return;
    $.post('ajax/categorias.php?op=eliminar', {id:d.id})
      .done(function(){
        table.ajax.reload(null,false);
      })
      .fail(function(xhr){
        var msg = 'Error';
        try { var r = JSON.parse(xhr.responseText); if (r.error) msg = r.error; } catch(e){ msg = xhr.responseText || msg; }
        alert(msg);
      });
  });

  $('#catForm').on('submit', function(e){
    e.preventDefault();
    $.post('ajax/categorias.php?op=guardar', $(this).serialize())
      .done(function(){
        $('#catModal').modal('hide');
        table.ajax.reload(null,false);
      })
      .fail(function(xhr){
        var msg = 'Error';
        try { var r = JSON.parse(xhr.responseText); if (r.error) msg = r.error; } catch(e){ msg = xhr.responseText || msg; }
        showMsg('danger', msg);
      });
  });
});
</script>
