<?php
// rrhh_home/ausencias_editor.php
// Editor mensual de AUSENCIAS/RETRASOS (similar a extras_editor)
// PHP 8.1.33 – UTF-8

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) { header("Location:index.html"); exit; }
$ES_SUPER = isset($_SESSION["superadmin"]) && $_SESSION["superadmin"] === "S";

require_once __DIR__ . '/dbcon.php';
mysqli_set_charset($con,'utf8mb4');

// Empleados para combo
$empleados=[];
$q="SELECT id, nombre_completo, cedula, categoria FROM empleados_planilla ORDER BY nombre_completo ASC";
if($rs=mysqli_query($con,$q)){ while($r=mysqli_fetch_assoc($rs)) $empleados[]=$r; mysqli_free_result($rs); }
$MES_DEF = date('Y-m');

// Header
if(!$ES_SUPER) include __DIR__.'/view/header.php';
else           include __DIR__.'/view/headeradmin.html';
?>
<script>
  $('#payroll_control').addClass("treeview active");
  $('#payroll_control_2').addClass("treeview active");
</script>

<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet"/>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

<style>
  .kpi{border:1px solid #e8e8e8;border-radius:12px;padding:14px;text-align:center;margin-bottom:12px;background:#fff}
  .kpi h3{margin:0;font-weight:800;letter-spacing:.3px}
  .kpi small{color:#6b7280}

  .cal-wrap{border:1px solid #e6e6e6;border-radius:12px;padding:12px;background:#fff}
  .cal-head{display:grid;grid-template-columns:repeat(7,1fr);gap:6px;margin-bottom:6px}
  .cal-head .dhead{border:1px solid #e5e7eb;border-radius:10px;padding:10px;text-align:center;background:#f1f5f9;font-weight:700;color:#334155}
  .cal{display:grid;grid-template-columns:repeat(7,1fr);gap:6px}
  .cal .d{border:1px solid #eef0f2;border-radius:12px;min-height:110px;padding:10px;position:relative;background:#fafafa;cursor:pointer;transition:box-shadow .18s ease,background .18s}
  .cal .d:hover{box-shadow:0 6px 18px rgba(0,0,0,.06);background:#fff}
  .cal .d .num{position:absolute;top:8px;right:10px;color:#94a3b8;font-size:12px;font-weight:700}
  .cal .d .h{font-weight:800;font-size:20px;margin-top:18px;color:#0f172a}
  .cal .d .f{font-size:12px;color:#64748b;margin-top:2px}
  .cal .d.hasdata{border-color:#fee2e2;background:#fff7f7}
  .cal .d.hasdata .h{color:#b91c1c}
</style>

<div class="box">
  <div class="box-header with-border">
    <h3>Ausencias / Retrasos – Editor mensual</h3>
    <div class="box-tools pull-right">
      <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
    </div>
  </div>

  <div class="box-body">
    <div class="row" style="margin-bottom:12px">
      <div class="col-md-4">
        <label>Empleado</label>
        <select id="empleado" class="form-control select2" style="width:100%">
          <option value="">-- Seleccione --</option>
          <?php foreach($empleados as $e): ?>
            <option value="<?= (int)$e['id'] ?>">
              <?= htmlspecialchars($e['nombre_completo']) ?> - <?= htmlspecialchars($e['cedula']) ?>
              (<?= htmlspecialchars($e['categoria']) ?>)
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <label>Mes</label>
        <input type="month" id="mes" class="form-control" value="<?= htmlspecialchars($MES_DEF) ?>">
      </div>
      <div class="col-md-5">
        <label>&nbsp;</label><br>
        <button id="btnCargar" class="btn btn-primary">Cargar calendario</button>
        <a href="planilla_home.php" class="btn btn-default">Ir a Home/Polilla</a>
      </div>
    </div>

    <!-- KPIs -->
    <div class="row">
      <div class="col-sm-3"><div class="kpi"><small>Días de ausencia</small><h3 id="kDias">0</h3></div></div>
      <div class="col-sm-3"><div class="kpi"><small>Horas por ausencia</small><h3 id="kHAus">0.00</h3></div></div>
      <div class="col-sm-3"><div class="kpi"><small>Eventos de retraso</small><h3 id="kEvR">0</h3></div></div>
      <div class="col-sm-3"><div class="kpi"><small>Horas de retraso</small><h3 id="kHRet">0.00</h3></div></div>
    </div>
    <div class="row">
      <div class="col-sm-3"><div class="kpi"><small>Total horas a descontar</small><h3 id="kTot">0.00</h3></div></div>
    </div>

    <div class="cal-wrap">
      <div id="calHead" class="cal-head"></div>
      <div id="cal" class="cal"></div>
    </div>
  </div>
</div>

<!-- Modal edición -->
<div class="modal fade" id="dlg" tabindex="-1" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Editar <span id="dlgFecha"></span></h4></div>
      <div class="modal-body">
        <div class="form-group">
          <label>Tipo</label>
          <select id="dlgTipo" class="form-control">
            <option value="AUSENCIA">AUSENCIA</option>
            <option value="RETRASO">RETRASO</option>
          </select>
        </div>
        <div class="form-group">
          <label>Horas</label>
          <input type="number" min="0" step="0.25" id="dlgHoras" class="form-control" placeholder="0.00">
          <small class="text-muted">Para AUSENCIA: si dejas 0, se usará el valor por defecto de horas del día.</small>
        </div>
        <div class="form-group">
          <label>Descripción (opcional)</label>
          <input type="text" id="dlgDesc" maxlength="255" class="form-control" placeholder="Motivo…">
        </div>
        <div id="dlgWarn" class="text-danger" style="display:none"></div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-danger pull-left" id="btnBorrar"><i class="fa fa-trash"></i> Borrar día</button>
        <button class="btn btn-default" data-dismiss="modal">Cancelar</button>
        <button id="btnGuardar" class="btn btn-primary">Guardar</button>
      </div>
    </div>
  </div>
</div>

<script>
/* ===== Select2 ===== */
$('.select2').select2({width:'100%', placeholder:'-- Seleccione --', allowClear:true});

/* ===== Estado ===== */
const cal      = document.getElementById('cal');
const calHead  = document.getElementById('calHead');
let curEmp = null, curMes = null, dataMes = {detalle:[]}, pref = {horas_dia:8, dias_mes:30};
let dlgFecha=null;

/* ===== Utilidades ===== */
function ymd(d){ const z=n=> (n<10?'0':'')+n; return d.getFullYear()+'-'+z(d.getMonth()+1)+'-'+z(d.getDate()); }
function daysInMonth(year, month){ return new Date(year, month+1, 0).getDate(); }

/* ===== Carga ===== */
function loadMonth(){
  curEmp = $('#empleado').val();
  curMes = $('#mes').val();
  if(!curEmp || !curMes){ alert('Seleccione empleado y mes.'); return; }

  $.post('ausencias_api.php',{action:'get_month', idempleado:curEmp, mes:curMes}, function(r){
    if(!r || !r.ok){ alert(r?.msg || 'No se pudo cargar.'); return; }
    pref = r.pref || pref;
    dataMes = r;
    renderTotals(r.totales || {});
    renderCalendar();
  }, 'json').fail(function(xhr){
    alert('Error de red o PHP en ausencias_api.php ('+xhr.status+'). Revisa el log PHP.');
  });
}

/* ===== Totales ===== */
function renderTotals(t){
  $('#kDias').text(parseInt(t.dias_ausencia||0,10));
  $('#kHAus').text(parseFloat(t.horas_ausencia||0).toFixed(2));
  $('#kEvR').text(parseInt(t.eventos_retraso||0,10));
  $('#kHRet').text(parseFloat(t.horas_retraso||0).toFixed(2));
  $('#kTot').text(parseFloat(t.horas_descuento_total||0).toFixed(2));
}

/* ===== Header calendario ===== */
const WEEKDAYS = ['Lunes','Martes','Miércoles','Jueves','Viernes','Sábado','Domingo'];
function renderCalendarHeader(){
  calHead.innerHTML = '';
  WEEKDAYS.forEach(n=>{
    const el = document.createElement('div');
    el.className = 'dhead';
    el.textContent = n;
    calHead.appendChild(el);
  });
}

/* ===== Render principal ===== */
function renderCalendar(){
  cal.innerHTML='';
  renderCalendarHeader();

  const parts = curMes.split('-'); const y=+parts[0], m=(+parts[1])-1;
  const first = new Date(y,m,1), lastDay = daysInMonth(y,m);

  // índice LUN=0..DOM=6
  const firstIndex = (first.getDay() + 6) % 7;
  for(let i=0;i<firstIndex;i++){
    const v=document.createElement('div');
    v.className='d';
    v.style.visibility='hidden';
    cal.appendChild(v);
  }

  for(let d=1; d<=lastDay; d++){
    const date = new Date(y,m,d); const s = ymd(date);
    const box = document.createElement('div'); box.className='d';

    const det   = (dataMes.detalle||[]).find(x=>x.fecha===s);
    const horas = det ? parseFloat(det.horas||0) : 0;
    const tipo  = det ? det.tipo : '';

    if (horas>0 || tipo) box.classList.add('hasdata');

    box.innerHTML = `<div class="num">${d}</div>
                     <div class="h">${horas>0?horas.toFixed(2):'—'}</div>
                     <div class="f">${tipo||''}</div>`;

    box.dataset.fecha = s;
    box.onclick = ()=>openDlg(s, det||null);
    cal.appendChild(box);
  }
}

/* ===== Modal ===== */
function openDlg(fecha, det){
  dlgFecha = fecha;
  $('#dlgFecha').text(fecha);
  $('#dlgTipo').val(det?det.tipo:'AUSENCIA');
  // Para AUSENCIA, si no había valor, sugerimos las horas del día; pero el usuario puede cambiarlo
  const defH = (det && typeof det.horas !== 'undefined') ? det.horas : (pref.horas_dia || 8);
  $('#dlgHoras').val(defH);
  $('#dlgDesc').val(det?det.descripcion:'');
  $('#dlgWarn').hide().text('');
  $('#dlg').modal('show');
}

$('#btnGuardar').on('click', function(){
  const tipo  = $('#dlgTipo').val();
  let horas   = parseFloat($('#dlgHoras').val()||'0');
  const desc  = $('#dlgDesc').val()||'';

  if (tipo==='RETRASO' && (isNaN(horas) || horas<=0)) { alert('Horas de retraso inválidas.'); return; }
  if (tipo==='AUSENCIA' && (isNaN(horas) || horas<0)) { horas = 0; } // 0 → backend usará horas_dia

  $.post('ausencias_api.php',{
    action:'upsert_day',
    idempleado: $('#empleado').val(),
    mes: $('#mes').val(),
    fecha: dlgFecha,
    tipo: tipo,
    horas: horas,
    descripcion: desc
  }, function(r){
    if(!r || !r.ok){ alert(r?.msg || 'No se pudo guardar.'); return; }
    $('#dlg').modal('hide');
    loadMonth();
  }, 'json').fail(function(xhr){
    alert('Error de red o PHP al guardar ('+xhr.status+').');
  });
});

$('#btnBorrar').on('click', function(){
  if(!confirm('¿Eliminar el registro de este día?')) return;
  $.post('ausencias_api.php',{
    action:'delete_day',
    idempleado: $('#empleado').val(),
    mes: $('#mes').val(),
    fecha: dlgFecha
  }, function(r){
    if(!r || !r.ok){ alert(r?.msg || 'No se pudo borrar.'); return; }
    $('#dlg').modal('hide');
    loadMonth();
  }, 'json').fail(function(xhr){
    alert('Error de red o PHP al borrar ('+xhr.status+').');
  });
});

/* ===== Go ===== */
$('#btnCargar').on('click', loadMonth);
$('#mes').on('change', function(){ if($('#empleado').val()) loadMonth(); });
</script>

<?php include __DIR__.'/view/footer.html'; ?>
