// embeddable_viewer.js - pinta el SVG inline
async function loadPlanInto(containerId, sector_id, type='electrical'){
  const r = await fetch(`/modulo_plano/ajax/plan_get.php?sector_id=${sector_id}&type=${encodeURIComponent(type)}`);
  const data = await r.json();
  const el = document.getElementById(containerId);
  if (!el){ return; }
  if (data && data.ok && data.plan && data.plan.svg){
    el.innerHTML = data.plan.svg; // SVG ya limpiado en el backend
  } else {
    el.innerHTML = `<div class="note">No hay plano publicado para este sector/tipo.</div>`;
  }
}
