// assets/i18n.js
(function () {
  // Diccionarios
  const I18N = {
    en: {
      main_menu: "Main Menu",
      dashboard: "Dashboard",
      employees: "Employees",
      employee_list: "Employee list",
      add_employee: "Add employee",
      categories: "Categories",
      add_category: "Add category",
      holidays: "Holidays",
      list_holidays: "List holidays",
      new_holiday: "New holiday",
      form: "Form",
      form_inbox: "Form Inbox",
      additional_holidays: "Additional holidays",
      list_additional: "List additional",
      new_additional: "New additional",
      work_disability: "Work Disability",
      list_disabilities: "List disabilities",
      new_disability: "New disability",
      employee_documents: "Employee documents",
      employee_docs: "Employee docs",
      docs_by_category: "Docs by category",
      add_employee_doc: "Add employee doc",
      add_category_doc: "Add category doc",
      download_formats: "Download formats",
      add_formats: "Add formats",
      check_formats: "Check formats",
      expiring_documents: "Expiring Documents",
      list_expiring_doc: "List expiring doc",
      new_expiring_doc: "New expiring doc",
      providers: "Providers",
      create_providers: "Create providers",
      check_providers: "Check providers",
      bscr_ops: "BSCR Ops",
      operations_mode: "Operations mode",
      furniture_list: "Furniture list",
      exit: "Exit",
      logout: "Logout"
    },
    es: {
      main_menu: "Menú principal",
      dashboard: "Tablero",
      employees: "Empleados",
      employee_list: "Lista de empleados",
      add_employee: "Agregar empleado",
      categories: "Categorías",
      add_category: "Agregar categoría",
      holidays: "Vacaciones",
      list_holidays: "Listar vacaciones",
      new_holiday: "Nueva vacación",
      form: "Formulario",
      form_inbox: "Bandeja de formularios",
      additional_holidays: "Vacaciones adicionales",
      list_additional: "Listar adicionales",
      new_additional: "Nuevo adicional",
      work_disability: "Incapacidad",
      list_disabilities: "Listar incapacidades",
      new_disability: "Nueva incapacidad",
      employee_documents: "Documentos de empleados",
      employee_docs: "Docs de empleados",
      docs_by_category: "Docs por categoría",
      add_employee_doc: "Agregar doc. empleado",
      add_category_doc: "Agregar doc. por categoría",
      download_formats: "Formatos descargables",
      add_formats: "Agregar formatos",
      check_formats: "Ver formatos",
      expiring_documents: "Documentos por vencer",
      list_expiring_doc: "Listar por vencer",
      new_expiring_doc: "Nuevo documento por vencer",
      providers: "Proveedores",
      create_providers: "Crear proveedor",
      check_providers: "Ver proveedores",
      bscr_ops: "Operaciones CBCR",
      operations_mode: "Modo de operaciones",
      furniture_list: "Lista de mobiliario",
      exit: "Salir",
      logout: "Cerrar sesión"
    }
  };

  function applyLang(lang) {
    const dict = I18N[lang] || I18N.en;
    document.documentElement.setAttribute("lang", lang);

    // Reemplaza texto en todos los elementos con data-i18n
    document.querySelectorAll("[data-i18n]").forEach((el) => {
      const key = el.getAttribute("data-i18n");
      const t = (dict && dict[key]) ? dict[key] : key;
      // Si el elemento ya tiene hijos (iconos), solo cambia el textNode principal
      if (el.childNodes.length === 1 && el.childNodes[0].nodeType === Node.TEXT_NODE) {
        el.textContent = t;
      } else {
        // Mantener íconos/hijos, solo reemplazar el contenido de texto visible
        // En la práctica, es más seguro setear textContent y reinsertar íconos si están fuera
        el.childNodes.forEach((n) => {
          if (n.nodeType === Node.TEXT_NODE) n.textContent = t;
        });
      }
    });
  }

  function getDefaultLang() {
    const saved = localStorage.getItem("lang");
    if (saved) return saved;
    const nav = (navigator.language || "en").toLowerCase();
    return nav.startsWith("es") ? "es" : "en";
  }

  // API global para cambiar idioma
  window.setLang = function (lang) {
    localStorage.setItem("lang", lang);
    applyLang(lang);
  };

  // Inicializar
  document.addEventListener("DOMContentLoaded", function () {
    applyLang(getDefaultLang());
  });
})();
