/* Multilingual FAQ dataset for the AI widget */
window.__AI_DATA__ = {
  en: {
    // Shown on HomeRRHH.php: ALL topics
    general: {
      suggestions: [
        "How are vacation days calculated?",
        "How is work disability calculated?",
        "What are additional days?",
        "How do disabilities subtract from vacations?",
        "Why does this system comply with labor law?",
        "How to upload employee documents?",
        "How to filter the calendar by category?"
      ],
      faqs: [
        {
          q: "How are vacation days calculated?",
          a: "Vacation accrues at 1 day per each 35 days worked. The system takes the employee’s entry date, computes days worked to today, divides by 35 and then applies manual adjustments (sumar/restar). Used days (vacations/extra) and disabilities (converted when applicable) reduce available balance."
        },
        {
          q: "How is work disability calculated?",
          a: "If your field 'dias_calculo' stores calendar days, the system converts to vacation units by dividing by 35 when needed. Some setups store already-converted values; in that case we skip the conversion."
        },
        {
          q: "What are additional days?",
          a: "They are extra vacation days granted by the company on a voluntary basis. They’re tracked separately (vacaciones_extra) and are counted toward the used balance."
        },
        {
          q: "How do disabilities subtract from vacations?",
          a: "Disability days (in 'dias_calculo') are converted to vacation units if necessary (÷35) and subtracted from available vacation balance, following your HR policy."
        },
        {
          q: "Why does this system comply with labor law?",
          a: "It follows the 35-day accrual rule, records start dates, counts service time precisely, supports adjustments and separates legal vacations from company extras. All calculations are transparent and auditable."
        },
        {
          q: "How to upload employee documents?",
          a: "Use Employee documents → Add employee doc (specific to one employee) or Add category doc (general). Then files appear in the employee’s detail and in the general documents list."
        },
        {
          q: "How to filter the calendar by category?",
          a: "Use the category select above the calendar. Choosing a category filters events. 'All' shows every record. Colors can be customized per category."
        }
      ]
    },

    home: { suggestions: ["Overview"], faqs: [] },
    employees: {
      suggestions: ["How to onboard a new employee?"],
      faqs: [
        { q: "How to onboard a new employee?", a: "Go to Check List Collaborator → Employee onboarding, complete the form and save. You can later attach documents and manage vacations/disabilities." }
      ]
    },
    vacaciones: {
      suggestions: ["Create vacations", "Vacation list"],
      faqs: [
        { q: "Create vacations", a: "Go to Holidays → Create Holidays. Fill dates (from–to), reason and days. The system will add these as used vacation units." },
        { q: "Vacation list", a: "Go to Holidays → List of holidays to review, filter and open supporting documents." }
      ]
    },
    vacaciones_extra: {
      suggestions: ["Create additional holidays"],
      faqs: [
        { q: "Create additional holidays", a: "Go to Additional holidays → Create additional holidays. These are voluntary days the company grants." }
      ]
    },
    incapacidad: {
      suggestions: ["Create work disability"],
      faqs: [
        { q: "Create work disability", a: "Go to Work disability → Create work disability. Enter dates and calculation days. If needed, the system converts to vacation units for balance impact." }
      ]
    },
    documentos: {
      suggestions: ["Employee docs vs docs by category"],
      faqs: [
        { q: "Employee docs vs docs by category", a: "Employee docs attach to a single employee record. Docs by category are general templates/policies that can apply to all or groups." }
      ]
    },
    calendario: {
      suggestions: ["Show only one category"],
      faqs: [
        { q: "Show only one category", a: "Use the dropdown above the calendar and pick a category to show only those events. Choose 'All' to show everything." }
      ]
    }
  },

  es: {
    general: {
      suggestions: [
        "¿Cómo se calculan las vacaciones?",
        "¿Cómo se calculan las incapacidades?",
        "¿Qué son los días adicionales?",
        "¿Cómo restan las incapacidades a las vacaciones?",
        "¿Por qué este sistema cumple con el Código de Trabajo?",
        "¿Cómo subir documentos de empleados?",
        "¿Cómo filtrar el calendario por categoría?"
      ],
      faqs: [
        {
          q: "¿Cómo se calculan las vacaciones?",
          a: "Las vacaciones se acumulan a razón de 1 día por cada 35 días trabajados. El sistema toma la fecha de ingreso, calcula días trabajados al día de hoy, divide entre 35 y aplica ajustes (sumar/restar). Los días usados (vacaciones/extra) y las incapacidades (convertidas cuando aplique) reducen el saldo disponible."
        },
        {
          q: "¿Cómo se calculan las incapacidades?",
          a: "Si el campo 'dias_calculo' son días calendario, el sistema los convierte a unidades de vacaciones dividiendo entre 35 cuando es necesario. En algunos esquemas ya vienen convertidos, en cuyo caso no se hace conversión."
        },
        {
          q: "¿Qué son los días adicionales?",
          a: "Son días extra de vacaciones que la empresa otorga de forma voluntaria. Se registran por separado (vacaciones_extra) y se descuentan del saldo total usado."
        },
        {
          q: "¿Cómo restan las incapacidades a las vacaciones?",
          a: "Los días de incapacidad (en 'dias_calculo') se convierten a unidades de vacaciones si es necesario (÷35) y se descuentan del saldo disponible, según la política de RRHH."
        },
        {
          q: "¿Por qué este sistema cumple con el Código de Trabajo?",
          a: "Aplica la regla de acumulación cada 35 días trabajados, registra fechas de ingreso, calcula la antigüedad con precisión, soporta ajustes y separa vacaciones legales de días extra de empresa. Los cálculos son transparentes y auditables."
        },
        {
          q: "¿Cómo subir documentos de empleados?",
          a: "En Documentos del empleado → Agregar documento del empleado (para un colaborador específico) o Agregar documento por categoría (generales). Luego se verán en el detalle del empleado y en la lista general."
        },
        {
          q: "¿Cómo filtrar el calendario por categoría?",
          a: "Usa el select de categoría sobre el calendario. Al elegir una categoría, solo verás esos eventos. 'Todos' muestra todo."
        }
      ]
    },

    home: { suggestions: ["Resumen general"], faqs: [] },
    employees: {
      suggestions: ["¿Cómo dar de alta a un colaborador?"],
      faqs: [
        { q: "¿Cómo dar de alta a un colaborador?", a: "Ve a Check List Collaborator → Employee onboarding, completa el formulario y guarda. Luego podrás adjuntar documentos y gestionar vacaciones/incapacidades." }
      ]
    },
    vacaciones: {
      suggestions: ["Crear vacaciones", "Listado de vacaciones"],
      faqs: [
        { q: "Crear vacaciones", a: "Ve a Holidays → Create Holidays. Coloca las fechas (desde–hasta), motivo y días. El sistema sumará estas unidades como usadas." },
        { q: "Listado de vacaciones", a: "Ingresa a Holidays → List of holidays para revisar, filtrar y abrir documentos de soporte." }
      ]
    },
    vacaciones_extra: {
      suggestions: ["Crear vacaciones adicionales"],
      faqs: [
        { q: "Crear vacaciones adicionales", a: "Ve a Additional holidays → Create additional holidays. Son días extra que otorga la empresa." }
      ]
    },
    incapacidad: {
      suggestions: ["Crear incapacidad"],
      faqs: [
        { q: "Crear incapacidad", a: "Ve a Work disability → Create work disability. Ingresa fechas y días de cálculo. Si corresponde, el sistema convierte a unidades de vacaciones para reflejarlo en el saldo." }
      ]
    },
    documentos: {
      suggestions: ["Docs de empleado vs docs por categoría"],
      faqs: [
        { q: "Docs de empleado vs docs por categoría", a: "Los documentos de empleado se adjuntan a un registro específico. Los documentos por categoría son plantillas/políticas generales aplicables a todos o a grupos." }
      ]
    },
    calendario: {
      suggestions: ["Mostrar solo una categoría"],
      faqs: [
        { q: "Mostrar solo una categoría", a: "Usa el selector sobre el calendario y elige una categoría para ver solo esos eventos. Con 'Todos' vuelves a mostrar todo." }
      ]
    }
  }
};
