/* AI helper widget – multilingual (ES/EN) + email only on typed & unmatched + scroll-to-last-message */
(function () {
  function findSelfScript() {
    var s = document.getElementsByTagName("script");
    for (var i = s.length - 1; i >= 0; i--) {
      if (/ai_widget\.js(\?|$)/.test(s[i].src)) return s[i];
    }
    return null;
  }
  var self = document.currentScript || findSelfScript();
  var ROOT = "/";
  if (self && self.src) ROOT = self.src.replace(/assets\/ai_widget\/ai_widget\.js.*$/i, "");
  ROOT = ROOT.replace(/\/+$/, "");
  var AI_ENDPOINT = ROOT + "/ajax/ai_widget_submit.php";
  var AI_DATA_URL = ROOT + "/assets/ai_widget/ai_widget_data.js";

  var NAV_LANG = (navigator.language || "en").toLowerCase();
  var initial = localStorage.getItem("aiw_lang") || (NAV_LANG.indexOf("es") === 0 ? "es" : "en");
  var LANG = (initial === "es" ? "es" : "en");

  var I18N = {
    en: {
      btnTitle: "Help",
      panelTitle: "Help & FAQs",
      close: "Close",
      inputPlaceholder: "Write your question…",
      send: "Send",
      hello: "Hi! Ask me about vacations, disability, additional days, documents, calendar…",
      suggested: "Suggested questions",
      thanks: "Thanks! We’ll get back to you shortly by email.",
      noPreset: "I don't have a preset answer for that yet.",
      allTopics: "Overview",
      langToggle: "ES"
    },
    es: {
      btnTitle: "Ayuda",
      panelTitle: "Ayuda y Preguntas",
      close: "Cerrar",
      inputPlaceholder: "Escribe tu pregunta…",
      send: "Enviar",
      hello: "¡Hola! Pregúntame sobre vacaciones, incapacidades, días adicionales, documentos, calendario…",
      suggested: "Preguntas sugeridas",
      thanks: "¡Gracias! Te responderemos por correo muy pronto.",
      noPreset: "Aún no tengo una respuesta predefinida para eso.",
      allTopics: "Resumen general",
      langToggle: "EN"
    }
  };

  (function loadData() {
    if (window.__AI_DATA__) { initWidget(); return; }
    var s = document.createElement("script");
    s.src = AI_DATA_URL + "?v=" + Date.now();
    s.onload = initWidget;
    s.onerror = function(){ console.warn("AI widget: cannot load ai_widget_data.js"); initWidget(); };
    document.head.appendChild(s);
  })();

  function initWidget(){
    if (window.__AI_WIDGET_LOADED__) return;
    window.__AI_WIDGET_LOADED__ = true;

    var css = ''
      + '.aiw-btn{position:fixed;right:16px;bottom:16px;width:56px;height:56px;border-radius:50%;'
      + 'background:#2563eb;color:#fff;display:flex;align-items:center;justify-content:center;'
      + 'box-shadow:0 8px 24px rgba(0,0,0,.2);cursor:pointer;z-index:999999;font-size:22px}'
      + '.aiw-btn:hover{transform:translateY(-1px)}'
      + '.aiw-panel{position:fixed;right:16px;bottom:84px;width:350px;max-width:92vw;max-height:70vh;'
      + 'background:#fff;border-radius:10px;box-shadow:0 12px 36px rgba(0,0,0,.25);overflow:hidden;z-index:999999}'
      + '.aiw-hd{display:flex;align-items:center;justify-content:space-between;padding:10px 12px;background:#f7f7fb;border-bottom:1px solid #e5e7eb}'
      + '.aiw-ttl{font-weight:600}.aiw-right{display:flex;gap:6px;align-items:center}'
      + '.aiw-lang{font-size:12px;border:1px solid #cbd5e1;background:#fff;color:#334155;border-radius:6px;padding:4px 8px;cursor:pointer}'
      + '.aiw-x{width:26px;height:26px;border-radius:6px;background:#ef4444;color:#fff;display:flex;align-items:center;justify-content:center;cursor:pointer}'
      + '.aiw-body{padding:10px 12px;overflow:auto;max-height:calc(70vh - 96px)}'
      + '.aiw-chips{display:flex;flex-wrap:wrap;gap:6px;margin-bottom:8px}'
      + '.aiw-chip{background:#eef2ff;color:#334155;border:1px solid #dbeafe;border-radius:999px;padding:4px 10px;font-size:12px;cursor:pointer}'
      + '.aiw-faq{border-top:1px dashed #e5e7eb;margin-top:8px;padding-top:8px}'
      + '.aiw-faq h4{font-size:12px;margin:0 0 6px;color:#334155}.aiw-faq li{font-size:12px;margin:0 0 6px;cursor:pointer;color:#0f172a}'
      + '.aiw-log{font-size:12px;color:#0f172a;background:#f9fafb;border:1px solid #e5e7eb;border-radius:8px;padding:8px;margin-bottom:8px}'
      + '.aiw-msg{margin:4px 0}'
      + '.aiw-input{display:flex;gap:6px;padding:8px;border-top:1px solid #e5e7eb;background:#f8fafc}'
      + '.aiw-input input{flex:1;border:1px solid #cbd5e1;border-radius:8px;padding:8px;font-size:13px}'
      + '.aiw-input button{border:0;background:#2563eb;color:#fff;border-radius:8px;padding:8px 12px}'
      + '@media (max-width:420px){.aiw-panel{right:8px;left:8px;width:auto}}';
    var style = document.createElement("style");
    style.textContent = css;
    document.head.appendChild(style);

    var btn = document.createElement("div");
    btn.className = "aiw-btn";
    btn.title = I18N[LANG].btnTitle;
    btn.textContent = "💬";
    btn.onclick = togglePanel;
    document.body.appendChild(btn);

    var panel = document.createElement("div");
    panel.className = "aiw-panel";
    panel.style.display = "none";
    panel.innerHTML = ''
      + '<div class="aiw-hd">'
      + '  <div class="aiw-ttl" id="aiwTitle"></div>'
      + '  <div class="aiw-right">'
      + '    <button class="aiw-lang" id="aiwLang"></button>'
      + '    <div class="aiw-x" id="aiwClose" title=""></div>'
      + '  </div>'
      + '</div>'
      + '<div class="aiw-body" id="aiwBody">'
      + '  <div class="aiw-chips" id="aiwChips"></div>'
      + '  <div class="aiw-log" id="aiwLog"></div>'
      + '  <div class="aiw-faq"><h4 id="aiwFaqTitle"></h4><ul id="aiwFaqs" style="list-style:none;padding-left:0;margin:0"></ul></div>'
      + '</div>'
      + '<div class="aiw-input"><input id="aiwQ" type="text"><button id="aiwSend"></button></div>';
    document.body.appendChild(panel);

    function scrollToLastMessage() {
      var body = document.getElementById("aiwBody");
      var msgs = body.querySelectorAll(".aiw-msg");
      if (!msgs.length) return;
      var last = msgs[msgs.length - 1];
      // Desplaza hasta el último mensaje (no hasta el final de FAQs)
      last.scrollIntoView({ behavior: "smooth", block: "end" });
    }

    function refreshUITexts() {
      document.getElementById("aiwTitle").textContent = I18N[LANG].panelTitle;
      var close = document.getElementById("aiwClose");
      close.textContent = "✕";
      close.title = I18N[LANG].close;
      document.getElementById("aiwFaqTitle").textContent = I18N[LANG].suggested;
      document.getElementById("aiwQ").placeholder = I18N[LANG].inputPlaceholder;
      document.getElementById("aiwSend").textContent = I18N[LANG].send;
      btn.title = I18N[LANG].btnTitle;
      document.getElementById("aiwLang").textContent = I18N[LANG].langToggle;
    }

    refreshUITexts();
    document.getElementById("aiwClose").onclick = togglePanel;
    document.getElementById("aiwSend").onclick = function(){ sendMsg(false); };
    document.getElementById("aiwQ").addEventListener("keydown", function (e) { if (e.key === "Enter") sendMsg(false); });
    document.getElementById("aiwLang").onclick = function(){
      LANG = (LANG === "es" ? "en" : "es");
      localStorage.setItem("aiw_lang", LANG);
      refreshUITexts();
      resetLog();
      renderTopic();
      // también nos movemos al saludo (primer mensaje)
      scrollToLastMessage();
    };

    resetLog();
    renderTopic();

    function togglePanel() {
      var panelEl = document.querySelector(".aiw-panel");
      var showing = (panelEl.style.display !== "none");
      panelEl.style.display = showing ? "none" : "block";
      if (!showing) scrollToLastMessage();
    }

    function resetLog() {
      var log = document.getElementById("aiwLog");
      log.innerHTML = '';
      appendLog(I18N[LANG].hello, "bot");
    }

    function currentTopicKey() {
      var u = location.pathname.toLowerCase();
      if (u.includes("homerrhh.php") || u.endsWith("/homerrhh.php")) return "home_all";
      if (u.includes("homerrhh") || u.includes("escritorio_rrhh") || u.includes("home")) return "home";
      if (u.includes("consulta_empleadosplanilla") || u.includes("empleadosplanilla")) return "employees";
      if (u.includes("vacaciones_extra")) return "vacaciones_extra";
      if (u.includes("consulta_vacaciones") || u.includes("ingreso_vacaciones")) return "vacaciones";
      if (u.includes("inscapacidad")) return "incapacidad";
      if (u.includes("documentos")) return "documentos";
      if (u.includes("calendario")) return "calendario";
      return "general";
    }

    function collectAll(lang) {
      var all = (window.__AI_DATA__ && window.__AI_DATA__[lang]) || {};
      var seenQ = {}, seenS = {};
      var res = { suggestions: [], faqs: [] };
      Object.keys(all).forEach(function (k) {
        var d = all[k] || {};
        (d.suggestions || []).forEach(function (s) {
          if (!seenS[s]) { seenS[s] = 1; res.suggestions.push(s); }
        });
        (d.faqs || []).forEach(function (f) {
          var q = f.q || "";
          if (!seenQ[q]) { seenQ[q] = 1; res.faqs.push(f); }
        });
      });
      return res;
    }

    function renderTopic() {
      var key = currentTopicKey();
      var langData = window.__AI_DATA__ ? window.__AI_DATA__[LANG] : null;
      var data;
      if (!langData) data = { suggestions: [], faqs: [] };
      else if (key === "home_all") data = collectAll(LANG);
      else data = langData[key] || langData.general || { suggestions: [], faqs: [] };

      var chips = document.getElementById("aiwChips"); chips.innerHTML = "";
      (data.suggestions || []).forEach(function (t) {
        var c = document.createElement("div");
        c.className = "aiw-chip"; c.textContent = t;
        c.onclick = function () { askPreset(t); };
        chips.appendChild(c);
      });

      var ul = document.getElementById("aiwFaqs"); ul.innerHTML = "";
      (data.faqs || []).forEach(function (f) {
        var li = document.createElement("li");
        li.textContent = f.q;
        li.onclick = function () { askPreset(f.q); };
        ul.appendChild(li);
      });
    }

    function appendLog(html, who) {
      var log = document.getElementById("aiwLog");
      var wrap = document.createElement("div");
      wrap.className = "aiw-msg";
      wrap.innerHTML = "<b>" + (who === "me" ? (LANG === "es" ? "Tú" : "You") : (LANG === "es" ? "Asistente" : "Assistant")) + ":</b> " + html;
      log.appendChild(wrap);
      scrollToLastMessage();
    }

    function localAnswer(q) {
      var langData = window.__AI_DATA__ ? window.__AI_DATA__[LANG] : null;
      if (!langData) return null;
      var keys = Object.keys(langData);
      var needle = (q || "").toLowerCase().trim();
      for (var i = 0; i < keys.length; i++) {
        var faqs = (langData[keys[i]] && langData[keys[i]].faqs) || [];
        for (var j = 0; j < faqs.length; j++) {
          var cand = (faqs[j].q || "").toLowerCase();
          if (cand === needle || cand.indexOf(needle) >= 0 || needle.indexOf(cand) >= 0) {
            return faqs[j].a;
          }
        }
      }
      return null;
    }

    function askPreset(q) {
      var inp = document.getElementById("aiwQ");
      inp.value = q;
      sendMsg(true); // preset → no email
    }

    function sendMsg(isPreset) {
      var inp = document.getElementById("aiwQ");
      var q = (inp.value || "").trim();
      if (!q) return;
      appendLog(q, "me");
      inp.value = "";

      var local = localAnswer(q);
      if (local) {
        appendLog(local, "bot");
      } else {
        if (isPreset) {
          appendLog(I18N[LANG].noPreset, "bot");
          return;
        } else {
          appendLog(I18N[LANG].thanks, "bot");
          fetch(AI_ENDPOINT, {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: "q=" + encodeURIComponent(q) + "&url=" + encodeURIComponent(location.href) + "&origin=typed&lang=" + encodeURIComponent(LANG)
          })
            .then(function (r) { return r.json(); })
            .then(function (j) { if (j && j.ok === false && j.error) console.warn("AI widget server:", j.error); })
            .catch(function (e) { console.warn("AI widget fetch err:", e); });
        }
      }
    }
  }
})();


