<?php
// rrhh_home/asistencia/scan_extra.php
// UI Horas Extra: escanea el MISMO QR y llama a extra_api.php
// ✅ BLOQUEO DURO: si extra_api responde lock=true => se bloquea TODO, incluso cámara.
//
// PHP 8.1.33

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION['gestor_id']) || (int)$_SESSION['gestor_id'] <= 0) {
  header('Location: login.php'); exit;
}

$gestorNombre = (string)($_SESSION['gestor_nombre'] ?? 'Gestor');

// HTTPS
$isHttps = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off')
  || (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] === '443');
$host = $_SERVER['HTTP_HOST'] ?? '';
$uri  = $_SERVER['REQUEST_URI'] ?? '/asistencia/scan_extra.php';
if (!$isHttps && stripos($host, 'hr.jportales.com') !== false) {
  header('Location: https://' . $host . $uri, true, 301);
  exit;
}

$fromLock = isset($_GET['lock']) ? 1 : 0;

// 🔙 A dónde volver (ajusta si quieres a dashboard.php)
$backUrl = 'scan.php';
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Horas Extra | Escanear</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.4.1/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/2.4.18/css/AdminLTE.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/2.4.18/css/skins/skin-blue.min.css">

  <style>
    .user-image-circle{width:28px;height:28px;border-radius:50%;object-fit:cover;border:2px solid rgba(255,255,255,.7);}
    .cardx{background:#fff;border:1px solid #e5e7eb;border-radius:12px;box-shadow:0 6px 18px rgba(0,0,0,.06);padding:16px;}
    .badge-pill{display:inline-block;padding:6px 10px;border-radius:999px;background:#f3f4f6;border:1px solid #e5e7eb;font-weight:800;}
    .pill{display:inline-block;padding:6px 10px;border-radius:999px;background:#eef2ff;border:1px solid #c7d2fe;color:#1e3a8a;font-weight:900;}
    .videoWrap{border:1px solid #e5e7eb;border-radius:12px;overflow:hidden;background:#000;min-height:280px;}
    video{width:100%;height:auto;display:block;object-fit:cover;}
    .btnx{border-radius:10px;font-weight:800;padding:10px 14px;}
    .btnx i{margin-right:6px;}
    .statusLine{margin-top:10px;font-size:13px;color:#374151;}
    .ok{color:#065f46;font-weight:800;}
    .bad{color:#b91c1c;font-weight:800;}

    .lockBox{
      display:none;
      border-radius:14px;
      border:2px solid #ef4444;
      background:#fef2f2;
      padding:14px 14px;
      color:#991b1b;
      font-weight:900;
      box-shadow:0 10px 22px rgba(0,0,0,.08);
      margin-bottom:12px;
    }
    .lockBox small{display:block;margin-top:6px;color:#7f1d1d;font-weight:800;}
    .dimAll{ opacity:.55; pointer-events:none; }

    /* Botón volver pro */
    .btn-back-pro{
      border-radius:12px !important;
      font-weight:900 !important;
      padding:10px 14px !important;
      border:2px solid rgba(255,255,255,.35) !important;
      box-shadow:0 10px 22px rgba(0,0,0,.12);
      position:relative;
      overflow:hidden;
    }
    .btn-back-pro:before{
      content:'';
      position:absolute; top:-40%; left:-40%;
      width:80%; height:180%;
      background:rgba(255,255,255,.18);
      transform:rotate(25deg);
      transition:all .25s ease;
    }
    .btn-back-pro:hover:before{ left:20%; }
  </style>
</head>

<body class="hold-transition skin-blue layout-top-nav">
<div class="wrapper">

  <!-- TOP NAV (sin sidebar) -->
  <header class="main-header">
    <nav class="navbar navbar-static-top" role="navigation" style="margin-left:0;">
      <div class="container">

        <div class="navbar-header">
          <a href="<?= htmlspecialchars($backUrl, ENT_QUOTES, 'UTF-8') ?>" class="navbar-brand">
            <b>Horas Extra</b> | QR
          </a>

          <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-collapse">
            <i class="fa fa-bars"></i>
          </button>
        </div>

        <div class="collapse navbar-collapse pull-left" id="navbar-collapse">
          <ul class="nav navbar-nav">
            <li>
              <a href="<?= htmlspecialchars($backUrl, ENT_QUOTES, 'UTF-8') ?>">
                <i class="fa fa-arrow-left"></i> Volver
              </a>
            </li>
          </ul>
        </div>

        <div class="navbar-custom-menu">
          <ul class="nav navbar-nav">

            <!-- Botón volver bien visual (lado derecho) -->
            <li class="hidden-xs">
              <a class="btn-back-pro" style="margin:8px 10px; color:#fff; background:rgba(0,0,0,.12);"
                 href="<?= htmlspecialchars($backUrl, ENT_QUOTES, 'UTF-8') ?>">
                <i class="fa fa-arrow-left"></i> Volver
              </a>
            </li>

            <li class="dropdown user user-menu">
              <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                <img src="https://via.placeholder.com/80x80.png?text=U" class="user-image user-image-circle" alt="User">
                <span class="hidden-xs"><?= htmlspecialchars($gestorNombre, ENT_QUOTES, 'UTF-8') ?></span>
              </a>
              <ul class="dropdown-menu">
                <li class="user-header">
                  <img src="https://via.placeholder.com/120x120.png?text=U" class="img-circle" alt="User">
                  <p style="margin-top:10px;">
                    <?= htmlspecialchars($gestorNombre, ENT_QUOTES, 'UTF-8') ?><br>
                    <small>Horas Extra</small>
                  </p>
                </li>
                <li class="user-footer">
                  <div class="pull-left">
                    <a href="dashboard.php" class="btn btn-default btn-flat">Dashboard</a>
                  </div>
                  <div class="pull-right">
                    <a href="logout.php" class="btn btn-default btn-flat">Salir</a>
                  </div>
                </li>
              </ul>
            </li>

          </ul>
        </div>

      </div>
    </nav>
  </header>

  <!-- Content -->
  <div class="content-wrapper" style="margin-left:0;">
    <div class="container">
      <section class="content-header">
        <h1><i class="fa fa-clock-o"></i> Horas Extra <small>Escaneo QR</small></h1>
      </section>

      <section class="content">
        <?php if($fromLock): ?>
          <div class="alert alert-warning" style="border-radius:12px;">
            🔒 Asistencia bloqueó la salida porque tienes <b>Horas Extra activas</b>.
          </div>
        <?php endif; ?>

        <!-- Botón volver dentro del contenido (extra visible en móvil) -->
        <div class="visible-xs" style="margin-bottom:10px;">
          <a href="<?= htmlspecialchars($backUrl, ENT_QUOTES, 'UTF-8') ?>" class="btn btn-primary btnx" style="width:100%;">
            <i class="fa fa-arrow-left"></i> Volver
          </a>
        </div>

        <div id="lockBox" class="lockBox"></div>

        <div id="mainCard" class="cardx">
          <div style="display:flex;gap:10px;flex-wrap:wrap;align-items:center;margin-bottom:10px;">
            <button id="btnStart" class="btn btn-primary btnx"><i class="fa fa-play-circle"></i> Activar cámara</button>
            <button id="btnRetry" class="btn btn-warning btnx" style="display:none;"><i class="fa fa-refresh"></i> Reintentar</button>
            <button id="btnStop" class="btn btn-default btnx" disabled><i class="fa fa-stop"></i> Detener</button>

            <select id="camSel" class="form-control" style="max-width:360px;" disabled></select>
            <span id="supportPill" class="pill">Detector: verificando…</span>

            <button id="btnDeleteTodayQuick" class="btn btn-danger btnx" style="display:none;">
              <i class="fa fa-trash"></i> Eliminar hoy
            </button>

            <span class="badge-pill" id="stBox">Estado Extra: --</span>
            <span class="badge-pill" id="planBox" style="display:none;">
              Programado: <b id="planText">--</b>
            </span>
            <span class="badge-pill" id="realBox" style="display:none;">Real: <b id="realText">--</b></span>
          </div>

          <div class="videoWrap"><video id="video" playsinline></video></div>
          <div class="statusLine" id="status">Listo. Presiona <b>Activar cámara</b>.</div>
          <div class="alert" id="result" style="display:none;border-radius:12px;margin-top:10px;"></div>
        </div>
      </section>
    </div>
  </div>

  <footer class="main-footer" style="font-size:12px;margin-left:0;">
    <div class="container">
      <div class="pull-right hidden-xs">Asistencia Gestores</div>
      <strong>© <?= date('Y') ?> JPortales</strong>
    </div>
  </footer>

</div>

<!-- Modal Plan -->
<div class="modal fade" id="planModal" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content" style="border-radius:14px;">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span>&times;</span></button>
        <h4 class="modal-title"><i class="fa fa-clock-o"></i> Programar horas extra</h4>
      </div>
      <div class="modal-body">
        <p id="planMsg" style="margin-bottom:12px;">Indica la hora estimada.</p>
        <div class="form-group">
          <label>Hora estimada (HH:MM)</label>
          <input type="time" id="plannedEnd" class="form-control" step="60">
          <div style="color:#6b7280;font-size:12px;margin-top:6px;">
            Debe ser mayor a la salida oficial.
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button id="btnSavePlan" class="btn btn-primary btnx"><i class="fa fa-save"></i> Guardar</button>
        <button class="btn btn-default btnx" data-dismiss="modal">Cancelar</button>
      </div>
    </div>
  </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.4.1/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/2.4.18/js/adminlte.min.js"></script>

<script>
const statusEl = document.getElementById('status');
const resEl    = document.getElementById('result');
const video    = document.getElementById('video');
const mainCard = document.getElementById('mainCard');

const btnStart = document.getElementById('btnStart');
const btnStop  = document.getElementById('btnStop');
const btnRetry = document.getElementById('btnRetry');
const camSel   = document.getElementById('camSel');
const pill     = document.getElementById('supportPill');

const stBox = document.getElementById('stBox');
const planBox = document.getElementById('planBox');
const planText = document.getElementById('planText');
const realBox = document.getElementById('realBox');
const realText = document.getElementById('realText');

const planModal = $('#planModal');
const plannedEnd = document.getElementById('plannedEnd');
const btnSavePlan = document.getElementById('btnSavePlan');

const btnDeleteTodayQuick = document.getElementById('btnDeleteTodayQuick');
const lockBox = document.getElementById('lockBox');

let stream=null, detector=null, scanning=false;
let lastToken='', lastTokenTs=0, lastMarkTs=0;

let HARD_LOCK = false;

function ok(m){ statusEl.innerHTML = '<span class="ok">'+m+'</span>'; }
function bad(m){ statusEl.innerHTML = '<span class="bad">'+m+'</span>'; }
function showResult(kind, html){
  resEl.className = 'alert ' + (kind==='ok' ? 'alert-success' : 'alert-danger');
  resEl.style.display = 'block';
  resEl.innerHTML = html;
}
function hideResult(){ resEl.style.display='none'; resEl.innerHTML=''; }

function stopCamera(){
  scanning=false;
  try{
    if(stream){ stream.getTracks().forEach(t=>t.stop()); stream=null; }
  }catch(_){}
  video.srcObject=null;
  btnStop.disabled=true;
  btnStart.disabled=false;
  camSel.disabled=false;
}

function applyHardLock(msg, info){
  HARD_LOCK = true;
  hideResult();

  // apaga cámara si estaba activa
  stopCamera();

  // bloquea todo
  mainCard.classList.add('dimAll');
  btnStart.disabled = true;
  btnRetry.style.display = 'none';
  btnStop.disabled = true;
  camSel.disabled = true;
  btnSavePlan.disabled = true;
  plannedEnd.disabled = true;
  btnDeleteTodayQuick.disabled = true;

  lockBox.style.display = 'block';

  const d  = (info && info.lock_date) ? info.lock_date : '';
  const se = (info && info.lock_schedule_end) ? info.lock_schedule_end : '--';
  const pe = (info && info.lock_planned_end) ? info.lock_planned_end : '--';

  lockBox.innerHTML = `
    <div style="font-size:16px;">🔒 QR BLOQUEADO</div>
    <div style="margin-top:6px;">${msg || 'Existe una Hora Extra pendiente de AYER. El módulo está bloqueado.'}</div>
    <small>Extra pendiente: <b>${d}</b> | Salida oficial: <b>${se}</b> | Plan: <b>${pe}</b></small>
    <small>Este bloqueo NO se puede resolver desde esta pantalla.</small>
  `;

  bad('QR bloqueado. No se permite usar Horas Extra.');
}

async function enumerateCams(){
  const devs = await navigator.mediaDevices.enumerateDevices();
  const cams = devs.filter(d => d.kind === 'videoinput');
  camSel.innerHTML = '';
  cams.forEach((c,i)=>{
    const opt = document.createElement('option');
    opt.value = c.deviceId;
    opt.textContent = c.label || ('Cámara ' + (i+1));
    camSel.appendChild(opt);
  });
  camSel.disabled = cams.length === 0;
  const saved = localStorage.getItem('asist_cam_id_extra');
  if (saved && cams.some(x=>x.deviceId===saved)) camSel.value = saved;
  return cams.length;
}

async function startCamera(deviceId=null){
  if (HARD_LOCK) return;

  hideResult();
  btnRetry.style.display='none';

  if (!navigator.mediaDevices?.getUserMedia){
    bad('Tu navegador no soporta cámara.');
    return;
  }
  if (!('BarcodeDetector' in window)) {
    pill.textContent='Detector: NO soportado';
    bad('Este navegador NO soporta detector QR. Usa Chrome.');
    return;
  }
  pill.textContent='Detector: OK';
  detector = new BarcodeDetector({formats:['qr_code']});

  const constraints = {
    audio:false,
    video: deviceId ? {deviceId:{exact:deviceId}} : {facingMode:{ideal:'environment'}}
  };

  try{
    stream = await navigator.mediaDevices.getUserMedia(constraints);
    video.srcObject = stream;
    await video.play();

    btnStop.disabled=false;
    btnStart.disabled=true;

    try{
      const n=await enumerateCams();
      if(n>0) camSel.disabled=false;
      if(camSel.value) localStorage.setItem('asist_cam_id_extra', camSel.value);
    }catch(_){}

    ok('Cámara activa. Escaneando…');
    scanning=true;
    scanLoop();
  }catch(e){
    btnRetry.style.display='inline-block';
    bad('No se pudo activar la cámara. Revisa permisos y presiona Reintentar.');
  }
}

async function postExtra(action, payload){
  const fd = new FormData();
  fd.append('action', action);
  Object.entries(payload||{}).forEach(([k,v])=>fd.append(k,v));
  const r = await fetch('extra_api.php', {method:'POST', body:fd});
  return r.json();
}

async function loadStatus(){
  try{
    const r = await fetch('extra_api.php?action=status', {cache:'no-store'});
    const j = await r.json();
    if(!j) return;

    if (j.lock) {
      applyHardLock(j.lock_msg || j.msg || 'QR bloqueado.', j);
      return;
    }

    // Normal
    stBox.textContent = 'Estado Extra: --';
    planBox.style.display='none';
    realBox.style.display='none';
    btnDeleteTodayQuick.style.display = 'none';

    if (!j.ok) {
      bad(j.msg || 'No status');
      return;
    }

    if(!j.has){
      stBox.textContent = 'Estado Extra: SIN PROGRAMAR';
      ok('Listo.');
      return;
    }

    btnDeleteTodayQuick.style.display = 'inline-block';
    stBox.textContent = 'Estado Extra: ' + (j.state || '--');

    if(j.planned_end){
      planText.textContent = j.planned_end;
      planBox.style.display='inline-block';
    }
    if(j.actual_end){
      realText.textContent = j.actual_end;
      realBox.style.display='inline-block';
    }
  }catch(_){}
}

async function marcarToken(token){
  if (HARD_LOCK) return;

  const now = Date.now();
  if (token === lastToken && (now-lastTokenTs)<2500) return;
  lastToken=token; lastTokenTs=now;
  if ((now-lastMarkTs)<1800) return;
  lastMarkTs=now;

  ok('QR leído. Procesando…');

  try{
    const j = await postExtra('scan', {token});
    if (j && j.lock) {
      applyHardLock(j.msg || 'QR bloqueado.', j);
      return;
    }
    if(!j || !j.ok) throw new Error(j?.msg || 'Error');

    if(j.need_plan){
      $('#planMsg').text('Salida oficial: ' + (j.schedule_end||'--') + '. Indica hasta qué hora te quedarás.');
      plannedEnd.value = '';
      planModal.data('token', token);
      planModal.modal('show');
      return;
    }

    if(j.closed){
      showResult('ok', `<b>${j.msg}</b><br>
        <b>Salida oficial:</b> ${j.schedule_end}<br>
        <b>Plan:</b> ${j.planned_end || '-'}<br>
        <b>Real:</b> ${j.actual_end}<br>
        <b>Horas:</b> ${j.hours ?? '-'}
      `);
      await loadStatus();
      ok('Listo.');
      return;
    }

    showResult('ok', `<b>${j.msg || 'OK'}</b>`);
    await loadStatus();

  }catch(e){
    showResult('err', `<b>Error:</b> ${e.message}`);
    bad('No se pudo procesar. Asegúrate de escanear el QR actual.');
  }
}

async function scanLoop(){
  if(!scanning || !detector || HARD_LOCK) return;
  try{
    const barcodes = await detector.detect(video);
    if(barcodes && barcodes.length){
      const token = barcodes[0].rawValue || '';
      if(token) await marcarToken(token);
    }
  }catch(_){}
  requestAnimationFrame(scanLoop);
}

// UI events
btnStart.addEventListener('click', async ()=>{
  if (HARD_LOCK) return;
  const id = localStorage.getItem('asist_cam_id_extra') || null;
  await startCamera(id);
});
btnRetry.addEventListener('click', async ()=>{
  if (HARD_LOCK) return;
  const id = localStorage.getItem('asist_cam_id_extra') || null;
  await startCamera(id);
});
btnStop.addEventListener('click', ()=>{
  if (HARD_LOCK) return;
  stopCamera();
  ok('Cámara detenida.');
});

camSel.addEventListener('change', async ()=>{
  if (HARD_LOCK) return;
  const id = camSel.value;
  if(!id) return;
  localStorage.setItem('asist_cam_id_extra', id);
  stopCamera();
  await startCamera(id);
});

// Guardar plan
btnSavePlan.addEventListener('click', async ()=>{
  if (HARD_LOCK) return;
  const token = planModal.data('token') || '';
  const t = (plannedEnd.value || '').trim();
  if(!t){ alert('Selecciona una hora.'); return; }

  try{
    const j = await postExtra('save_plan', {token, planned_end: t});
    if (j && j.lock) { applyHardLock(j.msg || 'QR bloqueado.', j); return; }
    if(!j || !j.ok) throw new Error(j?.msg || 'No se pudo guardar');
    planModal.modal('hide');
    showResult('ok', `<b>${j.msg}</b><br>Salida oficial: ${j.schedule_end} | Programado: ${j.planned_end}`);
    await loadStatus();
  }catch(e){
    alert(e.message);
  }
});

// Eliminar hoy (botón visible)
btnDeleteTodayQuick.addEventListener('click', async ()=>{
  if (HARD_LOCK) return;
  if(!confirm('¿Eliminar SOLO el registro de HOY de horas extra (programado/cierre)?')) return;
  try{
    const j = await postExtra('delete_today', {});
    if (j && j.lock) { applyHardLock(j.msg || 'QR bloqueado.', j); return; }
    if(!j || !j.ok) throw new Error(j?.msg || 'No se pudo eliminar');
    showResult('ok', `<b>${j.msg}</b>`);
    await loadStatus();
  }catch(e){
    alert(e.message);
  }
});

// Init
(async ()=>{
  pill.textContent = ('BarcodeDetector' in window) ? 'Detector: OK' : 'Detector: NO soportado';
  await loadStatus();
  try{ await enumerateCams(); }catch(_){}
})();
</script>
</body>
</html>
