<?php
// rrhh_home/asistencia/qr_public.php
// Pantalla pública: QR que cambia cada 40s (token firmado + expira)
// PHP 8.1.33 – UTF-8

declare(strict_types=1);
date_default_timezone_set('America/Costa_Rica');
?><!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Asistencia | QR Planilla</title>
  <style>
    html,body{height:100%;margin:0;font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial}
    .wrap{height:100%;display:flex;align-items:center;justify-content:center;background:#0b1220;color:#fff}
    .card{background:#111a2e;border:1px solid rgba(255,255,255,.08);border-radius:18px;padding:22px;min-width:320px;max-width:560px;width:92%;box-shadow:0 18px 60px rgba(0,0,0,.35)}
    .top{display:flex;justify-content:space-between;gap:12px;align-items:center;margin-bottom:14px}
    h1{font-size:18px;margin:0;font-weight:800;letter-spacing:.2px}
    .clock{font-variant-numeric:tabular-nums;opacity:.9}
    .qrbox{display:flex;justify-content:center;align-items:center;background:#fff;border-radius:16px;padding:18px}
    #qrcode{width:320px;max-width:100%}
    .meta{margin-top:12px;display:flex;justify-content:space-between;align-items:center;gap:10px}
    .pill{background:rgba(255,255,255,.10);border:1px solid rgba(255,255,255,.10);padding:6px 10px;border-radius:999px;font-size:13px}
    .small{opacity:.85;font-size:13px}
    .warn{margin-top:10px;font-size:13px;opacity:.85;line-height:1.35}
  </style>
</head>
<body>
<div class="wrap">
  <div class="card">
    <div class="top">
      <h1>Scan QR • Planilla (Asistencia)</h1>
      <div class="clock" id="clock">--:--:--</div>
    </div>

    <div class="qrbox">
      <div id="qrcode"></div>
    </div>

    <div class="meta">
      <div class="pill">Expira en <b id="exp">--</b>s</div>
      <div class="small" id="status">Cargando token…</div>
    </div>

    <div class="warn">
      Mantén esta pantalla abierta. El QR cambia automáticamente cada <b id="sec">40</b>s.<br>
      <b>Nota:</b> El token expira; una foto guardada NO sirve después.
    </div>
  </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
<script>
  const clockEl = document.getElementById('clock');
  const expEl = document.getElementById('exp');
  const statusEl = document.getElementById('status');
  const secEl = document.getElementById('sec');

  function tickClock(){
    const d = new Date();
    const z = n => (n<10?'0':'')+n;
    clockEl.textContent = z(d.getHours())+':'+z(d.getMinutes())+':'+z(d.getSeconds());
  }
  setInterval(tickClock, 300);
  tickClock();

  let qr = new QRCode(document.getElementById("qrcode"), {text:"...", width:320, height:320});
  let lastToken = null;
  let expiresIn = 0;
  let tokenSeconds = 40;

  async function refreshToken(){
    try{
      const res = await fetch('jornada_api.php?action=token', {cache:'no-store'});
      const j = await res.json();
      if(!j || !j.ok) throw new Error(j?.msg || 'No token');

      tokenSeconds = parseInt(j.token_seconds||40,10);
      secEl.textContent = tokenSeconds;

      expiresIn = parseInt(j.expires_in||0,10);
      expEl.textContent = expiresIn;

      if(j.token && j.token !== lastToken){
        lastToken = j.token;
        qr.clear();
        qr.makeCode(lastToken);
        statusEl.textContent = 'Token actualizado';
      } else {
        statusEl.textContent = 'Token vigente';
      }
    }catch(e){
      statusEl.textContent = 'Error token: ' + e.message;
    }
  }

  setInterval(()=>{
    if(expiresIn>0) expiresIn--;
    expEl.textContent = expiresIn;
    if(expiresIn<=2) refreshToken();
  }, 1000);

  refreshToken();
  setInterval(refreshToken, 5000);
</script>
</body>
</html>
