<?php
// rrhh_home/asistencia/login.php
// Login de gestores (NO es el admin del sistema)
// Regla: si el empleado ya está TRABAJANDO (WORKING) -> dashboard.php, si no -> scan.php
// PHP 8.1.33 – UTF-8

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Costa_Rica');

require_once __DIR__ . '/../dbcon.php';
mysqli_set_charset($con,'utf8mb4');

$msg = '';

// --------------------------
// Forzar HTTPS (cámara requiere HTTPS)
// --------------------------
$isHttps = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off')
        || (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] === '443');

$host = $_SERVER['HTTP_HOST'] ?? '';
$uri  = $_SERVER['REQUEST_URI'] ?? '/asistencia/login.php';

// Si estás en tu dominio, fuerza HTTPS
if (!$isHttps && stripos($host, 'hr.jportales.com') !== false) {
  header('Location: https://' . $host . $uri, true, 301);
  exit;
}

// --------------------------
// Helper: decidir a dónde ir
// --------------------------
function get_last_estado(mysqli $con, int $idempleado): string {
  $estado = '';
  $q = "SELECT estado
        FROM ausencias_marcajes
        WHERE idempleado=?
        ORDER BY id DESC
        LIMIT 1";
  if ($st = mysqli_prepare($con, $q)) {
    mysqli_stmt_bind_param($st,'i',$idempleado);
    mysqli_stmt_execute($st);
    mysqli_stmt_bind_result($st,$tmp);
    if (mysqli_stmt_fetch($st)) $estado = (string)$tmp;
    mysqli_stmt_close($st);
  }
  return $estado;
}

function redirect_after_login(mysqli $con, int $idempleado): void {
  $estado = get_last_estado($con, $idempleado);
  if ($estado === 'WORKING') {
    header('Location: dashboard.php'); exit;
  }
  header('Location: scan.php'); exit;
}

// --------------------------
// Si ya hay sesión: redirigir según estado actual
// --------------------------
if (isset($_SESSION['gestor_id']) && (int)$_SESSION['gestor_id'] > 0) {
  $idempleado = (int)($_SESSION['idempleado'] ?? 0);
  if ($idempleado <= 0) $idempleado = (int)($_SESSION['gestor_empleado_id'] ?? 0);
  if ($idempleado <= 0) $idempleado = (int)($_SESSION['idempleado_planilla'] ?? 0);

  // Si por alguna razón no está el idempleado en sesión, manda a scan para que no quede trabado
  if ($idempleado > 0) {
    redirect_after_login($con, $idempleado);
  } else {
    header('Location: scan.php'); exit;
  }
}

// --------------------------
// POST login
// --------------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $u = trim((string)($_POST['username'] ?? ''));
  $p = (string)($_POST['password'] ?? '');

  if ($u === '' || $p === '') {
    $msg = 'Ingrese usuario y clave.';
  } else {
    $q = "SELECT id, idempleado, username, pass_hash, nombre, activo
          FROM planilla_gestores
          WHERE is_deleted=0 AND username=?
          LIMIT 1";
    if ($st = mysqli_prepare($con, $q)) {
      mysqli_stmt_bind_param($st,'s',$u);
      mysqli_stmt_execute($st);
      $rs = mysqli_stmt_get_result($st);
      $row = $rs ? mysqli_fetch_assoc($rs) : null;
      mysqli_stmt_close($st);

      if (!$row) {
        $msg = 'Usuario no encontrado.';
      } elseif ((int)$row['activo'] !== 1) {
        $msg = 'Usuario desactivado.';
      } elseif (!password_verify($p, (string)$row['pass_hash'])) {
        $msg = 'Clave incorrecta.';
      } else {
        // Seguridad: regenerar id de sesión en login
        session_regenerate_id(true);

        $_SESSION['gestor_id'] = (int)$row['id'];

        // Mantengo tu sesión original:
        $_SESSION['gestor_empleado_id'] = (int)$row['idempleado'];

        // Alias adicional para que jornada_api.php lo use directo:
        $_SESSION['idempleado'] = (int)$row['idempleado'];

        // (Opcional, ayuda al extra_api.php si lo usas)
        $_SESSION['idempleado_planilla'] = (int)$row['idempleado'];

        $_SESSION['gestor_nombre'] = (string)$row['nombre'];

        // ✅ Aquí la magia: si ya está WORKING, manda a dashboard
        redirect_after_login($con, (int)$row['idempleado']);
      }
    } else {
      $msg = 'Error BD: '.mysqli_error($con);
    }
  }
}
?><!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Asistencia | Login</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.4.1/css/bootstrap.min.css">
  <style>
    body{background:#f3f4f6}
    .box{max-width:420px;margin:70px auto;background:#fff;border-radius:14px;padding:18px;border:1px solid #e5e7eb;box-shadow:0 10px 35px rgba(0,0,0,.06)}
    .title{font-weight:800;margin:0 0 10px}
    .muted{color:#6b7280}
  </style>
</head>
<body>
<div class="box">
  <h3 class="title">Asistencia • Gestor</h3>
  <p class="muted">Ingresa para poder escanear el QR y registrar tu jornada.</p>

  <?php if(!$isHttps): ?>
    <div class="alert alert-warning">
      ⚠ Para usar cámara debes entrar por <b>HTTPS</b>.
    </div>
  <?php endif; ?>

  <?php if($msg): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($msg, ENT_QUOTES, 'UTF-8') ?></div>
  <?php endif; ?>

  <form method="post" autocomplete="off">
    <div class="form-group">
      <label>Usuario</label>
      <input class="form-control" name="username" autocomplete="username" required>
    </div>
    <div class="form-group">
      <label>Clave</label>
      <input class="form-control" type="password" name="password" autocomplete="current-password" required>
    </div>
    <button class="btn btn-primary btn-block">Entrar</button>
  </form>

  <hr>
  <div class="muted" style="font-size:12px">
    Este acceso es solo para el módulo de asistencia (no entra al panel administrativo).
  </div>
</div>
</body>
</html>
