<?php
// rrhh_home/asistencia/inc/ui_state.php
declare(strict_types=1);

/**
 * Estado actual = último estado de ausencias_marcajes para el empleado.
 * Devuelve: WORKING | AWAY | DONE | '' (sin marca)
 */
function get_estado_actual(mysqli $con, int $idempleado): array {
  if ($idempleado <= 0) return ['estado'=>'', 'evento'=>'', 'fecha_hora'=>''];

  $q = "SELECT estado, evento, fecha_hora
        FROM ausencias_marcajes
        WHERE idempleado = ?
        ORDER BY id DESC
        LIMIT 1";
  $row = ['estado'=>'', 'evento'=>'', 'fecha_hora'=>''];

  if ($st = mysqli_prepare($con, $q)) {
    mysqli_stmt_bind_param($st, 'i', $idempleado);
    mysqli_stmt_execute($st);
    $rs = mysqli_stmt_get_result($st);
    $r = $rs ? mysqli_fetch_assoc($rs) : null;
    mysqli_stmt_close($st);

    if ($r) {
      $row['estado'] = (string)($r['estado'] ?? '');
      $row['evento'] = (string)($r['evento'] ?? '');
      $row['fecha_hora'] = (string)($r['fecha_hora'] ?? '');
    }
  }
  return $row;
}

/**
 * Contadores (placeholder por ahora).
 * Más adelante los conectamos a tablas reales.
 */
function get_header_counts(mysqli $con, int $gestor_id, int $idempleado): array {
  // NOTAS: por ahora 0, luego conectamos a recordatorios, chat, notificaciones.
  return [
    'notif_count' => 0,
    'msg_count' => 0,
    'notifs' => [
      // ejemplo
      // ['title'=>'Recordatorio', 'text'=>'Tienes un pendiente', 'time'=>'hoy']
    ],
    'msgs' => [
      // ejemplo
      // ['from'=>'Soporte', 'text'=>'Hola…', 'time'=>'1m']
    ]
  ];
}

function estado_es(string $estado): string {
  if ($estado === 'WORKING') return 'TRABAJANDO';
  if ($estado === 'AWAY') return 'AUSENTE / PAUSA';
  if ($estado === 'DONE') return 'FINALIZADO';
  return 'SIN MARCAJE';
}
